/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.stereotype.edition.editpolicies;

import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.gef.EditPart;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.diagram.core.commands.DeleteCommand;
import org.eclipse.gmf.runtime.diagram.core.listener.NotificationListener;
import org.eclipse.gmf.runtime.diagram.ui.editparts.BorderedBorderItemEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ConnectionEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.GraphicalEditPart;
import org.eclipse.gmf.runtime.notation.Bounds;
import org.eclipse.gmf.runtime.notation.Edge;
import org.eclipse.gmf.runtime.notation.LayoutConstraint;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.infra.gmfdiag.common.utils.GMFUnsafe;
import org.eclipse.papyrus.uml.appearance.helper.AppliedStereotypeHelper;
import org.eclipse.papyrus.uml.diagram.common.Activator;
import org.eclipse.papyrus.uml.diagram.common.editpolicies.AppliedStereotypeNodeLabelDisplayEditPolicy;
import org.eclipse.papyrus.uml.diagram.stereotype.edition.command.CreateAppliedStereotypeCommentViewCommand;
import org.eclipse.papyrus.uml.tools.utils.StereotypeUtil;
import org.eclipse.swt.widgets.Display;
import org.eclipse.uml2.uml.Element;

public class AppliedStereotypeCommentCreationEditPolicy
extends AppliedStereotypeNodeLabelDisplayEditPolicy {
    public static final String APPLIED_STEREOTYPE_COMMENT = "Applied_Stereotype_Comment";

    protected void updateAppliedStereotypeCommentShape() {
        String stereotypeLocalizationToDisplay = AppliedStereotypeHelper.getAppliedStereotypesPropertiesLocalization((EModelElement)((View)this.getHost().getModel()));
        String stereotypePropertiesToDisplay = AppliedStereotypeHelper.getAppliedStereotypesPropertiesToDisplay((EModelElement)((View)this.getHost().getModel()));
        if (this.getAppliedStereotypeCommentNode() == null && !stereotypePropertiesToDisplay.trim().equals("") && stereotypeLocalizationToDisplay.equals("Comment")) {
            if (this.getHost() instanceof ConnectionEditPart) {
                this.executeAppliedStereotypeCommentCreation((EditPart)((ConnectionEditPart)this.getHost()), ((ConnectionEditPart)this.getHost()).getEditingDomain(), ((ConnectionEditPart)this.getHost()).resolveSemanticElement());
            }
            if (this.getHost() instanceof GraphicalEditPart) {
                this.executeAppliedStereotypeCommentCreation((EditPart)((GraphicalEditPart)this.getHost()), ((GraphicalEditPart)this.getHost()).getEditingDomain(), ((GraphicalEditPart)this.getHost()).resolveSemanticElement());
            }
        }
        if (this.getAppliedStereotypeCommentNode() != null) {
            String todisplay;
            Node commentNode = this.getAppliedStereotypeCommentNode();
            if (!stereotypeLocalizationToDisplay.equals("Comment")) {
                TransactionalEditingDomain domain = TransactionUtil.getEditingDomain((EObject)commentNode);
                this.executeAppliedStereotypeCommentDeletion(domain, (View)commentNode);
            }
            if ("".equals((todisplay = StereotypeUtil.getPropertiesValues((String)stereotypePropertiesToDisplay, (Element)this.getUMLElement())).trim())) {
                TransactionalEditingDomain domain = TransactionUtil.getEditingDomain((EObject)commentNode);
                this.executeAppliedStereotypeCommentDeletion(domain, (View)commentNode);
            }
        }
    }

    protected int getvisisbleAppliedStereotypeCompartment(View view, EObject eobject) {
        int nbVisibleCompartment = 0;
        for (View subview : view.getChildren()) {
            if (subview.getElement() == null || subview.getElement().equals(eobject)) continue;
            ++nbVisibleCompartment;
        }
        return nbVisibleCompartment;
    }

    protected void delegateEAnnotationInCommentShape() {
        final Node appliedStereotypeComment = this.getAppliedStereotypeCommentNode();
        if (appliedStereotypeComment != null) {
            View originView = this.getView();
            final EAnnotation stereotypeAnnotation = originView.getEAnnotation("Stereotype_Annotation");
            final TransactionalEditingDomain domain = TransactionUtil.getEditingDomain((EObject)originView);
            final RecordingCommand cmd = new RecordingCommand(domain, "EannotationDelegation"){

                protected void doExecute() {
                    EAnnotation stereotypeAnnotationCopy = (EAnnotation)EcoreUtil.copy((EObject)stereotypeAnnotation);
                    appliedStereotypeComment.getEAnnotations().clear();
                    appliedStereotypeComment.getEAnnotations().add((Object)stereotypeAnnotationCopy);
                    RecordingCommand cmd = AppliedStereotypeHelper.getSetAppliedStereotypePropertiesLocalizationCommand((TransactionalEditingDomain)domain, (EModelElement)appliedStereotypeComment, (String)"Compartment");
                    cmd.execute();
                    String presentationKind = AppliedStereotypeHelper.getAppliedStereotypePresentationKind((EModelElement)AppliedStereotypeCommentCreationEditPolicy.this.getView());
                    cmd = AppliedStereotypeHelper.getRemoveAppliedStereotypeCommand((TransactionalEditingDomain)domain, (EModelElement)appliedStereotypeComment, (String)AppliedStereotypeHelper.getStereotypesToDisplay((EModelElement)appliedStereotypeComment), (String)presentationKind);
                    cmd.execute();
                }
            };
            Display.getCurrent().syncExec(new Runnable(){

                public void run() {
                    try {
                        GMFUnsafe.write((TransactionalEditingDomain)domain, (Command)cmd);
                    }
                    catch (Exception e) {
                        Activator.log.error((Throwable)e);
                    }
                }
            });
        }
    }

    protected Node getAppliedStereotypeCommentNode() {
        View SemanticView = (View)this.getHost().getModel();
        Edge appliedStereotypeLink = null;
        for (Edge edge : SemanticView.getSourceEdges()) {
            if (!edge.getType().equals("AppliedStereotypesCommentLink")) continue;
            appliedStereotypeLink = edge;
        }
        if (appliedStereotypeLink == null) {
            return null;
        }
        return (Node)appliedStereotypeLink.getTarget();
    }

    protected void executeAppliedStereotypeCommentCreation(final EditPart editPart, final TransactionalEditingDomain domain, final EObject semanticElement) {
        Display.getCurrent().syncExec(new Runnable(){

            public void run() {
                LayoutConstraint constraint;
                int x = 200;
                int y = 100;
                if (editPart.getModel() instanceof Node && (constraint = ((Node)editPart.getModel()).getLayoutConstraint()) instanceof Bounds) {
                    x += ((Bounds)constraint).getX();
                    y = ((Bounds)constraint).getY();
                }
                if (editPart.getModel() instanceof Edge && ((Edge)editPart.getModel()).getSource() instanceof Node && (constraint = ((Node)((Edge)editPart.getModel()).getSource()).getLayoutConstraint()) instanceof Bounds) {
                    x += ((Bounds)constraint).getX();
                    y = ((Bounds)constraint).getY() - 100;
                }
                boolean isBorderElement = false;
                if (editPart instanceof BorderedBorderItemEditPart) {
                    isBorderElement = true;
                }
                if (AppliedStereotypeCommentCreationEditPolicy.this.getAppliedStereotypeCommentNode() == null) {
                    CreateAppliedStereotypeCommentViewCommand command = new CreateAppliedStereotypeCommentViewCommand(domain, (View)editPart.getModel(), x, y, semanticElement, isBorderElement);
                    try {
                        GMFUnsafe.write((TransactionalEditingDomain)domain, (Command)command);
                    }
                    catch (Exception e) {
                        Activator.log.error((Throwable)e);
                    }
                }
            }
        });
    }

    protected void executeAppliedStereotypeCommentDeletion(final TransactionalEditingDomain domain, final View commentNode) {
        Display.getCurrent().syncExec(new Runnable(){

            public void run() {
                if (commentNode != null && TransactionUtil.getEditingDomain((EObject)commentNode) != null) {
                    DeleteCommand command = new DeleteCommand(commentNode);
                    try {
                        GMFUnsafe.write((TransactionalEditingDomain)domain, (ICommand)command);
                    }
                    catch (Exception e) {
                        Activator.log.error((Throwable)e);
                    }
                }
            }
        });
    }

    public void notifyChanged(Notification notification) {
        int eventType = notification.getEventType();
        if (eventType == 20) {
            this.getDiagramEventBroker().addNotificationListener((EObject)notification.getNewValue(), (NotificationListener)this);
        } else if (eventType == 21) {
            this.getDiagramEventBroker().removeNotificationListener((EObject)notification.getOldValue(), (NotificationListener)this);
            this.cleanStereotypeDisplayInEAnnotation();
            this.updateAppliedStereotypeCommentShape();
        }
        if (notification.getNotifier() instanceof View && notification.getEventType() == 3 && notification.getNewValue() instanceof EAnnotation && "Stereotype_Annotation" == ((EAnnotation)notification.getNewValue()).getSource()) {
            this.updateAppliedStereotypeCommentShape();
            this.delegateEAnnotationInCommentShape();
        }
        if (notification.getNotifier() instanceof EAnnotation && notification.getEventType() == 3 && "Stereotype_Annotation" == ((EAnnotation)notification.getNotifier()).getSource()) {
            this.updateAppliedStereotypeCommentShape();
            this.delegateEAnnotationInCommentShape();
        }
    }

    public void refreshDisplay() {
    }
}

