/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.gmfdiag.properties.widget;

import org.eclipse.gef.EditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.DiagramEditPart;
import org.eclipse.gmf.runtime.draw2d.ui.figures.FigureUtilities;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.papyrus.infra.gmfdiag.common.preferences.PreferencesConstantsHelper;
import org.eclipse.papyrus.infra.gmfdiag.common.utils.DiagramEditPartsUtil;
import org.eclipse.papyrus.infra.gmfdiag.preferences.Activator;
import org.eclipse.papyrus.infra.gmfdiag.properties.messages.Messages;
import org.eclipse.papyrus.views.properties.modelelement.DataSource;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;

public class DiagramPreferencesDefaultButton
extends Composite {
    private Button button;
    private SelectionListener listener;
    protected DataSource input;

    public DiagramPreferencesDefaultButton(Composite parent, int style) {
        super(parent, style);
        GridLayout layout = new GridLayout(1, false);
        this.setLayout((Layout)layout);
        this.createButton();
    }

    protected void createButton() {
        this.button = new Button((Composite)this, 0);
        this.button.setText(Messages.DiagramPreferencesDefaultButton_ResetDefault);
        this.listener = this.createListener();
        this.button.addSelectionListener(this.listener);
    }

    public void setInput(DataSource input) {
        this.input = input;
    }

    public DataSource getInput() {
        return this.input;
    }

    private SelectionListener createListener() {
        SelectionListener listener = new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                DiagramPreferencesDefaultButton.this.resetProperties();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        };
        return listener;
    }

    public void dispose() {
        super.dispose();
        this.button.removeSelectionListener(this.listener);
        this.input = null;
    }

    protected void resetProperties() {
        IPreferenceStore store = this.getPreferencesStore();
        IPreferenceStore globalPreferenceStore = Activator.getDefault().getPreferenceStore();
        String diagramType = this.getDiagramType();
        if (store != null && diagramType != null && !diagramType.equals("")) {
            store.setValue("rulergrid.viewgrid", globalPreferenceStore.getBoolean(PreferencesConstantsHelper.getDiagramConstant((String)diagramType, (int)24)));
            store.setValue("rulergrid.viewrulers", globalPreferenceStore.getBoolean(PreferencesConstantsHelper.getDiagramConstant((String)diagramType, (int)23)));
            store.setValue("rulergrid.gridlevel", globalPreferenceStore.getBoolean(PreferencesConstantsHelper.getDiagramConstant((String)diagramType, (int)30)));
            RGB gridColor = PreferenceConverter.getColor((IPreferenceStore)globalPreferenceStore, (String)PreferencesConstantsHelper.getDiagramConstant((String)diagramType, (int)28));
            store.setValue("rulergrid.gridlinecolor", FigureUtilities.RGBToInteger((RGB)gridColor).intValue());
            store.setValue("rulergrid.gridlinestyle", globalPreferenceStore.getInt(PreferencesConstantsHelper.getDiagramConstant((String)diagramType, (int)31)));
            store.setValue("rulergrid.gridspacing", globalPreferenceStore.getDouble(PreferencesConstantsHelper.getDiagramConstant((String)diagramType, (int)29)));
            store.setValue("rulergrid.snaptogrid", globalPreferenceStore.getBoolean(PreferencesConstantsHelper.getDiagramConstant((String)diagramType, (int)26)));
            store.setValue("rulergrid.snaptogeometry", globalPreferenceStore.getBoolean(PreferencesConstantsHelper.getDiagramConstant((String)diagramType, (int)27)));
            store.setValue("rulergrid.rulerunit", globalPreferenceStore.getInt(PreferencesConstantsHelper.getDiagramConstant((String)diagramType, (int)25)));
        }
    }

    protected IPreferenceStore getPreferencesStore() {
        IStructuredSelection selection = this.input.getSelection();
        Object firstElement = selection.getFirstElement();
        if (firstElement instanceof EditPart) {
            return DiagramEditPartsUtil.getDiagramWorkspacePreferenceStore((EditPart)((EditPart)firstElement));
        }
        return null;
    }

    protected String getDiagramType() {
        IStructuredSelection selection = this.input.getSelection();
        Object firstElement = selection.getFirstElement();
        if (firstElement instanceof EditPart) {
            DiagramEditPart diagramEditPart = DiagramEditPartsUtil.getDiagramEditPart((EditPart)((EditPart)firstElement));
            Diagram diagram = (Diagram)diagramEditPart.getAdapter(Diagram.class);
            return diagram.getType();
        }
        return "";
    }
}

