/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.stereotypecollector;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceProxyVisitor;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.papyrus.infra.core.resource.ModelSet;
import org.eclipse.papyrus.infra.emf.utils.BusinessModelResolver;
import org.eclipse.papyrus.infra.onefile.model.IPapyrusFile;
import org.eclipse.papyrus.uml.search.ui.Activator;
import org.eclipse.papyrus.uml.stereotypecollector.IStereotypeCollector;
import org.eclipse.papyrus.uml.stereotypecollector.Messages;
import org.eclipse.papyrus.uml.stereotypecollector.UMLResourceVisitor;
import org.eclipse.search.ui.ISearchPageContainer;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.Profile;
import org.eclipse.uml2.uml.ProfileApplication;
import org.eclipse.uml2.uml.Stereotype;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StereotypeCollector
implements IStereotypeCollector {
    private static final StereotypeCollector instance = new StereotypeCollector();

    private StereotypeCollector() {
    }

    public static final StereotypeCollector getInstance() {
        return instance;
    }

    @Override
    public Collection<Stereotype> computeAvailableStereotypes(ISearchPageContainer container) {
        HashSet<Stereotype> preResult = new HashSet<Stereotype>();
        HashSet<Profile> profiles = new HashSet<Profile>();
        HashSet<URI> umlResources = new HashSet<URI>();
        if (container == null) {
            umlResources.addAll(this.createWorkspaceScope());
        } else {
            switch (container.getSelectedScope()) {
                case 0: {
                    umlResources.addAll(this.createWorkspaceScope());
                    break;
                }
                case 1: {
                    ISelection selection = container.getSelection();
                    if (!selection.isEmpty()) {
                        if (selection instanceof IStructuredSelection) {
                            umlResources.addAll(this.createSelectionScope((IStructuredSelection)selection));
                            break;
                        }
                        umlResources.addAll(this.createWorkspaceScope());
                        break;
                    }
                    umlResources.addAll(this.createWorkspaceScope());
                    break;
                }
                case 3: {
                    String[] projects = container.getSelectedProjectNames();
                    umlResources.addAll(this.createProjectsScope(projects));
                    break;
                }
                case 2: {
                    IWorkingSet[] workingSets = container.getSelectedWorkingSets();
                    umlResources.addAll(this.createWorkingSetsScope(workingSets));
                    break;
                }
            }
        }
        for (URI uri : umlResources) {
            ModelSet resourceSet = new ModelSet();
            Resource resource = resourceSet.getResource(uri, true);
            TreeIterator UMLResourceContentIterator = resource.getAllContents();
            while (UMLResourceContentIterator.hasNext()) {
                EObject umlElement = (EObject)UMLResourceContentIterator.next();
                if (!(umlElement instanceof ProfileApplication)) continue;
                boolean found = false;
                Profile profileToProcess = ((ProfileApplication)umlElement).getAppliedProfile();
                for (Profile alreadyAddedProfile : profiles) {
                    if (!EcoreUtil.equals((EObject)alreadyAddedProfile, (EObject)profileToProcess)) continue;
                    found = true;
                }
                if (found) continue;
                profiles.add(profileToProcess);
            }
        }
        for (Profile profile : profiles) {
            TreeIterator profileContentIterator = profile.eAllContents();
            while (profileContentIterator.hasNext()) {
                EObject profileContent = (EObject)profileContentIterator.next();
                if (!(profileContent instanceof Stereotype)) continue;
                boolean found = false;
                Stereotype stereotypeToProcess = (Stereotype)profileContent;
                for (Stereotype alreadyAddedStereotype : preResult) {
                    if (!EcoreUtil.equals((EObject)alreadyAddedStereotype, (EObject)stereotypeToProcess)) continue;
                    found = true;
                }
                if (found) continue;
                preResult.add(stereotypeToProcess);
            }
        }
        HashSet<Stereotype> result = new HashSet<Stereotype>();
        for (Stereotype stereo : preResult) {
            result.add(stereo);
            for (Classifier parent : stereo.getGenerals()) {
                if (!(parent instanceof Stereotype)) continue;
                result.add((Stereotype)parent);
                boolean found = false;
                Stereotype stereotypeToProcess = (Stereotype)parent;
                for (Stereotype alreadyAddedStereotype : result) {
                    if (!EcoreUtil.equals((EObject)alreadyAddedStereotype, (EObject)stereotypeToProcess)) continue;
                    found = true;
                }
                if (found) continue;
                result.add(stereotypeToProcess);
            }
        }
        return result;
    }

    protected List<URI> createSelectionScope(IStructuredSelection selection) {
        ArrayList<URI> results = new ArrayList<URI>();
        for (Object object : selection) {
            if (object instanceof IPapyrusFile) {
                IResource[] associatedResources;
                IResource[] iResourceArray = associatedResources = ((IPapyrusFile)object).getAssociatedResources();
                int n = associatedResources.length;
                int n2 = 0;
                while (n2 < n) {
                    IResource iResource = iResourceArray[n2];
                    results.addAll(this.findUMLModels(iResource));
                    ++n2;
                }
                continue;
            }
            if (object instanceof IResource) {
                results.addAll(this.findUMLModels((IResource)object));
                continue;
            }
            Object element = BusinessModelResolver.getInstance().getBusinessModel(object);
            if (element instanceof EObject) {
                Resource eResource;
                Resource resource = eResource = element instanceof Resource ? (Resource)element : ((EObject)element).eResource();
                if (eResource != null) {
                    results.add(eResource.getURI());
                    continue;
                }
                results.addAll(this.createWorkspaceScope());
                continue;
            }
            results.addAll(this.createWorkspaceScope());
        }
        return results;
    }

    protected List<URI> createProjectsScope(String[] projects) {
        ArrayList<URI> results = new ArrayList<URI>();
        String[] stringArray = projects;
        int n = projects.length;
        int n2 = 0;
        while (n2 < n) {
            String projectName = stringArray[n2];
            IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
            if (project.isOpen()) {
                results.addAll(this.findUMLModels((IResource)project));
            }
            ++n2;
        }
        return results;
    }

    protected List<URI> createWorkingSetsScope(IWorkingSet[] workingSets) {
        ArrayList<URI> results = new ArrayList<URI>();
        if (workingSets != null && workingSets.length > 0) {
            IWorkingSet[] iWorkingSetArray = workingSets;
            int n = workingSets.length;
            int n2 = 0;
            while (n2 < n) {
                IWorkingSet iWorkingSet = iWorkingSetArray[n2];
                IAdaptable[] iAdaptableArray = iWorkingSet.getElements();
                int n3 = iAdaptableArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    IAdaptable element = iAdaptableArray[n4];
                    Object resource = element.getAdapter(IResource.class);
                    if (resource instanceof IResource) {
                        results.addAll(this.findUMLModels((IResource)resource));
                    }
                    ++n4;
                }
                ++n2;
            }
        }
        return results;
    }

    protected Collection<URI> findUMLModels(IResource res) {
        UMLResourceVisitor visitor = new UMLResourceVisitor();
        try {
            res.accept((IResourceProxyVisitor)visitor, 2);
        }
        catch (CoreException e) {
            Activator.log.warn(String.valueOf(Messages.StereotypeCollector_0) + res);
        }
        return visitor.getParticipantURIs();
    }

    protected Collection<URI> createWorkspaceScope() {
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        return this.findUMLModels((IResource)root);
    }
}

