/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.search.ui.validator;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.papyrus.uml.search.ui.validator.IParticipantValidator;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Stereotype;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ParticipantValidator
implements IParticipantValidator {
    private static ParticipantValidator instance = null;

    private ParticipantValidator() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final ParticipantValidator getInstance() {
        if (instance != null) return instance;
        Class<ParticipantValidator> clazz = ParticipantValidator.class;
        synchronized (ParticipantValidator.class) {
            if (instance != null) return instance;
            instance = new ParticipantValidator();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public Collection<EObject> getParticipants(EObject root, Object[] participantsTypes) {
        List<Object> participantsTypesList = Arrays.asList(participantsTypes);
        ArrayList<EObject> results = new ArrayList<EObject>();
        TreeIterator it = root.eAllContents();
        while (it.hasNext()) {
            EObject modelElement = (EObject)it.next();
            EClass e = modelElement.eClass();
            if (!participantsTypesList.contains(modelElement.eClass())) continue;
            results.add(modelElement);
        }
        return results;
    }

    public Collection<EObject> getParticipantsStereotype(EObject root, Object[] participantsTypes) {
        List<Object> participantsTypesList = Arrays.asList(participantsTypes);
        ArrayList<EObject> results = new ArrayList<EObject>();
        if (participantsTypesList.contains(root.eClass())) {
            results.add(root);
        }
        TreeIterator it = root.eAllContents();
        while (it.hasNext()) {
            EObject modelElement = (EObject)it.next();
            if (!(modelElement instanceof Element)) continue;
            for (Stereotype appliedStereotype : ((Element)modelElement).getAppliedStereotypes()) {
                for (Object stereotypeToGet : participantsTypesList) {
                    if (!EcoreUtil.equals((EObject)appliedStereotype, (EObject)((EObject)stereotypeToGet))) continue;
                    results.add(modelElement);
                }
            }
        }
        return results;
    }
}

