/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.search.ui.query;

import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.papyrus.infra.core.resource.NotFoundException;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.infra.services.viewersearch.impl.ViewerSearchService;
import org.eclipse.papyrus.uml.search.ui.Activator;
import org.eclipse.papyrus.uml.search.ui.Messages;
import org.eclipse.papyrus.uml.search.ui.query.AbstractPapyrusQuery;
import org.eclipse.papyrus.uml.search.ui.results.PapyrusSearchResult;
import org.eclipse.papyrus.uml.search.ui.validator.ParticipantValidator;
import org.eclipse.papyrus.uml.tools.model.UmlModel;
import org.eclipse.papyrus.views.search.regex.PatternHelper;
import org.eclipse.papyrus.views.search.results.AbstractResultEntry;
import org.eclipse.papyrus.views.search.results.AttributeMatch;
import org.eclipse.papyrus.views.search.results.ViewerMatch;
import org.eclipse.papyrus.views.search.scope.ScopeEntry;
import org.eclipse.search.ui.ISearchResult;
import org.eclipse.search.ui.text.Match;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Stereotype;
import org.eclipse.uml2.uml.UMLPackage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PapyrusQuery
extends AbstractPapyrusQuery {
    private String searchQueryText;
    private boolean isCaseSensitive;
    private boolean isRegularExpression;
    private Collection<ScopeEntry> scopeEntries;
    private Object[] participantsTypes;
    private PapyrusSearchResult results;
    private boolean searchAllStringAttributes;
    protected Set<AbstractResultEntry> fResults = null;

    @Override
    public boolean isCaseSensitive() {
        return this.isCaseSensitive;
    }

    @Override
    public boolean isRegularExpression() {
        return this.isRegularExpression;
    }

    public PapyrusQuery(String searchQueryText, boolean isCaseSensitive, boolean isRegularExpression, Collection<ScopeEntry> scopeEntries, Object[] participantsTypes, boolean searchAllStringAttributes) {
        this.searchQueryText = searchQueryText;
        this.isCaseSensitive = isCaseSensitive;
        this.isRegularExpression = isRegularExpression;
        this.scopeEntries = scopeEntries;
        this.participantsTypes = participantsTypes;
        this.searchAllStringAttributes = searchAllStringAttributes;
        this.results = new PapyrusSearchResult(this);
        this.fResults = new HashSet<AbstractResultEntry>();
    }

    public IStatus run(IProgressMonitor monitor) throws OperationCanceledException {
        this.results.removeAll();
        this.fResults.clear();
        for (ScopeEntry scopeEntry : this.scopeEntries) {
            try {
                if (scopeEntry.getModelSet() == null) continue;
                UmlModel umlModel = (UmlModel)scopeEntry.getModelSet().getModelChecked("org.eclipse.papyrus.infra.core.resource.uml.UmlModel");
                EObject root = umlModel.lookupRoot();
                Collection<EObject> participants = ParticipantValidator.getInstance().getParticipants(root, this.participantsTypes);
                this.evaluate(participants, scopeEntry);
            }
            catch (NotFoundException e) {
                Activator.log.error(String.valueOf(Messages.PapyrusQuery_0) + scopeEntry.getModelSet(), (Throwable)e);
            }
        }
        monitor.done();
        return Status.OK_STATUS;
    }

    /*
     * Unable to fully structure code
     */
    protected void evaluateAndAddToResult(String value, Object attribute, Pattern pattern, Object participant, ScopeEntry scopeEntry, Stereotype stereotype) {
        block3: {
            value = value != null ? value : "";
            m = pattern.matcher(value);
            if (!this.isRegularExpression) ** GOTO lbl16
            if (!m.matches()) break block3;
            start = m.start();
            end = m.end();
            match = new AttributeMatch(start, end, participant, scopeEntry, attribute, stereotype);
            this.fResults.add((AbstractResultEntry)match);
            break block3;
lbl-1000:
            // 1 sources

            {
                start = m.start();
                end = m.end();
                match = new AttributeMatch(start, end, participant, scopeEntry, attribute, stereotype);
                this.fResults.add((AbstractResultEntry)match);
lbl16:
                // 2 sources

                ** while (m.find())
            }
        }
    }

    protected void evaluate(Collection<EObject> participants, ScopeEntry scopeEntry) {
        for (EObject participant : participants) {
            Object pattern;
            String query = this.searchQueryText;
            if (this.searchQueryText.equals("")) {
                query = ".*";
            }
            if ((pattern = PatternHelper.getInstance().createPattern(query, this.isCaseSensitive, this.isRegularExpression)) == null) continue;
            if (this.searchAllStringAttributes) {
                for (EAttribute attribute : participant.eClass().getEAllAttributes()) {
                    Object value = participant.eGet((EStructuralFeature)attribute);
                    if (!(value instanceof String)) continue;
                    String stringValue = (String)value;
                    this.evaluateAndAddToResult(stringValue, attribute, (Pattern)pattern, participant, scopeEntry, null);
                }
                if (!(participant instanceof Element)) continue;
                EList stereotypes = ((Element)participant).getAppliedStereotypes();
                for (Stereotype stereotype : stereotypes) {
                    for (Property stereotypeProperty : stereotype.getAllAttributes()) {
                        Object value;
                        if (stereotypeProperty.getName().startsWith("base_") || !((value = ((Element)participant).getValue(stereotype, stereotypeProperty.getName())) instanceof String)) continue;
                        String stringValue = (String)value;
                        this.evaluateAndAddToResult(stringValue, stereotypeProperty, (Pattern)pattern, participant, scopeEntry, stereotype);
                    }
                }
                continue;
            }
            if (!(participant instanceof NamedElement)) continue;
            String umlElementName = ((NamedElement)participant).getName();
            umlElementName = umlElementName != null ? umlElementName : "";
            this.evaluateAndAddToResult(umlElementName, UMLPackage.eINSTANCE.getNamedElement_Name(), (Pattern)pattern, participant, scopeEntry, null);
        }
        ViewerSearchService viewerSearcherService = new ViewerSearchService();
        try {
            viewerSearcherService.startService();
            HashSet<Object> sources = new HashSet<Object>();
            for (AbstractResultEntry match : this.fResults) {
                if (match instanceof AttributeMatch) {
                    sources.add(((AttributeMatch)match).getSource());
                    continue;
                }
                sources.add(match.getSource());
            }
            Map viewersMappings = viewerSearcherService.getViewers(sources, scopeEntry.getModelSet());
            for (Object containingModelSet : viewersMappings.keySet()) {
                for (Object view : ((Map)viewersMappings.get(containingModelSet)).keySet()) {
                    Object semanticElement = ((Map)viewersMappings.get(containingModelSet)).get(view);
                    ViewerMatch viewMatch = new ViewerMatch(view, scopeEntry, semanticElement);
                    this.fResults.add((AbstractResultEntry)viewMatch);
                }
            }
        }
        catch (ServiceException e) {
            Activator.log.error(String.valueOf(Messages.PapyrusQuery_5) + scopeEntry.getModelSet(), (Throwable)e);
        }
    }

    public Set<AbstractResultEntry> getResults() {
        return this.fResults;
    }

    public String getLabel() {
        return Messages.PapyrusQuery_6;
    }

    public boolean canRerun() {
        return false;
    }

    public boolean canRunInBackground() {
        return true;
    }

    public ISearchResult getSearchResult() {
        for (AbstractResultEntry match : this.fResults) {
            this.results.addMatch((Match)match);
        }
        return this.results;
    }

    @Override
    public String getSearchQueryText() {
        return this.searchQueryText;
    }
}

