/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.emf.nattable.provider;

import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.nebula.widgets.nattable.config.IConfigRegistry;
import org.eclipse.papyrus.infra.emf.nattable.provider.EMFEObjectHeaderLabelProvider;
import org.eclipse.papyrus.infra.emf.nattable.registry.EStructuralFeatureImageRegistry;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableaxis.EStructuralFeatureAxis;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattablelabelprovider.FeatureLabelProviderConfiguration;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattablelabelprovider.ILabelProviderConfiguration;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattablelabelprovider.ObjectLabelProviderConfiguration;
import org.eclipse.papyrus.infra.nattable.utils.ILabelProviderContextElementWrapper;
import org.eclipse.papyrus.infra.nattable.utils.LabelProviderCellContextElementWrapper;
import org.eclipse.papyrus.infra.services.labelprovider.service.LabelProviderService;
import org.eclipse.swt.graphics.Image;

public class EMFFeatureHeaderLabelProvider
extends EMFEObjectHeaderLabelProvider {
    @Override
    public boolean accept(Object element) {
        if (element instanceof ILabelProviderContextElementWrapper) {
            Object object = ((ILabelProviderContextElementWrapper)element).getObject();
            return object instanceof EStructuralFeature || object instanceof EStructuralFeatureAxis;
        }
        return false;
    }

    protected String getText(FeatureLabelProviderConfiguration featureConf, IConfigRegistry configRegistry, String name, Object type, boolean isDerived, int lowerBound, int upperBounds) {
        boolean displayName = false;
        try {
            displayName = featureConf.isDisplayName();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        boolean displayMultiplicity = featureConf.isDisplayMultiplicity();
        boolean displayType = featureConf.isDisplayType();
        boolean displayIsDerived = featureConf.isDisplayIsDerived();
        String displayedText = "";
        if (isDerived && displayIsDerived) {
            displayedText = String.valueOf(displayedText) + "/";
        }
        if (displayName) {
            displayedText = String.valueOf(displayedText) + name;
        }
        if (displayType) {
            if (displayName) {
                displayedText = String.valueOf(displayedText) + " : ";
            }
            displayedText = String.valueOf(displayedText) + this.getTypeName(configRegistry, type);
        }
        if (displayMultiplicity) {
            displayedText = String.valueOf(displayedText) + " [";
            if (upperBounds == -1 && lowerBound <= 1) {
                displayedText = String.valueOf(displayedText) + "*";
            } else if (lowerBound == upperBounds) {
                displayedText = String.valueOf(displayedText) + Integer.toString(lowerBound);
            } else {
                displayedText = String.valueOf(displayedText) + Integer.toString(lowerBound);
                displayedText = String.valueOf(displayedText) + "..";
                displayedText = upperBounds == -1 ? String.valueOf(displayedText) + "*" : String.valueOf(displayedText) + Integer.toString(upperBounds);
            }
            displayedText = String.valueOf(displayedText) + "]";
        }
        return displayedText;
    }

    protected String getTypeName(IConfigRegistry configRegistry, Object type) {
        LabelProviderService serv = this.getLabelProviderService(configRegistry);
        if (type instanceof EClassifier) {
            return ((EClassifier)type).getName();
        }
        return serv.getLabelProvider(type).getText(type);
    }

    @Override
    public String getText(Object element) {
        ILabelProviderContextElementWrapper wrapper = (ILabelProviderContextElementWrapper)element;
        IConfigRegistry configRegistry = wrapper.getConfigRegistry();
        Object value = wrapper.getObject();
        EStructuralFeature feature = null;
        String alias = "";
        if (value instanceof EStructuralFeatureAxis) {
            feature = ((EStructuralFeatureAxis)value).getElement();
            alias = ((EStructuralFeatureAxis)value).getAlias();
        } else if (value instanceof EStructuralFeature) {
            feature = (EStructuralFeature)value;
        }
        String returnedValue = null;
        returnedValue = alias != null && !alias.isEmpty() ? alias : feature.getName();
        ILabelProviderConfiguration conf = null;
        if (wrapper instanceof LabelProviderCellContextElementWrapper) {
            conf = this.getLabelConfiguration((LabelProviderCellContextElementWrapper)wrapper);
        }
        if (conf instanceof ObjectLabelProviderConfiguration && !((ObjectLabelProviderConfiguration)conf).isDisplayLabel()) {
            returnedValue = "";
        } else if (conf instanceof FeatureLabelProviderConfiguration) {
            returnedValue = this.getText((FeatureLabelProviderConfiguration)conf, configRegistry, returnedValue, feature.getEType(), feature.isDerived(), feature.getLowerBound(), feature.getUpperBound());
        }
        return returnedValue;
    }

    @Override
    public Image getImage(Object element) {
        ILabelProviderConfiguration conf = null;
        if (element instanceof LabelProviderCellContextElementWrapper) {
            conf = this.getLabelConfiguration((LabelProviderCellContextElementWrapper)element);
        }
        if (conf instanceof ObjectLabelProviderConfiguration && !((ObjectLabelProviderConfiguration)conf).isDisplayIcon()) {
            return null;
        }
        Object object = ((ILabelProviderContextElementWrapper)element).getObject();
        EStructuralFeature feature = null;
        if (object instanceof EStructuralFeatureAxis) {
            feature = ((EStructuralFeatureAxis)object).getElement();
        } else if (object instanceof EStructuralFeature) {
            feature = (EStructuralFeature)object;
        }
        if (feature instanceof EAttribute) {
            return EStructuralFeatureImageRegistry.getAttributeIcon();
        }
        if (feature instanceof EReference) {
            return EMFFeatureHeaderLabelProvider.getEReferenceImage((EReference)feature);
        }
        if (feature == null) {
            return null;
        }
        return super.getImage(feature);
    }

    public static Image getEReferenceImage(EReference reference) {
        EReference opposite = reference.getEOpposite();
        if (reference.isContainment()) {
            if (opposite == null) {
                return EStructuralFeatureImageRegistry.getUnidirectionalAggregIcon();
            }
            return EStructuralFeatureImageRegistry.getAggregIcon();
        }
        if (opposite != null && opposite.isContainment()) {
            return EStructuralFeatureImageRegistry.getInvAggregIcon();
        }
        if (opposite == null) {
            return EStructuralFeatureImageRegistry.getUnidirectionalLinkIcon();
        }
        return EStructuralFeatureImageRegistry.getLinkIcon();
    }
}

