/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.widgets.selectors;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.papyrus.infra.widgets.editors.IElementSelectionListener;
import org.eclipse.papyrus.infra.widgets.editors.IElementSelector;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Text;

public class StringSelector
implements IElementSelector {
    public static final String LINE_SEPARATOR = System.getProperty("line.separator");
    protected Text text;
    protected boolean multiline;
    protected Set<IElementSelectionListener> elementSelectionListeners = new HashSet<IElementSelectionListener>();

    public StringSelector() {
        this(false);
    }

    public StringSelector(boolean multiline) {
        this.multiline = multiline;
    }

    @Override
    public Object[] getSelectedElements() {
        Object[] result = new String[]{this.text.getText()};
        this.text.setText("");
        return result;
    }

    @Override
    public void setSelectedElements(Object[] elements) {
    }

    @Override
    public void createControls(Composite parent) {
        this.text = new Text(parent, 2050);
        this.text.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent e) {
            }

            public void keyReleased(KeyEvent e) {
                if ((e.keyCode == 13 || e.keyCode == 0x1000050) && (e.stateMask == 0 && !StringSelector.this.multiline || (e.stateMask & 0x40000) != 0 && StringSelector.this.multiline) && !StringSelector.this.elementSelectionListeners.isEmpty()) {
                    String str = (String)StringSelector.this.getSelectedElements()[0];
                    if (str.endsWith(LINE_SEPARATOR)) {
                        str = str.substring(0, str.length() - LINE_SEPARATOR.length());
                    }
                    if (!"".equals(str)) {
                        for (IElementSelectionListener listener : StringSelector.this.elementSelectionListeners) {
                            listener.addElements(new Object[]{str});
                        }
                    }
                }
            }
        });
    }

    @Override
    public Object[] getAllElements() {
        return this.getSelectedElements();
    }

    @Override
    public void newObjectCreated(Object newObject) {
    }

    @Override
    public void clearTemporaryElements() {
    }

    @Override
    public void addElementSelectionListener(IElementSelectionListener listener) {
        this.elementSelectionListeners.add(listener);
    }

    @Override
    public void removeElementSelectionListener(IElementSelectionListener listener) {
        this.elementSelectionListeners.remove(listener);
    }
}

