/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.widgets.databinding;

import org.eclipse.core.databinding.observable.value.AbstractObservableValue;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.papyrus.infra.tools.databinding.AggregatedObservable;
import org.eclipse.papyrus.infra.widgets.messages.Messages;
import org.eclipse.swt.custom.CLabel;

public class CLabelObservableValue
extends AbstractObservableValue {
    protected CLabel label;
    protected Object currentValue;
    protected ILabelProvider labelProvider;
    protected AggregatedObservable aggregated;

    public CLabelObservableValue(CLabel label, IObservableValue modelObservable) {
        this(label, modelObservable, null);
    }

    public CLabelObservableValue(CLabel label, IObservableValue modelObservable, ILabelProvider labelProvider) {
        this.label = label;
        this.setLabelProvider(labelProvider);
        if (modelObservable instanceof AggregatedObservable) {
            this.aggregated = (AggregatedObservable)modelObservable;
        }
    }

    public void setLabelProvider(ILabelProvider labelProvider) {
        this.labelProvider = labelProvider != null ? labelProvider : new LabelProvider();
    }

    public Object getValueType() {
        return Object.class;
    }

    protected Object doGetValue() {
        return this.currentValue;
    }

    protected void doSetValue(Object value) {
        this.currentValue = value;
        if (this.aggregated != null && this.aggregated.hasDifferentValues()) {
            this.label.setText(Messages.ReferenceDialogObservable_Unchanged);
            this.label.setImage(null);
        } else if (this.currentValue == null) {
            this.label.setText(Messages.ReferenceDialog_Unset);
            this.label.setImage(null);
        } else {
            this.label.setText(this.labelProvider.getText(value));
            this.label.setImage(this.labelProvider.getImage(value));
        }
    }
}

