/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.tools.internal.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.EClassImpl;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EContentsEList;
import org.eclipse.emf.ecore.util.ECrossReferenceAdapter;
import org.eclipse.emf.ecore.util.ECrossReferenceEList;
import org.eclipse.emf.ecore.util.ExtendedMetaData;
import org.eclipse.emf.ecore.util.FeatureMapUtil;
import org.eclipse.emf.ecore.util.InternalEList;

public class CrossReferenceAdapter
extends ECrossReferenceAdapter {
    private static Map<EClass, List<EStructuralFeature>> eClassToChangeableFeatures = new HashMap<EClass, List<EStructuralFeature>>();
    private static List nullList = new ArrayList(1);
    private Map<Resource, Map<Resource, Counter>> imports = new HashMap<Resource, Map<Resource, Counter>>();
    private Map<Resource, Map<Resource, Counter>> exports = new HashMap<Resource, Map<Resource, Counter>>();
    private boolean resolve = true;

    public CrossReferenceAdapter() {
        this(true);
    }

    public CrossReferenceAdapter(boolean resolve) {
        this.resolve = resolve;
    }

    public void selfAdapt(Notification notification) {
        super.selfAdapt(notification);
        Object notifier = notification.getNotifier();
        Object feature = notification.getFeature();
        if (notifier instanceof Resource) {
            if (notification.getFeatureID(Resource.class) == 4) {
                if (!notification.getNewBooleanValue()) {
                    this.deregisterReferences((Resource)notifier);
                } else {
                    for (EObject child : ((Resource)notifier).getContents()) {
                        if (child == null) continue;
                        this.updateImportsAndExports((Resource)notifier, child, true);
                    }
                }
            }
            return;
        }
        if (!(notifier instanceof EObject) || !(feature instanceof EReference)) {
            return;
        }
        EReference reference = (EReference)feature;
        if (this.isImportExportCapable(reference, (EObject)notifier)) {
            switch (notification.getEventType()) {
                case 1: 
                case 2: 
                case 9: {
                    EObject newValue;
                    EObject oldValue = (EObject)notification.getOldValue();
                    if (oldValue != null) {
                        this.deregisterReference(((EObject)notification.getNotifier()).eResource(), oldValue.eResource());
                    }
                    if ((newValue = (EObject)notification.getNewValue()) == null) break;
                    this.registerReference(((EObject)notification.getNotifier()).eResource(), newValue.eResource());
                    break;
                }
                case 3: {
                    EObject newValue = (EObject)notification.getNewValue();
                    if (newValue == null) break;
                    this.registerReference(((EObject)notification.getNotifier()).eResource(), newValue.eResource());
                    break;
                }
                case 5: {
                    Collection newValues = (Collection)notification.getNewValue();
                    for (EObject newValue : newValues) {
                        this.registerReference(((EObject)notification.getNotifier()).eResource(), newValue.eResource());
                    }
                    break;
                }
                case 4: {
                    EObject oldValue = (EObject)notification.getOldValue();
                    if (oldValue == null) break;
                    this.deregisterReference(((EObject)notification.getNotifier()).eResource(), oldValue.eResource());
                    break;
                }
                case 6: {
                    Collection oldValues = (Collection)notification.getOldValue();
                    for (EObject oldValue : oldValues) {
                        this.deregisterReference(((EObject)notification.getNotifier()).eResource(), oldValue.eResource());
                    }
                    break;
                }
            }
        }
    }

    protected void handleContainment(Notification notification) {
        super.handleContainment(notification);
        Object notifier = notification.getNotifier();
        if (notifier instanceof ResourceSet) {
            return;
        }
        switch (notification.getEventType()) {
            case 3: {
                EObject newValue = (EObject)notification.getNewValue();
                if (newValue == null) break;
                Resource resource = notifier instanceof Resource ? (Resource)notifier : ((EObject)notification.getNotifier()).eResource();
                this.updateImportsAndExports(resource, newValue, true);
                break;
            }
            case 5: {
                Resource resource = notifier instanceof Resource ? (Resource)notifier : ((EObject)notification.getNotifier()).eResource();
                Collection newValues = (Collection)notification.getNewValue();
                for (EObject next : newValues) {
                    if (next == null) continue;
                    this.updateImportsAndExports(resource, next, true);
                }
                break;
            }
            case 4: {
                EObject oldValue = (EObject)notification.getOldValue();
                if (oldValue == null) break;
                Resource resource = notifier instanceof Resource ? (Resource)notifier : ((EObject)notification.getNotifier()).eResource();
                this.updateImportsAndExports(resource, oldValue, false);
                break;
            }
            case 6: {
                Resource resource;
                if (notifier instanceof Resource) {
                    resource = (Resource)notifier;
                    if (!resource.isLoaded()) {
                        this.deregisterReferences(resource);
                        return;
                    }
                } else {
                    resource = ((EObject)notification.getNotifier()).eResource();
                }
                Collection oldValues = (Collection)notification.getOldValue();
                for (EObject next : oldValues) {
                    if (next == null) continue;
                    this.updateImportsAndExports(resource, next, false);
                }
                break;
            }
        }
    }

    public void updateImportsAndExports(Resource resource, EObject value, boolean register) {
        CrossReferenceAdapter adapter = CrossReferenceAdapter.getExistingCrossReferenceAdapter((Notifier)value);
        if (register) {
            if (adapter != null) {
                for (EStructuralFeature.Setting next : adapter.getInverseReferences(value)) {
                    EObject owner;
                    EReference ref = (EReference)next.getEStructuralFeature();
                    if (!this.isImportExportCapable(ref, owner = next.getEObject())) continue;
                    this.registerReference(owner.eResource(), resource);
                }
            }
        } else {
            EContentsEList.FeatureIterator<EObject> crossReferences = this.getOptimizedCrossReferenceIterator(value);
            while (crossReferences.hasNext()) {
                EReference eReference;
                EObject referent = (EObject)crossReferences.next();
                if (referent == null || !this.isImportExportCapable(eReference = (EReference)crossReferences.feature(), referent)) continue;
                Resource referencedResource = referent.eResource();
                this.deregisterReference(resource, referencedResource);
            }
            if (adapter != null) {
                for (EStructuralFeature.Setting next : adapter.getInverseReferences(value)) {
                    EObject owner;
                    EReference ref = (EReference)next.getEStructuralFeature();
                    if (!this.isImportExportCapable(ref, owner = next.getEObject())) continue;
                    this.deregisterReference(owner.eResource(), resource);
                }
            }
        }
        if (adapter != null) {
            adapter.updateImportsAndExportsForContents(resource, value, register);
        }
    }

    public void updateImportsAndExportsForContents(Resource resource, EObject value, boolean register) {
        Iterator i = this.resolve() ? value.eContents().iterator() : ((InternalEList)value.eContents()).basicIterator();
        while (i.hasNext()) {
            this.updateImportsAndExports(resource, (EObject)i.next(), register);
        }
    }

    public void setTarget(Notifier target) {
        super.setTarget(target);
        if (target instanceof EObject) {
            EObject eObject = (EObject)target;
            Resource resource = eObject.eResource();
            EContentsEList.FeatureIterator<EObject> crossReferences = this.getOptimizedCrossReferenceIterator(eObject);
            while (crossReferences.hasNext()) {
                EReference eReference;
                EObject referent = (EObject)crossReferences.next();
                if (referent == null || !this.isImportExportCapable(eReference = (EReference)crossReferences.feature(), referent)) continue;
                Resource referencedResource = referent.eResource();
                this.registerReference(resource, referencedResource);
            }
        }
    }

    public void unsetTarget(Notifier notifier) {
        super.unsetTarget(notifier);
        if (notifier instanceof Resource) {
            this.deregisterReferences((Resource)notifier);
        }
    }

    public Set<Resource> getImports(Resource referencer) {
        Map<Resource, Counter> importsMap = this.getImportsMap(referencer);
        if (importsMap != null) {
            return Collections.unmodifiableSet(importsMap.keySet());
        }
        return Collections.emptySet();
    }

    public Set<Resource> getExports(Resource referenced) {
        Map<Resource, Counter> exportsMap = this.getExportsMap(referenced);
        if (exportsMap != null) {
            return Collections.unmodifiableSet(exportsMap.keySet());
        }
        return Collections.emptySet();
    }

    private Map<Resource, Counter> getImportsMap(Resource resource) {
        return this.imports.get(resource);
    }

    private Map<Resource, Counter> getExportsMap(Resource resource) {
        return this.exports.get(resource);
    }

    private void registerReference(Resource referencer, Resource referenced) {
        if (referencer != null && referenced != null && referencer != referenced) {
            Counter exportsCount;
            Counter importsCount;
            Map<Resource, Counter> importsMap = this.getImportsMap(referencer);
            if (importsMap == null) {
                importsMap = new HashMap<Resource, Counter>();
                this.imports.put(referencer, importsMap);
            }
            if ((importsCount = importsMap.get(referenced)) == null) {
                importsCount = new Counter();
                importsMap.put(referenced, importsCount);
                this.importAdded(referencer, referenced);
            } else {
                importsCount.inc();
            }
            Map<Resource, Counter> exportsMap = this.getExportsMap(referenced);
            if (exportsMap == null) {
                exportsMap = new HashMap<Resource, Counter>();
                this.exports.put(referenced, exportsMap);
            }
            if ((exportsCount = exportsMap.get(referencer)) == null) {
                exportsCount = new Counter();
                exportsMap.put(referencer, exportsCount);
                this.exportAdded(referenced, referencer);
            } else {
                exportsCount.inc();
            }
        }
    }

    protected void importAdded(Resource referencer, Resource referenced) {
    }

    protected void importRemoved(Resource referencer, Resource referenced) {
    }

    protected void exportAdded(Resource referenced, Resource referencer) {
    }

    protected void exportRemoved(Resource referenced, Resource referencer) {
    }

    private void deregisterReference(Resource referencer, Resource referenced) {
        if (referencer != null && referenced != null && referencer != referenced) {
            Counter exportsCount;
            Map<Resource, Counter> exportsMap;
            Counter importsCount;
            Map<Resource, Counter> importsMap = this.getImportsMap(referencer);
            if (importsMap != null && (importsCount = importsMap.get(referenced)) != null && importsCount.dec()) {
                importsMap.remove(referenced);
                this.importRemoved(referencer, referenced);
                if (importsMap.isEmpty()) {
                    this.imports.remove(referencer);
                }
            }
            if ((exportsMap = this.getExportsMap(referenced)) != null && (exportsCount = exportsMap.get(referencer)) != null && exportsCount.dec()) {
                exportsMap.remove(referencer);
                this.exportRemoved(referenced, referencer);
                if (exportsMap.isEmpty()) {
                    this.exports.remove(referenced);
                }
            }
        }
    }

    private void deregisterReferences(Resource referencer) {
        Object[] resImports;
        Object[] objectArray = resImports = this.getImports(referencer).toArray();
        int n = resImports.length;
        int n2 = 0;
        while (n2 < n) {
            Map<Resource, Counter> exportsMap;
            Object resImport = objectArray[n2];
            Resource referenced = (Resource)resImport;
            Map<Resource, Counter> importsMap = this.getImportsMap(referencer);
            if (importsMap != null) {
                importsMap.remove(referenced);
                this.importRemoved(referencer, referenced);
                if (importsMap.isEmpty()) {
                    this.imports.remove(referencer);
                }
            }
            if ((exportsMap = this.getExportsMap(referenced)) != null) {
                exportsMap.remove(referencer);
                this.exportRemoved(referenced, referencer);
                if (exportsMap.isEmpty()) {
                    this.exports.remove(referenced);
                }
            }
            ++n2;
        }
    }

    public Set<EObject> getInverseReferencers(EObject referenced, EReference reference, EClass type) {
        return this.getReferencers(this.getInverseReferences(referenced), reference, type);
    }

    public Set<EObject> getInverseReferencersCrossResource(EObject referenced, EReference reference, EClass type) {
        return this.getReferencers(this.getInverseReferencesCrossResource(referenced), reference, type);
    }

    public Collection<EStructuralFeature.Setting> getInverseReferencesCrossResource(EObject eObject) {
        return this.getInverseReferencesCrossResource(eObject, !this.resolve());
    }

    public Set<EObject> getNonNavigableInverseReferencers(EObject referenced, EReference reference, EClass type) {
        return this.getReferencers(this.getNonNavigableInverseReferences(referenced), reference, type);
    }

    private Set<EObject> getReferencers(Collection<EStructuralFeature.Setting> references, EReference reference, EClass type) {
        HashSet<EObject> set = new HashSet<EObject>();
        if (!references.isEmpty()) {
            for (EStructuralFeature.Setting setting : references) {
                EObject referencer;
                if (reference != null && reference != setting.getEStructuralFeature() || (referencer = setting.getEObject()) == null || type != null && !type.isInstance((Object)referencer)) continue;
                set.add(referencer);
            }
        }
        return set;
    }

    public static CrossReferenceAdapter getExistingCrossReferenceAdapter(Notifier notifier) {
        if (notifier == null) {
            return null;
        }
        CrossReferenceAdapter crossAdapter = null;
        EList adapters = notifier.eAdapters();
        int size = adapters.size();
        int i = 0;
        while (i < size) {
            Adapter adapter = (Adapter)adapters.get(i);
            if (adapter instanceof CrossReferenceAdapter) {
                crossAdapter = (CrossReferenceAdapter)adapter;
                break;
            }
            ++i;
        }
        return crossAdapter;
    }

    public static CrossReferenceAdapter getCrossReferenceAdapter(ResourceSet resourceSet) {
        if (resourceSet == null) {
            return null;
        }
        CrossReferenceAdapter result = CrossReferenceAdapter.getExistingCrossReferenceAdapter((Notifier)resourceSet);
        if (result == null) {
            result = new CrossReferenceAdapter();
            resourceSet.eAdapters().add((Object)result);
        }
        return result;
    }

    protected boolean resolve() {
        return this.resolve;
    }

    public Collection<EStructuralFeature.Setting> getInverseReferences(EObject eObject, boolean resolve1) {
        Collection nonNavigableInverseReferences;
        EObject eContainer;
        ArrayList<EStructuralFeature.Setting> result = new ArrayList<EStructuralFeature.Setting>();
        if (resolve1) {
            this.resolveAll(eObject);
        }
        if ((eContainer = eObject.eContainer()) != null) {
            result.add(((InternalEObject)eContainer).eSetting((EStructuralFeature)eObject.eContainmentFeature()));
        }
        if ((nonNavigableInverseReferences = (Collection)this.inverseCrossReferencer.get((Object)eObject)) != null) {
            result.addAll(nonNavigableInverseReferences);
        }
        for (EReference eReference : eObject.eClass().getEAllReferences()) {
            EReference eOpposite = eReference.getEOpposite();
            if (eOpposite == null || eReference.isContainer() || eReference.isContainment() || !eObject.eIsSet((EStructuralFeature)eReference)) continue;
            if (FeatureMapUtil.isMany((EObject)eObject, (EStructuralFeature)eReference)) {
                Object collection = eObject.eGet((EStructuralFeature)eReference);
                Iterator j = this.resolve() ? ((Collection)collection).iterator() : ((InternalEList)collection).basicIterator();
                while (j.hasNext()) {
                    InternalEObject referencingEObject = (InternalEObject)j.next();
                    result.add(referencingEObject.eSetting((EStructuralFeature)eOpposite));
                }
                continue;
            }
            InternalEObject referencingEObject = (InternalEObject)eObject.eGet((EStructuralFeature)eReference, this.resolve());
            if (referencingEObject == null) continue;
            result.add(referencingEObject.eSetting((EStructuralFeature)eOpposite));
        }
        return result;
    }

    private static List<EStructuralFeature> getCrossReferencesChangeableFeatures(EClass eCls) {
        ArrayList<EStructuralFeature> features = eClassToChangeableFeatures.get(eCls);
        if (features == null) {
            features = nullList;
            EStructuralFeature[] crossReferenceFeatures = ((EClassImpl.FeatureSubsetSupplier)eCls.getEAllStructuralFeatures()).crossReferences();
            if (crossReferenceFeatures != null) {
                features = new ArrayList<EStructuralFeature>(crossReferenceFeatures.length);
                EStructuralFeature[] eStructuralFeatureArray = crossReferenceFeatures;
                int n = crossReferenceFeatures.length;
                int n2 = 0;
                while (n2 < n) {
                    EStructuralFeature feature = eStructuralFeatureArray[n2];
                    if (CrossReferenceAdapter.isMutable(feature)) {
                        features.add(feature);
                    }
                    ++n2;
                }
            }
            eClassToChangeableFeatures.put(eCls, (List<EStructuralFeature>)features);
        }
        return features != nullList ? features : null;
    }

    static boolean isMutable(EStructuralFeature feature) {
        boolean result = feature.isChangeable();
        if (result && feature.isDerived()) {
            EStructuralFeature group = ExtendedMetaData.INSTANCE.getGroup(feature);
            result = group != null && !FeatureMapUtil.isFeatureMap((EStructuralFeature)feature);
        }
        return result;
    }

    private EContentsEList.FeatureIterator<EObject> getOptimizedCrossReferenceIterator(EObject eObj) {
        List<EStructuralFeature> features = CrossReferenceAdapter.getCrossReferencesChangeableFeatures(eObj.eClass());
        if (features != null) {
            Object list = null;
            list = features.size() > 0 ? new ECrossReferenceEList<EObject>(eObj, features.toArray(new EStructuralFeature[features.size()])){} : ECrossReferenceEList.emptyCrossReferenceEList();
            return (EContentsEList.FeatureIterator)(this.resolve() ? list.iterator() : list.basicIterator());
        }
        ECrossReferenceEList list = ECrossReferenceEList.emptyCrossReferenceEList();
        return (EContentsEList.FeatureIterator)list.iterator();
    }

    public Collection<EStructuralFeature.Setting> getInverseReferencesCrossResource(EObject eObject, boolean resolveProxies) {
        Collection nonNavigableInverseReferences;
        EObject eContainer;
        ArrayList<EStructuralFeature.Setting> result = new ArrayList<EStructuralFeature.Setting>();
        if (resolveProxies) {
            this.resolveAll(eObject);
        }
        if ((eContainer = eObject.eContainer()) != null) {
            result.add(((InternalEObject)eContainer).eSetting((EStructuralFeature)eObject.eContainmentFeature()));
        }
        if ((nonNavigableInverseReferences = (Collection)this.inverseCrossReferencer.get((Object)eObject)) != null) {
            result.addAll(nonNavigableInverseReferences);
        }
        for (EReference eReference : eObject.eClass().getEAllReferences()) {
            EReference eOpposite = eReference.getEOpposite();
            if (eOpposite == null || !this.isImportExportCapable(eReference, eObject) || !eObject.eIsSet((EStructuralFeature)eReference)) continue;
            if (FeatureMapUtil.isMany((EObject)eObject, (EStructuralFeature)eReference)) {
                Object collection = eObject.eGet((EStructuralFeature)eReference);
                Iterator j = this.resolve() ? ((Collection)collection).iterator() : ((InternalEList)collection).basicIterator();
                while (j.hasNext()) {
                    InternalEObject referencingEObject = (InternalEObject)j.next();
                    result.add(referencingEObject.eSetting((EStructuralFeature)eOpposite));
                }
                continue;
            }
            InternalEObject referencingEObject = (InternalEObject)eObject.eGet((EStructuralFeature)eReference, this.resolve());
            if (referencingEObject == null) continue;
            result.add(referencingEObject.eSetting((EStructuralFeature)eOpposite));
        }
        return result;
    }

    protected boolean isImportExportCapable(EReference reference, EObject owner) {
        return !reference.isContainer() && !reference.isContainment() && reference.isResolveProxies() && reference.isChangeable();
    }

    private static final class Counter {
        private int value = 1;

        Counter() {
        }

        int getValue() {
            return this.value;
        }

        void inc() {
            ++this.value;
        }

        boolean dec() {
            return --this.value <= 0;
        }
    }
}

