/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.business.internal.session.danalysis;

import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.LinkedHashSet;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.transaction.NotificationFilter;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.sirius.business.api.session.ModelChangeTrigger;
import org.eclipse.sirius.common.tools.api.query.NotificationQuery;
import org.eclipse.sirius.ext.base.Option;
import org.eclipse.sirius.ext.base.Options;

public class TrackingModificationTrigger
implements ModelChangeTrigger {
    public static final NotificationFilter IS_CHANGE = new NotificationFilter.Custom(){

        public boolean matches(Notification notification) {
            return !notification.isTouch() && !new NotificationQuery(notification).isTransientNotification();
        }
    };
    private final TransactionalEditingDomain domain;

    public TrackingModificationTrigger(TransactionalEditingDomain domain) {
        this.domain = domain;
    }

    @Override
    public Option<Command> localChangesAboutToCommit(Collection<Notification> notifications) {
        final LinkedHashSet impactedResources = Sets.newLinkedHashSet();
        LinkedHashSet impactedObjects = Sets.newLinkedHashSet();
        for (Notification change : notifications) {
            Resource res;
            EObject changed;
            if (!(change.getNotifier() instanceof EObject) || change.getNotifier() instanceof Resource || !impactedObjects.add(changed = (EObject)change.getNotifier()) || (res = changed.eResource()) == null || res.isModified()) continue;
            impactedResources.add(res);
        }
        if (!impactedResources.isEmpty()) {
            RecordingCommand setIsModified = new RecordingCommand(this.domain){

                protected void doExecute() {
                    for (Resource resource : impactedResources) {
                        resource.setModified(true);
                    }
                }
            };
            return Options.newSome((Object)setIsModified);
        }
        return Options.newNone();
    }

    @Override
    public int priority() {
        return 10;
    }
}

