/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.business.internal.session.danalysis;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.sirius.business.api.dialect.DialectManager;
import org.eclipse.sirius.business.api.query.ViewpointQuery;
import org.eclipse.sirius.business.internal.movida.VSMResolver;
import org.eclipse.sirius.business.internal.movida.ViewpointResourceOperations;
import org.eclipse.sirius.business.internal.movida.registry.ViewpointRegistry;
import org.eclipse.sirius.business.internal.session.danalysis.DAnalysisSessionImpl;
import org.eclipse.sirius.ext.base.Option;
import org.eclipse.sirius.viewpoint.DAnalysis;
import org.eclipse.sirius.viewpoint.DRepresentation;
import org.eclipse.sirius.viewpoint.DView;
import org.eclipse.sirius.viewpoint.description.Viewpoint;

final class MovidaSupport {
    private DAnalysisSessionImpl session;
    private Set<URI> vsmResources;

    MovidaSupport(DAnalysisSessionImpl session) {
        this.session = session;
    }

    void updatePhysicalVSMResourceURIs(Collection<Viewpoint> selectedViewpoints) {
        HashSet selected = Sets.newHashSet((Iterable)Iterables.filter((Iterable)Iterables.transform(selectedViewpoints, (Function)new Function<Viewpoint, URI>(){

            public URI apply(Viewpoint from) {
                return (URI)new ViewpointQuery(from).getViewpointURI().get();
            }
        }), (Predicate)Predicates.notNull()));
        this.vsmResources = new VSMResolver((ViewpointRegistry)org.eclipse.sirius.business.api.componentization.ViewpointRegistry.getInstance()).resolve(selected);
    }

    void registryChanged(final ViewpointRegistry registry, Set<URI> removed, Set<URI> added, Set<URI> changed) {
        Resource vsm;
        TransactionalEditingDomain transactionalEditingDomain = this.session.getTransactionalEditingDomain();
        HashSet selected = Sets.newHashSet((Iterable)Iterables.transform(this.session.getSelectedViewpoints(false), (Function)new Function<Viewpoint, URI>(){

            public URI apply(Viewpoint from) {
                return (URI)new ViewpointQuery(from).getViewpointURI().get();
            }
        }));
        Sets.SetView unavailable = Sets.intersection((Set)selected, removed);
        if (!unavailable.isEmpty()) {
            this.deselectMissingViewpoints((Sets.SetView<URI>)unavailable);
        }
        Set<URI> resourcesLoaded = this.vsmResources;
        Set<URI> resourcesRequired = new VSMResolver(registry).resolve(selected);
        HashSet resourcesChanged = Sets.newHashSet((Iterable)Iterables.transform((Iterable)Sets.intersection(changed, (Set)selected), (Function)new Function<URI, URI>(){

            public URI apply(URI logicalURI) {
                return (URI)registry.getProvider(logicalURI).get();
            }
        }));
        for (URI uri : Sets.difference(resourcesLoaded, resourcesRequired)) {
            vsm = transactionalEditingDomain.getResourceSet().getResource(uri, false);
            new ViewpointResourceOperations(vsm).unloadAndResetProxyURIs();
            transactionalEditingDomain.getResourceSet().getResources().remove((Object)vsm);
        }
        for (URI uri : resourcesChanged) {
            vsm = transactionalEditingDomain.getResourceSet().getResource(uri, false);
            if (vsm == null) continue;
            new ViewpointResourceOperations(vsm).unloadAndResetProxyURIs();
        }
        for (URI uri : Sets.difference(resourcesRequired, resourcesLoaded)) {
            transactionalEditingDomain.getResourceSet().getResource(uri, true);
        }
        for (DAnalysis analysis : this.session.allAnalyses()) {
            EcoreUtil.resolveAll((EObject)analysis);
        }
        this.vsmResources = resourcesRequired;
        transactionalEditingDomain.getCommandStack().execute((Command)new RecordingCommand(transactionalEditingDomain){

            protected void doExecute() {
                for (DView view : MovidaSupport.this.session.getSelectedViews()) {
                    for (DRepresentation representation : view.getAllRepresentations()) {
                        DialectManager.INSTANCE.refreshEffectiveRepresentationDescription(representation, (IProgressMonitor)new NullProgressMonitor());
                    }
                }
            }
        });
    }

    void deselectMissingViewpoints(final Sets.SetView<URI> unavailable) {
        NullProgressMonitor pm = new NullProgressMonitor();
        TransactionalEditingDomain ted = this.session.getTransactionalEditingDomain();
        ted.getCommandStack().execute((Command)new RecordingCommand(ted, (IProgressMonitor)pm){
            private final /* synthetic */ IProgressMonitor val$pm;
            {
                this.val$pm = iProgressMonitor;
                super($anonymous0);
            }

            protected void doExecute() {
                for (Viewpoint viewpoint : MovidaSupport.this.session.getSelectedViewpoints(false)) {
                    Option<URI> uri = new ViewpointQuery(viewpoint).getViewpointURI();
                    if (!uri.some() || !unavailable.contains(uri.get())) continue;
                    MovidaSupport.this.session.unselectSirius(viewpoint, this.val$pm);
                    DialectManager.INSTANCE.updateRepresentationsExtendedBy(MovidaSupport.this.session, viewpoint, false);
                }
            }
        });
    }
}

