/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.business.internal.metamodel.spec;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreEList;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.business.api.session.SessionManager;
import org.eclipse.sirius.viewpoint.DRepresentation;
import org.eclipse.sirius.viewpoint.DSemanticDecorator;
import org.eclipse.sirius.viewpoint.SiriusPlugin;
import org.eclipse.sirius.viewpoint.ViewpointPackage;
import org.eclipse.sirius.viewpoint.impl.DRepresentationContainerImpl;

public class DRepresentationContainerSpec
extends DRepresentationContainerImpl {
    @Override
    public EList<DRepresentation> getAllRepresentations() {
        ArrayList<DRepresentation> result = new ArrayList<DRepresentation>((Collection<DRepresentation>)this.getOwnedRepresentations());
        result.addAll((Collection<DRepresentation>)this.getReferencedRepresentations());
        return new EcoreEList.UnmodifiableEList(this.eInternalContainer(), (EStructuralFeature)ViewpointPackage.eINSTANCE.getDView_AllRepresentations(), result.size(), result.toArray());
    }

    @Override
    public void refresh() {
        HashSet<DRepresentation> representationsToDelete = new HashSet<DRepresentation>();
        for (DRepresentation representation : this.getAllRepresentations()) {
            if (representation instanceof DSemanticDecorator && ((DSemanticDecorator)((Object)representation)).getTarget() == null) {
                representationsToDelete.add(representation);
            }
            if (representationsToDelete.contains(representation)) continue;
            representation.refresh();
        }
        for (EObject next : representationsToDelete) {
            Session session = next instanceof DSemanticDecorator ? SessionManager.INSTANCE.getSession(((DSemanticDecorator)next).getTarget()) : SessionManager.INSTANCE.getSession(next);
            SiriusPlugin.getDefault().getModelAccessorRegistry().getModelAccessor(next).eDelete(next, session != null ? session.getSemanticCrossReferencer() : null);
        }
    }

    @Override
    public EList<EObject> getModels() {
        HashSet<EObject> models = new HashSet<EObject>(3);
        for (DRepresentation representation : this.getAllRepresentations()) {
            if (!(representation instanceof DSemanticDecorator)) continue;
            models.add(this.getModel(((DSemanticDecorator)((Object)representation)).getTarget()));
        }
        return new EcoreEList.UnmodifiableEList(this.eInternalContainer(), (EStructuralFeature)ViewpointPackage.eINSTANCE.getDRepresentationContainer_Models(), models.size(), models.toArray());
    }

    private EObject getModel(EObject target) {
        if (target != null && target.eResource() != null) {
            return (EObject)target.eResource().getContents().iterator().next();
        }
        return target;
    }
}

