/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.business.internal.contribution;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.sirius.description.contribution.AddFeatureContribution;
import org.eclipse.sirius.description.contribution.ClearFeatureContribution;
import org.eclipse.sirius.description.contribution.FeatureContribution;
import org.eclipse.sirius.description.contribution.IgnoreFeatureContribution;
import org.eclipse.sirius.description.contribution.RemoveFeatureContribution;
import org.eclipse.sirius.description.contribution.ResetFeatureContribution;
import org.eclipse.sirius.description.contribution.SetFeatureContribution;
import org.eclipse.sirius.description.contribution.util.ContributionSwitch;
import org.eclipse.sirius.ext.emf.EStructuralFeatureQuery;

public class FeatureContributor {
    private static final String TARGET_OBJECT = "Target object";
    private static final String SOURCE_OBJECT = "Source object";
    private final FeatureContribution contribution;
    private Set<EObject> additions;

    public FeatureContributor(FeatureContribution contribution) {
        this.contribution = (FeatureContribution)Preconditions.checkNotNull((Object)contribution);
        Preconditions.checkArgument((contribution.getTargetFeature() != null ? 1 : 0) != 0, (Object)"No target feature specified.");
        Preconditions.checkArgument((boolean)contribution.getTargetFeature().isChangeable(), (Object)"Target feature not modifiable.");
        Preconditions.checkArgument((boolean)new EStructuralFeatureQuery(contribution.getTargetFeature()).isAssignableFrom(contribution.getSourceFeature()), (Object)"Incompatible source and target features.");
    }

    public Set<EObject> apply(final EObject target, final EObject source) {
        Preconditions.checkNotNull((Object)source, (Object)"No source object specified.");
        Preconditions.checkNotNull((Object)target, (Object)"No target object specified.");
        this.additions = Collections.emptySet();
        ContributionSwitch<Void> contributionSwitch = new ContributionSwitch<Void>(){

            @Override
            public Void caseIgnoreFeatureContribution(IgnoreFeatureContribution object) {
                return null;
            }

            @Override
            public Void caseSetFeatureContribution(SetFeatureContribution sfc) {
                FeatureContributor.this.doSet(target, source, sfc);
                return null;
            }

            @Override
            public Void caseAddFeatureContribution(AddFeatureContribution afc) {
                FeatureContributor.this.doAdd(target, source, afc);
                return null;
            }

            @Override
            public Void caseRemoveFeatureContribution(RemoveFeatureContribution afc) {
                FeatureContributor.this.doRemove(target, source, afc);
                return null;
            }

            @Override
            public Void caseClearFeatureContribution(ClearFeatureContribution cfc) {
                FeatureContributor.this.doClear(target, cfc);
                return null;
            }

            @Override
            public Void caseResetFeatureContribution(ResetFeatureContribution rfc) {
                FeatureContributor.this.doReset(target, rfc);
                return null;
            }
        };
        contributionSwitch.doSwitch(this.contribution);
        return this.additions;
    }

    private void doSet(EObject target, EObject source, SetFeatureContribution sfc) {
        EStructuralFeature sourceFeature = sfc.getSourceFeature();
        EStructuralFeature targetFeature = sfc.getTargetFeature();
        EObject value = sourceFeature != null ? source.eGet(sourceFeature) : source;
        target.eSet(targetFeature, (Object)value);
        if (this.isAddition()) {
            this.additions = Collections.singleton(value);
        }
    }

    private void doAdd(EObject target, EObject source, AddFeatureContribution afc) {
        EStructuralFeature sourceFeature = afc.getSourceFeature();
        if (sourceFeature != null) {
            Preconditions.checkArgument((boolean)sourceFeature.isMany());
            this.checkFeatureIsPresent(source, sourceFeature, SOURCE_OBJECT);
        }
        EStructuralFeature targetFeature = afc.getTargetFeature();
        Preconditions.checkArgument((boolean)targetFeature.isMany());
        this.checkFeatureIsPresent(target, targetFeature, TARGET_OBJECT);
        Collection<Object> targetValues = this.getMany(target, targetFeature);
        Collection<Object> sourceValues = sourceFeature != null ? this.getMany(source, sourceFeature) : Collections.singletonList(source);
        if (this.isAddition()) {
            this.additions = ImmutableSet.copyOf((Iterable)Iterables.filter(sourceValues, EObject.class));
        }
        targetValues.addAll(sourceValues);
    }

    private void doRemove(EObject target, EObject source, RemoveFeatureContribution afc) {
        EStructuralFeature sourceFeature = afc.getSourceFeature();
        if (sourceFeature != null) {
            Preconditions.checkArgument((boolean)sourceFeature.isMany());
            this.checkFeatureIsPresent(source, sourceFeature, SOURCE_OBJECT);
        }
        EStructuralFeature targetFeature = afc.getTargetFeature();
        Preconditions.checkArgument((boolean)targetFeature.isMany());
        this.checkFeatureIsPresent(target, targetFeature, TARGET_OBJECT);
        Collection<Object> targetValues = this.getMany(target, targetFeature);
        Collection<Object> sourceValues = sourceFeature != null ? this.getMany(source, sourceFeature) : Collections.singletonList(source);
        targetValues.removeAll(sourceValues);
    }

    private void doClear(EObject target, ClearFeatureContribution cfc) {
        EStructuralFeature targetFeature = cfc.getTargetFeature();
        Preconditions.checkArgument((boolean)targetFeature.isMany());
        this.checkFeatureIsPresent(target, targetFeature, TARGET_OBJECT);
        Collection<Object> targetValues = this.getMany(target, targetFeature);
        targetValues.clear();
    }

    private void doReset(EObject target, ResetFeatureContribution rfc) {
        EStructuralFeature targetFeature = rfc.getTargetFeature();
        this.checkFeatureIsPresent(target, targetFeature, TARGET_OBJECT);
        target.eUnset(targetFeature);
    }

    private Collection<Object> getMany(EObject target, EStructuralFeature targetFeature) {
        Object rawValue = target.eGet(targetFeature);
        if (rawValue != null && !(rawValue instanceof Collection)) {
            throw new RuntimeException(MessageFormat.format("Expected a collection from many-valued feature {0} but got a {1}", this.featureString(targetFeature), rawValue.getClass()));
        }
        return (Collection)rawValue;
    }

    private String featureString(EStructuralFeature feature) {
        return String.valueOf(feature.getContainerClass().getName()) + "." + feature.getName();
    }

    private void checkFeatureIsPresent(EObject obj, EStructuralFeature feature, String name) {
        boolean present = new EStructuralFeatureQuery(feature).existsIn(obj);
        Preconditions.checkArgument((boolean)present, (Object)MessageFormat.format("{0} ({1}) does not have feature {2}", name, obj, this.featureString(feature)));
    }

    private boolean isAddition() {
        return this.contribution.getTargetFeature() instanceof EReference && ((EReference)this.contribution.getTargetFeature()).isContainment();
    }
}

