/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.business.api.action;

import com.google.common.base.Preconditions;
import java.util.Collection;
import java.util.Map;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.sirius.business.api.action.AbstractExternalJavaAction;

public class MoveElementInListAction
extends AbstractExternalJavaAction {
    @Override
    public boolean canExecute(Collection<? extends EObject> selections) {
        return selections.size() == 1;
    }

    @Override
    public void execute(Collection<? extends EObject> selections, Map<String, Object> parameters) {
        EStructuralFeature feature;
        EObject element = this.getParameter(parameters, "element", EObject.class);
        EObject owner = this.getParameter(parameters, "referenceOwner", EObject.class);
        String refName = this.getParameter(parameters, "referenceName", String.class);
        EObject pred = this.getOptionalParameter(parameters, "predecessor", EObject.class);
        if (pred != null) {
            Preconditions.checkArgument((element != pred ? 1 : 0) != 0, (Object)"'element' and 'predecessor' must be different.");
        }
        Preconditions.checkArgument(((feature = owner.eClass().getEStructuralFeature(refName)) != null ? 1 : 0) != 0, (Object)("Owner element type " + owner.eClass().getName() + " does not have a feature named " + refName));
        String qName = String.valueOf(feature.getEContainingClass().getName()) + "." + feature.getName();
        Preconditions.checkArgument((boolean)(feature instanceof EReference), (Object)("Feature " + qName + " is not an EReference"));
        Preconditions.checkArgument((boolean)feature.isMany(), (Object)("Reference " + qName + " is not multi-valued"));
        Preconditions.checkArgument((boolean)feature.isChangeable(), (Object)("Reference " + qName + " is not changeable"));
        EList list = (EList)owner.eGet(feature);
        Preconditions.checkArgument((pred == null || list.contains((Object)pred) ? 1 : 0) != 0, (Object)"'predecessor' parameter is not a member of the designated list.");
        Preconditions.checkArgument((boolean)list.contains((Object)element), (Object)"'element' parameter is not a member of the designated list.");
        this.moveElementAfter(element, pred, (EList<EObject>)list);
    }

    public void moveElementAfter(EObject element, EObject pred, EList<EObject> list) {
        if (pred == null) {
            list.move(0, (Object)element);
        } else {
            int predIndex;
            int thisIndex = list.indexOf((Object)element);
            if (thisIndex > (predIndex = list.indexOf((Object)pred))) {
                list.move(predIndex + 1, (Object)element);
            } else {
                list.move(predIndex, (Object)element);
            }
        }
    }
}

