/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.incquery.tooling.ui.wizards.internal.operations;

import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.emf.codegen.ecore.genmodel.GenModel;
import org.eclipse.emf.common.util.EList;
import org.eclipse.incquery.tooling.core.generator.genmodel.IEiqGenmodelProvider;
import org.eclipse.incquery.tooling.generator.model.generatorModel.GeneratorModelFactory;
import org.eclipse.incquery.tooling.generator.model.generatorModel.GeneratorModelReference;
import org.eclipse.incquery.tooling.generator.model.generatorModel.IncQueryGeneratorModel;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.xtext.ui.resource.IResourceSetProvider;
import org.eclipse.xtext.util.StringInputStream;

public class CreateGenmodelOperation
extends WorkspaceModifyOperation {
    private final IProject project;
    private final List<GenModel> genmodels;
    private final IEiqGenmodelProvider genmodelProvider;
    private final IResourceSetProvider resourceSetProvider;

    public CreateGenmodelOperation(IProject project, List<GenModel> genmodels, IEiqGenmodelProvider genmodelProvider, IResourceSetProvider resourceSetProvider) {
        this.project = project;
        this.genmodels = genmodels;
        this.genmodelProvider = genmodelProvider;
        this.resourceSetProvider = resourceSetProvider;
    }

    protected void execute(IProgressMonitor monitor) throws CoreException {
        try {
            IncQueryGeneratorModel generatorModel = this.genmodelProvider.getGeneratorModel(this.project, this.resourceSetProvider.get(this.project));
            EList genmodelRefs = generatorModel.getGenmodels();
            for (GenModel ecoreGenmodel : this.genmodels) {
                GeneratorModelReference ref = GeneratorModelFactory.eINSTANCE.createGeneratorModelReference();
                ref.setGenmodel(ecoreGenmodel);
                genmodelRefs.add((Object)ref);
            }
            if (genmodelRefs.isEmpty()) {
                IFile file = this.project.getFile("generator.eiqgen");
                file.create((InputStream)new StringInputStream(""), false, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
            } else {
                this.genmodelProvider.saveGeneratorModel(this.project, generatorModel);
            }
        }
        catch (IOException e) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.incquery.tooling.ui", "Cannot create generator model: " + e.getMessage(), (Throwable)e));
        }
    }
}

