/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.chess.multicore.commands;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.papyrus.MARTE.MARTE_Foundations.Alloc.Assign;
import org.eclipse.papyrus.infra.core.editor.IMultiDiagramEditor;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.infra.core.services.ServicesRegistry;
import org.eclipse.papyrus.infra.services.labelprovider.service.LabelProviderService;
import org.eclipse.papyrus.infra.widgets.providers.FilteredContentProvider;
import org.eclipse.papyrus.infra.widgets.providers.IStaticContentProvider;
import org.eclipse.papyrus.infra.widgets.providers.StaticContentProvider;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.Component;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.InstanceSpecification;
import org.eclipse.uml2.uml.Model;
import org.eclipse.uml2.uml.Package;
import org.polarsys.chess.chessmlprofile.Predictability.DeploymentConfiguration.HardwareBaseline.CH_HwProcessor;
import org.polarsys.chess.core.util.uml.ModelError;
import org.polarsys.chess.core.util.uml.UMLUtils;
import org.polarsys.chess.multicore.ReferenceSelectorNoDoubleClick;
import org.polarsys.chess.multicore.dialogs.CoreSelectorDialog;
import org.polarsys.chess.multicore.dialogs.SystemSelectionDialog;
import org.polarsys.chess.multicore.model.AbstractCommand;
import org.polarsys.chess.multicore.model.CHCore;
import org.polarsys.chess.multicore.model.CHTask;
import org.polarsys.chess.multicore.utils.GeneratorUtils;
import org.polarsys.chess.multicore.utils.QueryUtils;

public class AssignTasks2CoresCommand
extends AbstractCommand {
    private EList<CHTask> tasks;
    private Map<Package, EList<InstanceSpecification>> processorsMap = new HashMap<Package, EList<InstanceSpecification>>();
    private Map<InstanceSpecification, EList<CHCore>> coresMap = new HashMap<InstanceSpecification, EList<CHCore>>();
    private Map<CHCore, LinkedHashSet<Object>> result;
    private static Component hwSystem;
    private HashMap<CHTask, EList<CHTask>> operationList;
    private EList<Assign> assignments;
    private EList<InstanceSpecification> hwSystemsList = new BasicEList();

    private static InstanceSpecification openSystemSelector(Model umlModel, EList<InstanceSpecification> hwSystemsList) {
        ArrayList<InstanceSpecification> systemSelection = new ArrayList<InstanceSpecification>();
        for (InstanceSpecification syst : hwSystemsList) {
            systemSelection.add(syst);
        }
        Shell activeShell = Display.getDefault().getActiveShell();
        SystemSelectionDialog systemDialog = new SystemSelectionDialog(activeShell, systemSelection, "Select System where to assign tasks");
        if (systemDialog.open() == 0) {
            String selectedSystemQN = systemDialog.getSystemName();
            EList allElems = umlModel.allOwnedElements();
            for (Element elem : allElems) {
                InstanceSpecification theSystem;
                if (!(elem instanceof InstanceSpecification) || (theSystem = (InstanceSpecification)elem).getQualifiedName() == null || !theSystem.getQualifiedName().equals(selectedSystemQN)) continue;
                Classifier classif = (Classifier)theSystem.getClassifiers().get(0);
                hwSystem = (Component)classif;
                return theSystem;
            }
        }
        return null;
    }

    private static Map<CHCore, LinkedHashSet<Object>> openWizard(EList<CHTask> tasks, Package pack, EList<CHCore> cores, EList<Assign> assignments) {
        Map<CHCore, LinkedHashSet<Object>> result;
        ServicesRegistry servicesRegistry = ((IMultiDiagramEditor)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor()).getServicesRegistry();
        BasicEList taskNotYetAssignedToCore = new BasicEList();
        for (CHTask i : tasks) {
            if (QueryUtils.isTaskAssigned2Core(i, pack, assignments)) continue;
            taskNotYetAssignedToCore.add((Object)i);
        }
        ReferenceSelectorNoDoubleClick referenceSelector = new ReferenceSelectorNoDoubleClick(true, null, (EList<CHTask>)taskNotYetAssignedToCore);
        StaticContentProvider semanticProvider = new StaticContentProvider(tasks.toArray());
        FilteredContentProvider filteredProvider = new FilteredContentProvider((IStructuredContentProvider)semanticProvider);
        referenceSelector.setContentProvider((IStaticContentProvider)filteredProvider);
        CoreSelectorDialog dialog = null;
        ILabelProvider serv = null;
        try {
            serv = ((LabelProviderService)servicesRegistry.getService(LabelProviderService.class)).getLabelProvider();
        }
        catch (ServiceException serviceException) {}
        referenceSelector.setLabelProvider(serv);
        dialog = new CoreSelectorDialog(Display.getDefault().getActiveShell(), referenceSelector, cores, pack, assignments, 2, "Assign Tasks to Cores");
        dialog.setLabelProvider(serv);
        if (dialog.open() == 0 && (result = dialog.getResult()) != null) {
            return result;
        }
        return null;
    }

    @Override
    public void execute() throws ModelError {
        this.queryContent(this.umlModel);
        this.printContent();
        int howMany = this.hwSystemsList.size();
        InstanceSpecification theSystem = null;
        theSystem = howMany > 1 ? AssignTasks2CoresCommand.openSystemSelector(this.umlModel, this.hwSystemsList) : (InstanceSpecification)this.hwSystemsList.get(0);
        if (theSystem != null) {
            Package pack = QueryUtils.getOwnerCHGaResourcePlatformPackage(this.umlModel, theSystem);
            EList<InstanceSpecification> processorList = this.processorsMap.get(pack);
            BasicEList cores = new BasicEList();
            if (processorList != null) {
                for (InstanceSpecification proc : processorList) {
                    EList<CHCore> coreList = this.coresMap.get(proc);
                    for (CHCore core : coreList) {
                        cores.add((Object)core);
                    }
                }
            }
            this.result = AssignTasks2CoresCommand.openWizard(this.tasks, pack, (EList<CHCore>)cores, this.assignments);
            if (this.result != null) {
                this.updateModel();
            }
        }
    }

    private void printContent() {
        System.out.println("Tasks:");
        for (CHTask component : this.tasks) {
            System.out.println(component);
        }
        Set<Package> packs = this.processorsMap.keySet();
        for (Package pack : packs) {
            System.out.println("Package: " + pack.getName());
            EList<InstanceSpecification> procList = this.processorsMap.get(pack);
            for (InstanceSpecification theProc : procList) {
                System.out.println("Processor: " + theProc.getName());
                EList<CHCore> coreList = this.coresMap.get(theProc);
                for (CHCore theCore : coreList) {
                    System.out.println("Core: " + theCore.getName());
                }
            }
        }
    }

    private void updateModel() {
        TransactionalEditingDomain editingDomain = TransactionUtil.getEditingDomain((EObject)this.umlModel);
        editingDomain.getCommandStack().execute((Command)new Com(editingDomain));
    }

    private void queryContent(Model umlModel) throws ModelError {
        try {
            hwSystem = UMLUtils.getResourcePlatformComponent((Model)umlModel, (String)"DeploymentView");
        }
        catch (ModelError me) {
            ModelError me2 = new ModelError(String.valueOf(me.getMessage()) + " Be sure that HW root Components in the ComponentView are stereotyped with CHGaResourcePlatorm");
            throw me2;
        }
        EList<Package> packages = QueryUtils.getResourcePlatformPackages(umlModel, "DeploymentView");
        if (packages.size() == 0) {
            ModelError me = new ModelError("Error in model: no Package stereotyped as CHGAResourcePlatform in the Deployment View!");
            throw me;
        }
        this.hwSystemsList = new BasicEList();
        for (Package pack : packages) {
            BasicEList processors = new BasicEList();
            for (CH_HwProcessor ch_processor : QueryUtils.getAllProcessorInstancesInPackage(pack)) {
                InstanceSpecification instSpec = ch_processor.getBase_InstanceSpecification();
                processors.add((Object)instSpec);
                EList<CHCore> theCores = QueryUtils.getCores(ch_processor);
                this.coresMap.put(instSpec, theCores);
            }
            InstanceSpecification theSystem = UMLUtils.getRootInstanceInPackage((Package)pack);
            this.hwSystemsList.add((Object)theSystem);
            this.processorsMap.put(pack, (EList<InstanceSpecification>)processors);
        }
        if (this.hwSystemsList.isEmpty()) {
            ModelError me = new ModelError("Error in model: no System in the Deployment View!");
            throw me;
        }
        EList instances = UMLUtils.getAllComponentInstances((Model)umlModel, (boolean)true);
        this.tasks = QueryUtils.getCHTasksList((EList<InstanceSpecification>)instances);
        this.operationList = QueryUtils.getOperationChain(umlModel, this.tasks);
        this.assignments = UMLUtils.getTask2CoreAssignments((Model)umlModel, (String)"DeploymentView");
    }

    class Com
    extends RecordingCommand {
        private HashSet<CHTask> assignedOperations;

        public Com(TransactionalEditingDomain domain) {
            super(domain);
        }

        protected void doExecute() {
            HashMap<CHCore, LinkedHashSet<Object>> core2chtask = new HashMap<CHCore, LinkedHashSet<Object>>();
            for (CHCore core : AssignTasks2CoresCommand.this.result.keySet()) {
                this.assignedOperations = new HashSet();
                LinkedHashSet<Object> list = new LinkedHashSet<Object>();
                for (Object task : (LinkedHashSet)AssignTasks2CoresCommand.this.result.get(core)) {
                    CHTask owningTask = (CHTask)task;
                    list.add(owningTask);
                    this.addRelatedOperations(owningTask, list);
                }
                core2chtask.put(core, list);
            }
            QueryUtils.deleteTask2CoreAssociations(hwSystem);
            GeneratorUtils.buildTask2CoreAssociations(hwSystem, core2chtask);
        }

        private void addRelatedOperations(CHTask owningTask, LinkedHashSet<Object> list) {
            for (CHTask operation : (EList)AssignTasks2CoresCommand.this.operationList.get(owningTask)) {
                if (this.assignedOperations.contains(operation)) continue;
                list.add(operation);
                this.assignedOperations.add(operation);
            }
        }
    }
}

