/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.internal.bridge.genmodel;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.codegen.ecore.genmodel.GenModel;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.gmf.internal.bridge.genmodel.GenModelAccess;

public class FileGenModelAccess
implements GenModelAccess {
    private final URI myLocation;
    private GenModel myModel;

    public FileGenModelAccess(URI genModelResource) {
        this.myLocation = genModelResource;
    }

    public FileGenModelAccess(IFile genModelWorkspaceFile) {
        this(URI.createPlatformResourceURI((String)genModelWorkspaceFile.getFullPath().toString(), (boolean)true));
    }

    @Override
    public GenModel model() {
        return this.myModel;
    }

    @Override
    public IStatus load() {
        return this.load((ResourceSet)new ResourceSetImpl());
    }

    @Override
    public IStatus load(ResourceSet resourceSet) {
        if (this.myModel != null) {
            return Status.OK_STATUS;
        }
        try {
            Resource res = resourceSet.getResource(this.myLocation, true);
            Object root = res.getContents().get(0);
            if (root instanceof GenModel) {
                this.myModel = (GenModel)root;
                return Status.OK_STATUS;
            }
            return new Status(4, "org.eclipse.gmf.bridge", 0, "Root object of resource " + this.myLocation + " is not GenModel", null);
        }
        catch (RuntimeException ex) {
            return new Status(4, "org.eclipse.gmf.bridge", 0, "Can't load resource " + this.myLocation, (Throwable)ex);
        }
    }

    @Override
    public void unload() {
        if (this.myModel != null) {
            this.myModel.eResource().unload();
            this.myModel = null;
        }
    }
}

