/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.engine.generation.strategy;

import com.google.common.base.Charsets;
import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.List;
import java.util.Map;
import org.eclipse.acceleo.engine.AcceleoEnginePlugin;
import org.eclipse.acceleo.engine.generation.strategy.AbstractGenerationStrategy;
import org.eclipse.acceleo.engine.generation.strategy.IAcceleoGenerationStrategy;
import org.eclipse.acceleo.engine.generation.writers.AbstractAcceleoWriter;
import org.eclipse.acceleo.engine.generation.writers.AcceleoNullWriter;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.emf.common.EMFPlugin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DoNotGenerateGenerationStrategy
extends AbstractGenerationStrategy {
    private IAcceleoGenerationStrategy delegate;

    public DoNotGenerateGenerationStrategy(IAcceleoGenerationStrategy generationStrategy) {
        this.delegate = generationStrategy;
    }

    @Override
    public AbstractAcceleoWriter createWriterFor(File file, AbstractAcceleoWriter previous, boolean appendMode, boolean hasJMergeTags) throws IOException {
        if (EMFPlugin.IS_ECLIPSE_RUNNING && !this.shouldGenerate(file)) {
            return new AcceleoNullWriter();
        }
        return this.delegate.createWriterFor(file, previous, appendMode, hasJMergeTags);
    }

    @Override
    public AbstractAcceleoWriter createWriterFor(File file, AbstractAcceleoWriter previous, boolean appendMode, boolean hasJMergeTags, String charset) throws IOException {
        if (EMFPlugin.IS_ECLIPSE_RUNNING && !this.shouldGenerate(file)) {
            return new AcceleoNullWriter();
        }
        return this.delegate.createWriterFor(file, previous, appendMode, hasJMergeTags, charset);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean shouldGenerate(File file) {
        IFile workspaceFile = null;
        IFile[] filesForLocationURI = ResourcesPlugin.getWorkspace().getRoot().findFilesForLocationURI(file.toURI());
        Object object = filesForLocationURI;
        int n = filesForLocationURI.length;
        int n2 = 0;
        while (n2 < n) {
            IFile iFile = object[n2];
            IProject project = iFile.getProject();
            if (project.isAccessible()) {
                workspaceFile = iFile;
                break;
            }
            ++n2;
        }
        if (workspaceFile == null) return true;
        IFile doNotGenerateFile = workspaceFile.getProject().getFile(".do_not_generate");
        if (!doNotGenerateFile.exists()) return true;
        try {
            String line;
            List readLines = Files.readLines((File)doNotGenerateFile.getLocation().toFile(), (Charset)Charsets.US_ASCII);
            object = readLines.iterator();
            do {
                if (object.hasNext()) continue;
                return true;
            } while (!(line = (String)object.next()).trim().equals(workspaceFile.getFullPath().toString()));
            return false;
        }
        catch (IOException e) {
            AcceleoEnginePlugin.log(e, true);
        }
        return true;
    }

    @Override
    public void awaitCompletion() throws InterruptedException {
        this.delegate.awaitCompletion();
    }

    @Override
    public Map<String, StringWriter> createLostFile(String originalPath, Map<String, String> lostCode) {
        return this.delegate.createLostFile(originalPath, lostCode);
    }

    @Override
    public Map<String, StringWriter> createLostFiles(Map<String, Map<String, String>> lostCode) {
        return this.delegate.createLostFiles(lostCode);
    }

    @Override
    public void dispose() {
        this.delegate.dispose();
    }

    @Override
    public void flushWriter(String filePath, Writer writer) throws IOException {
        this.delegate.flushWriter(filePath, writer);
    }

    @Override
    public void flushWriters(Map<String, Writer> currentWriters) throws IOException {
        this.delegate.flushWriters(currentWriters);
    }

    @Override
    public Map<String, String> preparePreview(Map<String, Writer> currentWriters) {
        return this.delegate.preparePreview(currentWriters);
    }

    @Override
    public boolean willReturnPreview() {
        return this.delegate.willReturnPreview();
    }
}

