/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.alf.validation.typing;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.papyrus.uml.alf.alf.AdditiveExpression;
import org.eclipse.papyrus.uml.alf.alf.AlfPackage;
import org.eclipse.papyrus.uml.alf.alf.AndExpression;
import org.eclipse.papyrus.uml.alf.alf.BOOLEAN_LITERAL;
import org.eclipse.papyrus.uml.alf.alf.ClassExtentExpression;
import org.eclipse.papyrus.uml.alf.alf.ClassificationExpression;
import org.eclipse.papyrus.uml.alf.alf.CollectOrIterateOperation;
import org.eclipse.papyrus.uml.alf.alf.ConditionalAndExpression;
import org.eclipse.papyrus.uml.alf.alf.ConditionalOrExpression;
import org.eclipse.papyrus.uml.alf.alf.ConditionalTestExpression;
import org.eclipse.papyrus.uml.alf.alf.EqualityExpression;
import org.eclipse.papyrus.uml.alf.alf.ExclusiveOrExpression;
import org.eclipse.papyrus.uml.alf.alf.Expression;
import org.eclipse.papyrus.uml.alf.alf.ForAllOrExistsOrOneOperation;
import org.eclipse.papyrus.uml.alf.alf.INTEGER_LITERAL;
import org.eclipse.papyrus.uml.alf.alf.InclusiveOrExpression;
import org.eclipse.papyrus.uml.alf.alf.InstanceCreationExpression;
import org.eclipse.papyrus.uml.alf.alf.IsUniqueOperation;
import org.eclipse.papyrus.uml.alf.alf.LITERAL;
import org.eclipse.papyrus.uml.alf.alf.LinkOperationExpression;
import org.eclipse.papyrus.uml.alf.alf.MultiplicativeExpression;
import org.eclipse.papyrus.uml.alf.alf.NameExpression;
import org.eclipse.papyrus.uml.alf.alf.NonLiteralValueSpecification;
import org.eclipse.papyrus.uml.alf.alf.NullExpression;
import org.eclipse.papyrus.uml.alf.alf.OperationCallExpression;
import org.eclipse.papyrus.uml.alf.alf.ParenthesizedExpression;
import org.eclipse.papyrus.uml.alf.alf.PrimaryExpression;
import org.eclipse.papyrus.uml.alf.alf.PropertyCallExpression;
import org.eclipse.papyrus.uml.alf.alf.RelationalExpression;
import org.eclipse.papyrus.uml.alf.alf.STRING_LITERAL;
import org.eclipse.papyrus.uml.alf.alf.SelectOrRejectOperation;
import org.eclipse.papyrus.uml.alf.alf.SequenceConstructionExpression;
import org.eclipse.papyrus.uml.alf.alf.SequenceConstructionOrAccessCompletion;
import org.eclipse.papyrus.uml.alf.alf.SequenceElement;
import org.eclipse.papyrus.uml.alf.alf.SequenceExpansionExpression;
import org.eclipse.papyrus.uml.alf.alf.SequenceOperationExpression;
import org.eclipse.papyrus.uml.alf.alf.SequenceReductionExpression;
import org.eclipse.papyrus.uml.alf.alf.ShiftExpression;
import org.eclipse.papyrus.uml.alf.alf.SuffixExpression;
import org.eclipse.papyrus.uml.alf.alf.SuperInvocationExpression;
import org.eclipse.papyrus.uml.alf.alf.ThisExpression;
import org.eclipse.papyrus.uml.alf.alf.Tuple;
import org.eclipse.papyrus.uml.alf.alf.TupleElement;
import org.eclipse.papyrus.uml.alf.alf.UNLIMITED_LITERAL;
import org.eclipse.papyrus.uml.alf.alf.UnaryExpression;
import org.eclipse.papyrus.uml.alf.alf.UnqualifiedName;
import org.eclipse.papyrus.uml.alf.alf.ValueSpecification;
import org.eclipse.papyrus.uml.alf.scoping.AlfScopeProvider;
import org.eclipse.papyrus.uml.alf.validation.AlfJavaValidator;
import org.eclipse.papyrus.uml.alf.validation.typing.ErrorTypeFacade;
import org.eclipse.papyrus.uml.alf.validation.typing.MultiplicityFacadeFactory;
import org.eclipse.papyrus.uml.alf.validation.typing.SignatureFacade;
import org.eclipse.papyrus.uml.alf.validation.typing.SignatureFacadeFactory;
import org.eclipse.papyrus.uml.alf.validation.typing.TypeExpression;
import org.eclipse.papyrus.uml.alf.validation.typing.TypeExpressionFactory;
import org.eclipse.papyrus.uml.alf.validation.typing.TypeFacade;
import org.eclipse.papyrus.uml.alf.validation.typing.TypeFacadeFactory;
import org.eclipse.papyrus.uml.alf.validation.typing.TypeInferenceException;
import org.eclipse.uml2.uml.Behavior;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.Enumeration;
import org.eclipse.uml2.uml.Operation;
import org.eclipse.uml2.uml.Parameter;
import org.eclipse.uml2.uml.ParameterDirectionKind;
import org.eclipse.uml2.uml.PrimitiveType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TypeUtils {
    public static TypeFacade _undefined;
    public static TypeFacade _integer;
    public static TypeFacade _boolean;
    public static TypeFacade _unlimited;
    public static TypeFacade _natural;
    public static TypeFacade _string;
    public static TypeFacade _bitString;
    public static TypeExpression _nullExpression;
    public static TypeFacade _Collection;
    public static TypeFacade _Set;
    public static TypeFacade _Bag;
    public static TypeFacade _Queue;
    public static TypeFacade _OrderedSet;
    public static TypeFacade _List;
    public static TypeFacade _Deque;
    public static TypeFacade _Map;
    public static TypeFacade _Entry;
    public static Map<String, SignatureFacade> predefinedCollectionFunctions;
    private SuffixExpression suffixToBeIgnored = null;

    public TypeUtils() {
    }

    public TypeUtils(SuffixExpression suffixToBeIgnored) {
        this.suffixToBeIgnored = suffixToBeIgnored;
    }

    public TypeExpression getTypeOfExpression(Expression exp) {
        return this.getTypeOfConditionalTestExpression((ConditionalTestExpression)exp);
    }

    public TypeExpression getTypeOfConditionalTestExpression(ConditionalTestExpression exp) {
        if (exp.getWhenTrue() != null) {
            int trueFalseCompatibility;
            TypeExpression typeOfCondition = this.getTypeOfConditionalOrExpression(exp.getExp());
            if (typeOfCondition.getTypeFacade() instanceof ErrorTypeFacade) {
                ErrorTypeFacade error = (ErrorTypeFacade)typeOfCondition.getTypeFacade();
                return TypeExpressionFactory.eInstance.createTypeExpression(error);
            }
            if (TypeExpressionFactory.eInstance.createTypeExpression(_boolean).isCompatibleWithMe(typeOfCondition) != 3) {
                ErrorTypeFacade error = TypeFacadeFactory.eInstance.createErrorTypeFacade("An expression of type Boolean is expected. Found an expression of type " + typeOfCondition.getLabel(), exp, (EStructuralFeature)AlfPackage.eINSTANCE.getConditionalTestExpression_Exp());
                return TypeExpressionFactory.eInstance.createTypeExpression(error);
            }
            TypeExpression typeOfWhenTrue = this.getTypeOfConditionalTestExpression(exp.getWhenTrue());
            if (typeOfWhenTrue.getTypeFacade() instanceof ErrorTypeFacade) {
                ErrorTypeFacade error = (ErrorTypeFacade)typeOfWhenTrue.getTypeFacade();
                return TypeExpressionFactory.eInstance.createTypeExpression(error);
            }
            if (exp.getWhenFalse() == null) {
                ErrorTypeFacade error = TypeFacadeFactory.eInstance.createErrorTypeFacade("The 'when false' alternative is missing", exp, (EStructuralFeature)AlfPackage.eINSTANCE.getConditionalTestExpression_WhenFalse());
                return TypeExpressionFactory.eInstance.createTypeExpression(error);
            }
            TypeExpression typeOfWhenFalse = this.getTypeOfConditionalTestExpression(exp.getWhenFalse());
            if (typeOfWhenFalse.getTypeFacade() instanceof ErrorTypeFacade) {
                ErrorTypeFacade error = (ErrorTypeFacade)typeOfWhenFalse.getTypeFacade();
                return TypeExpressionFactory.eInstance.createTypeExpression(error);
            }
            int falseTrueCompatibility = typeOfWhenFalse.isCompatibleWithMe(typeOfWhenTrue);
            if (falseTrueCompatibility == (trueFalseCompatibility = typeOfWhenTrue.isCompatibleWithMe(typeOfWhenFalse))) {
                if (falseTrueCompatibility == 0) {
                    ErrorTypeFacade error = TypeFacadeFactory.eInstance.createErrorTypeFacade("The 'when true' and 'when false' alternatives must be type compatible", exp, (EStructuralFeature)AlfPackage.eINSTANCE.getConditionalTestExpression_WhenTrue());
                    return TypeExpressionFactory.eInstance.createTypeExpression(error);
                }
                return typeOfWhenTrue;
            }
            if (falseTrueCompatibility > trueFalseCompatibility) {
                return typeOfWhenFalse;
            }
            return typeOfWhenTrue;
        }
        return this.getTypeOfConditionalOrExpression(exp.getExp());
    }

    public TypeExpression getTypeOfConditionalOrExpression(ConditionalOrExpression exp) {
        if (exp.getExp().size() > 1) {
            TypeExpression previous = this.getTypeOfConditionalAndExpression((ConditionalAndExpression)exp.getExp().get(0));
            if (previous.getTypeFacade() instanceof ErrorTypeFacade) {
                return previous;
            }
            if (TypeExpressionFactory.eInstance.createTypeExpression(_boolean).isCompatibleWithMe(previous) == 0) {
                ErrorTypeFacade error = TypeFacadeFactory.eInstance.createErrorTypeFacade("Expecting an expression of type Boolean. Found an expression of type " + previous.getLabel(), exp, (EStructuralFeature)AlfPackage.eINSTANCE.getConditionalAndExpression_Exp());
                return TypeExpressionFactory.eInstance.createTypeExpression(error);
            }
            TypeExpression current = null;
            int i = 1;
            while (i < exp.getExp().size()) {
                ArrayList<TypeExpression> argumentTypes = new ArrayList<TypeExpression>();
                argumentTypes.add(previous);
                current = this.getTypeOfConditionalAndExpression((ConditionalAndExpression)exp.getExp().get(i));
                if (current.getTypeFacade() instanceof ErrorTypeFacade) {
                    return current;
                }
                if (TypeExpressionFactory.eInstance.createTypeExpression(_boolean).isCompatibleWithMe(current) == 0) {
                    ErrorTypeFacade error = TypeFacadeFactory.eInstance.createErrorTypeFacade("Operator || is undefined for (" + previous.getLabel() + ", " + current.getLabel() + ")", exp, (EStructuralFeature)AlfPackage.eINSTANCE.getConditionalAndExpression_Exp());
                    return TypeExpressionFactory.eInstance.createTypeExpression(error);
                }
                previous = current;
                ++i;
            }
            return current;
        }
        return this.getTypeOfConditionalAndExpression((ConditionalAndExpression)exp.getExp().get(0));
    }

    public TypeExpression getTypeOfConditionalAndExpression(ConditionalAndExpression exp) {
        if (exp.getExp().size() > 1) {
            TypeExpression previous = this.getTypeOfInclusiveOrExpression((InclusiveOrExpression)exp.getExp().get(0));
            if (previous.getTypeFacade() instanceof ErrorTypeFacade) {
                return previous;
            }
            if (TypeExpressionFactory.eInstance.createTypeExpression(_boolean).isCompatibleWithMe(previous) == 0) {
                ErrorTypeFacade error = TypeFacadeFactory.eInstance.createErrorTypeFacade("Expecting an expression of type Boolean. Found an expression of type " + previous.getLabel(), exp, (EStructuralFeature)AlfPackage.eINSTANCE.getConditionalAndExpression_Exp());
                return TypeExpressionFactory.eInstance.createTypeExpression(error);
            }
            TypeExpression current = null;
            int i = 1;
            while (i < exp.getExp().size()) {
                ArrayList<TypeExpression> argumentTypes = new ArrayList<TypeExpression>();
                argumentTypes.add(previous);
                current = this.getTypeOfInclusiveOrExpression((InclusiveOrExpression)exp.getExp().get(i));
                if (current.getTypeFacade() instanceof ErrorTypeFacade) {
                    return current;
                }
                if (TypeExpressionFactory.eInstance.createTypeExpression(_boolean).isCompatibleWithMe(current) == 0) {
                    ErrorTypeFacade error = TypeFacadeFactory.eInstance.createErrorTypeFacade("Operator && is undefined for (" + previous.getLabel() + ", " + current.getLabel() + ")", exp, (EStructuralFeature)AlfPackage.eINSTANCE.getConditionalAndExpression_Exp());
                    return TypeExpressionFactory.eInstance.createTypeExpression(error);
                }
                previous = current;
                ++i;
            }
            return current;
        }
        return this.getTypeOfInclusiveOrExpression((InclusiveOrExpression)exp.getExp().get(0));
    }

    public TypeExpression getTypeOfInclusiveOrExpression(InclusiveOrExpression exp) {
        if (exp.getExp().size() > 1) {
            TypeExpression previous = this.getTypeOfExclusiveOrExpression((ExclusiveOrExpression)exp.getExp().get(0));
            if (previous.getTypeFacade() instanceof ErrorTypeFacade) {
                return previous;
            }
            TypeExpression current = null;
            int i = 1;
            while (i < exp.getExp().size()) {
                ArrayList<TypeExpression> argumentTypes = new ArrayList<TypeExpression>();
                argumentTypes.add(previous);
                current = this.getTypeOfExclusiveOrExpression((ExclusiveOrExpression)exp.getExp().get(i));
                if (current.getTypeFacade() instanceof ErrorTypeFacade) {
                    return current;
                }
                argumentTypes.add(current);
                List<SignatureFacade> availableSignatures = AlfJavaValidator.predefinedBehaviorsAndTypes.getSignatures("|");
                List<SignatureFacade> applicableSignatures = SignatureFacade.findNearestSignature(argumentTypes, availableSignatures);
                if (applicableSignatures.isEmpty() || applicableSignatures.size() > 1) {
                    String message = "Operator | is undefined for (" + previous.getLabel() + ", " + current.getLabel() + ")";
                    ErrorTypeFacade error = TypeFacadeFactory.eInstance.createErrorTypeFacade(message, exp, (EStructuralFeature)AlfPackage.eINSTANCE.getExclusiveOrExpression_Exp());
                    return TypeExpressionFactory.eInstance.createTypeExpression(error);
                }
                previous = current = applicableSignatures.get(0).getReturnType();
                ++i;
            }
            return current;
        }
        return this.getTypeOfExclusiveOrExpression((ExclusiveOrExpression)exp.getExp().get(0));
    }

    public TypeExpression getTypeOfExclusiveOrExpression(ExclusiveOrExpression exp) {
        if (exp.getExp().size() > 1) {
            TypeExpression previous = this.getTypeOfAndExpression((AndExpression)exp.getExp().get(0));
            if (previous.getTypeFacade() instanceof ErrorTypeFacade) {
                return previous;
            }
            TypeExpression current = null;
            int i = 1;
            while (i < exp.getExp().size()) {
                ArrayList<TypeExpression> argumentTypes = new ArrayList<TypeExpression>();
                argumentTypes.add(previous);
                current = this.getTypeOfAndExpression((AndExpression)exp.getExp().get(i));
                if (current.getTypeFacade() instanceof ErrorTypeFacade) {
                    return current;
                }
                argumentTypes.add(current);
                List<SignatureFacade> availableSignatures = AlfJavaValidator.predefinedBehaviorsAndTypes.getSignatures("^");
                List<SignatureFacade> applicableSignatures = SignatureFacade.findNearestSignature(argumentTypes, availableSignatures);
                if (applicableSignatures.isEmpty() || applicableSignatures.size() > 1) {
                    String message = "Operator ^ is undefined for (" + previous.getLabel() + ", " + current.getLabel() + ")";
                    ErrorTypeFacade error = TypeFacadeFactory.eInstance.createErrorTypeFacade(message, exp, (EStructuralFeature)AlfPackage.eINSTANCE.getExclusiveOrExpression_Exp());
                    return TypeExpressionFactory.eInstance.createTypeExpression(error);
                }
                previous = current = applicableSignatures.get(0).getReturnType();
                ++i;
            }
            return current;
        }
        return this.getTypeOfAndExpression((AndExpression)exp.getExp().get(0));
    }

    public TypeExpression getTypeOfAndExpression(AndExpression exp) {
        if (exp.getExp().size() > 1) {
            TypeExpression previous = this.getTypeOfEqualityExpression((EqualityExpression)exp.getExp().get(0));
            if (previous.getTypeFacade() instanceof ErrorTypeFacade) {
                return previous;
            }
            TypeExpression current = null;
            int i = 1;
            while (i < exp.getExp().size()) {
                ArrayList<TypeExpression> argumentTypes = new ArrayList<TypeExpression>();
                argumentTypes.add(previous);
                current = this.getTypeOfEqualityExpression((EqualityExpression)exp.getExp().get(i));
                if (current.getTypeFacade() instanceof ErrorTypeFacade) {
                    return current;
                }
                argumentTypes.add(current);
                List<SignatureFacade> availableSignatures = AlfJavaValidator.predefinedBehaviorsAndTypes.getSignatures("&");
                List<SignatureFacade> applicableSignatures = SignatureFacade.findNearestSignature(argumentTypes, availableSignatures);
                if (applicableSignatures.isEmpty() || applicableSignatures.size() > 1) {
                    String message = "Operator & is undefined for (" + previous.getLabel() + ", " + current.getLabel() + ")";
                    ErrorTypeFacade error = TypeFacadeFactory.eInstance.createErrorTypeFacade(message, exp, (EStructuralFeature)AlfPackage.eINSTANCE.getAndExpression_Exp());
                    return TypeExpressionFactory.eInstance.createTypeExpression(error);
                }
                previous = current = applicableSignatures.get(0).getReturnType();
                ++i;
            }
            return current;
        }
        return this.getTypeOfEqualityExpression((EqualityExpression)exp.getExp().get(0));
    }

    public TypeExpression getTypeOfEqualityExpression(EqualityExpression exp) {
        if (exp.getExp().size() > 1) {
            for (ClassificationExpression classificationExp : exp.getExp()) {
                TypeExpression argType = this.getTypeOfClassificationExpression(classificationExp);
                if (!(argType.getTypeFacade() instanceof ErrorTypeFacade)) continue;
                return argType;
            }
            return TypeExpressionFactory.eInstance.createTypeExpression(_boolean);
        }
        return this.getTypeOfClassificationExpression((ClassificationExpression)exp.getExp().get(0));
    }

    public TypeExpression getTypeOfClassificationExpression(ClassificationExpression exp) {
        if (exp.getOp() != null) {
            TypeExpression typeOfClassifiedPart = this.getTypeOfRelationalExpression(exp.getExp());
            if (typeOfClassifiedPart.getTypeFacade() instanceof ErrorTypeFacade) {
                return typeOfClassifiedPart;
            }
            TypeFacade typeOfClassificationPart = TypeFacadeFactory.eInstance.createVoidFacade(exp.getTypeName());
            if (typeOfClassificationPart instanceof ErrorTypeFacade) {
                return TypeExpressionFactory.eInstance.createTypeExpression(typeOfClassificationPart);
            }
            return TypeExpressionFactory.eInstance.createTypeExpression(_boolean);
        }
        return this.getTypeOfRelationalExpression(exp.getExp());
    }

    public TypeExpression getTypeOfRelationalExpression(RelationalExpression exp) {
        if (exp.getOp() != null) {
            TypeExpression typeOfLeft = this.getTypeOfShiftExpression(exp.getLeft());
            if (typeOfLeft.getTypeFacade() instanceof ErrorTypeFacade) {
                return typeOfLeft;
            }
            if (exp.getRight() != null) {
                TypeExpression typeOfRight = this.getTypeOfShiftExpression(exp.getRight());
                if (typeOfRight.getTypeFacade() instanceof ErrorTypeFacade) {
                    return typeOfRight;
                }
                List<SignatureFacade> availableSignatures = AlfJavaValidator.predefinedBehaviorsAndTypes.getSignatures(exp.getOp());
                ArrayList<TypeExpression> argumentTypes = new ArrayList<TypeExpression>();
                argumentTypes.add(typeOfLeft);
                argumentTypes.add(typeOfRight);
                List<SignatureFacade> applicableSignatures = SignatureFacade.findNearestSignature(argumentTypes, availableSignatures);
                if (applicableSignatures.isEmpty() || applicableSignatures.size() > 1) {
                    String message = "Operator " + exp.getOp() + " is undefined for (" + typeOfLeft.getLabel() + ", " + typeOfRight.getLabel() + ")";
                    ErrorTypeFacade error = TypeFacadeFactory.eInstance.createErrorTypeFacade(message, exp, (EStructuralFeature)AlfPackage.eINSTANCE.getRelationalExpression_Op());
                    return TypeExpressionFactory.eInstance.createTypeExpression(error);
                }
                return applicableSignatures.get(0).getReturnType();
            }
            ErrorTypeFacade error = TypeFacadeFactory.eInstance.createErrorTypeFacade("Right operand missing", exp, (EStructuralFeature)AlfPackage.eINSTANCE.getRelationalExpression_Left());
            return TypeExpressionFactory.eInstance.createTypeExpression(error);
        }
        return this.getTypeOfShiftExpression(exp.getLeft());
    }

    public TypeExpression getTypeOfShiftExpression(ShiftExpression exp) {
        if (exp.getOp() != null) {
            if (exp.getExp().size() == 2) {
                TypeExpression typeOfLeft = this.getTypeOfAdditiveExpression((AdditiveExpression)exp.getExp().get(0));
                if (typeOfLeft.getTypeFacade() instanceof ErrorTypeFacade) {
                    return typeOfLeft;
                }
                TypeExpression typeOfRight = this.getTypeOfAdditiveExpression((AdditiveExpression)exp.getExp().get(1));
                if (typeOfRight.getTypeFacade() instanceof ErrorTypeFacade) {
                    return typeOfRight;
                }
                return TypeExpressionFactory.eInstance.createTypeExpression(_bitString);
            }
            if (exp.getExp().size() == 1) {
                TypeExpression typeOfLeft = this.getTypeOfAdditiveExpression((AdditiveExpression)exp.getExp().get(0));
                if (typeOfLeft.getTypeFacade() instanceof ErrorTypeFacade) {
                    return typeOfLeft;
                }
                ErrorTypeFacade error = TypeFacadeFactory.eInstance.createErrorTypeFacade("Right operand missing", exp, (EStructuralFeature)AlfPackage.eINSTANCE.getShiftExpression_Exp());
                return TypeExpressionFactory.eInstance.createTypeExpression(error);
            }
        }
        return this.getTypeOfAdditiveExpression((AdditiveExpression)exp.getExp().get(0));
    }

    public TypeExpression getTypeOfAdditiveExpression(AdditiveExpression exp) {
        if (exp.getExp().size() > 1) {
            TypeExpression previous = this.getTypeOfMultiplicativeExpression((MultiplicativeExpression)exp.getExp().get(0));
            if (previous.getTypeFacade() instanceof ErrorTypeFacade) {
                return previous;
            }
            TypeExpression current = null;
            int i = 1;
            while (i < exp.getExp().size()) {
                ArrayList<TypeExpression> argumentTypes = new ArrayList<TypeExpression>();
                argumentTypes.add(previous);
                current = this.getTypeOfMultiplicativeExpression((MultiplicativeExpression)exp.getExp().get(i));
                if (current.getTypeFacade() instanceof ErrorTypeFacade) {
                    return current;
                }
                argumentTypes.add(current);
                List<SignatureFacade> availableSignatures = AlfJavaValidator.predefinedBehaviorsAndTypes.getSignatures((String)exp.getOp().get(i - 1));
                List<SignatureFacade> applicableSignatures = SignatureFacade.findNearestSignature(argumentTypes, availableSignatures);
                if (applicableSignatures.isEmpty() || applicableSignatures.size() > 1) {
                    String message = "Operator " + (String)exp.getOp().get(i - 1) + " is undefined for (" + previous.getLabel() + ", " + current.getLabel() + ")";
                    ErrorTypeFacade error = TypeFacadeFactory.eInstance.createErrorTypeFacade(message, exp, (EStructuralFeature)AlfPackage.eINSTANCE.getAdditiveExpression_Exp());
                    return TypeExpressionFactory.eInstance.createTypeExpression(error);
                }
                previous = current = applicableSignatures.get(0).getReturnType();
                ++i;
            }
            return current;
        }
        return this.getTypeOfMultiplicativeExpression((MultiplicativeExpression)exp.getExp().get(0));
    }

    public TypeExpression getTypeOfMultiplicativeExpression(MultiplicativeExpression exp) {
        if (exp.getExp() == null || exp.getExp().size() == 0) {
            return TypeExpressionFactory.eInstance.createTypeExpression(_undefined);
        }
        if (exp.getExp().size() > 1) {
            TypeExpression previous = this.getTypeOfUnaryExpression((UnaryExpression)exp.getExp().get(0));
            if (previous.getTypeFacade() instanceof ErrorTypeFacade) {
                return previous;
            }
            TypeExpression current = null;
            int i = 1;
            while (i < exp.getExp().size()) {
                ArrayList<TypeExpression> argumentTypes = new ArrayList<TypeExpression>();
                argumentTypes.add(previous);
                current = this.getTypeOfUnaryExpression((UnaryExpression)exp.getExp().get(i));
                if (current.getTypeFacade() instanceof ErrorTypeFacade) {
                    return current;
                }
                argumentTypes.add(current);
                List<SignatureFacade> availableSignatures = AlfJavaValidator.predefinedBehaviorsAndTypes.getSignatures((String)exp.getOp().get(i - 1));
                List<SignatureFacade> applicableSignatures = SignatureFacade.findNearestSignature(argumentTypes, availableSignatures);
                if (applicableSignatures.isEmpty() || applicableSignatures.size() > 1) {
                    String message = "Operator " + (String)exp.getOp().get(i - 1) + " is undefined for (" + previous.getLabel() + ", " + current.getLabel() + ")";
                    ErrorTypeFacade error = TypeFacadeFactory.eInstance.createErrorTypeFacade(message, exp, (EStructuralFeature)AlfPackage.eINSTANCE.getMultiplicativeExpression_Exp());
                    return TypeExpressionFactory.eInstance.createTypeExpression(error);
                }
                previous = current = applicableSignatures.get(0).getReturnType();
                ++i;
            }
            return current;
        }
        return this.getTypeOfUnaryExpression((UnaryExpression)exp.getExp().get(0));
    }

    public TypeExpression getTypeOfUnaryExpression(UnaryExpression exp) {
        TypeExpression typeOfExp = this.getTypeOfPrimaryExpression(exp.getExp());
        if (typeOfExp.getTypeFacade() instanceof ErrorTypeFacade) {
            return typeOfExp;
        }
        if (exp.getOp() != null) {
            if (exp.getOp().equals("!")) {
                TypeExpression booleanExpression = TypeExpressionFactory.eInstance.createTypeExpression(_boolean);
                if (booleanExpression.isCompatibleWithMe(typeOfExp) == 0) {
                    ErrorTypeFacade error = TypeFacadeFactory.eInstance.createErrorTypeFacade("Unrary operator ! does not apply to " + typeOfExp.getLabel(), exp, (EStructuralFeature)AlfPackage.eINSTANCE.getUnaryExpression_Op());
                    typeOfExp = TypeExpressionFactory.eInstance.createTypeExpression(error);
                }
            } else if (exp.getOp().equals("-") || exp.getOp().equals("+")) {
                TypeExpression integerExpression = TypeExpressionFactory.eInstance.createTypeExpression(_integer);
                TypeExpression naturalExpression = TypeExpressionFactory.eInstance.createTypeExpression(_natural);
                TypeExpression unlimitedExpression = TypeExpressionFactory.eInstance.createTypeExpression(_unlimited);
                if (integerExpression.isCompatibleWithMe(typeOfExp) == 0 && naturalExpression.isCompatibleWithMe(typeOfExp) == 0 && unlimitedExpression.isCompatibleWithMe(typeOfExp) == 0) {
                    ErrorTypeFacade error = TypeFacadeFactory.eInstance.createErrorTypeFacade("Unary operator " + exp.getOp() + " does not apply to " + typeOfExp.getLabel(), exp, (EStructuralFeature)AlfPackage.eINSTANCE.getUnaryExpression_Op());
                    typeOfExp = TypeExpressionFactory.eInstance.createTypeExpression(error);
                }
            } else if (!exp.getOp().equals("$")) {
                if (exp.getOp().equals("~")) {
                    TypeExpression integerExpression = TypeExpressionFactory.eInstance.createTypeExpression(_integer);
                    TypeExpression bitstringExpression = TypeExpressionFactory.eInstance.createTypeExpression(_bitString);
                    if (integerExpression.isCompatibleWithMe(typeOfExp) == 0 && bitstringExpression.isCompatibleWithMe(typeOfExp) == 0) {
                        ErrorTypeFacade error = TypeFacadeFactory.eInstance.createErrorTypeFacade("Unary operator " + exp.getOp() + " does not apply to " + typeOfExp.getLabel(), exp, (EStructuralFeature)AlfPackage.eINSTANCE.getUnaryExpression_Op());
                        typeOfExp = TypeExpressionFactory.eInstance.createTypeExpression(error);
                    }
                } else {
                    ErrorTypeFacade error = TypeFacadeFactory.eInstance.createErrorTypeFacade("Undefined unary operator", exp, (EStructuralFeature)AlfPackage.eINSTANCE.getUnaryExpression_Op());
                    return TypeExpressionFactory.eInstance.createTypeExpression(error);
                }
            }
        }
        return typeOfExp;
    }

    public TypeExpression getTypeOfPrimaryExpression(PrimaryExpression exp) {
        return this.getTypeOfValueSpecification(exp.getPrefix());
    }

    public TypeExpression getTypeOfValueSpecification(ValueSpecification exp) {
        TypeExpression type = null;
        if (exp instanceof NameExpression) {
            type = this.getTypeOfNameExpression((NameExpression)exp);
        } else if (exp instanceof LITERAL) {
            type = this.getTypeOfLITERAL((LITERAL)exp);
        } else if (exp instanceof ThisExpression) {
            type = this.getTypeOfThisExpression((ThisExpression)exp);
        } else if (exp instanceof SuperInvocationExpression) {
            type = this.getTypeOfSuperInvocationExpression((SuperInvocationExpression)exp);
        } else if (exp instanceof InstanceCreationExpression) {
            type = this.getTypeOfInstanceCreationExpression((InstanceCreationExpression)exp);
        } else if (exp instanceof ParenthesizedExpression) {
            type = this.getTypeOfParenthesizedExpression((ParenthesizedExpression)exp);
        } else if (exp instanceof NullExpression) {
            type = this.getTypeOfNullExpression((NullExpression)exp);
        }
        return type;
    }

    public TypeExpression getTypeOfNullExpression(NullExpression exp) {
        return _nullExpression;
    }

    public TypeExpression getTypeOfInstanceCreationExpression(InstanceCreationExpression exp) {
        if (exp.getTuple() != null) {
            try {
                SignatureFacade s = SignatureFacadeFactory.eInstance.createConstructorFacade(exp);
                if (s.hasReturnType()) {
                    if (exp.getSuffix() != null && exp.getSuffix() != this.suffixToBeIgnored) {
                        return this.getTypeOfSuffixExpression(exp.getSuffix(), s.getReturnType());
                    }
                    return s.getReturnType();
                }
                ErrorTypeFacade error = TypeFacadeFactory.eInstance.createErrorTypeFacade("Constructor " + exp.getConstructor().getId() + " is illformed (no return type defined)", exp, (EStructuralFeature)AlfPackage.eINSTANCE.getInstanceCreationExpression_Constructor());
                return TypeExpressionFactory.eInstance.createTypeExpression(error);
            }
            catch (Exception e) {
                ErrorTypeFacade error = null;
                if (e instanceof TypeInferenceException) {
                    TypeInferenceException tie = (TypeInferenceException)e;
                    error = TypeFacadeFactory.eInstance.createErrorTypeFacade(tie.getErrorMessage(), tie.getErrorSource(), tie.getErrorFeature());
                } else {
                    error = TypeFacadeFactory.eInstance.createErrorTypeFacade(e.getMessage(), exp, (EStructuralFeature)AlfPackage.eINSTANCE.getInstanceCreationExpression_Constructor());
                }
                return TypeExpressionFactory.eInstance.createTypeExpression(error);
            }
        }
        ErrorTypeFacade error = TypeFacadeFactory.eInstance.createErrorTypeFacade("An instance creation or sequence creation is expected", exp, (EStructuralFeature)AlfPackage.eINSTANCE.getInstanceCreationExpression_Constructor());
        return TypeExpressionFactory.eInstance.createTypeExpression(error);
    }

    public TypeExpression getTypeOfSuperInvocationExpression(SuperInvocationExpression exp) {
        ErrorTypeFacade error = TypeFacadeFactory.eInstance.createErrorTypeFacade("SuperInvocationExpression are not supported in this version of the Alf editor", exp, (EStructuralFeature)AlfPackage.eINSTANCE.getSuperInvocationExpression_OperationName());
        return TypeExpressionFactory.eInstance.createTypeExpression(error);
    }

    public TypeExpression getTypeOfNonLiteralValueSpecification(NonLiteralValueSpecification exp) {
        if (exp instanceof NameExpression) {
            return this.getTypeOfNameExpression((NameExpression)exp);
        }
        if (exp instanceof ThisExpression) {
            return this.getTypeOfThisExpression((ThisExpression)exp);
        }
        if (exp instanceof SuperInvocationExpression) {
            return this.getTypeOfSuperInvocationExpression((SuperInvocationExpression)exp);
        }
        if (exp instanceof InstanceCreationExpression) {
            return this.getTypeOfInstanceCreationExpression((InstanceCreationExpression)exp);
        }
        if (exp instanceof ParenthesizedExpression) {
            return this.getTypeOfParenthesizedExpression((ParenthesizedExpression)exp);
        }
        return null;
    }

    public TypeExpression getTypeOfLITERAL(LITERAL exp) {
        TypeFacade t = _undefined;
        if (exp instanceof BOOLEAN_LITERAL) {
            t = _boolean;
        } else if (exp instanceof STRING_LITERAL) {
            t = _string;
        } else if (exp instanceof INTEGER_LITERAL) {
            t = _integer;
        } else if (exp instanceof UNLIMITED_LITERAL) {
            t = _unlimited;
        }
        return TypeExpressionFactory.eInstance.createTypeExpression(t);
    }

    public TypeExpression getTypeOfParenthesizedExpression(ParenthesizedExpression exp) {
        if (exp.getCasted() != null) {
            return this.getTypeOfCastExpression(exp);
        }
        TypeExpression typeOfParenthesizedExpression = this.getTypeOfExpression(exp.getExpOrTypeCast());
        if (typeOfParenthesizedExpression.getTypeFacade() instanceof ErrorTypeFacade) {
            return typeOfParenthesizedExpression;
        }
        if (exp.getSuffix() != null && exp.getSuffix() != this.suffixToBeIgnored) {
            return this.getTypeOfSuffixExpression(exp.getSuffix(), typeOfParenthesizedExpression);
        }
        return typeOfParenthesizedExpression;
    }

    protected TypeExpression getTypeOfCastExpression(ParenthesizedExpression exp) {
        TypeExpression typeOfCastedPart = this.getTypeOfNonLiteralValueSpecification(exp.getCasted());
        if (typeOfCastedPart.getTypeFacade() instanceof ErrorTypeFacade) {
            return typeOfCastedPart;
        }
        TypeFacade castingTypeFacade = TypeFacadeFactory.eInstance.createVoidFacade(exp.getExpOrTypeCast());
        TypeExpression result = new TypeExpression();
        result.setType(castingTypeFacade);
        result.setMultiplicity(typeOfCastedPart.getMultiplicity());
        return result;
    }

    protected boolean isACastExpression(NameExpression exp) {
        EObject container = exp.eContainer();
        NameExpression cddCastingPart = exp;
        while (container != null && !(container instanceof ParenthesizedExpression)) {
            cddCastingPart = container;
            container = container.eContainer();
        }
        if (container == null) {
            return false;
        }
        ParenthesizedExpression cddCastExpression = (ParenthesizedExpression)container;
        if (cddCastingPart.eContainingFeature() == AlfPackage.eINSTANCE.getParenthesizedExpression_ExpOrTypeCast()) {
            return cddCastExpression.getCasted() != null;
        }
        return false;
    }

    public TypeExpression getTypeOfNameExpression(NameExpression exp) {
        SequenceConstructionOrAccessCompletion sequenceAccessOrConstruction;
        String errorMessage;
        ErrorTypeFacade error;
        NameExpression previousPackage = null;
        if (exp.getPath() != null) {
            EList<UnqualifiedName> path = exp.getPath().getNamespace();
            List<EObject> visiblePackages = AlfScopeProvider.scopingTool.getVisiblePackages(exp).resolveByName(((UnqualifiedName)path.get(0)).getName());
            if (visiblePackages.isEmpty()) {
                List<EObject> visibleClassifiers = AlfScopeProvider.scopingTool.getVisibleClassifiers(exp).resolveByName(((UnqualifiedName)path.get(0)).getName());
                if (visibleClassifiers.isEmpty()) {
                    ErrorTypeFacade error2 = TypeFacadeFactory.eInstance.createErrorTypeFacade("Could not resolve package " + ((UnqualifiedName)path.get(0)).getName(), (EObject)path.get(0), (EStructuralFeature)AlfPackage.eINSTANCE.getUnqualifiedName_Name());
                    return TypeExpressionFactory.eInstance.createTypeExpression(error2);
                }
                if (visibleClassifiers.size() > 1) {
                    ErrorTypeFacade error3 = TypeFacadeFactory.eInstance.createErrorTypeFacade(String.valueOf(((UnqualifiedName)path.get(0)).getName()) + " resolves to multiple classifiers", exp.getPath(), (EStructuralFeature)AlfPackage.eINSTANCE.getQualifiedNamePath_Namespace());
                    return TypeExpressionFactory.eInstance.createTypeExpression(error3);
                }
                EObject previousClassifier = visibleClassifiers.get(0);
                int i = 1;
                while (i < path.size()) {
                    List<EObject> nestedVisibleClassifiers = AlfScopeProvider.scopingTool.getVisibleClassifiers(previousClassifier).resolveByName(((UnqualifiedName)path.get(i)).getName());
                    if (nestedVisibleClassifiers.isEmpty()) {
                        ErrorTypeFacade error4 = TypeFacadeFactory.eInstance.createErrorTypeFacade("Could not resolve classifier " + ((UnqualifiedName)path.get(i)).getName(), (EObject)path.get(i), (EStructuralFeature)AlfPackage.eINSTANCE.getUnqualifiedName_Name());
                        return TypeExpressionFactory.eInstance.createTypeExpression(error4);
                    }
                    if (nestedVisibleClassifiers.size() > 1) {
                        ErrorTypeFacade error5 = TypeFacadeFactory.eInstance.createErrorTypeFacade(String.valueOf(((UnqualifiedName)path.get(i)).getName()) + " resolves to multiple classifiers", exp.getPath(), (EStructuralFeature)AlfPackage.eINSTANCE.getQualifiedNamePath_Namespace());
                        return TypeExpressionFactory.eInstance.createTypeExpression(error5);
                    }
                    previousClassifier = nestedVisibleClassifiers.get(0);
                    ++i;
                }
                if (previousClassifier instanceof Enumeration) {
                    List<EObject> visibleEnumerationLiterals = AlfScopeProvider.scopingTool.getVisibleEnumerationLiterals(previousClassifier).resolveByName(exp.getId());
                    if (visibleEnumerationLiterals.isEmpty()) {
                        ErrorTypeFacade error6 = TypeFacadeFactory.eInstance.createErrorTypeFacade("Could not resolve enumeration literal " + exp.getId(), exp, (EStructuralFeature)AlfPackage.eINSTANCE.getNameExpression_Id());
                        return TypeExpressionFactory.eInstance.createTypeExpression(error6);
                    }
                    if (visibleEnumerationLiterals.size() > 1) {
                        ErrorTypeFacade error7 = TypeFacadeFactory.eInstance.createErrorTypeFacade(String.valueOf(exp.getId()) + " resolves to multiple enumeration literals", exp, (EStructuralFeature)AlfPackage.eINSTANCE.getNameExpression_Id());
                        return TypeExpressionFactory.eInstance.createTypeExpression(error7);
                    }
                    return TypeExpressionFactory.eInstance.createTypeExpression(previousClassifier);
                }
                ErrorTypeFacade error8 = TypeFacadeFactory.eInstance.createErrorTypeFacade(String.valueOf(((UnqualifiedName)path.get(path.size() - 1)).getName()) + " does not resolve to an enumeration", exp.getPath(), (EStructuralFeature)AlfPackage.eINSTANCE.getQualifiedNamePath_Namespace());
                return TypeExpressionFactory.eInstance.createTypeExpression(error8);
            }
            if (visiblePackages.size() > 1) {
                ErrorTypeFacade error9 = TypeFacadeFactory.eInstance.createErrorTypeFacade(String.valueOf(((UnqualifiedName)path.get(0)).getName()) + " resolves to multiple packages", exp.getPath(), (EStructuralFeature)AlfPackage.eINSTANCE.getQualifiedNamePath_Namespace());
                return TypeExpressionFactory.eInstance.createTypeExpression(error9);
            }
            previousPackage = visiblePackages.get(0);
            int i = 1;
            while (i < path.size()) {
                List<EObject> nestedVisiblePackages = AlfScopeProvider.scopingTool.getVisiblePackages(previousPackage).resolveByName(((UnqualifiedName)path.get(i)).getName());
                if (nestedVisiblePackages.isEmpty()) {
                    List<EObject> visibleClassifiers = AlfScopeProvider.scopingTool.getVisibleClassifiers(exp).resolveByName(((UnqualifiedName)path.get(i)).getName());
                    if (visibleClassifiers.isEmpty()) {
                        ErrorTypeFacade error10 = TypeFacadeFactory.eInstance.createErrorTypeFacade("Could not resolve package " + ((UnqualifiedName)path.get(i)).getName(), (EObject)path.get(i), (EStructuralFeature)AlfPackage.eINSTANCE.getUnqualifiedName_Name());
                        return TypeExpressionFactory.eInstance.createTypeExpression(error10);
                    }
                    if (visibleClassifiers.size() > 1) {
                        ErrorTypeFacade error11 = TypeFacadeFactory.eInstance.createErrorTypeFacade(String.valueOf(((UnqualifiedName)path.get(0)).getName()) + " resolves to multiple classifiers", exp.getPath(), (EStructuralFeature)AlfPackage.eINSTANCE.getQualifiedNamePath_Namespace());
                        return TypeExpressionFactory.eInstance.createTypeExpression(error11);
                    }
                    EObject previousClassifier = visibleClassifiers.get(0);
                    int j = i;
                    while (j < path.size()) {
                        List<EObject> nestedVisibleClassifiers = AlfScopeProvider.scopingTool.getVisibleClassifiers(previousClassifier).resolveByName(((UnqualifiedName)path.get(j)).getName());
                        if (nestedVisibleClassifiers.isEmpty()) {
                            ErrorTypeFacade error12 = TypeFacadeFactory.eInstance.createErrorTypeFacade("Could not resolve classifier " + ((UnqualifiedName)path.get(j)).getName(), (EObject)path.get(j), (EStructuralFeature)AlfPackage.eINSTANCE.getUnqualifiedName_Name());
                            return TypeExpressionFactory.eInstance.createTypeExpression(error12);
                        }
                        if (nestedVisibleClassifiers.size() > 1) {
                            ErrorTypeFacade error13 = TypeFacadeFactory.eInstance.createErrorTypeFacade(String.valueOf(((UnqualifiedName)path.get(j)).getName()) + " resolves to multiple classifiers", exp.getPath(), (EStructuralFeature)AlfPackage.eINSTANCE.getQualifiedNamePath_Namespace());
                            return TypeExpressionFactory.eInstance.createTypeExpression(error13);
                        }
                        previousClassifier = nestedVisibleClassifiers.get(0);
                        ++j;
                    }
                    if (previousClassifier instanceof Enumeration) {
                        List<EObject> visibleEnumerationLiterals = AlfScopeProvider.scopingTool.getVisibleEnumerationLiterals(previousClassifier).resolveByName(exp.getId());
                        if (visibleEnumerationLiterals.isEmpty()) {
                            ErrorTypeFacade error14 = TypeFacadeFactory.eInstance.createErrorTypeFacade("Could not resolve enumeration literal " + exp.getId(), exp, (EStructuralFeature)AlfPackage.eINSTANCE.getNameExpression_Id());
                            return TypeExpressionFactory.eInstance.createTypeExpression(error14);
                        }
                        if (visibleEnumerationLiterals.size() > 1) {
                            ErrorTypeFacade error15 = TypeFacadeFactory.eInstance.createErrorTypeFacade(String.valueOf(exp.getId()) + " resolves to multiple enumeration literals", exp, (EStructuralFeature)AlfPackage.eINSTANCE.getNameExpression_Id());
                            return TypeExpressionFactory.eInstance.createTypeExpression(error15);
                        }
                        return TypeExpressionFactory.eInstance.createTypeExpression(previousClassifier);
                    }
                    ErrorTypeFacade error16 = TypeFacadeFactory.eInstance.createErrorTypeFacade(String.valueOf(((UnqualifiedName)path.get(path.size() - 1)).getName()) + " does not resolve to an enumeration", exp.getPath(), (EStructuralFeature)AlfPackage.eINSTANCE.getQualifiedNamePath_Namespace());
                    return TypeExpressionFactory.eInstance.createTypeExpression(error16);
                }
                if (nestedVisiblePackages.size() > 1) {
                    ErrorTypeFacade error17 = TypeFacadeFactory.eInstance.createErrorTypeFacade(String.valueOf(((UnqualifiedName)path.get(i)).getName()) + " resolves to multiple packages", exp.getPath(), (EStructuralFeature)AlfPackage.eINSTANCE.getQualifiedNamePath_Namespace());
                    return TypeExpressionFactory.eInstance.createTypeExpression(error17);
                }
                previousPackage = nestedVisiblePackages.get(0);
                ++i;
            }
        }
        TypeExpression typeOfPrefix = null;
        if (exp.getPath() == null && exp.getInvocationCompletion() == null) {
            ErrorTypeFacade error18;
            List<EObject> visibleVariableOrParametersOrProperties = AlfScopeProvider.scopingTool.getVisibleVariablesOrParametersOrProperties(exp).resolveByName(exp.getId());
            if (visibleVariableOrParametersOrProperties.isEmpty()) {
                error18 = TypeFacadeFactory.eInstance.createErrorTypeFacade("Could not resolve local variable, property or parameter " + exp.getId(), exp, (EStructuralFeature)AlfPackage.eINSTANCE.getNameExpression_Id());
                return TypeExpressionFactory.eInstance.createTypeExpression(error18);
            }
            if (visibleVariableOrParametersOrProperties.size() > 1) {
                error18 = TypeFacadeFactory.eInstance.createErrorTypeFacade(String.valueOf(exp.getId()) + " resolves to multiple elements", exp, (EStructuralFeature)AlfPackage.eINSTANCE.getNameExpression_Id());
                return TypeExpressionFactory.eInstance.createTypeExpression(error18);
            }
            EObject resolved = visibleVariableOrParametersOrProperties.get(0);
            typeOfPrefix = TypeExpressionFactory.eInstance.createTypeExpression(resolved);
        }
        if (exp.getInvocationCompletion() != null) {
            ArrayList<TypeExpression> arguments = new ArrayList<TypeExpression>();
            for (TupleElement e : exp.getInvocationCompletion().getTupleElements()) {
                TypeExpression type = this.getTypeOfExpression(e.getArgument());
                if (type.getTypeFacade() != null && type.getTypeFacade() instanceof ErrorTypeFacade) {
                    return type;
                }
                arguments.add(type);
            }
            List<EObject> visibleOperationOrBehaviors = AlfScopeProvider.scopingTool.getVisibleOperationsOrBehaviors(previousPackage != null ? previousPackage : exp).resolveByName(exp.getId());
            if (visibleOperationOrBehaviors.isEmpty()) {
                ErrorTypeFacade error19 = TypeFacadeFactory.eInstance.createErrorTypeFacade("Could not resolve operation or behavior " + exp.getId(), exp, (EStructuralFeature)AlfPackage.eINSTANCE.getNameExpression_Id());
                return TypeExpressionFactory.eInstance.createTypeExpression(error19);
            }
            if (visibleOperationOrBehaviors.size() > 1) {
                ArrayList<SignatureFacade> availableSignatures = new ArrayList<SignatureFacade>();
                for (EObject operation : visibleOperationOrBehaviors) {
                    availableSignatures.add(SignatureFacadeFactory.eInstance.createSignatureFacade(operation));
                }
                List<SignatureFacade> selectedSignatures = SignatureFacade.findNearestSignature(arguments, availableSignatures);
                if (selectedSignatures.size() > 1) {
                    error = TypeFacadeFactory.eInstance.createErrorTypeFacade(String.valueOf(exp.getId()) + " resolves to multiple elements", exp, (EStructuralFeature)AlfPackage.eINSTANCE.getNameExpression_Id());
                    return TypeExpressionFactory.eInstance.createTypeExpression(error);
                }
                if (selectedSignatures.size() == 0) {
                    errorMessage = String.valueOf(exp.getId()) + " does not apply to arguments (";
                    boolean first = true;
                    for (TypeExpression argType : arguments) {
                        if (!first) {
                            errorMessage = String.valueOf(errorMessage) + ", ";
                        } else {
                            first = false;
                        }
                        errorMessage = String.valueOf(errorMessage) + argType.getLabel();
                    }
                    errorMessage = String.valueOf(errorMessage) + ")";
                    ErrorTypeFacade error20 = TypeFacadeFactory.eInstance.createErrorTypeFacade(errorMessage, exp, (EStructuralFeature)AlfPackage.eINSTANCE.getNameExpression_Id());
                    return TypeExpressionFactory.eInstance.createTypeExpression(error20);
                }
                typeOfPrefix = selectedSignatures.get(0).getReturnType();
            } else {
                SignatureFacade operationOrBehaviorSignature = SignatureFacadeFactory.eInstance.createSignatureFacade(visibleOperationOrBehaviors.get(0));
                String argumentsAreCompatible = operationOrBehaviorSignature.isCompatibleWithMe(arguments, true);
                if (argumentsAreCompatible.length() != 0) {
                    ErrorTypeFacade error21 = TypeFacadeFactory.eInstance.createErrorTypeFacade(argumentsAreCompatible, exp, (EStructuralFeature)AlfPackage.eINSTANCE.getNameExpression_InvocationCompletion());
                    return TypeExpressionFactory.eInstance.createTypeExpression(error21);
                }
                typeOfPrefix = operationOrBehaviorSignature.getReturnType();
            }
        }
        if (exp.getSequenceConstructionCompletion() != null && (sequenceAccessOrConstruction = exp.getSequenceConstructionCompletion()).getAccessCompletion() != null) {
            String errorMessage2;
            int prefixUpperBound = typeOfPrefix.getMultiplicity().getUpperBound();
            boolean prefixIsOrdered = typeOfPrefix.getMultiplicity().isOrdered();
            if (prefixUpperBound != -1 && prefixUpperBound <= 1) {
                errorMessage2 = "Unexpected index. " + exp.getId() + " is not a collection.";
                error = TypeFacadeFactory.eInstance.createErrorTypeFacade(errorMessage2, exp, (EStructuralFeature)AlfPackage.eINSTANCE.getNameExpression_SequenceConstructionCompletion());
                return TypeExpressionFactory.eInstance.createTypeExpression(error);
            }
            if (!prefixIsOrdered) {
                errorMessage2 = "Unexpected index. " + exp.getId() + " is not ordered.";
                error = TypeFacadeFactory.eInstance.createErrorTypeFacade(errorMessage2, exp, (EStructuralFeature)AlfPackage.eINSTANCE.getNameExpression_SequenceConstructionCompletion());
                return TypeExpressionFactory.eInstance.createTypeExpression(error);
            }
            TypeExpression typeOfIndex = this.getTypeOfExpression(sequenceAccessOrConstruction.getAccessCompletion().getAccessIndex());
            if (typeOfIndex.getTypeFacade() instanceof ErrorTypeFacade) {
                return typeOfIndex;
            }
            if (_integer.isCompatibleWithMe(typeOfIndex.getTypeFacade()) != 3 && _natural.isCompatibleWithMe(typeOfIndex.getTypeFacade()) != 3) {
                errorMessage = "Expecting an expression of type Integer. Found an expression of type " + typeOfIndex.getLabel();
                ErrorTypeFacade error22 = TypeFacadeFactory.eInstance.createErrorTypeFacade(errorMessage, sequenceAccessOrConstruction, (EStructuralFeature)AlfPackage.eINSTANCE.getAccessCompletion_AccessIndex());
                return TypeExpressionFactory.eInstance.createTypeExpression(error22);
            }
            typeOfPrefix.setMultiplicity(MultiplicityFacadeFactory.eInstance.createMultiplicityFacade(1, 1, false, false));
        }
        if (exp.getSuffix() != null && exp.getSuffix() != this.suffixToBeIgnored) {
            return this.getTypeOfSuffixExpression(exp.getSuffix(), typeOfPrefix);
        }
        return typeOfPrefix;
    }

    public TypeExpression getTypeOfThisExpression(ThisExpression exp) {
        TypeExpression typeOfPrefix = TypeExpressionFactory.eInstance.createTypeExpression((EObject)AlfJavaValidator.getContextClassifier());
        if (typeOfPrefix.getTypeFacade() instanceof ErrorTypeFacade) {
            return typeOfPrefix;
        }
        if (exp.getSuffix() != null && exp.getSuffix() != this.suffixToBeIgnored) {
            return this.getTypeOfSuffixExpression(exp.getSuffix(), typeOfPrefix);
        }
        return typeOfPrefix;
    }

    public TypeExpression getTypeOfSuffixExpression(SuffixExpression exp, TypeExpression propagatedTypeOfPrefix) {
        ErrorTypeFacade unsupportedCase;
        String errorMessage;
        Classifier actualPrefixType;
        EObject source = exp.eContainer();
        EStructuralFeature containtFeature = exp.eContainingFeature();
        TypeExpression typeOfPrefix = propagatedTypeOfPrefix;
        if (typeOfPrefix == null) {
            String errorMessage2 = "Type of prefix is undefined. Could not validate suffix.";
            ErrorTypeFacade error = TypeFacadeFactory.eInstance.createErrorTypeFacade(errorMessage2, source, containtFeature);
            return TypeExpressionFactory.eInstance.createTypeExpression(error);
        }
        if (typeOfPrefix.getTypeFacade() == _undefined) {
            String errorMessage3 = "The invocation prefix has no return parameter.";
            ErrorTypeFacade error = TypeFacadeFactory.eInstance.createErrorTypeFacade(errorMessage3, source, containtFeature);
            return TypeExpressionFactory.eInstance.createTypeExpression(error);
        }
        if (typeOfPrefix.getMultiplicity().getUpperBound() == 1 && (exp instanceof SequenceOperationExpression || exp instanceof SelectOrRejectOperation) && (actualPrefixType = typeOfPrefix.getTypeFacade().extractActualType()) != null) {
            Operation toSequenceOperation = null;
            int i = 0;
            while (i < actualPrefixType.getAllOperations().size() && toSequenceOperation == null) {
                Operation o = (Operation)actualPrefixType.getAllOperations().get(i);
                if (o.getName().equals("toSequence")) {
                    toSequenceOperation = o;
                }
                ++i;
            }
            if (toSequenceOperation != null) {
                typeOfPrefix = TypeExpressionFactory.eInstance.createTypeExpression((EObject)toSequenceOperation.getReturnResult());
            }
        }
        if (exp instanceof ClassExtentExpression) {
            errorMessage = "Class extent expressions are not supported in this version of the Alf editor";
            unsupportedCase = TypeFacadeFactory.eInstance.createErrorTypeFacade(errorMessage, source, containtFeature);
            return TypeExpressionFactory.eInstance.createTypeExpression(unsupportedCase);
        }
        if (exp instanceof LinkOperationExpression) {
            errorMessage = "Link operation expressions are not supported in this version of the Alf editor";
            unsupportedCase = TypeFacadeFactory.eInstance.createErrorTypeFacade(errorMessage, source, containtFeature);
            return TypeExpressionFactory.eInstance.createTypeExpression(unsupportedCase);
        }
        if (exp instanceof OperationCallExpression) {
            return this.getTypeOfOperationCallExpression((OperationCallExpression)exp, typeOfPrefix);
        }
        if (exp instanceof PropertyCallExpression) {
            return this.getTypeOfPropertyCallExpression((PropertyCallExpression)exp, typeOfPrefix);
        }
        if (exp instanceof SequenceExpansionExpression) {
            return this.getTypeOfSequenceExpansionExpression((SequenceExpansionExpression)exp, typeOfPrefix);
        }
        if (exp instanceof SequenceOperationExpression) {
            return this.getTypeOfSequenceOperationExpression((SequenceOperationExpression)exp, typeOfPrefix);
        }
        return this.getTypeOfSequenceReductionExpression((SequenceReductionExpression)exp, typeOfPrefix);
    }

    public TypeExpression getTypeOfSequenceOperationExpression(SequenceOperationExpression exp, TypeExpression typeOfPrefix) {
        if (exp.getOperationName() == null) {
            String errorMessage = "Sequence function is missing";
            ErrorTypeFacade unsupportedCase = TypeFacadeFactory.eInstance.createErrorTypeFacade(errorMessage, exp, (EStructuralFeature)AlfPackage.eINSTANCE.getSequenceOperationExpression_OperationName());
            return TypeExpressionFactory.eInstance.createTypeExpression(unsupportedCase);
        }
        SignatureFacade s = null;
        TypeFacade cddBehaviorFacade = TypeFacadeFactory.eInstance.createVoidFacade(exp.getOperationName());
        if (cddBehaviorFacade instanceof ErrorTypeFacade) {
            s = predefinedCollectionFunctions.get(exp.getOperationName().getId());
            if (s == null) {
                return TypeExpressionFactory.eInstance.createTypeExpression(cddBehaviorFacade);
            }
        } else {
            Classifier cddBehavior = cddBehaviorFacade.extractActualType();
            if (!(cddBehavior instanceof Behavior)) {
                String errorMessage = String.valueOf(cddBehavior.getName()) + " does not resolve to a Behavior";
                ErrorTypeFacade unsupportedCase = TypeFacadeFactory.eInstance.createErrorTypeFacade(errorMessage, exp, (EStructuralFeature)AlfPackage.eINSTANCE.getSequenceOperationExpression_OperationName());
                return TypeExpressionFactory.eInstance.createTypeExpression(unsupportedCase);
            }
            s = SignatureFacadeFactory.eInstance.createSignatureFacade((EObject)cddBehavior);
        }
        if (s.getParameters().isEmpty()) {
            EObject source = exp.eContainer();
            EStructuralFeature containtFeature = exp.eContainingFeature();
            String errorMessage = "Invalid sequence function. Should at least one in or inout parameter with multiplicity *";
            ErrorTypeFacade unsupportedCase = TypeFacadeFactory.eInstance.createErrorTypeFacade(errorMessage, source, containtFeature);
            return TypeExpressionFactory.eInstance.createTypeExpression(unsupportedCase);
        }
        Behavior sequenceFunction = (Behavior)s.getActualSignatureObject();
        Parameter firstParameter = (Parameter)sequenceFunction.getOwnedParameters().get(0);
        if (firstParameter.getDirection() != ParameterDirectionKind.IN_LITERAL && firstParameter.getDirection() != ParameterDirectionKind.INOUT_LITERAL || firstParameter.getUpper() != -1) {
            EObject source = exp.eContainer();
            EStructuralFeature containtFeature = exp.eContainingFeature();
            String errorMessage = "Invalid sequence function. The first parameter should have direction in or inout, with multiplicity *";
            ErrorTypeFacade unsupportedCase = TypeFacadeFactory.eInstance.createErrorTypeFacade(errorMessage, source, containtFeature);
            return TypeExpressionFactory.eInstance.createTypeExpression(unsupportedCase);
        }
        ArrayList<TypeExpression> arguments = new ArrayList<TypeExpression>();
        arguments.add(typeOfPrefix);
        for (TupleElement e : exp.getTuple().getTupleElements()) {
            TypeExpression argType = this.getTypeOfExpression(e.getArgument());
            if (argType.getTypeFacade() != null && argType.getTypeFacade() instanceof ErrorTypeFacade) {
                return argType;
            }
            arguments.add(argType);
        }
        String argumentsAreCompatible = s.isCompatibleWithMe(arguments, true);
        if (argumentsAreCompatible.length() != 0) {
            ErrorTypeFacade error = TypeFacadeFactory.eInstance.createErrorTypeFacade(argumentsAreCompatible, exp, (EStructuralFeature)AlfPackage.eINSTANCE.getSequenceOperationExpression_OperationName());
            return TypeExpressionFactory.eInstance.createTypeExpression(error);
        }
        TypeExpression typeOfSuffix = s.getReturnType();
        if (exp.getSuffix() != null) {
            return this.getTypeOfSuffixExpression(exp.getSuffix(), typeOfSuffix);
        }
        return typeOfSuffix;
    }

    public TypeExpression getTypeOfSequenceReductionExpression(SequenceReductionExpression exp, TypeExpression typeOfPrefix) {
        String errorMessage;
        int upperBoundOfPrefix = typeOfPrefix.getMultiplicityFacade().getUpperBound();
        if (upperBoundOfPrefix <= 1 && upperBoundOfPrefix != -1) {
            EObject source = exp.eContainer();
            EStructuralFeature containtFeature = exp.eContainingFeature();
            String errorMessage2 = "Prefix must be a collection";
            ErrorTypeFacade unsupportedCase = TypeFacadeFactory.eInstance.createErrorTypeFacade(errorMessage2, source, containtFeature);
            return TypeExpressionFactory.eInstance.createTypeExpression(unsupportedCase);
        }
        if (exp.getBehavior() == null) {
            String errorMessage3 = "Reduction behavior is missing";
            ErrorTypeFacade unsupportedCase = TypeFacadeFactory.eInstance.createErrorTypeFacade(errorMessage3, exp, (EStructuralFeature)AlfPackage.eINSTANCE.getSequenceReductionExpression_Behavior());
            return TypeExpressionFactory.eInstance.createTypeExpression(unsupportedCase);
        }
        TypeFacade cddBehaviorFacade = TypeFacadeFactory.eInstance.createVoidFacade(exp.getBehavior());
        if (cddBehaviorFacade instanceof ErrorTypeFacade) {
            return TypeExpressionFactory.eInstance.createTypeExpression(cddBehaviorFacade);
        }
        Classifier cddBehavior = cddBehaviorFacade.extractActualType();
        if (!(cddBehavior instanceof Behavior)) {
            String errorMessage4 = String.valueOf(cddBehavior.getName()) + " does not resolve to a Behavior";
            ErrorTypeFacade unsupportedCase = TypeFacadeFactory.eInstance.createErrorTypeFacade(errorMessage4, exp, (EStructuralFeature)AlfPackage.eINSTANCE.getSequenceReductionExpression_Behavior());
            return TypeExpressionFactory.eInstance.createTypeExpression(unsupportedCase);
        }
        Behavior behavior = (Behavior)cddBehavior;
        int n_inputParameters = 0;
        boolean invalidReductionBehavior = false;
        boolean returnParameterFound = false;
        Classifier paramsType = null;
        int i = 0;
        while (i < behavior.getOwnedParameters().size() && !invalidReductionBehavior) {
            Parameter p = (Parameter)behavior.getOwnedParameters().get(i);
            switch (p.getDirection()) {
                case IN_LITERAL: {
                    if (++n_inputParameters > 2) {
                        invalidReductionBehavior = true;
                        break;
                    }
                    if (p.getLower() != 1 || p.getUpper() != 1) {
                        invalidReductionBehavior = true;
                        break;
                    }
                    if (paramsType == null) {
                        paramsType = (Classifier)p.getType();
                        if (paramsType != null) break;
                        invalidReductionBehavior = true;
                        break;
                    }
                    if (paramsType == (Classifier)p.getType()) break;
                    invalidReductionBehavior = true;
                    break;
                }
                case INOUT_LITERAL: {
                    invalidReductionBehavior = true;
                    break;
                }
                case OUT_LITERAL: {
                    invalidReductionBehavior = true;
                    break;
                }
                case RETURN_LITERAL: {
                    returnParameterFound = true;
                    if (p.getLower() != 1 || p.getUpper() != 1) {
                        invalidReductionBehavior = true;
                        break;
                    }
                    if (paramsType == null) {
                        paramsType = (Classifier)p.getType();
                        if (paramsType != null) break;
                        invalidReductionBehavior = true;
                        break;
                    }
                    if (paramsType == (Classifier)p.getType()) break;
                    invalidReductionBehavior = true;
                }
            }
            ++i;
        }
        SignatureFacade behaviorFacade = SignatureFacadeFactory.eInstance.createSignatureFacade((EObject)behavior);
        if (invalidReductionBehavior || !returnParameterFound) {
            errorMessage = String.valueOf(behaviorFacade.getLabel()) + " is not a valid reduction behavior. It should have exactly two in parameters, one return parameter, all with multiplicity [1..1], and all with the same type.";
            ErrorTypeFacade unsupportedCase = TypeFacadeFactory.eInstance.createErrorTypeFacade(errorMessage, exp, (EStructuralFeature)AlfPackage.eINSTANCE.getSequenceReductionExpression_Behavior());
            return TypeExpressionFactory.eInstance.createTypeExpression(unsupportedCase);
        }
        if (TypeFacadeFactory.eInstance.createTypeFacade((EObject)paramsType).isCompatibleWithMe(typeOfPrefix.getTypeFacade()) == 0) {
            errorMessage = String.valueOf(behaviorFacade.getLabel()) + " does not apply to arguments of type " + typeOfPrefix.getTypeFacade().getLabel();
            ErrorTypeFacade unsupportedCase = TypeFacadeFactory.eInstance.createErrorTypeFacade(errorMessage, exp, (EStructuralFeature)AlfPackage.eINSTANCE.getSequenceReductionExpression_Behavior());
            return TypeExpressionFactory.eInstance.createTypeExpression(unsupportedCase);
        }
        TypeExpression typeOfExpression = TypeExpressionFactory.eInstance.createTypeExpression(typeOfPrefix.getTypeFacade());
        if (exp.getSuffix() != null && exp.getSuffix() != this.suffixToBeIgnored) {
            return this.getTypeOfSuffixExpression(exp.getSuffix(), typeOfExpression);
        }
        return typeOfExpression;
    }

    public TypeExpression getTypeOfSequenceExpansionExpression(SequenceExpansionExpression exp, TypeExpression typeOfPrefix) {
        if (exp instanceof SelectOrRejectOperation) {
            return this.getTypeOfSelectOrRejectOperation((SelectOrRejectOperation)exp, typeOfPrefix);
        }
        if (exp instanceof CollectOrIterateOperation) {
            return this.getTypeOfCollectOrIterateOperation((CollectOrIterateOperation)exp, typeOfPrefix);
        }
        if (exp instanceof ForAllOrExistsOrOneOperation) {
            return this.getTypeOfForAllOrExistsOrOneOperation((ForAllOrExistsOrOneOperation)exp, typeOfPrefix);
        }
        return this.getTypeOfIsUniqueOperation((IsUniqueOperation)exp, typeOfPrefix);
    }

    private TypeExpression getTypeOfIsUniqueOperation(IsUniqueOperation exp, TypeExpression typeOfPrefix) {
        if (exp.getName() == null) {
            ErrorTypeFacade error = TypeFacadeFactory.eInstance.createErrorTypeFacade("Local variable definition is missing", exp, (EStructuralFeature)AlfPackage.eINSTANCE.getSequenceExpansionExpression_Name());
            return TypeExpressionFactory.eInstance.createTypeExpression(error);
        }
        if (!AlfScopeProvider.scopingTool.getVisibleVariablesOrParametersOrProperties(exp.eContainer()).resolveByName(exp.getName()).isEmpty()) {
            ErrorTypeFacade error = TypeFacadeFactory.eInstance.createErrorTypeFacade("Local name " + exp.getName() + " is not available", exp, (EStructuralFeature)AlfPackage.eINSTANCE.getSequenceExpansionExpression_Name());
            return TypeExpressionFactory.eInstance.createTypeExpression(error);
        }
        TypeExpression typeOfCondition = this.getTypeOfExpression(exp.getExpr());
        if (typeOfCondition.getTypeFacade() instanceof ErrorTypeFacade) {
            return typeOfCondition;
        }
        int upperBound = typeOfCondition.getMultiplicity().getUpperBound();
        if (upperBound == 0) {
            ErrorTypeFacade error = TypeFacadeFactory.eInstance.createErrorTypeFacade("Expression must be typed", exp, (EStructuralFeature)AlfPackage.eINSTANCE.getSequenceExpansionExpression_Expr());
            return TypeExpressionFactory.eInstance.createTypeExpression(error);
        }
        TypeExpression typeOfExpression = TypeExpressionFactory.eInstance.createTypeExpression(_boolean);
        if (exp.getSuffix() != null && exp.getSuffix() != this.suffixToBeIgnored) {
            return this.getTypeOfSuffixExpression(exp.getSuffix(), typeOfExpression);
        }
        return typeOfExpression;
    }

    private TypeExpression getTypeOfForAllOrExistsOrOneOperation(ForAllOrExistsOrOneOperation exp, TypeExpression typeOfPrefix) {
        if (exp.getName() == null) {
            ErrorTypeFacade error = TypeFacadeFactory.eInstance.createErrorTypeFacade("Local variable definition is missing", exp, (EStructuralFeature)AlfPackage.eINSTANCE.getSequenceExpansionExpression_Name());
            return TypeExpressionFactory.eInstance.createTypeExpression(error);
        }
        if (!AlfScopeProvider.scopingTool.getVisibleVariablesOrParametersOrProperties(exp.eContainer()).resolveByName(exp.getName()).isEmpty()) {
            ErrorTypeFacade error = TypeFacadeFactory.eInstance.createErrorTypeFacade("Local name " + exp.getName() + " is not available", exp, (EStructuralFeature)AlfPackage.eINSTANCE.getSequenceExpansionExpression_Name());
            return TypeExpressionFactory.eInstance.createTypeExpression(error);
        }
        TypeExpression typeOfCondition = this.getTypeOfExpression(exp.getExpr());
        if (typeOfCondition.getTypeFacade() instanceof ErrorTypeFacade) {
            return typeOfCondition;
        }
        if (TypeExpressionFactory.eInstance.createTypeExpression(_boolean).isCompatibleWithMe(typeOfCondition) == 0) {
            ErrorTypeFacade error = TypeFacadeFactory.eInstance.createErrorTypeFacade("Expecting an expression of type Boolean. Found an expression of type " + typeOfCondition.getLabel(), exp, (EStructuralFeature)AlfPackage.eINSTANCE.getSequenceExpansionExpression_Expr());
            return TypeExpressionFactory.eInstance.createTypeExpression(error);
        }
        TypeExpression typeOfExpression = TypeExpressionFactory.eInstance.createTypeExpression(_boolean);
        if (exp.getSuffix() != null && exp.getSuffix() != this.suffixToBeIgnored) {
            return this.getTypeOfSuffixExpression(exp.getSuffix(), typeOfExpression);
        }
        return typeOfExpression;
    }

    private TypeExpression getTypeOfCollectOrIterateOperation(CollectOrIterateOperation exp, TypeExpression typeOfPrefix) {
        if (exp.getName() == null) {
            ErrorTypeFacade error = TypeFacadeFactory.eInstance.createErrorTypeFacade("Local variable definition is missing", exp, (EStructuralFeature)AlfPackage.eINSTANCE.getSequenceExpansionExpression_Name());
            return TypeExpressionFactory.eInstance.createTypeExpression(error);
        }
        if (!AlfScopeProvider.scopingTool.getVisibleVariablesOrParametersOrProperties(exp.eContainer()).resolveByName(exp.getName()).isEmpty()) {
            ErrorTypeFacade error = TypeFacadeFactory.eInstance.createErrorTypeFacade("Local name " + exp.getName() + " is not available", exp, (EStructuralFeature)AlfPackage.eINSTANCE.getSequenceExpansionExpression_Name());
            return TypeExpressionFactory.eInstance.createTypeExpression(error);
        }
        TypeExpression typeOfCondition = this.getTypeOfExpression(exp.getExpr());
        if (typeOfCondition.getTypeFacade() instanceof ErrorTypeFacade) {
            return typeOfCondition;
        }
        int lowerBound = typeOfPrefix.getMultiplicity().getLowerBound() * typeOfCondition.getMultiplicity().getLowerBound();
        int upperBound = typeOfPrefix.getMultiplicity().getUpperBound() * typeOfCondition.getMultiplicity().getUpperBound();
        lowerBound = lowerBound < 0 ? -1 : lowerBound;
        int n = upperBound = upperBound < 0 ? -1 : upperBound;
        if (upperBound == 0) {
            ErrorTypeFacade error = TypeFacadeFactory.eInstance.createErrorTypeFacade("Expression must be typed", exp, (EStructuralFeature)AlfPackage.eINSTANCE.getSequenceExpansionExpression_Expr());
            return TypeExpressionFactory.eInstance.createTypeExpression(error);
        }
        TypeExpression typeOfExpression = TypeExpressionFactory.eInstance.createTypeExpression(typeOfCondition.getTypeFacade());
        typeOfExpression.setMultiplicity(MultiplicityFacadeFactory.eInstance.createMultiplicityFacade(lowerBound, upperBound, typeOfPrefix.getMultiplicity().isUnique(), typeOfPrefix.getMultiplicity().isOrdered()));
        if (exp.getSuffix() != null && exp.getSuffix() != this.suffixToBeIgnored) {
            return this.getTypeOfSuffixExpression(exp.getSuffix(), typeOfExpression);
        }
        return typeOfExpression;
    }

    private TypeExpression getTypeOfSelectOrRejectOperation(SelectOrRejectOperation exp, TypeExpression typeOfPrefix) {
        if (exp.getName() == null) {
            ErrorTypeFacade error = TypeFacadeFactory.eInstance.createErrorTypeFacade("Local variable definition is missing", exp, (EStructuralFeature)AlfPackage.eINSTANCE.getSequenceExpansionExpression_Name());
            return TypeExpressionFactory.eInstance.createTypeExpression(error);
        }
        if (!AlfScopeProvider.scopingTool.getVisibleVariablesOrParametersOrProperties(exp.eContainer()).resolveByName(exp.getName()).isEmpty()) {
            ErrorTypeFacade error = TypeFacadeFactory.eInstance.createErrorTypeFacade("Local name " + exp.getName() + " is not available", exp, (EStructuralFeature)AlfPackage.eINSTANCE.getSequenceExpansionExpression_Name());
            return TypeExpressionFactory.eInstance.createTypeExpression(error);
        }
        TypeExpression typeOfCondition = this.getTypeOfExpression(exp.getExpr());
        if (typeOfCondition.getTypeFacade() instanceof ErrorTypeFacade) {
            return typeOfCondition;
        }
        if (TypeExpressionFactory.eInstance.createTypeExpression(_boolean).isCompatibleWithMe(typeOfCondition) == 0) {
            ErrorTypeFacade error = TypeFacadeFactory.eInstance.createErrorTypeFacade("Expecting an expression of type Boolean. Found an expression of type " + typeOfCondition.getLabel(), exp, (EStructuralFeature)AlfPackage.eINSTANCE.getSequenceExpansionExpression_Expr());
            return TypeExpressionFactory.eInstance.createTypeExpression(error);
        }
        TypeExpression typeOfExpression = TypeExpressionFactory.eInstance.createTypeExpression(typeOfPrefix.getTypeFacade());
        typeOfExpression.setMultiplicity(MultiplicityFacadeFactory.eInstance.createMultiplicityFacade(0, typeOfPrefix.getMultiplicity().getUpperBound(), typeOfPrefix.getMultiplicity().isUnique(), typeOfPrefix.getMultiplicity().isOrdered()));
        if (exp.getSuffix() != null && exp.getSuffix() != this.suffixToBeIgnored) {
            return this.getTypeOfSuffixExpression(exp.getSuffix(), typeOfExpression);
        }
        return typeOfExpression;
    }

    public TypeExpression getTypeOfPropertyCallExpression(PropertyCallExpression exp, TypeExpression typeOfPrefix) {
        Classifier type = typeOfPrefix.getTypeFacade().extractActualType();
        EObject source = exp.eContainer();
        EStructuralFeature containtFeature = exp.eContainingFeature();
        if (type == null) {
            String errorMessage = "Type of prefix is \"any\". Could not validate suffix.";
            ErrorTypeFacade error = TypeFacadeFactory.eInstance.createErrorTypeFacade(errorMessage, source, containtFeature);
            return TypeExpressionFactory.eInstance.createTypeExpression(error);
        }
        List<EObject> matchingProperties = AlfScopeProvider.scopingTool.getVisibleVariablesOrParametersOrProperties((EObject)type).resolveByName(exp.getPropertyName());
        if (matchingProperties.size() == 0) {
            String errorMessage = "Could not resolve property " + exp.getPropertyName() + " for classifier " + type.getName();
            ErrorTypeFacade error = TypeFacadeFactory.eInstance.createErrorTypeFacade(errorMessage, source, containtFeature);
            return TypeExpressionFactory.eInstance.createTypeExpression(error);
        }
        if (matchingProperties.size() > 1) {
            String errorMessage = String.valueOf(exp.getPropertyName()) + " matches multiple properties. Classifier " + type.getName() + " is illformed. Duplicate properties should be renamed or deleted.";
            ErrorTypeFacade error = TypeFacadeFactory.eInstance.createErrorTypeFacade(errorMessage, source, containtFeature);
            return TypeExpressionFactory.eInstance.createTypeExpression(error);
        }
        int upperBoundOfPrefix = typeOfPrefix.getMultiplicityFacade().getUpperBound();
        if (upperBoundOfPrefix == -1 || upperBoundOfPrefix > 1) {
            String errorMessage = "The prefix of this property call is a collection. An index should be used to access property " + exp.getPropertyName();
            ErrorTypeFacade error = TypeFacadeFactory.eInstance.createErrorTypeFacade(errorMessage, source, containtFeature);
            return TypeExpressionFactory.eInstance.createTypeExpression(error);
        }
        TypeExpression typeOfSuffix = TypeExpressionFactory.eInstance.createTypeExpression(matchingProperties.get(0));
        if (exp.getIndex() != null) {
            if (typeOfSuffix.isACollection()) {
                TypeExpression typeOfIndex = this.getTypeOfExpression(exp.getIndex());
                if (typeOfIndex.getTypeFacade() instanceof ErrorTypeFacade) {
                    return typeOfIndex;
                }
                if (typeOfIndex.isACollection() || typeOfIndex.getTypeFacade() != _integer) {
                    String errorMessage = "Expecting an expression of type Integer. Found an expression of type " + typeOfIndex.getLabel();
                    ErrorTypeFacade error = TypeFacadeFactory.eInstance.createErrorTypeFacade(errorMessage, exp, (EStructuralFeature)AlfPackage.eINSTANCE.getPropertyCallExpression_Index());
                    return TypeExpressionFactory.eInstance.createTypeExpression(error);
                }
                if (!typeOfSuffix.isOrdered()) {
                    String errorMessage = "Unexpected index. " + exp.getPropertyName() + " is not ordered.";
                    ErrorTypeFacade error = TypeFacadeFactory.eInstance.createErrorTypeFacade(errorMessage, source, containtFeature);
                    return TypeExpressionFactory.eInstance.createTypeExpression(error);
                }
                typeOfSuffix = TypeExpressionFactory.eInstance.createTypeExpression(typeOfSuffix.getTypeFacade());
            } else {
                String errorMessage = "Unexpected index. " + exp.getPropertyName() + " is not a collection.";
                ErrorTypeFacade error = TypeFacadeFactory.eInstance.createErrorTypeFacade(errorMessage, source, containtFeature);
                return TypeExpressionFactory.eInstance.createTypeExpression(error);
            }
        }
        if (exp.getSuffix() != null && exp.getSuffix() != this.suffixToBeIgnored) {
            return this.getTypeOfSuffixExpression(exp.getSuffix(), typeOfSuffix);
        }
        return typeOfSuffix;
    }

    public TypeExpression getTypeOfOperationCallExpression(OperationCallExpression exp, TypeExpression typeOfPrefix) {
        TypeExpression typeOfSuffix;
        Classifier type = typeOfPrefix.getTypeFacade().extractActualType();
        EObject source = exp.eContainer();
        EStructuralFeature containingFeature = exp.eContainingFeature();
        if (type == null) {
            String errorMessage = "Type of prefix is \"any\". Could not validate suffix.";
            ErrorTypeFacade error = TypeFacadeFactory.eInstance.createErrorTypeFacade(errorMessage, source, containingFeature);
            return TypeExpressionFactory.eInstance.createTypeExpression(error);
        }
        ArrayList<TypeExpression> arguments = new ArrayList<TypeExpression>();
        for (TupleElement e : exp.getTuple().getTupleElements()) {
            TypeExpression argType = this.getTypeOfExpression(e.getArgument());
            if (argType.getTypeFacade() != null && argType.getTypeFacade() instanceof ErrorTypeFacade) {
                return argType;
            }
            arguments.add(argType);
        }
        List<EObject> matchingOperations = AlfScopeProvider.scopingTool.getVisibleOperationsOrBehaviors((EObject)type).resolveByName(exp.getOperationName());
        if (matchingOperations.size() == 0) {
            String errorMessage = "";
            ErrorTypeFacade error = null;
            if (exp.getOperationName().equals("destroy")) {
                if (typeOfPrefix.getTypeFacade().extractActualType() instanceof PrimitiveType) {
                    errorMessage = String.valueOf(errorMessage) + "Primitive types do not have destructors.";
                } else if (arguments.size() > 0) {
                    errorMessage = String.valueOf(errorMessage) + "Default destructor has not parameters";
                }
                if (errorMessage.length() != 0) {
                    error = TypeFacadeFactory.eInstance.createErrorTypeFacade(errorMessage, source, containingFeature);
                    return TypeExpressionFactory.eInstance.createTypeExpression(error);
                }
                return TypeExpressionFactory.eInstance.createTypeExpression(_undefined);
            }
            errorMessage = "Could not resolve operation " + exp.getOperationName() + " for classifier " + type.getName();
            error = TypeFacadeFactory.eInstance.createErrorTypeFacade(errorMessage, source, containingFeature);
            return TypeExpressionFactory.eInstance.createTypeExpression(error);
        }
        if (matchingOperations.size() > 1) {
            ArrayList<SignatureFacade> availableSignatures = new ArrayList<SignatureFacade>();
            for (EObject operation : matchingOperations) {
                availableSignatures.add(SignatureFacadeFactory.eInstance.createSignatureFacade(operation));
            }
            List<SignatureFacade> selectedSignatures = SignatureFacade.findNearestSignature(arguments, availableSignatures);
            if (selectedSignatures.size() > 1) {
                ErrorTypeFacade error = TypeFacadeFactory.eInstance.createErrorTypeFacade(String.valueOf(exp.getOperationName()) + " resolves to multiple elements", exp, (EStructuralFeature)AlfPackage.eINSTANCE.getOperationCallExpression_OperationName());
                return TypeExpressionFactory.eInstance.createTypeExpression(error);
            }
            if (selectedSignatures.size() == 0) {
                String errorMessage = String.valueOf(exp.getOperationName()) + " does not apply to arguments (";
                boolean first = true;
                for (TypeExpression argType : arguments) {
                    if (!first) {
                        errorMessage = String.valueOf(errorMessage) + ", ";
                    } else {
                        first = false;
                    }
                    errorMessage = String.valueOf(errorMessage) + argType.getLabel();
                }
                errorMessage = String.valueOf(errorMessage) + ")";
                ErrorTypeFacade error = TypeFacadeFactory.eInstance.createErrorTypeFacade(errorMessage, exp, (EStructuralFeature)AlfPackage.eINSTANCE.getOperationCallExpression_OperationName());
                return TypeExpressionFactory.eInstance.createTypeExpression(error);
            }
            SignatureFacade operationSignature = selectedSignatures.get(0);
            String argumentsAreCompatible = operationSignature.isCompatibleWithMe(arguments, true);
            if (argumentsAreCompatible.length() != 0) {
                ErrorTypeFacade error = TypeFacadeFactory.eInstance.createErrorTypeFacade(argumentsAreCompatible, exp, (EStructuralFeature)AlfPackage.eINSTANCE.getOperationCallExpression_OperationName());
                return TypeExpressionFactory.eInstance.createTypeExpression(error);
            }
            typeOfSuffix = selectedSignatures.get(0).getReturnType();
        } else {
            typeOfSuffix = TypeExpressionFactory.eInstance.createTypeExpression(matchingOperations.get(0));
            SignatureFacade operationSignature = new SignatureFacade(matchingOperations.get(0));
            String argumentsAreCompatible = operationSignature.isCompatibleWithMe(arguments, true);
            if (argumentsAreCompatible.length() != 0) {
                ErrorTypeFacade error = TypeFacadeFactory.eInstance.createErrorTypeFacade(argumentsAreCompatible, exp, (EStructuralFeature)AlfPackage.eINSTANCE.getOperationCallExpression_OperationName());
                return TypeExpressionFactory.eInstance.createTypeExpression(error);
            }
            typeOfSuffix = operationSignature.getReturnType();
        }
        if (exp.getSuffix() != null && exp.getSuffix() != this.suffixToBeIgnored) {
            return this.getTypeOfSuffixExpression(exp.getSuffix(), typeOfSuffix);
        }
        return typeOfSuffix;
    }

    public TypeExpression getTypeOfSequenceElement(SequenceElement s) {
        if (s instanceof Expression) {
            return this.getTypeOfExpression((Expression)s);
        }
        return this.getTypeOfSequenceConstructionExpression((SequenceConstructionExpression)s);
    }

    public TypeExpression getTypeOfSequenceConstructionExpression(SequenceConstructionExpression s) {
        String errorMessage = "";
        ErrorTypeFacade error = null;
        if (s.getSequenceElement() == null || s.getSequenceElement().isEmpty()) {
            errorMessage = "Invalid sequence construction expression.";
            error = TypeFacadeFactory.eInstance.createErrorTypeFacade(errorMessage, s, (EStructuralFeature)AlfPackage.eINSTANCE.getSequenceConstructionExpression_SequenceElement());
            return TypeExpressionFactory.eInstance.createTypeExpression(error);
        }
        TypeExpression baseType = this.getTypeOfSequenceElement((SequenceElement)s.getSequenceElement().get(0));
        if (baseType.getTypeFacade() instanceof ErrorTypeFacade) {
            return baseType;
        }
        if (s.getRangeUpper() != null) {
            TypeExpression upperType = this.getTypeOfExpression(s.getRangeUpper());
            if (upperType.getTypeFacade() instanceof ErrorTypeFacade) {
                return upperType;
            }
            if (upperType.isCompatibleWithMe(baseType) != 0) {
                return TypeExpressionFactory.eInstance.createTypeExpression(upperType.getTypeFacade(), 0, -1, false, true);
            }
            if (baseType.isCompatibleWithMe(upperType) != 0) {
                return TypeExpressionFactory.eInstance.createTypeExpression(baseType.getTypeFacade(), 0, -1, false, true);
            }
            errorMessage = String.valueOf(errorMessage) + "All the elements in the sequence must be type compatible.";
            error = TypeFacadeFactory.eInstance.createErrorTypeFacade(errorMessage, s, (EStructuralFeature)AlfPackage.eINSTANCE.getSequenceConstructionExpression_SequenceElement());
            return TypeExpressionFactory.eInstance.createTypeExpression(error);
        }
        ArrayList<TypeExpression> typeOfSequenceElements = new ArrayList<TypeExpression>();
        typeOfSequenceElements.add(baseType);
        int i = 1;
        while (i < s.getSequenceElement().size()) {
            TypeExpression t = this.getTypeOfSequenceElement((SequenceElement)s.getSequenceElement().get(i));
            if (t.getTypeFacade() instanceof ErrorTypeFacade) {
                return t;
            }
            typeOfSequenceElements.add(t);
            ++i;
        }
        TypeExpression commonSuperType = this.findCommonSuperType(typeOfSequenceElements);
        if (commonSuperType == null) {
            errorMessage = "All the elements in the sequence must be type compatible.";
            error = TypeFacadeFactory.eInstance.createErrorTypeFacade(errorMessage, s, (EStructuralFeature)AlfPackage.eINSTANCE.getSequenceConstructionExpression_SequenceElement());
            commonSuperType = TypeExpressionFactory.eInstance.createTypeExpression(error);
        } else {
            commonSuperType.setMultiplicity(MultiplicityFacadeFactory.eInstance.createMultiplicityFacade(-1));
        }
        return commonSuperType;
    }

    private TypeExpression findCommonSuperType(List<TypeExpression> l) {
        TypeExpression mostGeneral = l.get(0);
        int i = 1;
        while (i < l.size() && mostGeneral != null) {
            TypeExpression current = l.get(i);
            if (mostGeneral != current && current.isCompatibleWithMe(mostGeneral) == 0) {
                mostGeneral = mostGeneral.isCompatibleWithMe(current) != 0 ? current : null;
            }
            ++i;
        }
        return mostGeneral;
    }

    public TypeExpression getTypeOfCandidateExpression(EObject exp) {
        if (exp instanceof Tuple) {
            return this.getTypeOfCandidateExpression(exp.eContainer());
        }
        if (exp instanceof Expression) {
            return this.getTypeOfExpression((Expression)exp);
        }
        if (exp instanceof ConditionalTestExpression) {
            return this.getTypeOfConditionalTestExpression((ConditionalTestExpression)exp);
        }
        if (exp instanceof ConditionalOrExpression) {
            return this.getTypeOfConditionalOrExpression((ConditionalOrExpression)exp);
        }
        if (exp instanceof ConditionalAndExpression) {
            return this.getTypeOfConditionalAndExpression((ConditionalAndExpression)exp);
        }
        if (exp instanceof InclusiveOrExpression) {
            return this.getTypeOfInclusiveOrExpression((InclusiveOrExpression)exp);
        }
        if (exp instanceof ExclusiveOrExpression) {
            return this.getTypeOfExclusiveOrExpression((ExclusiveOrExpression)exp);
        }
        if (exp instanceof AndExpression) {
            return this.getTypeOfAndExpression((AndExpression)exp);
        }
        if (exp instanceof EqualityExpression) {
            return this.getTypeOfEqualityExpression((EqualityExpression)exp);
        }
        if (exp instanceof ClassificationExpression) {
            return this.getTypeOfClassificationExpression((ClassificationExpression)exp);
        }
        if (exp instanceof RelationalExpression) {
            return this.getTypeOfRelationalExpression((RelationalExpression)exp);
        }
        if (exp instanceof ShiftExpression) {
            return this.getTypeOfShiftExpression((ShiftExpression)exp);
        }
        if (exp instanceof AdditiveExpression) {
            return this.getTypeOfAdditiveExpression((AdditiveExpression)exp);
        }
        if (exp instanceof MultiplicativeExpression) {
            return this.getTypeOfMultiplicativeExpression((MultiplicativeExpression)exp);
        }
        if (exp instanceof UnaryExpression) {
            return this.getTypeOfUnaryExpression((UnaryExpression)exp);
        }
        if (exp instanceof PrimaryExpression) {
            return this.getTypeOfPrimaryExpression((PrimaryExpression)exp);
        }
        if (exp instanceof ValueSpecification) {
            return this.getTypeOfValueSpecification((ValueSpecification)exp);
        }
        if (exp instanceof NullExpression) {
            return this.getTypeOfNullExpression((NullExpression)exp);
        }
        if (exp instanceof InstanceCreationExpression) {
            return this.getTypeOfInstanceCreationExpression((InstanceCreationExpression)exp);
        }
        if (exp instanceof SuperInvocationExpression) {
            return this.getTypeOfSuperInvocationExpression((SuperInvocationExpression)exp);
        }
        if (exp instanceof NonLiteralValueSpecification) {
            return this.getTypeOfNonLiteralValueSpecification((NonLiteralValueSpecification)exp);
        }
        if (exp instanceof LITERAL) {
            return this.getTypeOfLITERAL((LITERAL)exp);
        }
        if (exp instanceof ParenthesizedExpression) {
            return this.getTypeOfParenthesizedExpression((ParenthesizedExpression)exp);
        }
        if (exp instanceof NameExpression) {
            return this.getTypeOfNameExpression((NameExpression)exp);
        }
        if (exp instanceof ThisExpression) {
            return this.getTypeOfThisExpression((ThisExpression)exp);
        }
        if (exp instanceof SequenceOperationExpression) {
            TypeUtils localTypeUtil = new TypeUtils((SuffixExpression)exp);
            TypeExpression typeOfPrefix = localTypeUtil.getTypeOfCandidateExpression(exp.eContainer());
            if (typeOfPrefix.getTypeFacade() instanceof ErrorTypeFacade) {
                return typeOfPrefix;
            }
            return this.getTypeOfSequenceOperationExpression((SequenceOperationExpression)exp, typeOfPrefix);
        }
        if (exp instanceof SequenceReductionExpression) {
            TypeUtils localTypeUtil = new TypeUtils((SuffixExpression)exp);
            TypeExpression typeOfPrefix = localTypeUtil.getTypeOfCandidateExpression(exp.eContainer());
            if (typeOfPrefix.getTypeFacade() instanceof ErrorTypeFacade) {
                return typeOfPrefix;
            }
            return this.getTypeOfSequenceReductionExpression((SequenceReductionExpression)exp, typeOfPrefix);
        }
        if (exp instanceof SequenceExpansionExpression) {
            TypeUtils localTypeUtil = new TypeUtils((SuffixExpression)exp);
            TypeExpression typeOfPrefix = localTypeUtil.getTypeOfCandidateExpression(exp.eContainer());
            if (typeOfPrefix.getTypeFacade() instanceof ErrorTypeFacade) {
                return typeOfPrefix;
            }
            return this.getTypeOfSequenceExpansionExpression((SequenceExpansionExpression)exp, typeOfPrefix);
        }
        if (exp instanceof IsUniqueOperation) {
            TypeUtils localTypeUtil = new TypeUtils((SuffixExpression)exp);
            TypeExpression typeOfPrefix = localTypeUtil.getTypeOfCandidateExpression(exp.eContainer());
            if (typeOfPrefix.getTypeFacade() instanceof ErrorTypeFacade) {
                return typeOfPrefix;
            }
            return this.getTypeOfIsUniqueOperation((IsUniqueOperation)exp, typeOfPrefix);
        }
        if (exp instanceof ForAllOrExistsOrOneOperation) {
            TypeUtils localTypeUtil = new TypeUtils((SuffixExpression)exp);
            TypeExpression typeOfPrefix = localTypeUtil.getTypeOfCandidateExpression(exp.eContainer());
            if (typeOfPrefix.getTypeFacade() instanceof ErrorTypeFacade) {
                return typeOfPrefix;
            }
            return this.getTypeOfForAllOrExistsOrOneOperation((ForAllOrExistsOrOneOperation)exp, typeOfPrefix);
        }
        if (exp instanceof CollectOrIterateOperation) {
            TypeUtils localTypeUtil = new TypeUtils((SuffixExpression)exp);
            TypeExpression typeOfPrefix = localTypeUtil.getTypeOfCandidateExpression(exp.eContainer());
            if (typeOfPrefix.getTypeFacade() instanceof ErrorTypeFacade) {
                return typeOfPrefix;
            }
            return this.getTypeOfCollectOrIterateOperation((CollectOrIterateOperation)exp, typeOfPrefix);
        }
        if (exp instanceof SelectOrRejectOperation) {
            TypeUtils localTypeUtil = new TypeUtils((SuffixExpression)exp);
            TypeExpression typeOfPrefix = localTypeUtil.getTypeOfCandidateExpression(exp.eContainer());
            if (typeOfPrefix.getTypeFacade() instanceof ErrorTypeFacade) {
                return typeOfPrefix;
            }
            return this.getTypeOfSelectOrRejectOperation((SelectOrRejectOperation)exp, typeOfPrefix);
        }
        if (exp instanceof PropertyCallExpression) {
            TypeUtils localTypeUtil = new TypeUtils((SuffixExpression)exp);
            TypeExpression typeOfPrefix = localTypeUtil.getTypeOfCandidateExpression(exp.eContainer());
            if (typeOfPrefix.getTypeFacade() instanceof ErrorTypeFacade) {
                return typeOfPrefix;
            }
            return this.getTypeOfPropertyCallExpression((PropertyCallExpression)exp, typeOfPrefix);
        }
        if (exp instanceof OperationCallExpression) {
            TypeUtils localTypeUtil = new TypeUtils((SuffixExpression)exp);
            TypeExpression typeOfPrefix = localTypeUtil.getTypeOfCandidateExpression(exp.eContainer());
            if (typeOfPrefix.getTypeFacade() instanceof ErrorTypeFacade) {
                return typeOfPrefix;
            }
            return this.getTypeOfOperationCallExpression((OperationCallExpression)exp, typeOfPrefix);
        }
        if (exp instanceof SequenceElement) {
            return this.getTypeOfSequenceElement((SequenceElement)exp);
        }
        if (exp instanceof SequenceConstructionExpression) {
            return this.getTypeOfSequenceConstructionExpression((SequenceConstructionExpression)exp);
        }
        String errorMessage = "Not an expression.";
        ErrorTypeFacade error = TypeFacadeFactory.eInstance.createErrorTypeFacade(errorMessage, exp, null);
        return TypeExpressionFactory.eInstance.createTypeExpression(error);
    }
}

