/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.internal.repository.tools.tasks;

import java.net.URI;
import org.apache.tools.ant.BuildException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.equinox.p2.core.ProvisionException;
import org.eclipse.equinox.p2.internal.repository.tools.ArtifactRepositoryValidator;
import org.eclipse.equinox.p2.internal.repository.tools.Messages;
import org.eclipse.equinox.p2.internal.repository.tools.tasks.AbstractRepositoryTask;
import org.eclipse.equinox.p2.internal.repository.tools.tasks.DestinationRepository;
import org.eclipse.equinox.p2.repository.artifact.IArtifactRepository;
import org.eclipse.equinox.p2.repository.artifact.IArtifactRepositoryManager;

public class ValidateTask
extends AbstractRepositoryTask {
    private String comparatorID;

    public void execute() {
        ArtifactRepositoryValidator validator;
        IArtifactRepositoryManager manager = (IArtifactRepositoryManager)ValidateTask.getAgent().getService(IArtifactRepositoryManager.SERVICE_NAME);
        if (manager == null) {
            throw new BuildException(Messages.no_artifactRepo_manager);
        }
        try {
            validator = new ArtifactRepositoryValidator(this.comparatorID);
        }
        catch (ProvisionException e) {
            throw new BuildException(Messages.invalidComparatorId, (Throwable)e);
        }
        IArtifactRepository artifactRepository = null;
        for (DestinationRepository repo : this.destinations) {
            URI repoLocation = repo.getDescriptor().getRepoLocation();
            try {
                artifactRepository = manager.loadRepository(repoLocation, null);
                IStatus result = validator.validateRepository(artifactRepository);
                if (result.isOK()) continue;
                throw new BuildException(result.getMessage());
            }
            catch (ProvisionException e) {
                throw new BuildException(Messages.exception_loadingRepository, (Throwable)e);
            }
        }
    }

    public void setLocation(String value) {
        super.setDestination(value);
    }

    public void setComparatorID(String value) {
        this.comparatorID = value;
    }
}

