/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.internal.repository.tools.tasks;

import java.net.URI;
import java.net.URISyntaxException;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.URIUtil;
import org.eclipse.equinox.p2.core.ProvisionException;
import org.eclipse.equinox.p2.internal.repository.tools.MirrorApplication;
import org.eclipse.equinox.p2.internal.repository.tools.RepositoryDescriptor;

public class MirrorMetadataTask
extends Task {
    URI source;
    URI destination;
    String destinationName;
    String writeMode;
    boolean references = true;

    public void execute() {
        RepositoryDescriptor destinationRepo = new RepositoryDescriptor();
        destinationRepo.setName(this.destinationName);
        destinationRepo.setLocation(this.destination);
        destinationRepo.setKind("M");
        destinationRepo.setFormat(this.source);
        if (this.writeMode != null && this.writeMode.equals("clean")) {
            destinationRepo.setAppend(false);
        }
        RepositoryDescriptor sourceRepo = new RepositoryDescriptor();
        sourceRepo.setLocation(this.source);
        sourceRepo.setKind("M");
        MirrorApplication app = new MirrorApplication();
        app.addDestination(destinationRepo);
        app.addSource(sourceRepo);
        app.setReferences(this.references);
        try {
            IStatus result = app.run(null);
            if (result.getSeverity() != 0) {
                this.log(result.getMessage());
            }
        }
        catch (ProvisionException e) {
            throw new BuildException((Throwable)e);
        }
    }

    public void setSource(String value) {
        try {
            this.source = URIUtil.fromString((String)value);
        }
        catch (URISyntaxException e) {
            throw new BuildException((Throwable)e);
        }
    }

    public void setDestination(String value) {
        try {
            this.destination = URIUtil.fromString((String)value);
        }
        catch (URISyntaxException e) {
            throw new BuildException((Throwable)e);
        }
    }

    public void setDestinationName(String value) {
        this.destinationName = value;
    }

    public void setWriteMode(String value) {
        this.writeMode = value;
    }

    public void setReferences(boolean value) {
        this.references = value;
    }
}

