/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.internal.repository.tools.tasks;

import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.eclipse.core.runtime.URIUtil;
import org.eclipse.equinox.p2.internal.repository.mirroring.IArtifactMirrorLog;
import org.eclipse.equinox.p2.internal.repository.tools.MirrorApplication;
import org.eclipse.equinox.p2.internal.repository.tools.RepositoryDescriptor;
import org.eclipse.equinox.p2.internal.repository.tools.tasks.AntMirrorLog;

public class MirrorArtifactsTask
extends Task {
    URI source;
    URI destination;
    String destinationName;
    URI baseline;
    File mirrorLog;
    File comparatorLog;
    String comparatorID;
    String writeMode;
    boolean compare = false;
    boolean ignoreErrors = false;
    boolean raw = false;
    boolean verbose = false;
    boolean references = true;

    public void execute() {
        RepositoryDescriptor destinationRepo = new RepositoryDescriptor();
        destinationRepo.setName(this.destinationName);
        destinationRepo.setLocation(this.destination);
        destinationRepo.setKind("A");
        destinationRepo.setFormat(this.source);
        if (this.writeMode != null && this.writeMode.equals("clean")) {
            destinationRepo.setAppend(false);
        }
        RepositoryDescriptor sourceRepo = new RepositoryDescriptor();
        sourceRepo.setLocation(this.source);
        sourceRepo.setKind("A");
        MirrorApplication app = new MirrorApplication();
        app.addDestination(destinationRepo);
        app.addSource(sourceRepo);
        app.setRaw(this.raw);
        app.setIgnoreErrors(this.ignoreErrors);
        app.setVerbose(this.verbose);
        app.setCompare(this.compare);
        app.setComparatorID(this.comparatorID);
        app.setBaseline(this.baseline);
        app.setReferences(this.references);
        if (this.comparatorLog != null) {
            app.setComparatorLog(this.comparatorLog);
        }
        if (this.mirrorLog != null) {
            app.setLog(this.mirrorLog);
        } else {
            try {
                app.setLog((IArtifactMirrorLog)new AntMirrorLog((Object)this));
            }
            catch (NoSuchMethodException noSuchMethodException) {}
        }
        try {
            app.run(null);
        }
        catch (Exception e) {
            throw new BuildException("Exception while running mirror application.", (Throwable)e);
        }
    }

    public void setSource(String value) {
        try {
            this.source = URIUtil.fromString((String)value);
        }
        catch (URISyntaxException e) {
            throw new BuildException((Throwable)e);
        }
    }

    public void setDestination(String value) {
        try {
            this.destination = URIUtil.fromString((String)value);
        }
        catch (URISyntaxException e) {
            throw new BuildException((Throwable)e);
        }
    }

    public void setDestinationName(String value) {
        this.destinationName = value;
    }

    public void setBaseline(String value) {
        try {
            this.baseline = URIUtil.fromString((String)value);
        }
        catch (URISyntaxException e) {
            throw new BuildException((Throwable)e);
        }
        this.compare = true;
    }

    public void setComparatorID(String value) {
        this.comparatorID = value;
        this.compare = true;
    }

    public void setComparatorLog(String value) {
        this.comparatorLog = new File(value);
    }

    public void setWriteMode(String value) {
        this.writeMode = value;
    }

    public void setLog(String value) {
        this.mirrorLog = new File(value);
    }

    public void setCompare(boolean value) {
        this.compare = value;
    }

    public void setIgnoreErrors(boolean value) {
        this.ignoreErrors = value;
    }

    public void setRaw(boolean value) {
        this.raw = value;
    }

    public void setVerbose(boolean value) {
        this.verbose = value;
    }

    public void setReferences(boolean value) {
        this.references = value;
    }
}

