/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.internal.repository.tools.tasks;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Map;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.eclipse.core.runtime.URIUtil;
import org.eclipse.equinox.internal.p2.artifact.repository.CompositeArtifactRepository;
import org.eclipse.equinox.p2.core.ProvisionException;
import org.eclipse.equinox.p2.internal.repository.tools.tasks.AbstractRepositoryTask;
import org.eclipse.equinox.p2.repository.artifact.IArtifactRepository;
import org.eclipse.equinox.p2.repository.artifact.IArtifactRepositoryManager;

public class CreateCompositeArtifactRepositoryTask
extends Task {
    URI location;
    String name = "Composite Artifact Repository";
    boolean atomic = true;
    boolean compressed = true;
    boolean failOnExists = false;
    Map<String, String> properties = new HashMap<String, String>();

    public void execute() {
        IArtifactRepositoryManager manager;
        block8: {
            this.validate();
            manager = (IArtifactRepositoryManager)AbstractRepositoryTask.getAgent().getService(IArtifactRepositoryManager.SERVICE_NAME);
            if (manager == null) {
                throw new BuildException("Unable to aquire artifact repository manager service.");
            }
            manager.removeRepository(this.location);
            try {
                IArtifactRepository repository = manager.loadRepository(this.location, null);
                if (repository instanceof CompositeArtifactRepository) {
                    if (this.failOnExists) {
                        throw new BuildException("Composite repository already exists at location: " + this.location);
                    }
                    return;
                }
            }
            catch (ProvisionException e) {
                if (e.getStatus().getCode() == 1000) break block8;
                throw new BuildException("Exception while trying to read repository at: " + this.location, (Throwable)e);
            }
        }
        if (this.compressed) {
            this.properties.put("p2.compressed", Boolean.toString(true));
        }
        this.properties.put("p2.atomic.composite.loading", Boolean.toString(this.atomic));
        try {
            manager.createRepository(this.location, this.name, "org.eclipse.equinox.p2.artifact.repository.compositeRepository", this.properties);
        }
        catch (ProvisionException e) {
            throw new BuildException("Error occurred while creating composite artifact repository.", (Throwable)e);
        }
    }

    private void validate() {
        if (this.location == null) {
            throw new BuildException("Must specify repository location.");
        }
        if (this.name == null) {
            throw new BuildException("Must specify a repository name.");
        }
    }

    public void setName(String value) {
        this.name = value;
    }

    public void setLocation(String value) throws URISyntaxException {
        this.location = URIUtil.fromString((String)value);
    }

    public void setCompressed(boolean value) {
        this.compressed = value;
    }

    public void setAtomic(boolean value) {
        this.atomic = value;
    }

    public void setFailOnExists(boolean value) {
        this.failOnExists = value;
    }
}

