/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.internal.repository.tools.tasks;

import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.FileSet;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.URIUtil;
import org.eclipse.equinox.internal.p2.artifact.repository.Activator;
import org.eclipse.equinox.internal.p2.core.helpers.ServiceHelper;
import org.eclipse.equinox.p2.core.IProvisioningAgent;
import org.eclipse.equinox.p2.internal.repository.tools.AbstractApplication;
import org.eclipse.equinox.p2.internal.repository.tools.Messages;
import org.eclipse.equinox.p2.internal.repository.tools.RepositoryDescriptor;
import org.eclipse.equinox.p2.internal.repository.tools.tasks.AntMirrorLog;
import org.eclipse.equinox.p2.internal.repository.tools.tasks.DestinationRepository;
import org.eclipse.equinox.p2.internal.repository.tools.tasks.IUDescription;
import org.eclipse.equinox.p2.internal.repository.tools.tasks.RepositoryFileSet;
import org.eclipse.equinox.p2.internal.repository.tools.tasks.RepositoryList;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.BundleContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractRepositoryTask
extends Task {
    protected static final String ANT_PREFIX = "${";
    protected AbstractApplication application;
    protected List<IUDescription> iuTasks = new ArrayList<IUDescription>();
    protected List<FileSet> sourceRepos = new ArrayList<FileSet>();
    protected List<DestinationRepository> destinations = new ArrayList<DestinationRepository>();

    protected void addMetadataSourceRepository(URI repoLocation, boolean optional) {
        RepositoryDescriptor source = new RepositoryDescriptor();
        source.setLocation(repoLocation);
        source.setKind("M");
        source.setOptional(optional);
        this.application.addSource(source);
    }

    protected void addArtifactSourceRepository(URI repoLocation, boolean optional) {
        RepositoryDescriptor source = new RepositoryDescriptor();
        source.setLocation(repoLocation);
        source.setKind("A");
        source.setOptional(optional);
        this.application.addSource(source);
    }

    public Object createIu() {
        IUDescription iu = new IUDescription();
        this.iuTasks.add(iu);
        return iu;
    }

    public void setSource(String location) {
        RepositoryDescriptor source = new RepositoryDescriptor();
        try {
            source.setLocation(URIUtil.fromString((String)location));
            this.application.addSource(source);
        }
        catch (URISyntaxException e) {
            throw new BuildException((Throwable)e);
        }
    }

    public void setDestination(String location) {
        DestinationRepository dest = new DestinationRepository();
        dest.setLocation(location);
        this.destinations.add(dest);
        this.application.addDestination(dest.getDescriptor());
    }

    public DestinationRepository createDestination() {
        DestinationRepository destination = new DestinationRepository();
        this.destinations.add(destination);
        this.application.addDestination(destination.getDescriptor());
        return destination;
    }

    public DestinationRepository createRepository() {
        DestinationRepository destination = new DestinationRepository();
        this.destinations.add(destination);
        this.application.addDestination(destination.getDescriptor());
        return destination;
    }

    public static IProvisioningAgent getAgent() throws BuildException {
        IProvisioningAgent agent = (IProvisioningAgent)ServiceHelper.getService((BundleContext)Activator.getContext(), (String)IProvisioningAgent.SERVICE_NAME);
        if (agent == null) {
            throw new BuildException(Messages.no_provisioning_agent);
        }
        return agent;
    }

    public void addConfiguredSource(RepositoryList sourceList) {
        for (DestinationRepository repo : sourceList.getRepositoryList()) {
            this.application.addSource(repo.getDescriptor());
        }
        for (FileSet fileSet : sourceList.getFileSetList()) {
            this.sourceRepos.add(fileSet);
        }
    }

    protected void prepareSourceRepos() {
        if (this.sourceRepos == null || this.sourceRepos.isEmpty()) {
            return;
        }
        for (RepositoryFileSet repositoryFileSet : this.sourceRepos) {
            if (repositoryFileSet.getRepoLocation() != null) {
                if (repositoryFileSet.getRepoLocation().startsWith(ANT_PREFIX)) continue;
                if (repositoryFileSet.isArtifact()) {
                    this.addArtifactSourceRepository(repositoryFileSet.getRepoLocationURI(), repositoryFileSet.isOptional());
                }
                if (!repositoryFileSet.isMetadata()) continue;
                this.addMetadataSourceRepository(repositoryFileSet.getRepoLocationURI(), repositoryFileSet.isOptional());
                continue;
            }
            if (repositoryFileSet.getDir() == null) continue;
            DirectoryScanner scanner = repositoryFileSet.getDirectoryScanner(this.getProject());
            String[][] elements = new String[][]{scanner.getIncludedDirectories(), scanner.getIncludedFiles()};
            int i = 0;
            while (i < 2) {
                int j = 0;
                while (j < elements[i].length) {
                    File file = new File(repositoryFileSet.getDir(), elements[i][j]);
                    URI uri = file.toURI();
                    if (file.isFile() && file.getName().endsWith(".zip")) {
                        uri = URIUtil.toJarURI((URI)uri, null);
                    }
                    if (repositoryFileSet.isBoth()) {
                        this.addArtifactSourceRepository(uri, repositoryFileSet.isOptional());
                        this.addMetadataSourceRepository(uri, repositoryFileSet.isOptional());
                    } else if (repositoryFileSet.isArtifact()) {
                        this.addArtifactSourceRepository(uri, repositoryFileSet.isOptional());
                    } else if (repositoryFileSet.isMetadata()) {
                        this.addMetadataSourceRepository(uri, repositoryFileSet.isOptional());
                    } else {
                        throw new BuildException(NLS.bind((String)Messages.unknown_repository_type, (Object)uri));
                    }
                    ++j;
                }
                ++i;
            }
        }
        this.sourceRepos.clear();
    }

    /*
     * Unable to fully structure code
     */
    protected List<IInstallableUnit> prepareIUs() {
        if (this.iuTasks == null || this.iuTasks.isEmpty()) {
            return null;
        }
        repository = this.application.getCompositeMetadataRepository();
        result = new ArrayList<IInstallableUnit>();
        for (IUDescription iu : this.iuTasks) {
            iuQuery = iu.createQuery();
            queryResult = repository.query(iuQuery, null).iterator();
            if (!iu.isRequired() || queryResult.hasNext()) ** GOTO lbl12
            throw new BuildException(NLS.bind((String)Messages.AbstractRepositoryTask_unableToFind, (Object)iu.toString()));
lbl-1000:
            // 1 sources

            {
                result.add((IInstallableUnit)queryResult.next());
lbl12:
                // 2 sources

                ** while (queryResult.hasNext())
            }
lbl13:
            // 1 sources

        }
        return result;
    }

    protected void log(IStatus status) {
        try {
            new AntMirrorLog((Object)this).log(status);
        }
        catch (NoSuchMethodException noSuchMethodException) {}
    }
}

