/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.facet.custom.ui.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.ETypedElement;
import org.eclipse.emf.facet.custom.core.ICustomizationManager;
import org.eclipse.emf.facet.custom.core.exception.CustomizationException;
import org.eclipse.emf.facet.custom.metamodel.v0_2_0.internal.treeproxy.EAttributeTreeElement;
import org.eclipse.emf.facet.custom.metamodel.v0_2_0.internal.treeproxy.EObjectTreeElement;
import org.eclipse.emf.facet.custom.metamodel.v0_2_0.internal.treeproxy.EReferenceTreeElement;
import org.eclipse.emf.facet.custom.metamodel.v0_2_0.internal.treeproxy.EStructuralFeatureTreeElement;
import org.eclipse.emf.facet.custom.metamodel.v0_2_0.internal.treeproxy.TreeElement;
import org.eclipse.emf.facet.custom.metamodel.v0_2_0.internal.treeproxy.TreeproxyFactory;
import org.eclipse.emf.facet.custom.ui.IContentPropertiesHandler;
import org.eclipse.emf.facet.custom.ui.IContentPropertiesHandlerFactory;
import org.eclipse.emf.facet.custom.ui.ICustomizedContentProvider;
import org.eclipse.emf.facet.custom.ui.ICustomizedTreeContentProvider;
import org.eclipse.emf.facet.custom.ui.internal.Activator;
import org.eclipse.emf.facet.custom.ui.internal.TreeElementAdapter;
import org.eclipse.emf.facet.efacet.core.FacetUtils;
import org.eclipse.emf.facet.efacet.core.IFacetManager;
import org.eclipse.emf.facet.efacet.core.exception.FacetManagerException;
import org.eclipse.emf.facet.util.core.Logger;
import org.eclipse.jface.viewers.Viewer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CustomizedTreeContentProvider
implements ICustomizedTreeContentProvider,
ICustomizedContentProvider {
    private final ICustomizationManager customManager;
    private final IContentPropertiesHandler contentHandler;
    private Object previousInput;
    private Object[] rootElements;

    public CustomizedTreeContentProvider(ICustomizationManager customManager) {
        this.customManager = customManager;
        this.contentHandler = IContentPropertiesHandlerFactory.DEFAULT.createIContentPropertiesHandler(customManager);
    }

    private static Object[] getRootElements(Object inputElement) {
        Object[] result;
        if (inputElement == null) {
            result = new Object[]{};
        } else if (inputElement instanceof EObject) {
            result = new EObject[]{(EObject)inputElement};
        } else if (inputElement instanceof Collection) {
            result = ((Collection)inputElement).toArray();
        } else if (inputElement instanceof EObject[]) {
            result = (EObject[])inputElement;
        } else {
            throw new IllegalArgumentException("Unhandled input element type: " + inputElement.getClass().getSimpleName());
        }
        return result;
    }

    public Object[] getElements(Object inputElement) {
        Object[] result;
        if (this.previousInput == inputElement) {
            result = this.rootElements;
        } else {
            this.previousInput = inputElement;
            Object[] elements = CustomizedTreeContentProvider.getRootElements(inputElement);
            ArrayList<Object> elementList = new ArrayList<Object>();
            Object[] objectArray = elements;
            int n = elements.length;
            int n2 = 0;
            while (n2 < n) {
                Object element = objectArray[n2];
                if (this.isVisible(element, null)) {
                    if (element instanceof EObject) {
                        EObjectTreeElement eObjectProxy = CustomizedTreeContentProvider.createEObjectProxy(element, null);
                        elementList.add(eObjectProxy);
                    } else {
                        elementList.add(element);
                    }
                }
                ++n2;
            }
            result = elementList.toArray();
            this.rootElements = result;
        }
        return result;
    }

    protected static EObjectTreeElement createEObjectProxy(Object element, EStructuralFeatureTreeElement parent) {
        EObject eObject = (EObject)element;
        EObjectTreeElement eObjectProxy = TreeproxyFactory.eINSTANCE.createEObjectTreeElement();
        eObjectProxy.setEObject(eObject);
        eObjectProxy.setParent(parent);
        eObject.eAdapters().add((Object)new TreeElementAdapter(eObjectProxy));
        return eObjectProxy;
    }

    public Object[] getChildren(Object parentElement) {
        Object[] result;
        if (parentElement == null) {
            result = new Object[]{};
        } else if (parentElement instanceof EObjectTreeElement) {
            EObjectTreeElement eObjectProxy = (EObjectTreeElement)parentElement;
            result = this.getChildren(eObjectProxy);
        } else if (parentElement instanceof EAttributeTreeElement) {
            EAttributeTreeElement attributeProxy = (EAttributeTreeElement)parentElement;
            result = this.getChildren(attributeProxy);
        } else if (parentElement instanceof EReferenceTreeElement) {
            EReferenceTreeElement referenceProxy = (EReferenceTreeElement)parentElement;
            result = this.getChildren(referenceProxy);
        } else {
            Logger.logError((String)("Unknown element in tree: " + parentElement.getClass()), (Plugin)Activator.getDefault());
            result = new Object[]{};
        }
        return result;
    }

    private Object[] getChildren(EObjectTreeElement treeElement) {
        Object children = treeElement.getSfTreeElmement();
        if (children == null || children.isEmpty()) {
            children = new ArrayList();
            children.addAll(this.createAttributes(treeElement));
            children.addAll(this.createReferences(treeElement));
        }
        return children.toArray();
    }

    public Object[] getChildren(EAttributeTreeElement attributeProxy) {
        ArrayList<Object> children = new ArrayList<Object>();
        EAttribute eAttribute = attributeProxy.getEAttribute();
        if (eAttribute.isMany()) {
            EObjectTreeElement parent = attributeProxy.getParent();
            if (!(parent instanceof EObjectTreeElement)) {
                throw new IllegalStateException("An attribute should appear only under a model element");
            }
            EObjectTreeElement parentProxy = parent;
            EObject eObject = parentProxy.getEObject();
            try {
                IFacetManager facetManager = this.customManager.getFacetManager();
                List result = facetManager.getOrInvokeMultiValued(eObject, (ETypedElement)eAttribute, null);
                for (Object object : result) {
                    if (object instanceof EObject) {
                        EObject childEObject = (EObject)object;
                        children.add(CustomizedTreeContentProvider.createEObjectProxy(childEObject, (EStructuralFeatureTreeElement)attributeProxy));
                    }
                    children.add(object);
                }
            }
            catch (FacetManagerException e) {
                Logger.logError((Throwable)e, (Plugin)Activator.getDefault());
            }
        }
        return children.toArray();
    }

    public Object[] getChildren(EReferenceTreeElement referenceProxy) {
        TreeElement child;
        EReference eReference = referenceProxy.getEReference();
        EObjectTreeElement parent = referenceProxy.getParent();
        if (!(parent instanceof EObjectTreeElement)) {
            throw new IllegalStateException("A reference should appear only under a model element");
        }
        EObjectTreeElement parentProxy = parent;
        EObject eObject = parentProxy.getEObject();
        List<Object> result = eReference.isMany() ? this.getMultiValuedReferenceChildren(eReference, eObject, referenceProxy) : ((child = this.getSingleValuedReferenceChild(eReference, eObject, referenceProxy)) == null ? Collections.emptyList() : Collections.singletonList(child));
        return result.toArray();
    }

    private TreeElement getSingleValuedReferenceChild(EReference eReference, EObject eObject, EReferenceTreeElement parent) {
        TreeElement child = null;
        if (parent.getReferedEObjectTE() == null || parent.getReferedEObjectTE().size() == 0) {
            try {
                IFacetManager facetManager = this.customManager.getFacetManager();
                EObject referedEObject = (EObject)facetManager.getOrInvoke(eObject, (ETypedElement)eReference, EObject.class);
                if (referedEObject != null) {
                    child = CustomizedTreeContentProvider.createEObjectProxy(referedEObject, (EStructuralFeatureTreeElement)parent);
                }
            }
            catch (FacetManagerException e) {
                Logger.logError((Throwable)e, (Plugin)Activator.getDefault());
            }
        } else {
            child = (TreeElement)parent.getReferedEObjectTE().get(0);
        }
        return child;
    }

    private List<EObjectTreeElement> getMultiValuedReferenceChildren(EReference eReference, EObject eObject, EReferenceTreeElement parent) {
        EList children = new ArrayList();
        if (parent.getReferedEObjectTE() == null || parent.getReferedEObjectTE().size() == 0) {
            try {
                IFacetManager facetManager = this.customManager.getFacetManager();
                List result = facetManager.getOrInvokeMultiValued(eObject, (ETypedElement)eReference, null);
                for (Object object : result) {
                    if (!(object instanceof EObject)) continue;
                    EObject childEObject = (EObject)object;
                    children.add(CustomizedTreeContentProvider.createEObjectProxy(childEObject, (EStructuralFeatureTreeElement)parent));
                }
            }
            catch (FacetManagerException e) {
                Logger.logError((Throwable)e, (Plugin)Activator.getDefault());
            }
        } else {
            children = parent.getReferedEObjectTE();
        }
        return children;
    }

    private Collection<EAttributeTreeElement> createAttributes(EObjectTreeElement treeElement) {
        EObject eObject = treeElement.getEObject();
        EClass eClass = eObject.eClass();
        IFacetManager facetManager = this.customManager.getFacetManager();
        ArrayList<EAttribute> allAttributes = new ArrayList<EAttribute>();
        allAttributes.addAll((Collection<EAttribute>)eClass.getEAllAttributes());
        try {
            Set facetAttributes = FacetUtils.getETypedElements((EObject)eObject, EAttribute.class, (IFacetManager)facetManager);
            allAttributes.addAll(facetAttributes);
        }
        catch (FacetManagerException e) {
            Logger.logError((Throwable)e, (Plugin)Activator.getDefault());
        }
        return this.createAttributeProxies(allAttributes, treeElement);
    }

    private Collection<EAttributeTreeElement> createAttributeProxies(List<EAttribute> allAttributes, EObjectTreeElement parent) {
        EObject eObject = parent.getEObject();
        ArrayList<EAttributeTreeElement> result = new ArrayList<EAttributeTreeElement>();
        for (EAttribute eAttribute : allAttributes) {
            if (!this.isVisible(eObject, (ETypedElement)eAttribute)) continue;
            EAttributeTreeElement attributeProxy = TreeproxyFactory.eINSTANCE.createEAttributeTreeElement();
            attributeProxy.setEAttribute(eAttribute);
            attributeProxy.setParent(parent);
            result.add(attributeProxy);
        }
        return result;
    }

    private Collection<EReferenceTreeElement> createReferences(EObjectTreeElement treeElement) {
        EObject eObject = treeElement.getEObject();
        EClass eClass = eObject.eClass();
        IFacetManager facetManager = this.customManager.getFacetManager();
        ArrayList<EReference> allReferences = new ArrayList<EReference>();
        allReferences.addAll((Collection<EReference>)eClass.getEAllReferences());
        try {
            Set facetReferences = FacetUtils.getETypedElements((EObject)eObject, EReference.class, (IFacetManager)facetManager);
            allReferences.addAll(facetReferences);
        }
        catch (FacetManagerException e) {
            Logger.logError((Throwable)e, (Plugin)Activator.getDefault());
        }
        return this.createReferenceProxies(allReferences, treeElement);
    }

    private Collection<EReferenceTreeElement> createReferenceProxies(List<EReference> allReferences, EObjectTreeElement parent) {
        EObject eObject = parent.getEObject();
        ArrayList<EReferenceTreeElement> result = new ArrayList<EReferenceTreeElement>();
        for (EReference eReference : allReferences) {
            if (!this.isVisible(eObject, (ETypedElement)eReference)) continue;
            EReferenceTreeElement referenceProxy = TreeproxyFactory.eINSTANCE.createEReferenceTreeElement();
            referenceProxy.setEReference(eReference);
            referenceProxy.setParent(parent);
            result.add(referenceProxy);
        }
        return result;
    }

    public Object getParent(Object element) {
        EObject result = null;
        if (element instanceof TreeElement) {
            TreeElement treeElement = (TreeElement)element;
            result = treeElement.eContainer();
        }
        return result;
    }

    public boolean hasChildren(Object element) {
        return this.getChildren(element).length > 0;
    }

    public void dispose() {
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
    }

    @Override
    public ICustomizationManager getCustomizationManager() {
        return this.customManager;
    }

    public boolean isVisible(Object object, ETypedElement eTypedElement) {
        Boolean result = Boolean.TRUE;
        if (object instanceof EObject) {
            EObject eObject = (EObject)object;
            try {
                result = (Boolean)this.customManager.getCustomValueOf(eObject, eTypedElement, this.contentHandler.getIsVisible(), Boolean.class);
            }
            catch (CustomizationException e) {
                Logger.logError((Throwable)e, (Plugin)Activator.getDefault());
            }
        }
        return result;
    }
}

