/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.tools.utils;

import java.util.Collection;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.emf.core.util.EMFCoreUtil;
import org.eclipse.osgi.util.NLS;
import org.eclipse.uml2.uml.NamedElement;

public class NamedElementUtil {
    public static final String COPY_OF = "CopyOf";
    public static final String QUALIFIED_NAME_SEPARATOR = "::";
    private static final String PUBLIC_STRING = "+";
    private static final String PROTECTED_STRING = "#";
    private static final String PRIVATE_STRING = "-";
    private static final String PACKAGE_STRING = "~";

    public static int getQualifiedNameMaxDepth(NamedElement namedElement) {
        int d = 0;
        String s = namedElement.getQualifiedName();
        if (s == null) {
            return 0;
        }
        int n = 0;
        while ((n = s.indexOf(QUALIFIED_NAME_SEPARATOR, n)) != -1) {
            n += 2;
            ++d;
        }
        return d;
    }

    public static String getDefaultNameWithIncrement(EObject newElement) {
        if (newElement.eContainer() != null) {
            return NamedElementUtil.getDefaultNameWithIncrement(newElement, (Collection)newElement.eContainer().eContents());
        }
        return null;
    }

    public static String getDefaultNameWithIncrement(EObject newElement, Collection contents) {
        return NamedElementUtil.getDefaultNameWithIncrement("", newElement, contents);
    }

    public static String getDefaultCopyNameWithIncrement(NamedElement namedElement, Collection contents) {
        String rootName = namedElement.getName();
        if (rootName != null) {
            for (Object o : contents) {
                String name;
                if (!(o instanceof EObject) || !rootName.equals(name = EMFCoreUtil.getName((EObject)((EObject)o)))) continue;
                String newName = NLS.bind((String)"CopyOf_{0}_", (Object)rootName);
                return NamedElementUtil.getDefaultNameWithIncrementFromBase(newName, contents);
            }
        }
        return rootName;
    }

    public static String getDefaultNameWithIncrement(String prefix, EObject newElement, Collection contents) {
        if (prefix == null) {
            prefix = "";
        }
        return NamedElementUtil.getDefaultNameWithIncrementFromBase(String.valueOf(prefix) + newElement.eClass().getName(), contents);
    }

    public static String getDefaultNameWithIncrementFromBase(String base, Collection contents) {
        if (base.equalsIgnoreCase("property")) {
            base = "Attribute";
        }
        int nextNumber = 1;
        for (Object o : contents) {
            String name;
            if (!(o instanceof EObject) || (name = EMFCoreUtil.getName((EObject)((EObject)o))) == null || !name.startsWith(base)) continue;
            String end = name.substring(base.length());
            int nextNumberTmp = 1;
            try {
                nextNumberTmp = Integer.parseInt(end) + 1;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            if (nextNumberTmp <= nextNumber) continue;
            nextNumber = nextNumberTmp;
        }
        return String.valueOf(base) + nextNumber;
    }

    public static String getVisibilityAsSign(NamedElement element) {
        String vKindValue = "";
        switch (element.getVisibility().getValue()) {
            case 0: {
                vKindValue = PUBLIC_STRING;
                break;
            }
            case 1: {
                vKindValue = PRIVATE_STRING;
                break;
            }
            case 3: {
                vKindValue = PACKAGE_STRING;
                break;
            }
            case 2: {
                vKindValue = PROTECTED_STRING;
            }
        }
        return vKindValue;
    }

    public static String getNameFromQualifiedName(String qualifiedName) {
        String name = qualifiedName.substring(qualifiedName.lastIndexOf(QUALIFIED_NAME_SEPARATOR) + QUALIFIED_NAME_SEPARATOR.length());
        return name != null ? name : "";
    }

    public static String getParentQualifiedName(String childQualifiedName) {
        String childName = NamedElementUtil.getNameFromQualifiedName(childQualifiedName);
        String parentQualifiedName = childQualifiedName.substring(0, childQualifiedName.length() - (QUALIFIED_NAME_SEPARATOR.length() + childName.length()));
        return parentQualifiedName != null ? parentQualifiedName : "";
    }

    public static String getName(NamedElement element) {
        if (element.getName() != null) {
            return element.getName();
        }
        return NamedElementUtil.getDefaultNameWithIncrement((EObject)element);
    }
}

