/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.view.spi.categorization.swt;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecp.edit.internal.swt.util.OverlayImageDescriptor;
import org.eclipse.emf.ecp.edit.internal.swt.util.SWTValidationHelper;
import org.eclipse.emf.ecp.view.spi.categorization.model.VAbstractCategorization;
import org.eclipse.emf.ecp.view.spi.categorization.model.VCategorizableElement;
import org.eclipse.emf.ecp.view.spi.categorization.model.VCategorizationElement;
import org.eclipse.emf.ecp.view.spi.categorization.model.VCategory;
import org.eclipse.emf.ecp.view.spi.categorization.swt.Activator;
import org.eclipse.emf.ecp.view.spi.categorization.swt.ECPTreeViewAction;
import org.eclipse.emf.ecp.view.spi.context.ViewModelContext;
import org.eclipse.emf.ecp.view.spi.model.VElement;
import org.eclipse.emf.ecp.view.spi.renderer.NoPropertyDescriptorFoundExeption;
import org.eclipse.emf.ecp.view.spi.renderer.NoRendererFoundException;
import org.eclipse.emf.ecp.view.spi.swt.AbstractSWTRenderer;
import org.eclipse.emf.ecp.view.spi.swt.SWTRendererFactory;
import org.eclipse.emf.ecp.view.spi.swt.layout.GridDescriptionFactory;
import org.eclipse.emf.ecp.view.spi.swt.layout.SWTGridCell;
import org.eclipse.emf.ecp.view.spi.swt.layout.SWTGridDescription;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.ITableItemLabelProvider;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryContentProvider;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.custom.TreeEditor;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.TreeEvent;
import org.eclipse.swt.events.TreeListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;

public abstract class AbstractJFaceTreeRenderer<VELEMENT extends VElement>
extends AbstractSWTRenderer<VELEMENT> {
    private SWTGridDescription gridDescription;

    public AbstractJFaceTreeRenderer() {
    }

    AbstractJFaceTreeRenderer(SWTRendererFactory factory) {
        super(factory);
    }

    public SWTGridDescription getGridDescription(SWTGridDescription gridDescription) {
        if (this.gridDescription == null) {
            this.gridDescription = GridDescriptionFactory.INSTANCE.createSimpleGrid(1, 1, (AbstractSWTRenderer)this);
        }
        return this.gridDescription;
    }

    protected void dispose() {
        this.gridDescription = null;
        super.dispose();
    }

    protected Control renderControl(SWTGridCell cell, Composite parent) throws NoRendererFoundException, NoPropertyDescriptorFoundExeption {
        EList<VAbstractCategorization> categorizations = this.getCategorizations();
        if (categorizations.size() == 1 && categorizations.get(0) instanceof VCategory) {
            VElement child = (VElement)this.getCategorizations().get(0);
            AbstractSWTRenderer renderer = this.getSWTRendererFactory().getRenderer(child, this.getViewModelContext());
            if (renderer == null) {
                Activator.getDefault().getLog().log((IStatus)new Status(1, "org.eclipse.emf.ecp.view.categorization.swt", String.format("No Renderer for %s found.", child.eClass().getName())));
                return null;
            }
            Control render = renderer.render(cell, parent);
            renderer.finalizeRendering(parent);
            return render;
        }
        SashForm sashForm = new SashForm(parent, 256);
        GridDataFactory.fillDefaults().grab(true, true).align(4, 4).applyTo((Control)sashForm);
        TreeViewer treeViewer = new TreeViewer((Composite)sashForm);
        ScrolledComposite editorComposite = this.createdEditorPane((Composite)sashForm);
        this.setupTreeViewer(treeViewer, editorComposite);
        this.initTreeViewer(treeViewer);
        sashForm.setWeights(new int[]{1, 3});
        return sashForm;
    }

    protected abstract EList<VAbstractCategorization> getCategorizations();

    protected abstract VCategorizationElement getCategorizationElement();

    protected ScrolledComposite createdEditorPane(Composite composite) {
        ScrolledComposite editorComposite = this.createScrolledComposite(composite);
        editorComposite.setExpandHorizontal(true);
        editorComposite.setExpandVertical(true);
        editorComposite.setShowFocusedControl(true);
        GridDataFactory.fillDefaults().grab(true, true).align(4, 4).applyTo((Control)editorComposite);
        return editorComposite;
    }

    private ScrolledComposite createScrolledComposite(Composite parent) {
        ScrolledComposite scrolledComposite = new ScrolledComposite(parent, 2816);
        scrolledComposite.setShowFocusedControl(true);
        scrolledComposite.setExpandVertical(true);
        scrolledComposite.setExpandHorizontal(true);
        scrolledComposite.setBackground(parent.getBackground());
        Composite childComposite = new Composite((Composite)scrolledComposite, 0);
        childComposite.setBackground(parent.getBackground());
        return scrolledComposite;
    }

    protected void setupTreeViewer(final TreeViewer treeViewer, ScrolledComposite editorComposite) {
        treeViewer.addFilter(new ViewerFilter(){

            public boolean select(Viewer viewer, Object parentElement, Object element) {
                return VCategorizableElement.class.isInstance(element) && ((VCategorizableElement)element).isVisible();
            }
        });
        GridDataFactory.fillDefaults().align(1, 4).grab(false, true).hint(400, -1).applyTo((Control)treeViewer.getTree());
        ArrayList<TreeEditor> editors = new ArrayList<TreeEditor>();
        final ComposedAdapterFactory adapterFactory = new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE);
        final AdapterFactoryContentProvider contentProvider = new AdapterFactoryContentProvider((AdapterFactory)adapterFactory){

            public boolean hasChildren(Object object) {
                boolean hasChildren = super.hasChildren(object);
                if (hasChildren) {
                    Object[] objectArray = this.getChildren(object);
                    int n = objectArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Object o = objectArray[n2];
                        ViewerFilter[] viewerFilterArray = treeViewer.getFilters();
                        int n3 = viewerFilterArray.length;
                        int n4 = 0;
                        while (n4 < n3) {
                            ViewerFilter viewerFilter = viewerFilterArray[n4];
                            if (viewerFilter.select((Viewer)treeViewer, object, o)) {
                                return true;
                            }
                            ++n4;
                        }
                        ++n2;
                    }
                }
                return false;
            }
        };
        final TreeTableLabelProvider treeTableLabelProvider = this.getTreeLabelProvider((AdapterFactory)adapterFactory);
        treeViewer.getTree().addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent event) {
                contentProvider.dispose();
                treeTableLabelProvider.dispose();
                adapterFactory.dispose();
            }
        });
        treeViewer.setContentProvider((IContentProvider)contentProvider);
        treeViewer.setLabelProvider((IBaseLabelProvider)treeTableLabelProvider);
        treeViewer.addSelectionChangedListener((ISelectionChangedListener)new TreeSelectionChangedListener(this.getViewModelContext(), editorComposite, this.getCategorizationElement(), treeViewer, editors));
        this.addTreeEditor(treeViewer, (EObject)this.getVElement(), editors);
    }

    protected TreeTableLabelProvider getTreeLabelProvider(AdapterFactory adapterFactory) {
        return new TreeTableLabelProvider(adapterFactory);
    }

    protected void initTreeViewer(TreeViewer treeViewer) {
        treeViewer.setInput((Object)this.getVElement());
        treeViewer.expandAll();
        if (this.getCategorizations().size() != 0) {
            treeViewer.setSelection((ISelection)new StructuredSelection(this.getCategorizations().get(0)));
        }
    }

    private Composite createComposite(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setBackground(parent.getBackground());
        GridLayoutFactory.fillDefaults().numColumns(2).equalWidth(false).applyTo(composite);
        GridDataFactory.fillDefaults().grab(true, true).align(4, 4).applyTo((Control)composite);
        return composite;
    }

    protected void addTreeEditor(TreeViewer treeViewer, EObject view, final List<TreeEditor> editors) {
        Tree tree = treeViewer.getTree();
        int maxActions = 0;
        TreeIterator viewContents = view.eAllContents();
        while (viewContents.hasNext()) {
            VAbstractCategorization abstractCategorization;
            EObject object = (EObject)viewContents.next();
            if (!VAbstractCategorization.class.isInstance(object) || maxActions >= (abstractCategorization = (VAbstractCategorization)object).getActions().size()) continue;
            maxActions = abstractCategorization.getActions().size();
        }
        if (maxActions == 0) {
            return;
        }
        TreeColumn columnText = new TreeColumn(tree, 0);
        columnText.setWidth(300);
        columnText.setAlignment(4);
        int i = 0;
        while (i < maxActions) {
            TreeColumn column = new TreeColumn(tree, 0);
            column.setWidth(50);
            TreeEditor editor = new TreeEditor(tree);
            editor.horizontalAlignment = 0x1000000;
            editor.grabHorizontal = true;
            editor.minimumWidth = 50;
            editor.setColumn(i + 1);
            editors.add(editor);
            ++i;
        }
        tree.addTreeListener(new TreeListener(){

            public void treeExpanded(TreeEvent e) {
            }

            public void treeCollapsed(TreeEvent e) {
                AbstractJFaceTreeRenderer.this.cleanUpTreeEditors(editors);
            }
        });
    }

    private void cleanUpTreeEditors(List<TreeEditor> editors) {
        for (TreeEditor editor : editors) {
            Control oldEditor = editor.getEditor();
            if (oldEditor == null) continue;
            oldEditor.dispose();
        }
    }

    protected void addButtons(TreeViewer treeViewer, TreeSelection treeSelection, List<TreeEditor> editors) {
        this.cleanUpTreeEditors(editors);
        if (treeSelection.getPaths().length == 0) {
            return;
        }
        TreeItem item = treeViewer.getTree().getSelection()[0];
        if (item == null) {
            return;
        }
        VCategorizableElement object = (VCategorizableElement)treeSelection.getFirstElement();
        if (object.getECPActions() == null) {
            return;
        }
        int i = 0;
        while (i < object.getECPActions().size()) {
            ECPTreeViewAction action = (ECPTreeViewAction)object.getECPActions().get(i);
            TreeEditor editor = editors.get(i);
            action.init(treeViewer, treeSelection, editor);
            action.execute();
            ++i;
        }
    }

    private final class TreeSelectionChangedListener
    implements ISelectionChangedListener {
        private final ViewModelContext viewModelContext;
        private final ScrolledComposite editorComposite;
        private final VCategorizationElement vCategorizationElement;
        private final TreeViewer treeViewer;
        private final List<TreeEditor> editors;
        private Composite childComposite;

        private TreeSelectionChangedListener(ViewModelContext viewModelContext, ScrolledComposite editorComposite, VCategorizationElement vCategorizationElement, TreeViewer treeViewer, List<TreeEditor> editors) {
            this.viewModelContext = viewModelContext;
            this.editorComposite = editorComposite;
            this.vCategorizationElement = vCategorizationElement;
            this.treeViewer = treeViewer;
            this.editors = editors;
        }

        public void selectionChanged(SelectionChangedEvent event) {
            TreeSelection treeSelection = (TreeSelection)event.getSelection();
            Object selection = treeSelection.getFirstElement();
            AbstractJFaceTreeRenderer.this.addButtons(this.treeViewer, treeSelection, this.editors);
            if (selection == null) {
                return;
            }
            if (this.childComposite != null) {
                this.childComposite.dispose();
                this.childComposite = null;
            }
            this.childComposite = AbstractJFaceTreeRenderer.this.createComposite((Composite)this.editorComposite);
            this.childComposite.setBackground(this.editorComposite.getBackground());
            this.editorComposite.setContent((Control)this.childComposite);
            VElement child = (VElement)selection;
            try {
                AbstractSWTRenderer renderer = AbstractJFaceTreeRenderer.this.getSWTRendererFactory().getRenderer(child, this.viewModelContext);
                if (renderer == null) {
                    Activator.getDefault().getLog().log((IStatus)new Status(1, "org.eclipse.emf.ecp.view.categorization.swt", String.format("No Renderer for %s found.", child.eClass().getName())));
                    return;
                }
                Control render = renderer.render((SWTGridCell)renderer.getGridDescription(GridDescriptionFactory.INSTANCE.createEmptyGridDescription()).getGrid().get(0), this.childComposite);
                renderer.finalizeRendering(this.childComposite);
                GridDataFactory.fillDefaults().align(4, 4).grab(true, true).applyTo(render);
                this.vCategorizationElement.setCurrentSelection((VCategorizableElement)child);
            }
            catch (NoRendererFoundException e) {
                e.printStackTrace();
            }
            catch (NoPropertyDescriptorFoundExeption e) {
                e.printStackTrace();
            }
            this.childComposite.layout();
            Point point = this.childComposite.computeSize(-1, -1);
            this.editorComposite.setMinSize(point);
        }
    }

    protected class TreeTableLabelProvider
    extends AdapterFactoryLabelProvider
    implements ITableItemLabelProvider {
        public TreeTableLabelProvider(AdapterFactory adapterFactory) {
            super(adapterFactory);
        }

        public String getColumnText(Object object, int columnIndex) {
            String text = super.getColumnText(object, columnIndex);
            if (columnIndex == 0 && VCategorizableElement.class.isInstance(object)) {
                text = super.getColumnText((Object)((VCategorizableElement)object).getLabelObject(), columnIndex);
            }
            return text;
        }

        public Image getColumnImage(Object object, int columnIndex) {
            if (columnIndex != 0) {
                return null;
            }
            Image image = super.getColumnImage(object, columnIndex);
            if (VCategorizableElement.class.isInstance(object)) {
                image = super.getColumnImage((Object)((VCategorizableElement)object).getLabelObject(), columnIndex);
            }
            return this.getValidationOverlay(image, (VElement)object);
        }

        protected Image getValidationOverlay(Image image, VElement categorization) {
            ImageDescriptor overlay = null;
            if (categorization.getDiagnostic() == null) {
                return image;
            }
            overlay = SWTValidationHelper.INSTANCE.getValidationOverlayDescriptor(categorization.getDiagnostic().getHighestSeverity());
            if (overlay == null) {
                return image;
            }
            OverlayImageDescriptor imageDescriptor = new OverlayImageDescriptor(image, overlay, 2);
            Image resultImage = imageDescriptor.createImage();
            return resultImage;
        }
    }
}

