/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.gmfdiag.common.utils;

import java.util.Collection;
import org.eclipse.core.expressions.PropertyTester;
import org.eclipse.gmf.runtime.diagram.ui.parts.IDiagramWorkbenchPart;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.papyrus.infra.tools.util.WorkbenchPartHelper;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbenchPart;

public class DiagramPropertyTester
extends PropertyTester {
    public static final String IS_DIAGRAM_EDITOR = "isDiagramEditor";
    public static final String IS_GMF_DIAGRAM_CONTEXT_ACTIVE = "isGmfDiagramContextActive";
    public static final String IS_TEXT_ZONE = "isTextZone";

    public boolean test(Object receiver, String property, Object[] args, Object expectedValue) {
        if (IS_DIAGRAM_EDITOR.equals(property) && receiver instanceof IStructuredSelection) {
            boolean answer = this.isDiagramEditor((IStructuredSelection)receiver);
            return new Boolean(answer).equals(expectedValue);
        }
        if (IS_GMF_DIAGRAM_CONTEXT_ACTIVE.equals(property) && receiver instanceof Collection) {
            boolean answer = this.isDiagramContextActive((Collection)receiver);
            return new Boolean(answer).equals(expectedValue);
        }
        if (IS_TEXT_ZONE.equals(property) && receiver instanceof Shell) {
            boolean answer = this.isTextZone((Shell)receiver);
            return new Boolean(answer).equals(expectedValue);
        }
        return false;
    }

    private boolean isTextZone(Shell shell) {
        Control focusControl;
        Display display = shell.getDisplay();
        return display != null && ((focusControl = display.getFocusControl()) instanceof StyledText || focusControl instanceof Text);
    }

    private boolean isDiagramEditor(IStructuredSelection selection) {
        IWorkbenchPart part = WorkbenchPartHelper.getCurrentActiveWorkbenchPart();
        if (part != null) {
            IDiagramWorkbenchPart diagramPart = (IDiagramWorkbenchPart)part.getAdapter(IDiagramWorkbenchPart.class);
            return diagramPart != null;
        }
        return false;
    }

    private boolean isDiagramContextActive(Collection<?> activeContextIds) {
        return activeContextIds.contains("org.eclipse.gmf.runtime.diagram.ui.diagramContext");
    }
}

