/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.gmfdiag.common.providers;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.diagram.core.listener.DiagramEventBroker;
import org.eclipse.gmf.runtime.diagram.core.listener.NotificationListener;
import org.eclipse.gmf.runtime.draw2d.ui.render.RenderedImage;
import org.eclipse.gmf.runtime.notation.NotationPackage;
import org.eclipse.gmf.runtime.notation.StringValueStyle;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.infra.gmfdiag.common.Activator;
import org.eclipse.papyrus.infra.gmfdiag.common.service.shape.AbstractShapeProvider;
import org.eclipse.papyrus.infra.gmfdiag.common.service.shape.ProviderNotificationManager;
import org.w3c.dom.svg.SVGDocument;

public class StyleBasedShapeProvider
extends AbstractShapeProvider {
    protected static final String STYLE_PROPERTY = "svgFile";
    private ProviderNotificationManager manager;
    private List<SVGDocument> listEmptySVG = new ArrayList<SVGDocument>(0);
    private List<RenderedImage> listEmptyRendered = new ArrayList<RenderedImage>(0);
    private List<SVGDocument> listSingletonSVG = new ArrayList<SVGDocument>(1);
    private List<RenderedImage> listSingletonRendered;

    public StyleBasedShapeProvider() {
        this.listSingletonSVG.add(null);
        this.listSingletonRendered = new ArrayList<RenderedImage>(1);
        this.listSingletonRendered.add(null);
    }

    @Override
    public List<RenderedImage> getShapes(EObject view) {
        if (!(view instanceof View)) {
            return this.listEmptyRendered;
        }
        View v = (View)view;
        String svgFile = this.extract((StringValueStyle)v.getNamedStyle(NotationPackage.eINSTANCE.getStringValueStyle(), STYLE_PROPERTY));
        if (svgFile == null) {
            return this.listEmptyRendered;
        }
        SVGDocument svg = this.getSVGDocument(view, svgFile);
        RenderedImage img = null;
        try {
            img = this.renderSVGDocument(view, svg);
        }
        catch (IOException e) {
            Activator.log.error("Failed to render the svg file: " + svgFile, (Throwable)e);
        }
        this.listSingletonRendered.set(0, img);
        return this.listSingletonRendered;
    }

    @Override
    public List<SVGDocument> getSVGDocument(EObject view) {
        if (!(view instanceof View)) {
            return this.listEmptySVG;
        }
        View v = (View)view;
        String svgFile = this.extract((StringValueStyle)v.getNamedStyle(NotationPackage.eINSTANCE.getStringValueStyle(), STYLE_PROPERTY));
        if (svgFile == null) {
            return this.listEmptySVG;
        }
        SVGDocument svg = this.getSVGDocument(view, svgFile);
        this.listSingletonSVG.set(0, svg);
        return this.listSingletonSVG;
    }

    @Override
    public boolean providesShapes(EObject view) {
        if (!(view instanceof View)) {
            return false;
        }
        View v = (View)view;
        String svgFile = this.extract((StringValueStyle)v.getNamedStyle(NotationPackage.eINSTANCE.getStringValueStyle(), STYLE_PROPERTY));
        return svgFile != null;
    }

    private String extract(StringValueStyle style) {
        if (style == null || style.getStringValue() == null || style.getStringValue().isEmpty()) {
            return null;
        }
        return style.getStringValue();
    }

    @Override
    public ProviderNotificationManager createProviderNotificationManager(DiagramEventBroker diagramEventBroker, EObject view, NotificationListener notificationListener) {
        if (this.manager != null) {
            return this.manager;
        }
        this.manager = new ProviderNotificationManager(diagramEventBroker, view, notificationListener){

            @Override
            protected void registerListeners() {
            }
        };
        return this.manager;
    }
}

