/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.gmfdiag.common.helper;

import org.eclipse.emf.common.command.AbstractCommand;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.papyrus.commands.Activator;
import org.eclipse.papyrus.infra.core.resource.ModelSet;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.infra.core.services.ServicesRegistry;
import org.eclipse.papyrus.infra.emf.utils.ServiceUtilsForEObject;
import org.eclipse.papyrus.infra.gmfdiag.common.AbstractPapyrusGmfCreateDiagramCommandHandler;
import org.eclipse.papyrus.infra.gmfdiag.common.utils.DiagramUtils;
import org.eclipse.papyrus.infra.viewpoints.configuration.PapyrusView;
import org.eclipse.papyrus.infra.viewpoints.policy.ViewPrototype;

public class DiagramPrototype
extends ViewPrototype {
    protected final String category;
    protected final AbstractPapyrusGmfCreateDiagramCommandHandler command;

    public DiagramPrototype(PapyrusView configuration, String category, AbstractPapyrusGmfCreateDiagramCommandHandler command) {
        super(configuration);
        this.category = category;
        this.command = command;
    }

    public boolean instantiateOn(EObject owner) {
        return this.instantiateOn(owner, null);
    }

    public boolean instantiateOn(EObject owner, String name) {
        ModelSet modelSet;
        ServicesRegistry registry;
        try {
            registry = ServiceUtilsForEObject.getInstance().getServiceRegistry(owner);
        }
        catch (ServiceException ex) {
            Activator.log.error((Throwable)ex);
            return false;
        }
        try {
            modelSet = (ModelSet)registry.getService(ModelSet.class);
        }
        catch (ServiceException ex) {
            Activator.log.error((Throwable)ex);
            return false;
        }
        Diagram result = this.command.createDiagram(modelSet, owner, owner, this, name);
        return result != null;
    }

    public boolean isOwnerReassignable() {
        return true;
    }

    public Command getCommandChangeOwner(EObject view, final EObject target) {
        final Diagram diagram = (Diagram)view;
        final EObject previous = DiagramUtils.getOwner(diagram);
        return new AbstractCommand("Change diagram owner"){

            public void execute() {
                DiagramUtils.setOwner(diagram, target);
            }

            public void redo() {
                DiagramUtils.setOwner(diagram, previous);
            }

            protected boolean prepare() {
                return true;
            }
        };
    }

    public Command getCommandChangeRoot(EObject view, final EObject target) {
        final Diagram diagram = (Diagram)view;
        final EObject previous = diagram.getElement();
        return new AbstractCommand("Change diagram root element"){

            public void execute() {
                diagram.setElement(target);
            }

            public void redo() {
                diagram.setElement(previous);
            }

            protected boolean prepare() {
                return true;
            }
        };
    }

    public EObject getOwnerOf(EObject view) {
        return DiagramUtils.getOwner((Diagram)view);
    }

    public EObject getRootOf(EObject view) {
        return ((Diagram)view).getElement();
    }
}

