/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.gmfdiag.common.editpolicies;

import org.eclipse.core.databinding.observable.ChangeEvent;
import org.eclipse.core.databinding.observable.IChangeListener;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.IFigure;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gef.EditPart;
import org.eclipse.gmf.runtime.diagram.core.listener.DiagramEventBroker;
import org.eclipse.gmf.runtime.diagram.core.listener.NotificationListener;
import org.eclipse.gmf.runtime.diagram.ui.editparts.GraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.gef.ui.internal.editpolicies.GraphicalEditPolicyEx;
import org.eclipse.gmf.runtime.notation.BooleanValueStyle;
import org.eclipse.gmf.runtime.notation.NotationPackage;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.infra.emf.utils.EMFHelper;
import org.eclipse.papyrus.infra.gmfdiag.common.databinding.custom.CustomBooleanStyleObservableValue;
import org.eclipse.papyrus.infra.gmfdiag.common.editpart.IPapyrusEditPart;

public class BorderDisplayEditPolicy
extends GraphicalEditPolicyEx
implements IChangeListener,
NotificationListener {
    public static final String DISPLAY_BORDER = "displayBorder";
    public static final String BORDER_DISPLAY_EDITPOLICY = "BORDER_DISPLAY_EDITPOLICY";
    protected IObservableValue styleObservable;
    protected Border defaultBorder;

    public void activate() {
        View view = (View)this.getHost().getModel();
        if (view == null) {
            return;
        }
        this.styleObservable = new CustomBooleanStyleObservableValue(view, EMFHelper.resolveEditingDomain((EObject)view), DISPLAY_BORDER);
        this.styleObservable.addChangeListener((IChangeListener)this);
        this.getDiagramEventBroker().addNotificationListener((EObject)view, (NotificationListener)this);
        EObject semanticElement = EMFHelper.getEObject((Object)this.getHost());
        if (semanticElement != null) {
            this.getDiagramEventBroker().addNotificationListener(semanticElement, (NotificationListener)this);
        }
        this.refreshBorderDisplay();
    }

    protected DiagramEventBroker getDiagramEventBroker() {
        TransactionalEditingDomain theEditingDomain = ((IGraphicalEditPart)this.getHost()).getEditingDomain();
        if (theEditingDomain != null) {
            return DiagramEventBroker.getInstance((TransactionalEditingDomain)theEditingDomain);
        }
        return null;
    }

    protected BooleanValueStyle getMaintainSymbolRatioStyle(View currentView) {
        return (BooleanValueStyle)currentView.getNamedStyle(NotationPackage.eINSTANCE.getBooleanValueStyle(), DISPLAY_BORDER);
    }

    public void deactivate() {
        if (this.styleObservable != null) {
            this.styleObservable.removeChangeListener((IChangeListener)this);
            this.styleObservable.dispose();
            this.styleObservable = null;
        }
    }

    public void notifyChanged(Notification notification) {
        this.refreshBorderDisplay();
    }

    public void handleChange(ChangeEvent event) {
        this.getHost().refresh();
    }

    public void refresh() {
        this.refreshBorderDisplay();
    }

    protected IFigure getPrimaryShape() {
        EditPart host = this.getHost();
        if (host instanceof IPapyrusEditPart) {
            IPapyrusEditPart graphicalHost = (IPapyrusEditPart)host;
            return graphicalHost.getPrimaryShape();
        }
        return this.getHostFigure();
    }

    protected View getNotationView() {
        EditPart host = this.getHost();
        if (host instanceof GraphicalEditPart) {
            return ((GraphicalEditPart)host).getNotationView();
        }
        View view = (View)host.getAdapter(View.class);
        return view;
    }

    protected void refreshBorderDisplay() {
        View view = this.getNotationView();
        if (view == null) {
            return;
        }
        BooleanValueStyle displayBorderStyle = this.findDisplayBorderStyle(view);
        if (displayBorderStyle != null && !displayBorderStyle.isBooleanValue()) {
            if (this.defaultBorder == null) {
                this.defaultBorder = this.getPrimaryShape().getBorder();
            }
            this.getPrimaryShape().setBorder(null);
        } else {
            if (this.defaultBorder != null) {
                this.getPrimaryShape().setBorder(this.defaultBorder);
            }
            this.defaultBorder = null;
        }
    }

    private BooleanValueStyle findDisplayBorderStyle(View view) {
        View parentView = view;
        while (parentView.getElement() == view.getElement()) {
            BooleanValueStyle style = (BooleanValueStyle)parentView.getNamedStyle(NotationPackage.eINSTANCE.getBooleanValueStyle(), DISPLAY_BORDER);
            if (style != null) {
                return style;
            }
            if (!(parentView.eContainer() instanceof View)) break;
            parentView = (View)parentView.eContainer();
        }
        return null;
    }
}

