/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.gmfdiag.common;

import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.transaction.RollbackException;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gef.DefaultEditDomain;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.gef.commands.CommandStack;
import org.eclipse.gmf.runtime.common.core.command.CompositeCommand;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.diagram.core.preferences.PreferencesHint;
import org.eclipse.gmf.runtime.diagram.ui.editparts.DiagramEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IPrimaryEditPart;
import org.eclipse.gmf.runtime.diagram.ui.parts.DiagramEditDomain;
import org.eclipse.gmf.runtime.diagram.ui.parts.DiagramGraphicalViewer;
import org.eclipse.gmf.runtime.diagram.ui.resources.editor.parts.DiagramDocumentEditor;
import org.eclipse.gmf.runtime.draw2d.ui.figures.FigureUtilities;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.jface.preference.PreferenceStore;
import org.eclipse.papyrus.commands.CheckedDiagramCommandStack;
import org.eclipse.papyrus.infra.gmfdiag.common.Activator;
import org.eclipse.papyrus.infra.gmfdiag.common.SemanticFromGMFElement;
import org.eclipse.papyrus.infra.gmfdiag.common.preferences.PreferencesConstantsHelper;
import org.eclipse.papyrus.infra.gmfdiag.common.reconciler.DiagramReconciler;
import org.eclipse.papyrus.infra.gmfdiag.common.reconciler.DiagramReconcilersReader;
import org.eclipse.papyrus.infra.gmfdiag.common.reconciler.DiagramVersioningUtils;
import org.eclipse.papyrus.infra.gmfdiag.common.utils.GMFUnsafe;
import org.eclipse.papyrus.infra.tools.util.EclipseCommandUtils;
import org.eclipse.papyrus.infra.widgets.util.IRevealSemanticElement;
import org.eclipse.papyrus.infra.widgets.util.NavigationTarget;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.commands.ICommandService;

public class SynchronizableGmfDiagramEditor
extends DiagramDocumentEditor
implements IRevealSemanticElement,
NavigationTarget {
    public SynchronizableGmfDiagramEditor(boolean hasFlyoutPalette) {
        super(hasFlyoutPalette);
    }

    public void revealSemanticElement(List<?> elementList) {
        this.revealElement(elementList);
    }

    public boolean revealElement(Object element) {
        return this.revealElement(Collections.singleton(element));
    }

    public boolean revealElement(Collection<?> elementList) {
        SemanticFromGMFElement semanticFromGMFElement = new SemanticFromGMFElement();
        GraphicalViewer graphicalViewer = this.getGraphicalViewer();
        if (graphicalViewer != null) {
            Iterator iter = graphicalViewer.getEditPartRegistry().values().iterator();
            IGraphicalEditPart researchedEditPart = null;
            while (iter.hasNext() && researchedEditPart == null) {
                Object currentEditPart = iter.next();
                if (!(currentEditPart instanceof IPrimaryEditPart) || !elementList.contains(semanticFromGMFElement.getSemanticElement(currentEditPart))) continue;
                researchedEditPart = (IGraphicalEditPart)currentEditPart;
                break;
            }
            if (researchedEditPart == null) {
                for (Object element : elementList) {
                    if (!graphicalViewer.getEditPartRegistry().containsKey(element)) continue;
                    researchedEditPart = (IGraphicalEditPart)graphicalViewer.getEditPartRegistry().get(element);
                    break;
                }
            }
            if (researchedEditPart != null) {
                graphicalViewer.select(researchedEditPart);
                graphicalViewer.reveal(researchedEditPart);
                return true;
            }
        }
        return false;
    }

    public Object getAdapter(Class type) {
        if (type == DiagramEditPart.class) {
            return this.getDiagramEditPart();
        }
        if (type == Diagram.class) {
            return this.getDiagram();
        }
        return super.getAdapter(type);
    }

    protected void configureDiagramEditDomain() {
        DefaultEditDomain editDomain = this.getEditDomain();
        if (editDomain != null) {
            CommandStack stack = editDomain.getCommandStack();
            if (stack != null) {
                stack.dispose();
            }
            CheckedDiagramCommandStack diagramStack = new CheckedDiagramCommandStack(this.getDiagramEditDomain());
            editDomain.setCommandStack((CommandStack)diagramStack);
        }
        DiagramEditDomain diagEditDomain = (DiagramEditDomain)this.getDiagramEditDomain();
        diagEditDomain.setActionManager(this.createActionManager());
    }

    public void setFocus() {
        super.setFocus();
        this.updateToggleActionState();
    }

    protected void updateToggleActionState() {
        ICommandService commandService = (ICommandService)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getService(ICommandService.class);
        if (commandService == null) {
            throw new RuntimeException(String.format("The Eclipse service %s has not been found", ICommandService.class));
        }
        IPreferenceStore wsPreferenceStore = ((DiagramGraphicalViewer)this.getDiagramGraphicalViewer()).getWorkspaceViewerPreferenceStore();
        Command command = commandService.getCommand("org.eclipse.papyrus.infra.gmfdiag.menu.ViewGridCommand");
        EclipseCommandUtils.updateToggleCommandState((Command)command, (boolean)wsPreferenceStore.getBoolean("rulergrid.viewgrid"));
        command = commandService.getCommand("org.eclipse.papyrus.infra.gmfdiag.menu.ViewRulersCommand");
        EclipseCommandUtils.updateToggleCommandState((Command)command, (boolean)wsPreferenceStore.getBoolean("rulergrid.viewrulers"));
        command = commandService.getCommand("org.eclipse.papyrus.infra.gmfdiag.menu.ViewPageBreaksCommand");
        EclipseCommandUtils.updateToggleCommandState((Command)command, (boolean)wsPreferenceStore.getBoolean("viewpagebreaks"));
        command = commandService.getCommand("org.eclipse.papyrus.infra.gmfdiag.menu.SnapToGridCommand");
        EclipseCommandUtils.updateToggleCommandState((Command)command, (boolean)wsPreferenceStore.getBoolean("rulergrid.snaptogrid"));
    }

    protected void addDefaultPreferences() {
        super.addDefaultPreferences();
        PreferencesHint preferencesHint = this.getPreferencesHint();
        IPreferenceStore globalPreferenceStore = (IPreferenceStore)preferencesHint.getPreferenceStore();
        String diagramType = this.getDiagram().getType();
        boolean viewGrid = globalPreferenceStore.getBoolean(PreferencesConstantsHelper.getDiagramConstant(diagramType, 24));
        boolean viewRuler = globalPreferenceStore.getBoolean(PreferencesConstantsHelper.getDiagramConstant(diagramType, 23));
        int rulerUnit = globalPreferenceStore.getInt(PreferencesConstantsHelper.getDiagramConstant(diagramType, 25));
        boolean snapToGrid = globalPreferenceStore.getBoolean(PreferencesConstantsHelper.getDiagramConstant(diagramType, 26));
        boolean snapToGeometry = globalPreferenceStore.getBoolean(PreferencesConstantsHelper.getDiagramConstant(diagramType, 27));
        RGB rgb = PreferenceConverter.getColor((IPreferenceStore)globalPreferenceStore, (String)PreferencesConstantsHelper.getDiagramConstant(diagramType, 28));
        int gridLineColor = FigureUtilities.RGBToInteger((RGB)rgb);
        double gridSpacing = globalPreferenceStore.getDouble(PreferencesConstantsHelper.getDiagramConstant(diagramType, 29));
        boolean gridOrder = globalPreferenceStore.getBoolean(PreferencesConstantsHelper.getDiagramConstant(diagramType, 30));
        int gridLineStyle = globalPreferenceStore.getInt(PreferencesConstantsHelper.getDiagramConstant(diagramType, 31));
        PreferenceStore localStore = this.getWorkspaceViewerPreferenceStore();
        localStore.setValue("rulergrid.viewgrid", viewGrid);
        localStore.setValue("rulergrid.viewrulers", viewRuler);
        localStore.setValue("rulergrid.rulerunit", rulerUnit);
        localStore.setValue("rulergrid.snaptogrid", snapToGrid);
        localStore.setValue("rulergrid.snaptogeometry", snapToGeometry);
        localStore.setValue("rulergrid.gridlinecolor", gridLineColor);
        localStore.setValue("rulergrid.gridspacing", gridSpacing);
        localStore.setValue("rulergrid.gridlevel", !gridOrder);
        localStore.setValue("rulergrid.gridlevel", gridOrder);
        localStore.setValue("rulergrid.gridlinestyle", gridLineStyle);
    }

    protected static class ReconcileHelper {
        private final TransactionalEditingDomain domain;

        public ReconcileHelper(TransactionalEditingDomain domain) {
            this.domain = domain;
        }

        public void reconcileDiagram(Diagram diagram) throws CoreException {
            CompositeCommand migration = this.buildReconcileCommand(diagram);
            if (migration == null) {
                return;
            }
            migration.add((IUndoableOperation)DiagramVersioningUtils.createStampCurrentVersionCommand(diagram));
            try {
                GMFUnsafe.write(this.domain, (ICommand)migration);
            }
            catch (ExecutionException e) {
                this.handleReconcileException(diagram, (Exception)((Object)e));
            }
            catch (InterruptedException e) {
                this.handleReconcileException(diagram, e);
            }
            catch (RollbackException e) {
                this.handleReconcileException(diagram, (Exception)((Object)e));
            }
        }

        protected CompositeCommand buildReconcileCommand(Diagram diagram) {
            String diagramType;
            if (DiagramVersioningUtils.isOfCurrentPapyrusVersion(diagram)) {
                return null;
            }
            String sourceVersion = DiagramVersioningUtils.getCompatibilityVersion((View)diagram);
            Map<String, Collection<DiagramReconciler>> diagramReconcilers = DiagramReconcilersReader.getInstance().load();
            if (!diagramReconcilers.containsKey(diagramType = diagram.getType())) {
                return null;
            }
            Collection<DiagramReconciler> reconcilers = diagramReconcilers.get(diagram.getType());
            boolean someFailed = false;
            CompositeCommand whole = new CompositeCommand("Reconciling");
            for (DiagramReconciler next : reconcilers) {
                ICommand nextCommand;
                if (!next.canReconcileFrom(diagram, sourceVersion) || (nextCommand = next.getReconcileCommand(diagram)) == null) continue;
                if (nextCommand.canExecute()) {
                    whole.add((IUndoableOperation)nextCommand);
                    continue;
                }
                Activator.log.error("Diagram reconciler " + next + " failed to reconcile diagram : " + diagram, null);
                someFailed = true;
            }
            if (someFailed) {
                return null;
            }
            return whole;
        }

        protected void handleReconcileException(Diagram diagram, Exception e) throws CoreException {
            Activator.getInstance().logError("Reconciling the diagram: " + diagram, e);
        }
    }
}

