/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.common.groups.core.ui;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gef.EditPart;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.papyrus.commands.wrappers.GMFtoEMFCommandWrapper;
import org.eclipse.papyrus.infra.widgets.toolbox.notification.builders.IContext;
import org.eclipse.papyrus.uml.diagram.common.groups.Messages;
import org.eclipse.papyrus.uml.diagram.common.groups.commands.ChangeGraphicalParentCommand;
import org.eclipse.papyrus.uml.diagram.common.groups.core.PendingGroupNotificationsManager;
import org.eclipse.papyrus.uml.diagram.common.groups.core.ui.NotificationConfigurator;
import org.eclipse.papyrus.uml.diagram.common.groups.core.ui.utils.CreatorUtils;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.forms.widgets.FormText;
import org.eclipse.ui.forms.widgets.FormToolkit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ChooseChildrenNotificationConfigurator
extends NotificationConfigurator {
    private IGraphicalEditPart parentEditPart;
    protected List<IGraphicalEditPart> allChildren;
    protected List<IGraphicalEditPart> automaticChildren;
    private Map<Button, IGraphicalEditPart> childCheckBoxes;
    protected IGraphicalEditPart host;

    public ChooseChildrenNotificationConfigurator(IGraphicalEditPart parentEditPart, List<IGraphicalEditPart> allChildren, List<IGraphicalEditPart> automaticChildren, IGraphicalEditPart host, PendingGroupNotificationsManager manager) {
        super(parentEditPart, manager, Messages.ChooseChildrenICompositeCreator_ChooseChildren, NotificationConfigurator.Mode.QUESTION_MODE);
        this.parentEditPart = parentEditPart;
        this.allChildren = allChildren;
        this.automaticChildren = automaticChildren;
        this.host = host;
        this.childCheckBoxes = new HashMap<Button, IGraphicalEditPart>();
    }

    public void run(IContext context) {
        TransactionalEditingDomain editingDomain = this.mainEditPart.getEditingDomain();
        HashSet<IGraphicalEditPart> childrenUpdated = new HashSet<IGraphicalEditPart>();
        for (Button checkBoxButton : this.childCheckBoxes.keySet()) {
            IGraphicalEditPart childPart;
            if (!checkBoxButton.getSelection() || !checkBoxButton.isEnabled() || childrenUpdated.contains(childPart = this.childCheckBoxes.get(checkBoxButton))) continue;
            this.changeGraphicalParentOf(editingDomain, childPart);
            childrenUpdated.add(childPart);
        }
        this.closeNotitfication(context);
    }

    private void changeGraphicalParentOf(TransactionalEditingDomain editingDomain, IGraphicalEditPart childPart) {
        String label = "Change graphical parent of " + CreatorUtils.getLabel(childPart) + " to " + CreatorUtils.getLabel(this.mainEditPart);
        ChangeGraphicalParentCommand cmd = new ChangeGraphicalParentCommand(editingDomain, label, (EditPart)this.mainEditPart, (EditPart)childPart, this.host);
        if (cmd != null && cmd.canExecute()) {
            editingDomain.getCommandStack().execute((Command)new GMFtoEMFCommandWrapper((ICommand)cmd));
        }
    }

    public Composite createComposite(Composite parent, FormToolkit toolkit) {
        if (toolkit == null) {
            toolkit = new FormToolkit(parent.getDisplay());
        }
        Composite top = toolkit.createComposite(parent, 0);
        top.setLayout((Layout)new FormLayout());
        FormText textLabel = toolkit.createFormText(top, false);
        textLabel.setText(String.valueOf(Messages.ChooseParentNotificationCommand_ChooseGraphicalChildrenMessage) + CreatorUtils.getLabel(this.mainEditPart) + " :", false, true);
        FormData data = new FormData();
        textLabel.setLayoutData((Object)data);
        FormText previousElement = textLabel;
        this.createCheckBoxes(toolkit, top, (Control)previousElement);
        return top;
    }

    private void createCheckBoxes(FormToolkit toolkit, Composite top, Control previousElement) {
        for (final IGraphicalEditPart child : this.allChildren) {
            String label = CreatorUtils.getLabel(child);
            Button checkBox = toolkit.createButton(top, label, 32);
            if (!child.getParent().equals(this.mainEditPart)) {
                if (this.automaticChildren.contains(child)) {
                    checkBox.setSelection(true);
                    checkBox.setEnabled(false);
                } else {
                    checkBox.setSelection(false);
                }
                FormData data = CreatorUtils.getFormDataUnder(previousElement);
                checkBox.setLayoutData((Object)data);
                previousElement = checkBox;
                this.childCheckBoxes.put(checkBox, child);
            }
            checkBox.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent e) {
                    ChooseChildrenNotificationConfigurator.this.childCheckBoxes.remove(e.widget);
                }
            });
            checkBox.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    Widget check = e.widget;
                    if (check instanceof Button) {
                        boolean selection = ((Button)check).getSelection();
                        for (Button b : this.getAllButtonFor(child)) {
                            b.setSelection(selection);
                        }
                    }
                }

                private List<Button> getAllButtonFor(IGraphicalEditPart child2) {
                    ArrayList<Button> result = new ArrayList<Button>();
                    for (Button childButton : ChooseChildrenNotificationConfigurator.this.childCheckBoxes.keySet()) {
                        IGraphicalEditPart childEdipart = (IGraphicalEditPart)ChooseChildrenNotificationConfigurator.this.childCheckBoxes.get(childButton);
                        if (!childEdipart.equals(child2)) continue;
                        result.add(childButton);
                    }
                    return result;
                }
            });
        }
    }

    public boolean isThereAnyModification(IGraphicalEditPart _parentEditPart, List<IGraphicalEditPart> _allChildren, List<IGraphicalEditPart> _automaticChildren, IGraphicalEditPart _host) {
        boolean sameParentEditPart = this.mainEditPart.equals(_parentEditPart);
        boolean sameHost = this.host.equals(_host);
        boolean sameAllChildren = this.containsSameElements(this.allChildren, _allChildren);
        boolean sameAutomaticChildren = this.containsSameElements(this.automaticChildren, _automaticChildren);
        return !sameParentEditPart || !sameHost || !sameAllChildren || !sameAutomaticChildren;
    }

    private boolean containsSameElements(List<IGraphicalEditPart> list1, List<IGraphicalEditPart> list2) {
        return list1.containsAll(list2) && list2.containsAll(list1);
    }

    @Override
    protected void closeNotitfication(IContext context) {
        this.papyrusNotificationView.dispose();
        this.notification.delete();
        this.manager.removeChooseChildrenNotification(this.mainEditPart);
    }
}

