/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.xtext.base.cs2as;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.ocl.examples.domain.elements.DomainType;
import org.eclipse.ocl.examples.domain.types.AbstractTuplePart;
import org.eclipse.ocl.examples.domain.utilities.DomainUtil;
import org.eclipse.ocl.examples.pivot.AnyType;
import org.eclipse.ocl.examples.pivot.Class;
import org.eclipse.ocl.examples.pivot.DataType;
import org.eclipse.ocl.examples.pivot.Element;
import org.eclipse.ocl.examples.pivot.Enumeration;
import org.eclipse.ocl.examples.pivot.LambdaType;
import org.eclipse.ocl.examples.pivot.NamedElement;
import org.eclipse.ocl.examples.pivot.Parameter;
import org.eclipse.ocl.examples.pivot.PivotPackage;
import org.eclipse.ocl.examples.pivot.Property;
import org.eclipse.ocl.examples.pivot.TemplateableElement;
import org.eclipse.ocl.examples.pivot.TupleType;
import org.eclipse.ocl.examples.pivot.Type;
import org.eclipse.ocl.examples.pivot.TypedMultiplicityElement;
import org.eclipse.ocl.examples.pivot.util.Pivotable;
import org.eclipse.ocl.examples.pivot.utilities.PivotUtil;
import org.eclipse.ocl.examples.xtext.base.basecs.AnnotationCS;
import org.eclipse.ocl.examples.xtext.base.basecs.ClassCS;
import org.eclipse.ocl.examples.xtext.base.basecs.ClassifierCS;
import org.eclipse.ocl.examples.xtext.base.basecs.ConstraintCS;
import org.eclipse.ocl.examples.xtext.base.basecs.DataTypeCS;
import org.eclipse.ocl.examples.xtext.base.basecs.DocumentationCS;
import org.eclipse.ocl.examples.xtext.base.basecs.ElementCS;
import org.eclipse.ocl.examples.xtext.base.basecs.EnumerationCS;
import org.eclipse.ocl.examples.xtext.base.basecs.EnumerationLiteralCS;
import org.eclipse.ocl.examples.xtext.base.basecs.LambdaTypeCS;
import org.eclipse.ocl.examples.xtext.base.basecs.ModelElementCS;
import org.eclipse.ocl.examples.xtext.base.basecs.ModelElementRefCS;
import org.eclipse.ocl.examples.xtext.base.basecs.MultiplicityBoundsCS;
import org.eclipse.ocl.examples.xtext.base.basecs.MultiplicityStringCS;
import org.eclipse.ocl.examples.xtext.base.basecs.OperationCS;
import org.eclipse.ocl.examples.xtext.base.basecs.PackageCS;
import org.eclipse.ocl.examples.xtext.base.basecs.PackageOwnerCS;
import org.eclipse.ocl.examples.xtext.base.basecs.ParameterCS;
import org.eclipse.ocl.examples.xtext.base.basecs.PathElementCS;
import org.eclipse.ocl.examples.xtext.base.basecs.PathNameCS;
import org.eclipse.ocl.examples.xtext.base.basecs.PivotableElementCS;
import org.eclipse.ocl.examples.xtext.base.basecs.PrimitiveTypeRefCS;
import org.eclipse.ocl.examples.xtext.base.basecs.StructuralFeatureCS;
import org.eclipse.ocl.examples.xtext.base.basecs.TemplateBindingCS;
import org.eclipse.ocl.examples.xtext.base.basecs.TemplateParameterSubstitutionCS;
import org.eclipse.ocl.examples.xtext.base.basecs.TemplateSignatureCS;
import org.eclipse.ocl.examples.xtext.base.basecs.TemplateableElementCS;
import org.eclipse.ocl.examples.xtext.base.basecs.TuplePartCS;
import org.eclipse.ocl.examples.xtext.base.basecs.TupleTypeCS;
import org.eclipse.ocl.examples.xtext.base.basecs.TypeRefCS;
import org.eclipse.ocl.examples.xtext.base.basecs.TypedElementCS;
import org.eclipse.ocl.examples.xtext.base.basecs.TypedRefCS;
import org.eclipse.ocl.examples.xtext.base.basecs.TypedTypeRefCS;
import org.eclipse.ocl.examples.xtext.base.basecs.WildcardTypeRefCS;
import org.eclipse.ocl.examples.xtext.base.basecs.util.AbstractExtendingBaseCSVisitor;
import org.eclipse.ocl.examples.xtext.base.basecs.util.VisitableCS;
import org.eclipse.ocl.examples.xtext.base.cs2as.BasicContinuation;
import org.eclipse.ocl.examples.xtext.base.cs2as.CS2PivotConversion;
import org.eclipse.ocl.examples.xtext.base.cs2as.Continuation;
import org.eclipse.ocl.examples.xtext.base.cs2as.Continuations;
import org.eclipse.ocl.examples.xtext.base.cs2as.Dependency;
import org.eclipse.ocl.examples.xtext.base.cs2as.PivotDependency;
import org.eclipse.ocl.examples.xtext.base.cs2as.PivotHasSuperClassesDependency;
import org.eclipse.ocl.examples.xtext.base.cs2as.SingleContinuation;
import org.eclipse.ocl.examples.xtext.base.utilities.ElementUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BaseCSPreOrderVisitor
extends AbstractExtendingBaseCSVisitor<Continuation<?>, CS2PivotConversion> {
    public BaseCSPreOrderVisitor(@NonNull CS2PivotConversion context) {
        super(context);
    }

    @Override
    public Continuation<?> visiting(@NonNull VisitableCS visitable) {
        throw new IllegalArgumentException("Unsupported " + visitable.eClass().getName() + " for CS2Pivot PreOrder pass");
    }

    @Override
    public Continuation<?> visitAnnotationCS(@NonNull AnnotationCS object) {
        return null;
    }

    @Override
    public Continuation<?> visitClassCS(@NonNull ClassCS csClass) {
        Class pivotElement = (Class)PivotUtil.getPivot(Class.class, (Pivotable)csClass);
        if (pivotElement == null) {
            return null;
        }
        Continuations continuations = new Continuations();
        if (csClass.getOwnedTemplateSignature() != null) {
            continuations.add(new TemplateSignatureContinuation((CS2PivotConversion)((Object)this.context), (NamedElement)pivotElement, csClass));
        } else {
            pivotElement.setOwnedTemplateSignature(null);
        }
        if (!(pivotElement instanceof AnyType)) {
            continuations.add(new ClassSupersContinuation((CS2PivotConversion)((Object)this.context), pivotElement, csClass));
        }
        return continuations.getContinuation();
    }

    @Override
    public Continuation<?> visitConstraintCS(@NonNull ConstraintCS csConstraint) {
        return null;
    }

    @Override
    public Continuation<?> visitDataTypeCS(@NonNull DataTypeCS csDataType) {
        DataType pivotElement = (DataType)PivotUtil.getPivot(DataType.class, (Pivotable)csDataType);
        if (pivotElement != null) {
            List pivotSuperClasses = pivotElement.getSuperClass();
            pivotSuperClasses.clear();
            Class oclElementType = ((CS2PivotConversion)((Object)this.context)).getMetaModelManager().getOclElementType();
            pivotSuperClasses.add(oclElementType);
        }
        return null;
    }

    @Override
    public Continuation<?> visitDocumentationCS(@NonNull DocumentationCS object) {
        return null;
    }

    @Override
    public Continuation<?> visitEnumerationCS(@NonNull EnumerationCS csEnumeration) {
        Enumeration pivotElement = (Enumeration)PivotUtil.getPivot(Enumeration.class, (Pivotable)csEnumeration);
        if (pivotElement != null) {
            List pivotSuperClasses = pivotElement.getSuperClass();
            pivotSuperClasses.clear();
            Class oclElementType = ((CS2PivotConversion)((Object)this.context)).getMetaModelManager().getOclElementType();
            pivotSuperClasses.add(oclElementType);
        }
        return null;
    }

    @Override
    public Continuation<?> visitEnumerationLiteralCS(@NonNull EnumerationLiteralCS csEnumerationLiteral) {
        return null;
    }

    @Override
    public Continuation<?> visitLambdaTypeCS(@NonNull LambdaTypeCS csLambdaType) {
        return new LambdaContinuation((CS2PivotConversion)((Object)this.context), csLambdaType);
    }

    @Override
    public Continuation<?> visitModelElementCS(@NonNull ModelElementCS csModelElement) {
        return null;
    }

    @Override
    public Continuation<?> visitModelElementRefCS(@NonNull ModelElementRefCS csModelElementRef) {
        return null;
    }

    @Override
    public Continuation<?> visitMultiplicityBoundsCS(@NonNull MultiplicityBoundsCS object) {
        return null;
    }

    @Override
    public Continuation<?> visitMultiplicityStringCS(@NonNull MultiplicityStringCS object) {
        return null;
    }

    @Override
    public Continuation<?> visitOperationCS(@NonNull OperationCS csOperation) {
        return null;
    }

    @Override
    public Continuation<?> visitPackageCS(@NonNull PackageCS csPackage) {
        return null;
    }

    @Override
    public Continuation<?> visitPackageOwnerCS(@NonNull PackageOwnerCS object) {
        return null;
    }

    @Override
    public Continuation<?> visitParameterCS(@NonNull ParameterCS csParameter) {
        return new ParameterContinuation((CS2PivotConversion)((Object)this.context), csParameter);
    }

    @Override
    public Continuation<?> visitPathElementCS(@NonNull PathElementCS csElement) {
        return null;
    }

    @Override
    public Continuation<?> visitPathNameCS(@NonNull PathNameCS csElement) {
        return null;
    }

    @Override
    public Continuation<?> visitPrimitiveTypeRefCS(@NonNull PrimitiveTypeRefCS csPrimitiveTypeRef) {
        return new PrimitiveTypeRefContinuation((CS2PivotConversion)((Object)this.context), csPrimitiveTypeRef);
    }

    @Override
    public Continuation<?> visitStructuralFeatureCS(@NonNull StructuralFeatureCS csStructuralFeature) {
        return null;
    }

    @Override
    public Continuation<?> visitTemplateBindingCS(@NonNull TemplateBindingCS csTemplateBinding) {
        return null;
    }

    @Override
    public Continuation<?> visitTemplateSignatureCS(@NonNull TemplateSignatureCS csTemplateSignature) {
        return null;
    }

    @Override
    public Continuation<?> visitTupleTypeCS(@NonNull TupleTypeCS csTupleType) {
        return new TupleContinuation((CS2PivotConversion)((Object)this.context), csTupleType);
    }

    @Override
    public Continuation<?> visitTypedTypeRefCS(@NonNull TypedTypeRefCS csTypedTypeRef) {
        if (csTypedTypeRef.getOwnedTemplateBinding() == null) {
            return new UnspecializedTypeRefContinuation((CS2PivotConversion)((Object)this.context), csTypedTypeRef);
        }
        return new SpecializedTypeRefContinuation1((CS2PivotConversion)((Object)this.context), csTypedTypeRef);
    }

    @Override
    public Continuation<?> visitWildcardTypeRefCS(@NonNull WildcardTypeRefCS csWildcardTypeRef) {
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class ClassSupersContinuation
    extends SingleContinuation<ClassCS> {
        private static Dependency[] computeDependencies(@NonNull CS2PivotConversion context, @NonNull ClassCS csElement) {
            EList<TypedRefCS> csSuperTypes = csElement.getOwnedSuperType();
            if (csSuperTypes.isEmpty()) {
                return null;
            }
            ArrayList<PivotDependency> dependencies = new ArrayList<PivotDependency>();
            for (TypedRefCS csSuperType : csSuperTypes) {
                dependencies.add(new PivotDependency(csSuperType));
            }
            return dependencies.toArray(new Dependency[dependencies.size()]);
        }

        public ClassSupersContinuation(@NonNull CS2PivotConversion context, Class pivotParent, @NonNull ClassCS csElement) {
            super(context, (Element)pivotParent, null, csElement, ClassSupersContinuation.computeDependencies(context, csElement));
        }

        @Override
        public BasicContinuation<?> execute() {
            Class pivotElement = (Class)PivotUtil.getPivot(Class.class, (Pivotable)((Pivotable)this.csElement));
            if (pivotElement != null) {
                List superClasses = pivotElement.getSuperClass();
                this.context.refreshList(Type.class, superClasses, (List<? extends PivotableElementCS>)((ClassCS)this.csElement).getOwnedSuperType());
                if (superClasses.isEmpty()) {
                    Class oclElementType = this.context.getMetaModelManager().getOclElementType();
                    pivotElement.getSuperClass().add(oclElementType);
                }
            }
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class LambdaContinuation
    extends SingleContinuation<LambdaTypeCS> {
        private static Dependency[] computeDependencies(@NonNull CS2PivotConversion context, @NonNull LambdaTypeCS csElement) {
            TypedRefCS ownedContextType = (TypedRefCS)DomainUtil.nonNullState((Object)csElement.getOwnedContextType());
            TypedRefCS ownedResultType = (TypedRefCS)DomainUtil.nonNullState((Object)csElement.getOwnedResultType());
            EList<TypedRefCS> csParameterTypes = csElement.getOwnedParameterType();
            int iMax = csParameterTypes.size();
            Dependency[] dependencies = new Dependency[2 + iMax];
            dependencies[0] = context.createTypeIsReferenceableDependency(ownedContextType);
            dependencies[1] = context.createTypeIsReferenceableDependency(ownedResultType);
            int i = 0;
            while (i < iMax) {
                TypedRefCS csParameterType = (TypedRefCS)DomainUtil.nonNullState((Object)((TypedRefCS)csParameterTypes.get(i)));
                dependencies[i + 2] = context.createTypeIsReferenceableDependency(csParameterType);
                ++i;
            }
            return dependencies;
        }

        public LambdaContinuation(@NonNull CS2PivotConversion context, @NonNull LambdaTypeCS csElement) {
            super(context, null, null, csElement, LambdaContinuation.computeDependencies(context, csElement));
        }

        @Override
        public BasicContinuation<?> execute() {
            Type contextType = (Type)PivotUtil.getPivot(Type.class, (Pivotable)((LambdaTypeCS)this.csElement).getOwnedContextType());
            Type resultType = (Type)PivotUtil.getPivot(Type.class, (Pivotable)((LambdaTypeCS)this.csElement).getOwnedResultType());
            String name = ((LambdaTypeCS)this.csElement).getName();
            if (contextType != null && resultType != null && name != null) {
                ArrayList<Type> parameterTypes = new ArrayList<Type>();
                for (TypedRefCS csParameterType : ((LambdaTypeCS)this.csElement).getOwnedParameterType()) {
                    Type parameterType = (Type)PivotUtil.getPivot(Type.class, (Pivotable)csParameterType);
                    parameterTypes.add(parameterType);
                }
                LambdaType lambdaType = this.context.getMetaModelManager().getLambdaType(name, contextType, parameterTypes, resultType, null);
                this.context.installPivotTypeWithMultiplicity((Type)lambdaType, (TypedRefCS)this.csElement);
            }
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class ParameterContinuation
    extends SingleContinuation<ParameterCS> {
        public ParameterContinuation(@NonNull CS2PivotConversion context, @NonNull ParameterCS csElement) {
            super(context, null, null, csElement, new Dependency[0]);
        }

        @Override
        public boolean canExecute() {
            Element pivot;
            if (!super.canExecute()) {
                return false;
            }
            TypedRefCS ownedType = ((ParameterCS)this.csElement).getOwnedType();
            Element element = pivot = ownedType != null ? ownedType.getPivot() : null;
            return pivot != null;
        }

        @Override
        public BasicContinuation<?> execute() {
            Parameter parameter = (Parameter)PivotUtil.getPivot(Parameter.class, (Pivotable)((Pivotable)this.csElement));
            if (parameter != null) {
                this.context.refreshRequiredType((TypedMultiplicityElement)parameter, (TypedElementCS)this.csElement);
            }
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class PrimitiveTypeRefContinuation
    extends TypedRefContinuation<PrimitiveTypeRefCS> {
        public PrimitiveTypeRefContinuation(@NonNull CS2PivotConversion context, @NonNull PrimitiveTypeRefCS csElement) {
            super(context, csElement, new Dependency[0]);
        }

        @Override
        public BasicContinuation<?> execute() {
            Type pivotType;
            String name = ((PrimitiveTypeRefCS)this.csElement).getName();
            if (name != null && (pivotType = this.context.getMetaModelManager().getLibraryType(name)) != null) {
                this.context.installPivotTypeWithMultiplicity(pivotType, (TypedRefCS)this.csElement);
            }
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class SpecializedTypeRefContinuation1
    extends SingleContinuation<TypedTypeRefCS> {
        public SpecializedTypeRefContinuation1(@NonNull CS2PivotConversion context, @NonNull TypedTypeRefCS csElement) {
            super(context, null, null, csElement, context.getTypesHaveSignaturesInterDependency());
            assert (csElement.getOwnedTemplateBinding() != null);
        }

        @Override
        public BasicContinuation<?> execute() {
            Type pivotType = ((TypedTypeRefCS)this.csElement).getType();
            return new SpecializedTypeRefContinuation2(this.context, (TypedTypeRefCS)this.csElement);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class SpecializedTypeRefContinuation2
    extends TypedRefContinuation<TypedTypeRefCS> {
        private static Dependency[] computeDependencies(@NonNull CS2PivotConversion context, @NonNull TypedTypeRefCS csElement) {
            ArrayList<Dependency> dependencies = new ArrayList<Dependency>();
            TemplateBindingCS csTemplateBinding = csElement.getOwnedTemplateBinding();
            if (csTemplateBinding != null) {
                for (TemplateParameterSubstitutionCS csTemplateParameterSubstitution : csTemplateBinding.getOwnedParameterSubstitution()) {
                    Dependency dependency;
                    TypeRefCS csTemplateParameter = csTemplateParameterSubstitution.getOwnedActualParameter();
                    if (csTemplateParameter == null || (dependency = context.createTypeIsReferenceableDependency(csTemplateParameter)) == null) continue;
                    dependencies.add(dependency);
                }
                for (TemplateParameterSubstitutionCS csTemplateParameterSubstitution : csTemplateBinding.getOwnedParameterSubstitution()) {
                    TypeRefCS csActualParameter = csTemplateParameterSubstitution.getOwnedActualParameter();
                    dependencies.add(new PivotDependency(csActualParameter));
                }
            }
            dependencies.add(new PivotHasSuperClassesDependency(csElement));
            return dependencies.toArray(new Dependency[dependencies.size()]);
        }

        public SpecializedTypeRefContinuation2(@NonNull CS2PivotConversion context, @NonNull TypedTypeRefCS csElement) {
            super(context, csElement, SpecializedTypeRefContinuation2.computeDependencies(context, csElement));
            assert (csElement.getOwnedTemplateBinding() != null);
        }

        @Override
        public boolean canExecute() {
            if (!super.canExecute()) {
                return false;
            }
            if (this.context.isInReturnTypeWithUnresolvedParameters((ElementCS)this.csElement)) {
                return false;
            }
            Type pivotType = ((TypedTypeRefCS)this.csElement).getType();
            if (pivotType != null) {
                if (pivotType.getSuperClass().size() <= 0) {
                    return false;
                }
                TemplateBindingCS csTemplateBinding = ((TypedTypeRefCS)this.csElement).getOwnedTemplateBinding();
                if (csTemplateBinding != null) {
                    for (TemplateParameterSubstitutionCS csTemplateParameterSubstitution : csTemplateBinding.getOwnedParameterSubstitution()) {
                        TypeRefCS ownedActualParameter = csTemplateParameterSubstitution.getOwnedActualParameter();
                        if (ownedActualParameter instanceof WildcardTypeRefCS) {
                            return true;
                        }
                        Type actualParameterClass = (Type)ownedActualParameter.getPivot();
                        if (actualParameterClass != null) continue;
                        return false;
                    }
                }
            }
            return true;
        }

        @Override
        public BasicContinuation<?> execute() {
            Type pivotType = ((TypedTypeRefCS)this.csElement).getType();
            if (pivotType != null) {
                TemplateBindingCS csTemplateBinding = ((TypedTypeRefCS)this.csElement).getOwnedTemplateBinding();
                if (csTemplateBinding != null && ElementUtil.isSpecialization(csTemplateBinding)) {
                    pivotType = (Type)this.context.specializeTemplates((TypedTypeRefCS)this.csElement);
                }
                if (pivotType != null) {
                    this.context.installPivotTypeWithMultiplicity(pivotType, (TypedRefCS)this.csElement);
                }
            }
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class TemplateSignatureContinuation
    extends SingleContinuation<ClassifierCS> {
        public TemplateSignatureContinuation(@NonNull CS2PivotConversion context, NamedElement pivotParent, @NonNull ClassifierCS csElement) {
            super(context, (Element)pivotParent, (EStructuralFeature)PivotPackage.Literals.TEMPLATEABLE_ELEMENT__OWNED_TEMPLATE_SIGNATURE, csElement, new Dependency[0]);
            context.getTypesHaveSignaturesInterDependency().addDependency(this);
        }

        @Override
        public BasicContinuation<?> execute() {
            Type pivotElement = (Type)PivotUtil.getPivot(Type.class, (Pivotable)((Pivotable)this.csElement));
            if (pivotElement != null) {
                this.context.refreshTemplateSignature((TemplateableElementCS)this.csElement, (TemplateableElement)pivotElement);
                this.context.getTypesHaveSignaturesInterDependency().setSatisfied(this);
            }
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class TupleContinuation
    extends TypedRefContinuation<TupleTypeCS> {
        public TupleContinuation(@NonNull CS2PivotConversion context, @NonNull TupleTypeCS csElement) {
            super(context, csElement, new Dependency[0]);
        }

        @Override
        public boolean canExecute() {
            if (!super.canExecute()) {
                return false;
            }
            for (TuplePartCS csTuplePart : ((TupleTypeCS)this.csElement).getOwnedParts()) {
                TypedRefCS ownedType = csTuplePart.getOwnedType();
                Element pivot = ownedType.getPivot();
                if (pivot != null) continue;
                return false;
            }
            return !this.context.isInReturnTypeWithUnresolvedParameters((ElementCS)this.csElement);
        }

        @Override
        public BasicContinuation<?> execute() {
            String name = ((TupleTypeCS)this.csElement).getName();
            if (name != null) {
                ArrayList<AbstractTuplePart> parts = new ArrayList<AbstractTuplePart>();
                for (TuplePartCS csTuplePart : ((TupleTypeCS)this.csElement).getOwnedParts()) {
                    Type partType;
                    String partName = csTuplePart.getName();
                    if (partName == null || (partType = (Type)PivotUtil.getPivot(Type.class, (Pivotable)csTuplePart.getOwnedType())) == null) continue;
                    parts.add(new AbstractTuplePart((DomainType)partType, partName));
                }
                TupleType tupleType = this.context.getMetaModelManager().getTupleType(name, parts, null);
                this.context.installPivotTypeWithMultiplicity((Type)tupleType, (TypedRefCS)this.csElement);
                List tupleParts = tupleType.getOwnedAttribute();
                for (TuplePartCS csTuplePart : ((TupleTypeCS)this.csElement).getOwnedParts()) {
                    String partName = csTuplePart.getName();
                    Property tuplePart = (Property)DomainUtil.getNamedElement((Iterable)tupleParts, (String)partName);
                    if (tuplePart == null) continue;
                    this.context.installPivotUsage(csTuplePart, (Element)tuplePart);
                }
            }
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static abstract class TypedRefContinuation<T extends TypedRefCS>
    extends SingleContinuation<T> {
        public TypedRefContinuation(@NonNull CS2PivotConversion context, @NonNull T csElement, Dependency ... dependencies) {
            super(context, null, null, csElement, new Dependency[0]);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class UnspecializedTypeRefContinuation
    extends TypedRefContinuation<TypedTypeRefCS> {
        public UnspecializedTypeRefContinuation(@NonNull CS2PivotConversion context, @NonNull TypedTypeRefCS csElement) {
            super(context, csElement, context.getTypesHaveSignaturesInterDependency());
            assert (csElement.getOwnedTemplateBinding() == null);
        }

        @Override
        public BasicContinuation<?> execute() {
            Type pivotType = ((TypedTypeRefCS)this.csElement).getType();
            if (pivotType != null) {
                this.context.installPivotTypeWithMultiplicity(pivotType, (TypedRefCS)this.csElement);
            }
            return null;
        }
    }
}

