/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.emf.validation.validity.export;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.examples.emf.validation.validity.export.IValidityExporter;
import org.eclipse.ocl.examples.emf.validation.validity.export.IValidityExporterDescriptor;
import org.eclipse.ocl.examples.emf.validation.validity.plugin.ValidityPlugin;

public class ValidityExporterDescriptor
implements IValidityExporterDescriptor {
    private final IConfigurationElement element;
    @NonNull
    private final String exporterClassAttribute;
    @NonNull
    private final String exporterName;
    @NonNull
    private final String exporterType;
    private IValidityExporter exporter;

    public ValidityExporterDescriptor(IConfigurationElement configuration, @NonNull String exporterClassAttribute, @NonNull String exporterType, @NonNull String exporterName) {
        this.element = configuration;
        this.exporterClassAttribute = exporterClassAttribute;
        this.exporterType = exporterType;
        this.exporterName = exporterName;
    }

    @Override
    @NonNull
    public String getExporterType() {
        return this.exporterType;
    }

    @NonNull
    public String getExporterName() {
        return this.exporterName;
    }

    @Override
    @Nullable
    public IValidityExporter getExporter() {
        if (this.exporter == null) {
            try {
                this.exporter = (IValidityExporter)this.element.createExecutableExtension(this.exporterClassAttribute);
            }
            catch (CoreException e) {
                ValidityPlugin.getPlugin().getLog().log(e.getStatus());
            }
        }
        return this.exporter;
    }
}

