/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.tree.business.internal.dialect.common.tree;

import com.google.common.collect.Lists;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.sirius.ext.base.Option;
import org.eclipse.sirius.ext.base.Options;
import org.eclipse.sirius.synchronizer.ChildCreationSupport;
import org.eclipse.sirius.synchronizer.Mapping;
import org.eclipse.sirius.tree.DTreeItem;
import org.eclipse.sirius.tree.business.internal.dialect.common.tree.AbstractCreatedDTreeItemContainer;
import org.eclipse.sirius.tree.business.internal.dialect.common.tree.OutputTreeItemDescriptor;
import org.eclipse.sirius.tree.business.internal.dialect.common.tree.RTreeItemMapping;
import org.eclipse.sirius.tree.business.internal.dialect.common.tree.TreeItemContainerChildSupport;
import org.eclipse.sirius.tree.business.internal.dialect.common.viewpoint.GlobalContext;
import org.eclipse.sirius.tree.business.internal.refresh.DTreeElementSynchronizerSpec;

class CreatedTreeItem
extends AbstractCreatedDTreeItemContainer {
    private DTreeItem tItem;
    private OutputTreeItemDescriptor descriptor;
    private int newIndex;
    private Option<Mapping> newMapping = Options.newNone();

    public CreatedTreeItem(GlobalContext ctx, DTreeItem tItem, OutputTreeItemDescriptor descriptor) {
        super(ctx);
        this.tItem = tItem;
        this.descriptor = descriptor;
        this.newIndex = descriptor.getIndex();
    }

    public OutputTreeItemDescriptor getDescriptor() {
        return this.descriptor;
    }

    public void setNewIndex(int nextIndex) {
        this.newIndex = nextIndex;
    }

    public int getNewIndex() {
        return this.newIndex;
    }

    public EObject getCreatedElement() {
        return this.tItem;
    }

    public void updateMapping() {
        if (!this.newMapping.some()) {
            throw new RuntimeException("no mapping to set");
        }
        this.tItem.setActualMapping(((RTreeItemMapping)this.newMapping.get()).getDescription());
    }

    public void refresh() {
        DTreeElementSynchronizerSpec sync = new DTreeElementSynchronizerSpec(this.getGlobalContext().getInterpreter(), this.getGlobalContext().getModelAccessor());
        sync.refresh(this.tItem);
    }

    public void setNewMapping(Mapping map) {
        this.newMapping = Options.newSome((Object)map);
    }

    public Option<? extends ChildCreationSupport> getChildSupport() {
        return Options.newSome((Object)new TreeItemContainerChildSupport(this.getGlobalContext(), this.tItem));
    }

    public List<Mapping> getChildMappings() {
        EObject grandpa;
        EObject papa = this.tItem.eContainer();
        if (papa instanceof DTreeItem && (grandpa = papa.eContainer()) instanceof DTreeItem && !((DTreeItem)grandpa).isExpanded()) {
            return Lists.newArrayList();
        }
        return this.getDescriptor().getMapping().getChildMappings();
    }
}

