/*
 * Decompiled with CFR 0.152.
 */
package de.itemis.xtext.utils.gmf.experimental;

import com.google.common.collect.Maps;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EContentAdapter;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gmf.runtime.diagram.ui.resources.editor.parts.DiagramDocumentEditor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.xtext.resource.IResourceDescription;
import org.eclipse.xtext.resource.IResourceServiceProvider;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.ui.editor.IDirtyResource;
import org.eclipse.xtext.ui.editor.IDirtyStateManager;
import org.eclipse.xtext.ui.shared.Access;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class DirtyStateAwareDiagramDocumentEditor
extends DiagramDocumentEditor {
    private IDirtyStateManager dirtyStateManager = (IDirtyStateManager)Access.getIDirtyStateManager().get();
    private Map<URI, IDirtyResource> uri2dirtyResource = Maps.newHashMap();

    public DirtyStateAwareDiagramDocumentEditor(boolean hasFlyoutPalette) {
        super(hasFlyoutPalette);
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        super.init(site, input);
        this.createDirtyResources();
    }

    private void createDirtyResources() {
        List<Resource> resources = this.getResources();
        for (Resource resource : resources) {
            if (resource instanceof XtextResource) continue;
            this.createDirtyResource(resource);
        }
    }

    private void createDirtyResource(Resource resource) {
        IResourceServiceProvider resourceServiceProvider = IResourceServiceProvider.Registry.INSTANCE.getResourceServiceProvider(resource.getURI());
        if (resourceServiceProvider == null) {
            return;
        }
        DirtyResourceAdapter dirtyResource = new DirtyResourceAdapter(resource, resourceServiceProvider);
        this.dirtyStateManager.manageDirtyState((IDirtyResource)dirtyResource);
        this.uri2dirtyResource.put(resource.getURI(), dirtyResource);
        if (EcoreUtil.getExistingAdapter((Notifier)resource, DirtyResourceUpdater.class) == null) {
            resource.eAdapters().add((Object)new DirtyResourceUpdater(dirtyResource));
        }
    }

    public void dispose() {
        this.removeDirtyResources();
        super.dispose();
    }

    private void removeDirtyResources() {
        List<Resource> resources = this.getResources();
        for (Resource resource : resources) {
            if (resource instanceof XtextResource) continue;
            this.removeDirtyResource(resource);
        }
    }

    private void removeDirtyResource(Resource resource) {
        IDirtyResource dirtyResource = this.uri2dirtyResource.get(resource.getURI());
        this.dirtyStateManager.discardDirtyState(dirtyResource);
        this.uri2dirtyResource.remove(resource.getURI());
    }

    private List<Resource> getResources() {
        TransactionalEditingDomain editingDomain = this.getEditingDomain();
        EList resources = editingDomain.getResourceSet().getResources();
        return resources;
    }

    private static final class DirtyResourceAdapter
    implements IDirtyResource {
        private final Resource resource;
        private final IResourceServiceProvider serviceProvider;

        protected DirtyResourceAdapter(Resource resource, IResourceServiceProvider provider) {
            this.resource = resource;
            this.serviceProvider = provider;
        }

        public String getContents() {
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            try {
                this.resource.save((OutputStream)outputStream, null);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            return new String(outputStream.toByteArray());
        }

        public String getActualContents() {
            return this.getContents();
        }

        public IResourceDescription getDescription() {
            return this.serviceProvider.getResourceDescriptionManager().getResourceDescription(this.resource);
        }

        public URI getURI() {
            return this.resource.getURI();
        }
    }

    private final class DirtyResourceUpdater
    extends EContentAdapter {
        private final DirtyResourceAdapter dirtyResource;

        private DirtyResourceUpdater(DirtyResourceAdapter dirtyResource) {
            this.dirtyResource = dirtyResource;
        }

        public void notifyChanged(Notification notification) {
            DirtyStateAwareDiagramDocumentEditor.this.dirtyStateManager.announceDirtyStateChanged((IDirtyResource)this.dirtyResource);
        }

        public boolean isAdapterForType(Object type) {
            return type == DirtyResourceUpdater.class;
        }
    }
}

