/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.api.tools.internal.tasks;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.Flags;
import org.eclipse.pde.api.tools.internal.comparator.DeltaXmlVisitor;
import org.eclipse.pde.api.tools.internal.provisional.RestrictionModifiers;
import org.eclipse.pde.api.tools.internal.provisional.comparator.DeltaProcessor;
import org.eclipse.pde.api.tools.internal.provisional.comparator.IDelta;
import org.eclipse.pde.api.tools.internal.util.FilteredElements;
import org.eclipse.pde.api.tools.internal.util.Util;

public class FilterListDeltaVisitor
extends DeltaXmlVisitor {
    public static final int CHECK_DEPRECATION = 1;
    public static final int CHECK_OTHER = 2;
    public static final int CHECK_ALL = 3;
    private FilteredElements excludedElements;
    private FilteredElements includedElements;
    private List<String> nonExcludedElements;
    private int flags;

    public FilterListDeltaVisitor(FilteredElements excludedElements, FilteredElements includedElements, int flags) throws CoreException {
        this.excludedElements = excludedElements;
        this.includedElements = includedElements;
        this.nonExcludedElements = new ArrayList<String>();
        this.flags = flags;
    }

    private boolean checkExclude(IDelta delta) {
        return this.isExcluded(delta);
    }

    public String getPotentialExcludeList() {
        if (this.nonExcludedElements == null) {
            return "";
        }
        Collections.sort(this.nonExcludedElements);
        StringWriter stringWriter = new StringWriter();
        PrintWriter writer = new PrintWriter(stringWriter);
        for (String string : this.nonExcludedElements) {
            writer.println(string);
        }
        writer.close();
        return String.valueOf(stringWriter.getBuffer());
    }

    private boolean isExcluded(IDelta delta) {
        String typeName = delta.getTypeName();
        StringBuffer buffer = new StringBuffer();
        String componentId = delta.getComponentId();
        if (componentId != null) {
            if (this.excludedElements.containsExactMatch(componentId) || this.excludedElements.containsPartialMatch(componentId)) {
                return true;
            }
            if (!(this.includedElements.isEmpty() || this.includedElements.containsExactMatch(componentId) || this.includedElements.containsPartialMatch(componentId))) {
                return true;
            }
            buffer.append(componentId).append(':');
        }
        if (typeName != null) {
            buffer.append(typeName);
        }
        int flags = delta.getFlags();
        switch (flags) {
            case 48: {
                buffer.append('.').append(delta.getKey());
                break;
            }
            case 8: 
            case 12: 
            case 16: 
            case 25: 
            case 27: 
            case 28: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 70: 
            case 71: 
            case 72: {
                buffer.append('#').append(delta.getKey());
                break;
            }
            case 59: 
            case 60: {
                buffer.append(Util.getDeltaFlagsName((int)flags)).append('_').append(Util.getDeltaKindName((int)delta.getKind()));
                break;
            }
            case 3: {
                buffer.append(Util.getDeltaKindName((int)delta.getKind())).append('#').append(delta.getKey());
                break;
            }
        }
        String listKey = String.valueOf(buffer);
        if (this.excludedElements.containsExactMatch(listKey)) {
            return true;
        }
        if (!(this.includedElements.isEmpty() || this.includedElements.containsExactMatch(delta.getKey()) || this.includedElements.containsPartialMatch(delta.getKey()))) {
            return true;
        }
        this.nonExcludedElements.add(listKey);
        return false;
    }

    /*
     * Enabled aggressive block sorting
     */
    protected void processLeafDelta(IDelta delta) {
        if (DeltaProcessor.isCompatible((IDelta)delta)) {
            switch (delta.getKind()) {
                case 1: {
                    int modifiers = delta.getNewModifiers();
                    if (Flags.isPublic((int)modifiers)) {
                        if ((this.flags & 1) != 0) {
                            switch (delta.getFlags()) {
                                case 72: {
                                    if (this.checkExclude(delta)) break;
                                    super.processLeafDelta(delta);
                                    break;
                                }
                            }
                        }
                        if ((this.flags & 2) != 0) {
                            switch (delta.getFlags()) {
                                case 8: 
                                case 12: 
                                case 16: 
                                case 25: 
                                case 27: 
                                case 28: 
                                case 46: 
                                case 48: 
                                case 56: 
                                case 61: 
                                case 62: 
                                case 63: 
                                case 64: 
                                case 70: {
                                    if (this.checkExclude(delta)) break;
                                    super.processLeafDelta(delta);
                                    break;
                                }
                                default: {
                                    break;
                                }
                            }
                        }
                    } else if (Flags.isProtected((int)modifiers) && !RestrictionModifiers.isExtendRestriction((int)delta.getCurrentRestrictions())) {
                        if ((this.flags & 1) != 0) {
                            switch (delta.getFlags()) {
                                case 72: {
                                    if (this.checkExclude(delta)) break;
                                    super.processLeafDelta(delta);
                                    break;
                                }
                            }
                        }
                        if ((this.flags & 2) != 0) {
                            switch (delta.getFlags()) {
                                case 8: 
                                case 12: 
                                case 16: 
                                case 25: 
                                case 46: 
                                case 48: 
                                case 56: 
                                case 61: 
                                case 62: 
                                case 63: 
                                case 64: 
                                case 70: {
                                    if (this.checkExclude(delta)) break;
                                    super.processLeafDelta(delta);
                                    break;
                                }
                            }
                        }
                    }
                    if (delta.getElementType() != 3) return;
                    if ((this.flags & 2) == 0) return;
                    switch (delta.getKind()) {
                        case 1: {
                            if (delta.getFlags() != 3) return;
                            if (this.checkExclude(delta)) return;
                            super.processLeafDelta(delta);
                            return;
                        }
                    }
                    return;
                }
                case 2: {
                    if ((this.flags & 2) == 0) return;
                    switch (delta.getFlags()) {
                        case 59: 
                        case 60: {
                            if (this.checkExclude(delta)) return;
                            super.processLeafDelta(delta);
                            return;
                        }
                    }
                    return;
                }
                case 3: {
                    if ((this.flags & 1) == 0) return;
                    switch (delta.getFlags()) {
                        case 72: {
                            if (this.checkExclude(delta)) return;
                            super.processLeafDelta(delta);
                            return;
                        }
                    }
                    return;
                }
            }
            return;
        }
        if ((this.flags & 2) == 0) return;
        switch (delta.getKind()) {
            case 1: {
                switch (delta.getFlags()) {
                    case 8: 
                    case 12: 
                    case 16: 
                    case 25: 
                    case 27: 
                    case 28: 
                    case 46: 
                    case 48: 
                    case 56: 
                    case 61: 
                    case 62: 
                    case 63: 
                    case 64: 
                    case 70: {
                        if (!Util.isVisible((int)delta.getNewModifiers())) return;
                        if (this.checkExclude(delta)) return;
                        super.processLeafDelta(delta);
                        return;
                    }
                }
                return;
            }
            case 3: {
                switch (delta.getFlags()) {
                    case 8: 
                    case 12: 
                    case 16: 
                    case 25: 
                    case 27: 
                    case 28: 
                    case 46: 
                    case 48: 
                    case 56: 
                    case 61: 
                    case 62: 
                    case 63: 
                    case 64: 
                    case 70: 
                    case 71: {
                        if (!Util.isVisible((int)delta.getOldModifiers())) return;
                        if (this.checkExclude(delta)) return;
                        super.processLeafDelta(delta);
                        return;
                    }
                    case 3: {
                        if (this.checkExclude(delta)) return;
                        super.processLeafDelta(delta);
                        return;
                    }
                }
                return;
            }
        }
    }
}

