/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.api.tools.internal.tasks;

import com.ibm.icu.text.DateFormat;
import java.io.File;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Calendar;
import java.util.HashSet;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Pattern;
import org.apache.tools.ant.BuildException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.osgi.service.resolver.ResolverError;
import org.eclipse.osgi.util.NLS;
import org.eclipse.pde.api.tools.internal.provisional.ApiDescriptionVisitor;
import org.eclipse.pde.api.tools.internal.provisional.ApiPlugin;
import org.eclipse.pde.api.tools.internal.provisional.model.IApiBaseline;
import org.eclipse.pde.api.tools.internal.provisional.model.IApiComponent;
import org.eclipse.pde.api.tools.internal.provisional.model.IApiElement;
import org.eclipse.pde.api.tools.internal.provisional.search.ApiSearchEngine;
import org.eclipse.pde.api.tools.internal.provisional.search.IApiSearchReporter;
import org.eclipse.pde.api.tools.internal.provisional.search.IApiSearchRequestor;
import org.eclipse.pde.api.tools.internal.provisional.search.IMetadata;
import org.eclipse.pde.api.tools.internal.search.ApiDescriptionModifier;
import org.eclipse.pde.api.tools.internal.search.SkippedComponent;
import org.eclipse.pde.api.tools.internal.search.UseMetadata;
import org.eclipse.pde.api.tools.internal.search.UseSearchRequestor;
import org.eclipse.pde.api.tools.internal.search.XmlSearchReporter;
import org.eclipse.pde.api.tools.internal.tasks.CommonUtilsTask;
import org.eclipse.pde.api.tools.internal.tasks.Messages;
import org.eclipse.pde.api.tools.internal.util.FilteredElements;
import org.eclipse.pde.api.tools.internal.util.Util;

public final class ApiUseTask
extends CommonUtilsTask {
    private boolean considerapi = false;
    private boolean considerinternal = false;
    private boolean considerillegaluse = false;
    private TreeSet<SkippedComponent> notsearched = null;
    private String scopepattern = null;
    private String referencepattern = null;
    private File baselinedir = null;
    private String[] apiPatterns = null;
    private String[] internalPatterns = null;
    private String[] archivePatterns = null;
    private FilteredElements excludedElements = null;
    private FilteredElements includedElements = null;
    private String filters = null;

    public void setLocation(String location) {
        this.currentBaselineLocation = location;
    }

    public void setScopePattern(String scopepattern) {
        this.scopepattern = scopepattern;
    }

    public void setReferencePattern(String referencepattern) {
        this.referencepattern = referencepattern;
    }

    public void setReport(String reportlocation) {
        this.reportLocation = reportlocation;
    }

    public void setDebug(String debugValue) {
        this.debug = Boolean.toString(true).equals(debugValue);
    }

    public void setConsiderAPI(String considerapi) {
        this.considerapi = Boolean.toString(true).equals(considerapi);
    }

    public void setConsiderIllegalUse(String considerillegaluse) {
        this.considerillegaluse = Boolean.toString(true).equals(considerillegaluse);
    }

    public void setApiPatterns(String patterns) {
        this.apiPatterns = this.parsePatterns(patterns);
    }

    public void setConsiderInternal(String considerinternal) {
        this.considerinternal = Boolean.toString(true).equals(considerinternal);
    }

    public void setInternalPatterns(String patterns) {
        this.internalPatterns = this.parsePatterns(patterns);
    }

    public void setArchivePatterns(String patterns) {
        this.archivePatterns = this.parsePatterns(patterns);
    }

    protected void assertParameters() throws BuildException {
        if (this.reportLocation == null) {
            StringWriter out = new StringWriter();
            PrintWriter writer = new PrintWriter(out);
            writer.println(NLS.bind((String)Messages.ApiUseTask_missing_report_location, (Object[])new String[]{this.reportLocation}));
            writer.flush();
            writer.close();
            throw new BuildException(String.valueOf(out.getBuffer()));
        }
        if (this.currentBaselineLocation == null) {
            StringWriter out = new StringWriter();
            PrintWriter writer = new PrintWriter(out);
            writer.println(NLS.bind((String)Messages.ApiUseTask_missing_baseline_argument, (Object[])new String[]{this.currentBaselineLocation}));
            writer.flush();
            writer.close();
            throw new BuildException(String.valueOf(out.getBuffer()));
        }
        if (!(this.considerapi || this.considerinternal || this.considerillegaluse)) {
            throw new BuildException(Messages.UseTask_no_scan_both_types_not_searched_for);
        }
    }

    public void execute() throws BuildException {
        this.assertParameters();
        this.writeDebugHeader();
        this.cleanReportLocation();
        UseMetadata data = new UseMetadata(this.getSearchFlags(), this.scopepattern, this.referencepattern, this.currentBaselineLocation, this.reportLocation, this.apiPatterns, this.internalPatterns, this.archivePatterns, DateFormat.getDateTimeInstance().format(Calendar.getInstance().getTime()), this.getDescription());
        IApiBaseline baseline = this.getBaseline("current_baseline", this.currentBaselineLocation);
        XmlSearchReporter reporter = new XmlSearchReporter(this.reportLocation, this.debug);
        try {
            try {
                HashSet<String> ids = new HashSet<String>();
                TreeSet<IApiComponent> scope = new TreeSet<IApiComponent>(Util.componentsorter);
                this.getContext(baseline, ids, scope);
                ApiSearchEngine engine = new ApiSearchEngine();
                UseSearchRequestor requestor = new UseSearchRequestor(ids, scope.toArray(new IApiElement[scope.size()]), this.getSearchFlags());
                requestor.setJarPatterns(this.archivePatterns);
                requestor.setFilterRoot(this.filters);
                if (this.apiPatterns != null || this.internalPatterns != null) {
                    ApiDescriptionModifier visitor = new ApiDescriptionModifier(this.internalPatterns, this.apiPatterns);
                    IApiComponent[] components = baseline.getApiComponents();
                    int i = 0;
                    while (i < components.length) {
                        IApiComponent component = components[i];
                        if (!component.isSystemComponent() && !component.isSourceComponent()) {
                            visitor.setApiDescription(component.getApiDescription());
                            component.getApiDescription().accept((ApiDescriptionVisitor)visitor, null);
                        }
                        ++i;
                    }
                }
                ApiPlugin.DEBUG_SEARCH_ENGINE = this.debug;
                engine.search(baseline, (IApiSearchRequestor)requestor, (IApiSearchReporter)reporter, null);
            }
            catch (CoreException ce) {
                throw new BuildException(Messages.ApiUseTask_search_engine_problem, (Throwable)ce);
            }
        }
        finally {
            if (baseline != null) {
                baseline.dispose();
                this.deleteBaseline(this.currentBaselineLocation, this.baselinedir);
            }
            reporter.reportNotSearched(this.notsearched.toArray(new IApiElement[this.notsearched.size()]));
            reporter.reportMetadata((IMetadata)data);
            reporter.reportCounts();
        }
    }

    boolean acceptComponent(IApiComponent component, Pattern pattern, boolean allowresolve) throws CoreException {
        ResolverError[] errors;
        if (!allowresolve && (errors = component.getErrors()) != null) {
            this.notsearched.add(new SkippedComponent(component.getSymbolicName(), component.getVersion(), errors));
            return false;
        }
        if (component.isSystemComponent()) {
            return false;
        }
        if (pattern != null) {
            return pattern.matcher(component.getSymbolicName()).matches();
        }
        return true;
    }

    private void getContext(IApiBaseline baseline, Set<String> ids, Set<IApiComponent> scope) throws CoreException {
        this.excludedElements = CommonUtilsTask.initializeFilteredElements(this.excludeListLocation, baseline, this.debug);
        if (this.debug) {
            System.out.println("====================================================================================");
            System.out.println("Excluded elements list:");
            System.out.println(this.excludedElements);
        }
        this.includedElements = CommonUtilsTask.initializeFilteredElements(this.includeListLocation, baseline, this.debug);
        if (this.debug) {
            System.out.println("====================================================================================");
            System.out.println("Included elements list:");
            System.out.println(this.includedElements);
        }
        IApiComponent[] components = baseline.getApiComponents();
        this.notsearched = new TreeSet(Util.componentsorter);
        Pattern refPattern = null;
        Pattern scopePattern = null;
        if (this.referencepattern != null) {
            refPattern = Pattern.compile(this.referencepattern);
        }
        if (this.scopepattern != null) {
            scopePattern = Pattern.compile(this.scopepattern);
        }
        int i = 0;
        while (i < components.length) {
            String symbolicName = components[i].getSymbolicName();
            boolean skip = false;
            if (!(this.includedElements.isEmpty() || this.includedElements.containsExactMatch(symbolicName) || this.includedElements.containsPartialMatch(symbolicName))) {
                skip = true;
            }
            if (!skip && (this.excludedElements.containsExactMatch(symbolicName) || this.excludedElements.containsPartialMatch(symbolicName))) {
                skip = true;
            }
            if (!skip) {
                if (this.acceptComponent(components[i], refPattern, true)) {
                    ids.add(symbolicName);
                }
                if (this.acceptComponent(components[i], scopePattern, false)) {
                    scope.add(components[i]);
                }
            } else {
                this.notsearched.add(new SkippedComponent(symbolicName, components[i].getVersion(), components[i].getErrors()));
            }
            ++i;
        }
    }

    protected int getSearchFlags() {
        int flags = this.considerapi ? 1 : 0;
        flags |= this.considerinternal ? 2 : 0;
        return flags |= this.considerillegaluse ? 4 : 0;
    }

    protected IApiBaseline getBaseline(String name, String location) {
        if (location == null) {
            return null;
        }
        long time = 0L;
        if (this.debug) {
            time = System.currentTimeMillis();
            System.out.println("Preparing '" + name + "' baseline installation...");
        }
        File installdir = this.extractSDK(name, location);
        if (this.debug) {
            System.out.println("done in: " + (System.currentTimeMillis() - time) + " ms");
            time = System.currentTimeMillis();
        }
        if (this.debug) {
            time = System.currentTimeMillis();
            System.out.println("Creating '" + name + "' baseline...");
        }
        IApiBaseline baseline = this.createBaseline(name, installdir.getAbsolutePath(), this.eeFileLocation);
        if (this.debug) {
            System.out.println("done in: " + (System.currentTimeMillis() - time) + " ms");
        }
        this.baselinedir = installdir;
        return baseline;
    }

    protected void cleanReportLocation() {
        File file;
        if (this.reportLocation == null) {
            return;
        }
        long time = 0L;
        if (this.debug) {
            time = System.currentTimeMillis();
            System.out.println("Cleaning report location...");
        }
        if ((file = new File(this.reportLocation)).exists()) {
            Util.delete((File)file);
        }
        if (this.debug) {
            System.out.println("done in: " + (System.currentTimeMillis() - time) + " ms");
        }
    }

    protected void writeDebugHeader() {
        if (this.debug) {
            System.out.println("Product location to search : " + this.currentBaselineLocation);
            System.out.println("Report location : " + this.reportLocation);
            System.out.println("Searching for API references : " + this.considerapi);
            System.out.println("Searching for internal references : " + this.considerinternal);
            System.out.println("Searching for illegal API use : " + this.considerillegaluse);
            if (this.excludeListLocation != null) {
                System.out.println("Exclude list location : " + this.excludeListLocation);
            } else {
                System.out.println("No exclude list location");
            }
            if (this.includeListLocation != null) {
                System.out.println("Include list location : " + this.includeListLocation);
            } else {
                System.out.println("No include list location");
            }
            if (this.filters != null) {
                System.out.println("API Filter location : " + this.filters);
            } else {
                System.out.println("No API filter location");
            }
            if (this.scopepattern == null) {
                System.out.println("No scope pattern defined - searching all bundles");
            } else {
                System.out.println("Scope pattern : " + this.scopepattern);
            }
            if (this.referencepattern == null) {
                System.out.println("No baseline pattern defined - reporting references to all bundles");
            } else {
                System.out.println("Baseline pattern : " + this.referencepattern);
            }
            System.out.println("-----------------------------------------------------------------------------------------------------");
        }
    }

    public void setExcludeList(String excludeListLocation) {
        this.excludeListLocation = excludeListLocation;
    }

    public void setIncludeList(String includeListLocation) {
        this.includeListLocation = includeListLocation;
    }

    public void setFilters(String filters) {
        this.filters = filters;
    }
}

