/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.api.tools.internal.tasks;

import java.io.File;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.TreeSet;
import java.util.regex.Pattern;
import org.apache.tools.ant.BuildException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.osgi.service.resolver.ResolverError;
import org.eclipse.osgi.util.NLS;
import org.eclipse.pde.api.tools.internal.provisional.model.IApiBaseline;
import org.eclipse.pde.api.tools.internal.provisional.model.IApiComponent;
import org.eclipse.pde.api.tools.internal.search.ReferenceLookupVisitor;
import org.eclipse.pde.api.tools.internal.search.SkippedComponent;
import org.eclipse.pde.api.tools.internal.search.UseScanParser;
import org.eclipse.pde.api.tools.internal.search.UseScanVisitor;
import org.eclipse.pde.api.tools.internal.tasks.CommonUtilsTask;
import org.eclipse.pde.api.tools.internal.tasks.Messages;
import org.eclipse.pde.api.tools.internal.util.FilteredElements;
import org.eclipse.pde.api.tools.internal.util.Util;

public final class ApiMigrationTask
extends CommonUtilsTask {
    private TreeSet<SkippedComponent> notsearched = null;
    private String scopepattern = null;
    private String referencepattern = null;
    private File baselinedir = null;
    private String scanLocation = null;

    public void setCandidate(String location) {
        this.currentBaselineLocation = location;
    }

    public void setScopePattern(String scopepattern) {
        this.scopepattern = scopepattern;
    }

    public void setReferencePattern(String referencepattern) {
        this.referencepattern = referencepattern;
    }

    public void setReport(String reportlocation) {
        this.reportLocation = reportlocation;
    }

    public void setUseScan(String scanLocation) {
        this.scanLocation = scanLocation;
    }

    public void setDebug(String debugValue) {
        this.debug = Boolean.toString(true).equals(debugValue);
    }

    protected void assertParameters() throws BuildException {
        if (this.reportLocation == null) {
            StringWriter out = new StringWriter();
            PrintWriter writer = new PrintWriter(out);
            writer.println(NLS.bind((String)Messages.ApiUseTask_missing_report_location, (Object[])new String[]{this.reportLocation}));
            writer.flush();
            writer.close();
            throw new BuildException(String.valueOf(out.getBuffer()));
        }
        if (this.currentBaselineLocation == null) {
            StringWriter out = new StringWriter();
            PrintWriter writer = new PrintWriter(out);
            writer.println(NLS.bind((String)Messages.ApiUseTask_missing_baseline_argument, (Object[])new String[]{this.currentBaselineLocation}));
            writer.flush();
            writer.close();
            throw new BuildException(String.valueOf(out.getBuffer()));
        }
        if (this.scanLocation == null) {
            StringWriter out = new StringWriter();
            PrintWriter writer = new PrintWriter(out);
            writer.println(NLS.bind((String)Messages.ApiMigrationTask_missing_scan_location, (Object[])new String[]{this.scanLocation}));
            writer.flush();
            writer.close();
            throw new BuildException(String.valueOf(out.getBuffer()));
        }
        String xmlLocation = this.scanLocation;
        File file = new File(xmlLocation);
        if (!file.exists()) {
            StringWriter out = new StringWriter();
            PrintWriter writer = new PrintWriter(out);
            writer.println(NLS.bind((String)Messages.ApiMigrationTask_scan_location_not_exist, (Object[])new String[]{this.scanLocation}));
            writer.flush();
            writer.close();
            throw new BuildException(String.valueOf(out.getBuffer()));
        }
        if (!file.isDirectory()) {
            StringWriter out = new StringWriter();
            PrintWriter writer = new PrintWriter(out);
            writer.println(NLS.bind((String)Messages.ApiMigrationTask_scan_location_not_dir, (Object[])new String[]{this.scanLocation}));
            writer.flush();
            writer.close();
            throw new BuildException(String.valueOf(out.getBuffer()));
        }
        if (this.reportLocation.equals(this.scanLocation)) {
            StringWriter out = new StringWriter();
            PrintWriter writer = new PrintWriter(out);
            writer.println(NLS.bind((String)Messages.ApiMigrationTask_scan_locatoin_same_as_report_location, (Object[])new String[]{this.scanLocation}));
            writer.flush();
            writer.close();
            throw new BuildException(String.valueOf(out.getBuffer()));
        }
    }

    public void execute() throws BuildException {
        this.assertParameters();
        this.writeDebugHeader();
        this.cleanReportLocation();
        IApiBaseline baseline = this.getBaseline("current_baseline", this.currentBaselineLocation);
        try {
            try {
                String xmlLocation = this.scanLocation;
                File file = new File(xmlLocation);
                File nested = new File(file, "xml");
                if (nested.exists() && nested.isDirectory()) {
                    file = nested;
                }
                ReferenceLookupVisitor lookup = new ReferenceLookupVisitor(baseline, this.reportLocation);
                lookup.setAnalysisScope(this.scopepattern);
                lookup.setTargetScope(this.referencepattern);
                FilteredElements excludedElements = CommonUtilsTask.initializeFilteredElements(this.excludeListLocation, baseline, this.debug);
                if (this.debug) {
                    System.out.println("====================================================================================");
                    System.out.println("Excluded elements list:");
                    System.out.println(excludedElements);
                }
                lookup.setExcludedElements(excludedElements);
                FilteredElements includedElements = CommonUtilsTask.initializeFilteredElements(this.includeListLocation, baseline, this.debug);
                if (this.debug) {
                    System.out.println("====================================================================================");
                    System.out.println("Included elements list:");
                    System.out.println(includedElements);
                }
                lookup.setIncludedElements(includedElements);
                UseScanParser parser = new UseScanParser();
                parser.parse(file.getAbsolutePath(), (IProgressMonitor)new NullProgressMonitor(), (UseScanVisitor)lookup);
            }
            catch (CoreException ce) {
                throw new BuildException(ce.getStatus().getMessage(), (Throwable)ce);
            }
            catch (Exception e) {
                throw new BuildException(e.getMessage(), (Throwable)e);
            }
        }
        finally {
            if (baseline != null) {
                baseline.dispose();
                this.deleteBaseline(this.currentBaselineLocation, this.baselinedir);
            }
        }
    }

    boolean acceptComponent(IApiComponent component, Pattern pattern, boolean allowresolve) throws CoreException {
        ResolverError[] errors;
        if (!allowresolve && (errors = component.getErrors()) != null) {
            this.notsearched.add(new SkippedComponent(component.getSymbolicName(), component.getVersion(), errors));
            return false;
        }
        if (component.isSystemComponent()) {
            return false;
        }
        if (pattern != null) {
            return pattern.matcher(component.getSymbolicName()).matches();
        }
        return true;
    }

    protected IApiBaseline getBaseline(String name, String location) {
        if (location == null) {
            return null;
        }
        long time = 0L;
        if (this.debug) {
            time = System.currentTimeMillis();
            System.out.println("Preparing '" + name + "' baseline installation...");
        }
        File installdir = this.extractSDK(name, location);
        if (this.debug) {
            System.out.println("done in: " + (System.currentTimeMillis() - time) + " ms");
            time = System.currentTimeMillis();
        }
        if (this.debug) {
            time = System.currentTimeMillis();
            System.out.println("Creating '" + name + "' baseline...");
        }
        IApiBaseline baseline = this.createBaseline(name, installdir.getAbsolutePath(), this.eeFileLocation);
        if (this.debug) {
            System.out.println("done in: " + (System.currentTimeMillis() - time) + " ms");
        }
        this.baselinedir = installdir;
        return baseline;
    }

    protected void cleanReportLocation() {
        File file;
        if (this.reportLocation == null) {
            return;
        }
        long time = 0L;
        if (this.debug) {
            time = System.currentTimeMillis();
            System.out.println("Cleaning report location...");
        }
        if ((file = new File(this.reportLocation)).exists()) {
            Util.delete((File)file);
        }
        if (this.debug) {
            System.out.println("done in: " + (System.currentTimeMillis() - time) + " ms");
        }
    }

    protected void writeDebugHeader() {
        if (this.debug) {
            System.out.println("Migration candidate to analyze : " + this.currentBaselineLocation);
            System.out.println("Report location : " + this.reportLocation);
            System.out.println("Scan location : " + this.scanLocation);
            if (this.scopepattern == null) {
                System.out.println("No scope pattern defined - searching all bundles");
            } else {
                System.out.println("Scope pattern : " + this.scopepattern);
            }
            if (this.referencepattern == null) {
                System.out.println("No baseline pattern defined - reporting references to all bundles");
            } else {
                System.out.println("Baseline pattern : " + this.referencepattern);
            }
            System.out.println("-----------------------------------------------------------------------------------------------------");
        }
    }

    public void setExcludeList(String excludeListLocation) {
        this.excludeListLocation = excludeListLocation;
    }

    public void setIncludeList(String includeListLocation) {
        this.includeListLocation = includeListLocation;
    }
}

