/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.api.tools.internal.tasks;

import com.ibm.icu.text.MessageFormat;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileFilter;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.eclipse.osgi.util.NLS;
import org.eclipse.pde.api.tools.internal.tasks.Messages;
import org.eclipse.pde.api.tools.internal.util.Util;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class AnalysisReportConversionTask
extends Task {
    static final Problem[] NO_PROBLEMS = new Problem[0];
    static final String[] NO_NON_API_BUNDLES = new String[0];
    boolean debug;
    private String htmlReportsLocation;
    private File htmlRoot;
    private File reportsRoot;
    private String xmlReportsLocation;

    private void dumpFooter(PrintWriter writer) {
        writer.println(Messages.W3C_page_footer);
    }

    private void dumpHeader(PrintWriter writer, Report report) {
        writer.println(MessageFormat.format((String)Messages.fullReportTask_apiproblemheader, (Object[])new Object[]{report.componentID}));
        writer.println(MessageFormat.format((String)Messages.fullReportTask_apiproblemsummary, (Object[])new Object[]{Integer.toString(report.getProblemSize("compatibility")), Integer.toString(report.getProblemSize("usage")), Integer.toString(report.getProblemSize("bundleVersion"))}));
        if (report.getProblemSize("componentResolution") == 1) {
            writer.println(MessageFormat.format((String)Messages.fullReportTask_resolutiondetailsSingle, (Object[])new Object[]{report.componentID, Integer.toString(report.getProblemSize("componentResolution"))}));
        } else if (report.getProblemSize("componentResolution") > 1) {
            writer.println(MessageFormat.format((String)Messages.fullReportTask_resolutiondetails, (Object[])new Object[]{report.componentID, Integer.toString(report.getProblemSize("componentResolution"))}));
        }
    }

    private void dumpIndexEntry(int i, PrintWriter writer, Summary summary) {
        if (this.debug) {
            System.out.println(summary);
        }
        if (i % 2 == 0) {
            writer.println(MessageFormat.format((String)Messages.fullReportTask_indexsummary_even, (Object[])new Object[]{summary.componentID, Integer.toString(summary.compatibilityNumber), Integer.toString(summary.apiUsageNumber), Integer.toString(summary.bundleVersionNumber), summary.link}));
        } else {
            writer.println(MessageFormat.format((String)Messages.fullReportTask_indexsummary_odd, (Object[])new Object[]{summary.componentID, Integer.toString(summary.compatibilityNumber), Integer.toString(summary.apiUsageNumber), Integer.toString(summary.bundleVersionNumber), summary.link}));
        }
        if (summary.componentResolutionNumber > 0) {
            if (i % 2 == 0) {
                writer.println(MessageFormat.format((String)Messages.fullReportTask_resolutionsummary_even, (Object[])new Object[]{summary.componentID, Integer.toString(summary.componentResolutionNumber)}));
            } else {
                writer.println(MessageFormat.format((String)Messages.fullReportTask_resolutionsummary_odd, (Object[])new Object[]{summary.componentID, Integer.toString(summary.componentResolutionNumber)}));
            }
        }
    }

    private void dumpIndexFile(File reportsRoot, Summary[] summaries, Summary allNonApiBundleSummary) {
        File htmlFile = new File(this.htmlReportsLocation, "index.html");
        PrintWriter writer = null;
        try {
            try {
                FileWriter fileWriter = new FileWriter(htmlFile);
                writer = new PrintWriter(new BufferedWriter(fileWriter));
                if (allNonApiBundleSummary != null) {
                    writer.println(MessageFormat.format((String)Messages.fullReportTask_indexheader, (Object[])new Object[]{NLS.bind((String)Messages.fullReportTask_nonApiBundleSummary, (Object)allNonApiBundleSummary.link)}));
                } else {
                    writer.println(MessageFormat.format((String)Messages.fullReportTask_indexheader, (Object[])new Object[]{Messages.fullReportTask_apiBundleSummary}));
                }
                Arrays.sort(summaries, new Comparator<Object>(){

                    @Override
                    public int compare(Object o1, Object o2) {
                        Summary summary1 = (Summary)o1;
                        Summary summary2 = (Summary)o2;
                        return summary1.componentID.compareTo(summary2.componentID);
                    }
                });
                int i = 0;
                int max = summaries.length;
                while (i < max) {
                    this.dumpIndexEntry(i, writer, summaries[i]);
                    ++i;
                }
                writer.println(Messages.fullReportTask_indexfooter);
                writer.flush();
            }
            catch (IOException iOException) {
                throw new BuildException(NLS.bind((String)Messages.ioexception_writing_html_file, (Object)htmlFile.getAbsolutePath()));
            }
        }
        finally {
            if (writer != null) {
                writer.close();
            }
        }
    }

    private void dumpNonApiBundles(PrintWriter writer, Report report) {
        writer.println(Messages.fullReportTask_bundlesheader);
        String[] nonApiBundleNames = report.getNonApiBundles();
        int i = 0;
        while (i < nonApiBundleNames.length) {
            String bundleName = nonApiBundleNames[i];
            if (i % 2 == 0) {
                writer.println(MessageFormat.format((String)Messages.fullReportTask_bundlesentry_even, (Object[])new Object[]{bundleName}));
            } else {
                writer.println(MessageFormat.format((String)Messages.fullReportTask_bundlesentry_odd, (Object[])new Object[]{bundleName}));
            }
            ++i;
        }
        writer.println(Messages.fullReportTask_bundlesfooter);
    }

    private void dumpProblems(PrintWriter writer, String categoryName, Problem[] problems, boolean printEmptyCategory) {
        if (problems != null && problems.length != 0) {
            writer.println(MessageFormat.format((String)Messages.fullReportTask_categoryheader, (Object[])new Object[]{categoryName}));
            int i = 0;
            int max = problems.length;
            while (i < max) {
                Problem problem = problems[i];
                if (i % 2 == 0) {
                    switch (problem.severity) {
                        case 2: {
                            writer.println(MessageFormat.format((String)Messages.fullReportTask_problementry_even_error, (Object[])new Object[]{problem.getHtmlMessage()}));
                            break;
                        }
                        case 1: {
                            writer.println(MessageFormat.format((String)Messages.fullReportTask_problementry_even_warning, (Object[])new Object[]{problem.getHtmlMessage()}));
                            break;
                        }
                    }
                } else {
                    switch (problem.severity) {
                        case 2: {
                            writer.println(MessageFormat.format((String)Messages.fullReportTask_problementry_odd_error, (Object[])new Object[]{problem.getHtmlMessage()}));
                            break;
                        }
                        case 1: {
                            writer.println(MessageFormat.format((String)Messages.fullReportTask_problementry_odd_warning, (Object[])new Object[]{problem.getHtmlMessage()}));
                            break;
                        }
                    }
                }
                ++i;
            }
            writer.println(Messages.fullReportTask_categoryfooter);
        } else if (printEmptyCategory) {
            writer.println(MessageFormat.format((String)Messages.fullReportTask_category_no_elements, (Object[])new Object[]{categoryName}));
        }
    }

    private void dumpReport(File xmlFile, Report report) {
        String htmlName = this.extractNameFromXMLName(xmlFile);
        report.setLink(this.extractLinkFrom(htmlName));
        File htmlFile = new File(htmlName);
        File parent = htmlFile.getParentFile();
        if (!parent.exists() && !parent.mkdirs()) {
            throw new BuildException(NLS.bind((String)Messages.could_not_create_file, (Object)htmlName));
        }
        PrintWriter writer = null;
        try {
            try {
                FileWriter fileWriter = new FileWriter(htmlFile);
                writer = new PrintWriter(new BufferedWriter(fileWriter));
                if (report.isNonApiBundlesReport()) {
                    this.dumpNonApiBundles(writer, report);
                } else {
                    this.dumpHeader(writer, report);
                    this.dumpProblems(writer, Messages.AnalysisReportConversionTask_component_resolution_header, report.getProblems("componentResolution"), false);
                    this.dumpProblems(writer, Messages.fullReportTask_compatibility_header, report.getProblems("compatibility"), true);
                    this.dumpProblems(writer, Messages.fullReportTask_api_usage_header, report.getProblems("usage"), true);
                    this.dumpProblems(writer, Messages.fullReportTask_bundle_version_header, report.getProblems("bundleVersion"), true);
                    this.dumpFooter(writer);
                }
                writer.flush();
            }
            catch (IOException iOException) {
                throw new BuildException(NLS.bind((String)Messages.ioexception_writing_html_file, (Object)htmlName));
            }
        }
        finally {
            if (writer != null) {
                writer.close();
            }
        }
    }

    public void execute() throws BuildException {
        if (this.debug) {
            System.out.println("xmlReportsLocation : " + this.xmlReportsLocation);
            System.out.println("htmlReportsLocation : " + this.htmlReportsLocation);
        }
        if (this.xmlReportsLocation == null) {
            throw new BuildException(Messages.missing_xml_files_location);
        }
        this.reportsRoot = new File(this.xmlReportsLocation);
        if (!this.reportsRoot.exists() || !this.reportsRoot.isDirectory()) {
            throw new BuildException(NLS.bind((String)Messages.invalid_directory_name, (Object)this.xmlReportsLocation));
        }
        SAXParserFactory factory = SAXParserFactory.newInstance();
        SAXParser parser = null;
        try {
            parser = factory.newSAXParser();
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
        if (parser == null) {
            throw new BuildException(Messages.could_not_create_sax_parser);
        }
        if (this.htmlReportsLocation == null) {
            this.htmlReportsLocation = this.xmlReportsLocation;
        }
        this.htmlRoot = new File(this.htmlReportsLocation);
        if (!this.htmlRoot.exists() && !this.htmlRoot.mkdirs()) {
            throw new BuildException(NLS.bind((String)Messages.could_not_create_file, (Object)this.htmlReportsLocation));
        }
        if (this.debug) {
            System.out.println("output name :" + this.htmlReportsLocation);
        }
        try {
            File[] allFiles = Util.getAllFiles((File)this.reportsRoot, (FileFilter)new FileFilter(){

                @Override
                public boolean accept(File pathname) {
                    return pathname.isDirectory() || pathname.getName().endsWith(".xml");
                }
            });
            if (allFiles != null) {
                int length = allFiles.length;
                ArrayList<Summary> summariesList = new ArrayList<Summary>(length);
                Summary nonApiBundleSummary = null;
                int i = 0;
                while (i < length) {
                    File file = allFiles[i];
                    ConverterDefaultHandler defaultHandler = new ConverterDefaultHandler(this.debug);
                    parser.parse(file, (DefaultHandler)defaultHandler);
                    Report report = defaultHandler.getReport();
                    if (report == null) {
                        if (this.debug) {
                            System.out.println("Skipped file : " + file.getAbsolutePath());
                        }
                    } else {
                        this.dumpReport(file, report);
                        if (report.isNonApiBundlesReport()) {
                            nonApiBundleSummary = new Summary(report);
                        } else {
                            summariesList.add(new Summary(report));
                        }
                    }
                    ++i;
                }
                if (!summariesList.isEmpty() || nonApiBundleSummary != null) {
                    Summary[] summaries = new Summary[summariesList.size()];
                    summariesList.toArray(summaries);
                    this.dumpIndexFile(this.reportsRoot, summaries, nonApiBundleSummary);
                }
            }
        }
        catch (SAXException sAXException) {
        }
        catch (IOException iOException) {}
    }

    private String extractLinkFrom(String fileName) {
        StringBuffer buffer = new StringBuffer();
        buffer.append('.').append(fileName.substring(this.htmlRoot.getAbsolutePath().length()).replace('\\', '/'));
        return String.valueOf(buffer);
    }

    private String extractNameFromXMLName(File xmlFile) {
        String fileName = xmlFile.getAbsolutePath();
        int index = fileName.lastIndexOf(46);
        StringBuffer buffer = new StringBuffer();
        buffer.append(fileName.substring(this.reportsRoot.getAbsolutePath().length(), index)).append(".html");
        File htmlFile = new File(this.htmlReportsLocation, String.valueOf(buffer));
        return htmlFile.getAbsolutePath();
    }

    public void setDebug(String debugValue) {
        this.debug = Boolean.toString(true).equals(debugValue);
    }

    public void setHtmlFiles(String htmlFilesLocation) {
        this.htmlReportsLocation = htmlFilesLocation;
    }

    public void setXmlFiles(String xmlFilesLocation) {
        this.xmlReportsLocation = xmlFilesLocation;
    }

    static final class ConverterDefaultHandler
    extends DefaultHandler {
        String category;
        boolean debug;
        Report report;

        public ConverterDefaultHandler(boolean debug) {
            this.debug = debug;
        }

        public Report getReport() {
            return this.report;
        }

        @Override
        public void startElement(String uri, String localName, String name, Attributes attributes) throws SAXException {
            if ("report".equals(name)) {
                String componentID = attributes.getValue("componentID");
                if (this.debug) {
                    System.out.println("component id : " + String.valueOf(componentID));
                }
                this.report = new Report(componentID);
            } else if ("category".equals(name)) {
                this.category = attributes.getValue("value");
                if (this.debug) {
                    System.out.println("category : " + this.category);
                }
            } else if ("api_problem".equals(name)) {
                String message = attributes.getValue("message");
                if (this.debug) {
                    System.out.println("problem message : " + message);
                }
                int severity = Integer.parseInt(attributes.getValue("severity"));
                if (this.debug) {
                    System.out.println("problem severity : " + severity);
                }
                this.report.addProblem(this.category, new Problem(message, severity));
            } else if ("resolver_error".equals(name)) {
                String message = attributes.getValue("message");
                if (this.debug) {
                    System.out.println("Resolver error : " + message);
                }
                this.report.addProblem(this.category, new Problem(message, 1));
            } else if ("bundle".equals(name)) {
                String bundleName = attributes.getValue("name");
                if (this.debug) {
                    System.out.println("bundle name : " + bundleName);
                }
                this.report.addNonApiBundles(bundleName);
            } else if (!(!this.debug || "message_arguments".equals(name) || "message_argument".equals(name) || "api_problems".equals(name) || "extra_argument".equals(name) || "extra_arguments".equals(name))) {
                System.out.println("unknown element : " + String.valueOf(name));
            }
        }
    }

    static final class Problem {
        String message;
        int severity;

        public Problem(String message, int severity) {
            this.message = message;
            this.severity = severity;
        }

        public String getHtmlMessage() {
            StringBuffer buffer = new StringBuffer();
            char[] chars = this.message.toCharArray();
            int i = 0;
            int max = chars.length;
            while (i < max) {
                char character = chars[i];
                switch (character) {
                    case '<': {
                        buffer.append("&lt;");
                        break;
                    }
                    case '>': {
                        buffer.append("&gt;");
                        break;
                    }
                    case '&': {
                        buffer.append("&amp;");
                        break;
                    }
                    case '\"': {
                        buffer.append("&quot;");
                        break;
                    }
                    default: {
                        buffer.append(character);
                    }
                }
                ++i;
            }
            return String.valueOf(buffer);
        }

        public String toString() {
            StringBuffer buffer = new StringBuffer();
            buffer.append("Problem : ").append(this.message).append(' ').append(this.severity);
            return String.valueOf(buffer);
        }
    }

    private static final class Report {
        String componentID;
        String link;
        List<String> nonApiBundles;
        Map<String, List<Problem>> problemsPerCategories;

        Report(String componentID) {
            this.componentID = componentID;
        }

        public void addNonApiBundles(String bundleName) {
            if (this.nonApiBundles == null) {
                this.nonApiBundles = new ArrayList<String>();
            }
            this.nonApiBundles.add(bundleName);
        }

        public void addProblem(String category, Problem problem) {
            List<Problem> problemsList;
            if (this.problemsPerCategories == null) {
                this.problemsPerCategories = new HashMap<String, List<Problem>>();
            }
            if ((problemsList = this.problemsPerCategories.get(category)) == null) {
                problemsList = new ArrayList<Problem>();
                this.problemsPerCategories.put(category, problemsList);
            }
            problemsList.add(problem);
        }

        public String[] getNonApiBundles() {
            if (this.nonApiBundles == null || this.nonApiBundles.size() == 0) {
                return NO_NON_API_BUNDLES;
            }
            String[] nonApiBundlesNames = new String[this.nonApiBundles.size()];
            this.nonApiBundles.toArray(nonApiBundlesNames);
            return nonApiBundlesNames;
        }

        public Problem[] getProblems(String category) {
            int size;
            if (this.problemsPerCategories == null) {
                return NO_PROBLEMS;
            }
            List<Problem> problemsList = this.problemsPerCategories.get(category);
            int n = size = problemsList == null ? 0 : problemsList.size();
            if (size == 0) {
                return NO_PROBLEMS;
            }
            Problem[] problems = new Problem[size];
            problemsList.toArray(problems);
            return problems;
        }

        public int getProblemSize(String category) {
            if (this.problemsPerCategories == null) {
                return 0;
            }
            List<Problem> problemsList = this.problemsPerCategories.get(category);
            return problemsList == null ? 0 : problemsList.size();
        }

        public boolean isNonApiBundlesReport() {
            return this.componentID == null;
        }

        public void setLink(String link) {
            this.link = link;
        }
    }

    private static final class Summary {
        int apiUsageNumber;
        int bundleVersionNumber;
        int compatibilityNumber;
        int componentResolutionNumber;
        String componentID;
        String link;

        public Summary(Report report) {
            this.apiUsageNumber = report.getProblemSize("usage");
            this.bundleVersionNumber = report.getProblemSize("bundleVersion");
            this.compatibilityNumber = report.getProblemSize("compatibility");
            this.componentResolutionNumber = report.getProblemSize("componentResolution");
            this.componentID = report.componentID;
            this.link = report.link;
        }

        public String toString() {
            return MessageFormat.format((String)"{0} : compatibility {1}, api usage {2}, bundle version {3}, resolution {4}, link {5}", (Object[])new Object[]{this.componentID, Integer.toString(this.compatibilityNumber), Integer.toString(this.apiUsageNumber), Integer.toString(this.bundleVersionNumber), Integer.toString(this.componentResolutionNumber), this.link});
        }
    }
}

