/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.api.tools.internal.tasks;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.tools.ant.BuildException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.osgi.service.resolver.ResolverError;
import org.eclipse.osgi.util.NLS;
import org.eclipse.pde.api.tools.internal.AntFilterStore;
import org.eclipse.pde.api.tools.internal.builder.BaseApiAnalyzer;
import org.eclipse.pde.api.tools.internal.builder.BuildContext;
import org.eclipse.pde.api.tools.internal.model.StubApiComponent;
import org.eclipse.pde.api.tools.internal.problems.ApiProblemFactory;
import org.eclipse.pde.api.tools.internal.provisional.ApiPlugin;
import org.eclipse.pde.api.tools.internal.provisional.IApiFilterStore;
import org.eclipse.pde.api.tools.internal.provisional.builder.IBuildContext;
import org.eclipse.pde.api.tools.internal.provisional.model.IApiBaseline;
import org.eclipse.pde.api.tools.internal.provisional.model.IApiComponent;
import org.eclipse.pde.api.tools.internal.provisional.problems.IApiProblem;
import org.eclipse.pde.api.tools.internal.tasks.CommonUtilsTask;
import org.eclipse.pde.api.tools.internal.tasks.Messages;
import org.eclipse.pde.api.tools.internal.util.FilteredElements;
import org.eclipse.pde.api.tools.internal.util.Util;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class APIToolsAnalysisTask
extends CommonUtilsTask {
    public static final String BUNDLE_VERSION = "bundleVersion";
    public static final String COMPATIBILITY = "compatibility";
    public static final String COMPONENT_RESOLUTION = "componentResolution";
    private static final Summary[] NO_SUMMARIES = new Summary[0];
    public static final String USAGE = "usage";
    private FilteredElements excludedElements;
    private FilteredElements includedElements;
    private String filters;
    private Properties properties;
    private boolean processUnresolvedBundles = true;

    private Summary[] createAllSummaries(Map<String, IApiProblem[]> allProblems) {
        Set<Map.Entry<String, IApiProblem[]>> entrySet = allProblems.entrySet();
        int size = entrySet.size();
        if (size == 0) {
            return NO_SUMMARIES;
        }
        ArrayList<Map.Entry<String, IApiProblem[]>> allEntries = new ArrayList<Map.Entry<String, IApiProblem[]>>();
        allEntries.addAll(entrySet);
        Collections.sort(allEntries, new Comparator<Object>(){

            @Override
            public int compare(Object o1, Object o2) {
                Map.Entry entry1 = (Map.Entry)o1;
                Map.Entry entry2 = (Map.Entry)o2;
                return ((String)entry1.getKey()).compareTo((String)entry2.getKey());
            }
        });
        Summary[] summaries = new Summary[size];
        int i = 0;
        for (Map.Entry entry : allEntries) {
            summaries[i++] = this.createProblemSummary((String)entry.getKey(), (IApiProblem[])entry.getValue());
        }
        return summaries;
    }

    private Summary createProblemSummary(String componentID, IApiProblem[] apiProblems) {
        return new Summary(componentID, apiProblems);
    }

    private void dumpReport(Summary[] summaries, List<String> nonAPIBundleNames, Map<String, Object> bundlesWithErrors) {
        ProblemCounter counter = new ProblemCounter();
        int i = 0;
        int max = summaries.length;
        while (i < max) {
            Summary summary = summaries[i];
            String contents = null;
            String componentID = summary.componentID;
            if (!this.isFiltered(componentID)) {
                if (this.debug) {
                    System.out.println(summary.getDetails());
                }
                try {
                    Document document = Util.newDocument();
                    Element report = document.createElement("report");
                    report.setAttribute("version", "1");
                    report.setAttribute("componentID", componentID);
                    document.appendChild(report);
                    Element category = document.createElement("category");
                    category.setAttribute("key", Integer.toString(0x10000000));
                    category.setAttribute("value", COMPATIBILITY);
                    this.insertAPIProblems(category, document, summary.apiCompatibilityProblems, counter);
                    report.appendChild(category);
                    category = document.createElement("category");
                    category.setAttribute("key", Integer.toString(0x20000000));
                    category.setAttribute("value", USAGE);
                    this.insertAPIProblems(category, document, summary.apiUsageProblems, counter);
                    report.appendChild(category);
                    category = document.createElement("category");
                    category.setAttribute("key", Integer.toString(0x30000000));
                    category.setAttribute("value", BUNDLE_VERSION);
                    this.insertAPIProblems(category, document, summary.apiBundleVersionProblems, counter);
                    report.appendChild(category);
                    if (bundlesWithErrors != null && bundlesWithErrors.containsKey(componentID)) {
                        category = document.createElement("category");
                        category.setAttribute("key", Integer.toString(0x60000000));
                        category.setAttribute("value", COMPONENT_RESOLUTION);
                        ResolverError[] errors = (ResolverError[])bundlesWithErrors.get(componentID);
                        int j = 0;
                        while (j < errors.length) {
                            Element error = document.createElement("resolver_error");
                            error.setAttribute("message", errors[j].toString());
                            category.appendChild(error);
                            ++j;
                        }
                        report.appendChild(category);
                    }
                    contents = Util.serializeDocument((Document)document);
                }
                catch (DOMException e) {
                    throw new BuildException((Throwable)e);
                }
                catch (CoreException e) {
                    throw new BuildException((Throwable)e);
                }
                if (contents != null) {
                    this.saveReport(componentID, contents, "report.xml");
                }
            }
            ++i;
        }
        if (nonAPIBundleNames != null && nonAPIBundleNames.size() != 0) {
            String contents = null;
            try {
                Document document = Util.newDocument();
                Element report = document.createElement("report");
                report.setAttribute("version", "1");
                document.appendChild(report);
                for (String bundleName : nonAPIBundleNames) {
                    if (this.isFiltered(bundleName)) continue;
                    Element bundle = document.createElement("bundle");
                    bundle.setAttribute("name", bundleName);
                    report.appendChild(bundle);
                }
                contents = Util.serializeDocument((Document)document);
            }
            catch (DOMException e) {
                throw new BuildException((Throwable)e);
            }
            catch (CoreException e) {
                throw new BuildException((Throwable)e);
            }
            if (contents != null) {
                this.saveReport("Skipped Bundles", contents, "report.xml");
            }
        }
        String contents = null;
        try {
            Document document = Util.newDocument();
            Element root = document.createElement("reportedcount");
            document.appendChild(root);
            root.setAttribute("total", Integer.toString(counter.total));
            root.setAttribute("warnings", Integer.toString(counter.warnings));
            root.setAttribute("errors", Integer.toString(counter.errors));
            contents = Util.serializeDocument((Document)document);
        }
        catch (DOMException e) {
            throw new BuildException((Throwable)e);
        }
        catch (CoreException e) {
            throw new BuildException((Throwable)e);
        }
        if (contents != null) {
            this.saveReport(null, contents, "counts.xml");
        }
    }

    public void execute() throws BuildException {
        if (this.referenceBaselineLocation == null || this.currentBaselineLocation == null || this.reportLocation == null) {
            StringWriter out = new StringWriter();
            PrintWriter writer = new PrintWriter(out);
            writer.println(NLS.bind((String)Messages.printArguments, (Object[])new String[]{this.referenceBaselineLocation, this.currentBaselineLocation, this.reportLocation}));
            writer.flush();
            writer.close();
            throw new BuildException(String.valueOf(out.getBuffer()));
        }
        if (this.debug) {
            System.out.println("reference : " + this.referenceBaselineLocation);
            System.out.println("baseline to compare : " + this.currentBaselineLocation);
            System.out.println("report location : " + this.reportLocation);
            if (this.filters != null) {
                System.out.println("filter store : " + this.filters);
            } else {
                System.out.println("No filter store");
            }
            if (this.excludeListLocation != null) {
                System.out.println("exclude list location : " + this.excludeListLocation);
            } else {
                System.out.println("No exclude list location");
            }
            if (this.includeListLocation != null) {
                System.out.println("include list location : " + this.includeListLocation);
            } else {
                System.out.println("No include list location");
            }
        }
        long time = 0L;
        if (this.debug) {
            time = System.currentTimeMillis();
        }
        File referenceInstallDir = this.extractSDK("referenceBaseline", this.referenceBaselineLocation);
        File baselineInstallDir = this.extractSDK("currentBaseline", this.currentBaselineLocation);
        if (this.debug) {
            System.out.println("Preparation of baseline installation : " + (System.currentTimeMillis() - time) + "ms");
            time = System.currentTimeMillis();
        }
        IApiBaseline referenceBaseline = this.createBaseline("reference_baseline", referenceInstallDir.getAbsolutePath(), this.eeFileLocation);
        IApiBaseline currentBaseline = this.createBaseline("current_baseline", baselineInstallDir.getAbsolutePath(), this.eeFileLocation);
        if (this.excludeListLocation != null) {
            this.excludedElements = CommonUtilsTask.initializeFilteredElements(this.excludeListLocation, currentBaseline, this.debug);
            if (this.debug) {
                System.out.println("==============================================================================");
                System.out.println("Excluded elements list:");
                System.out.println(this.excludedElements);
            }
        }
        if (this.includeListLocation != null) {
            this.includedElements = CommonUtilsTask.initializeFilteredElements(this.includeListLocation, currentBaseline, this.debug);
            if (this.debug) {
                System.out.println("==============================================================================");
                System.out.println("Included elements list:");
                System.out.println(this.includedElements);
            }
        }
        if (this.debug) {
            System.out.println("Creation of both baselines : " + (System.currentTimeMillis() - time) + "ms");
            time = System.currentTimeMillis();
        }
        HashMap<String, IApiProblem[]> allProblems = new HashMap<String, IApiProblem[]>();
        ArrayList<String> allNonApiBundles = new ArrayList<String>();
        ArrayList<String> allApiBundles = new ArrayList<String>();
        HashMap<String, Object> bundlesWithErrors = new HashMap<String, Object>();
        try {
            IApiComponent[] apiComponents = currentBaseline.getApiComponents();
            int length = apiComponents.length;
            HashSet<String> visitedApiComponentNames = new HashSet<String>();
            int i = 0;
            while (i < length) {
                block44: {
                    IApiComponent apiComponent = apiComponents[i];
                    String name = apiComponent.getSymbolicName();
                    visitedApiComponentNames.add(name);
                    if (!this.isFiltered(name) && !apiComponent.isSystemComponent()) {
                        if (!Util.isApiToolsComponent((IApiComponent)apiComponent)) {
                            allNonApiBundles.add(name);
                        } else {
                            block43: {
                                try {
                                    ResolverError[] resolverErrors = apiComponent.getErrors();
                                    if (resolverErrors == null || resolverErrors.length <= 0) break block43;
                                    bundlesWithErrors.put(name, apiComponent.getErrors());
                                    if (this.processUnresolvedBundles) break block43;
                                    break block44;
                                }
                                catch (CoreException e) {
                                    ApiPlugin.log((IStatus)e.getStatus());
                                    throw new BuildException((Throwable)e);
                                }
                            }
                            allApiBundles.add(name);
                            BaseApiAnalyzer analyzer = new BaseApiAnalyzer();
                            try {
                                try {
                                    analyzer.setContinueOnResolverError(true);
                                    analyzer.analyzeComponent(null, this.getFilterStore(name), this.properties, referenceBaseline, apiComponent, (IBuildContext)new BuildContext(), (IProgressMonitor)new NullProgressMonitor());
                                    IApiProblem[] problems = analyzer.getProblems();
                                    problems = this.removeDuplicates(problems);
                                    if (problems.length != 0) {
                                        allProblems.put(name, problems);
                                    } else if (this.debug) {
                                        System.out.println(String.valueOf(name) + " has no problems");
                                    }
                                }
                                catch (RuntimeException e) {
                                    ApiPlugin.log((Throwable)e);
                                    throw e;
                                }
                            }
                            finally {
                                analyzer.dispose();
                            }
                        }
                    }
                }
                ++i;
            }
            if (this.debug) {
                System.out.println("==========================");
                System.out.println("Total number of components in current baseline :" + length);
                System.out.println("==========================");
                System.out.println("Total number of api tools components in current baseline :" + allApiBundles.size());
                System.out.println("Details:");
                Collections.sort(allApiBundles);
                for (String string : allApiBundles) {
                    System.out.println(string);
                }
                System.out.println("==========================");
                System.out.println("Total number of non-api tools components in current baseline :" + allNonApiBundles.size());
                System.out.println("Details:");
                Collections.sort(allNonApiBundles);
                for (String string : allNonApiBundles) {
                    System.out.println(string);
                }
                System.out.println("==========================");
                System.out.println("Total number of components with resolver errors :" + bundlesWithErrors.size());
                System.out.println("Details:");
                ArrayList names = new ArrayList();
                names.addAll(bundlesWithErrors.keySet());
                Collections.sort(names);
                for (String name : names) {
                    System.out.println(name);
                    ResolverError[] errors = (ResolverError[])bundlesWithErrors.get(name);
                    int i2 = 0;
                    while (i2 < errors.length) {
                        System.out.println(errors[i2]);
                        ++i2;
                    }
                }
                System.out.println("==========================");
            }
            IApiComponent[] baselineApiComponents = referenceBaseline.getApiComponents();
            int i3 = 0;
            int max = baselineApiComponents.length;
            while (i3 < max) {
                IApiComponent apiComponent = baselineApiComponents[i3];
                String id = apiComponent.getSymbolicName();
                if (!visitedApiComponentNames.remove(id) && !this.isFiltered(id)) {
                    IApiProblem problem = ApiProblemFactory.newApiProblem((String)id, null, (String[])new String[]{id}, (String[])new String[]{"org.eclipse.jdt.internal.core.JavaModelManager.handleId", "apiMarkerID"}, (Object[])new Object[]{id, new Integer(2)}, (int)0, (int)-1, (int)-1, (int)0x10000000, (int)3, (int)3, (int)3);
                    allProblems.put(id, new IApiProblem[]{problem});
                }
                ++i3;
            }
        }
        finally {
            if (this.debug) {
                System.out.println("API tools verification check : " + (System.currentTimeMillis() - time) + "ms");
                time = System.currentTimeMillis();
            }
            referenceBaseline.dispose();
            currentBaseline.dispose();
            StubApiComponent.disposeAllCaches();
            this.deleteBaseline(this.referenceBaselineLocation, referenceInstallDir);
            this.deleteBaseline(this.currentBaselineLocation, baselineInstallDir);
            if (this.debug) {
                System.out.println("Cleanup : " + (System.currentTimeMillis() - time) + "ms");
            }
        }
        Summary[] summaries = this.createAllSummaries(allProblems);
        try {
            this.dumpReport(summaries, allNonApiBundles, bundlesWithErrors);
        }
        catch (RuntimeException e) {
            ApiPlugin.log((Throwable)e);
            throw e;
        }
    }

    private boolean isFiltered(String componentID) {
        if (this.excludedElements != null && (this.excludedElements.containsExactMatch(componentID) || this.excludedElements.containsPartialMatch(componentID))) {
            return true;
        }
        return this.includedElements != null && !this.includedElements.isEmpty() && !this.includedElements.containsExactMatch(componentID) && !this.includedElements.containsPartialMatch(componentID);
    }

    private IApiProblem[] removeDuplicates(IApiProblem[] problems) {
        int length = problems.length;
        if (length <= 1) {
            return problems;
        }
        HashSet<String> uniqueProblems = new HashSet<String>(length);
        ArrayList<IApiProblem> allProblems = null;
        int i = 0;
        while (i < length) {
            IApiProblem apiProblem = problems[i];
            String message = apiProblem.getMessage();
            if (!uniqueProblems.contains(message)) {
                if (allProblems == null) {
                    allProblems = new ArrayList<IApiProblem>(length);
                }
                uniqueProblems.add(message);
                allProblems.add(apiProblem);
            }
            ++i;
        }
        return allProblems.toArray(new IApiProblem[allProblems.size()]);
    }

    private IApiFilterStore getFilterStore(String name) {
        if (this.filters == null) {
            return null;
        }
        return new AntFilterStore(this.filters, name);
    }

    private void insertAPIProblems(Element root, Document document, List<IApiProblem> problems, ProblemCounter counter) throws CoreException {
        Element apiProblems = document.createElement("api_problems");
        root.appendChild(apiProblems);
        Element element = null;
        Collections.sort(problems, new Comparator<Object>(){

            @Override
            public int compare(Object o1, Object o2) {
                IApiProblem p1 = (IApiProblem)o1;
                IApiProblem p2 = (IApiProblem)o2;
                return p1.getTypeName().compareTo(p2.getTypeName());
            }
        });
        for (IApiProblem problem : problems) {
            String[] messageArguments;
            int j;
            int severity = this.getSeverity(problem);
            counter.addProblem(severity);
            element = document.createElement("api_problem");
            element.setAttribute("typeName", String.valueOf(problem.getTypeName()));
            element.setAttribute("id", Integer.toString(problem.getId()));
            element.setAttribute("linenumber", Integer.toString(problem.getLineNumber()));
            element.setAttribute("charstart", Integer.toString(problem.getCharStart()));
            element.setAttribute("charend", Integer.toString(problem.getCharEnd()));
            element.setAttribute("elementkind", Integer.toString(problem.getElementKind()));
            element.setAttribute("severity", Integer.toString(severity));
            element.setAttribute("kind", Integer.toString(problem.getKind()));
            element.setAttribute("flags", Integer.toString(problem.getFlags()));
            element.setAttribute("message", problem.getMessage());
            String[] extraMarkerAttributeIds = problem.getExtraMarkerAttributeIds();
            if (extraMarkerAttributeIds != null && extraMarkerAttributeIds.length != 0) {
                int length = extraMarkerAttributeIds.length;
                Object[] extraMarkerAttributeValues = problem.getExtraMarkerAttributeValues();
                Element extraArgumentsElement = document.createElement("extra_arguments");
                j = 0;
                while (j < length) {
                    Element extraArgumentElement = document.createElement("extra_argument");
                    extraArgumentElement.setAttribute("id", extraMarkerAttributeIds[j]);
                    extraArgumentElement.setAttribute("value", String.valueOf(extraMarkerAttributeValues[j]));
                    extraArgumentsElement.appendChild(extraArgumentElement);
                    ++j;
                }
                element.appendChild(extraArgumentsElement);
            }
            if ((messageArguments = problem.getMessageArguments()) != null && messageArguments.length != 0) {
                int length = messageArguments.length;
                Element messageArgumentsElement = document.createElement("message_arguments");
                j = 0;
                while (j < length) {
                    Element messageArgumentElement = document.createElement("message_argument");
                    messageArgumentElement.setAttribute("value", String.valueOf(messageArguments[j]));
                    messageArgumentsElement.appendChild(messageArgumentElement);
                    ++j;
                }
                element.appendChild(messageArgumentsElement);
            }
            apiProblems.appendChild(element);
        }
    }

    private int getSeverity(IApiProblem problem) {
        String value;
        String key;
        if (this.properties != null && (key = ApiProblemFactory.getProblemSeverityId((IApiProblem)problem)) != null && (value = this.properties.getProperty(key, null)) != null && "Error".equals(value)) {
            return 2;
        }
        return 1;
    }

    public void setDebug(String debugValue) {
        this.debug = Boolean.toString(true).equals(debugValue);
    }

    public void setEEFile(String eeFileLocation) {
        this.eeFileLocation = eeFileLocation;
    }

    public void setExcludeList(String excludeListLocation) {
        this.excludeListLocation = excludeListLocation;
    }

    public void setIncludeList(String includeListLocation) {
        this.includeListLocation = includeListLocation;
    }

    public void setFilters(String filters) {
        this.filters = filters;
    }

    public void setPreferences(String preferencesLocation) {
        block15: {
            File preferencesFile = new File(preferencesLocation);
            if (!preferencesFile.exists()) {
                return;
            }
            BufferedInputStream inputStream = null;
            try {
                try {
                    inputStream = new BufferedInputStream(new FileInputStream(preferencesFile));
                    Properties temp = new Properties();
                    temp.load(inputStream);
                    this.properties = temp;
                }
                catch (IOException iOException) {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (IOException iOException2) {}
                    }
                    break block15;
                }
            }
            catch (Throwable throwable) {
                if (inputStream != null) {
                    try {
                        inputStream.close();
                    }
                    catch (IOException iOException) {}
                }
                throw throwable;
            }
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public void setProfile(String baselineLocation) {
        this.currentBaselineLocation = baselineLocation;
    }

    public void setBaseline(String baselineLocation) {
        this.referenceBaselineLocation = baselineLocation;
    }

    public void setReport(String reportLocation) {
        this.reportLocation = reportLocation;
    }

    public void setProcessUnresolvedBundles(boolean processUnresolvedBundles) {
        this.processUnresolvedBundles = processUnresolvedBundles;
    }

    private static class ProblemCounter {
        int total = 0;
        int warnings = 0;
        int errors = 0;

        public void addProblem(int severity) {
            ++this.total;
            if (severity == 2) {
                ++this.errors;
            } else if (severity == 1) {
                ++this.warnings;
            }
        }
    }

    private static class Summary {
        List<IApiProblem> apiBundleVersionProblems = new ArrayList<IApiProblem>();
        List<IApiProblem> apiCompatibilityProblems = new ArrayList<IApiProblem>();
        List<IApiProblem> apiUsageProblems = new ArrayList<IApiProblem>();
        String componentID;

        public Summary(String componentID, IApiProblem[] apiProblems) {
            this.componentID = componentID;
            int i = 0;
            int max = apiProblems.length;
            while (i < max) {
                IApiProblem problem = apiProblems[i];
                switch (problem.getCategory()) {
                    case 0x10000000: {
                        this.apiCompatibilityProblems.add(problem);
                        break;
                    }
                    case 0x20000000: {
                        this.apiUsageProblems.add(problem);
                        break;
                    }
                    case 0x30000000: {
                        this.apiBundleVersionProblems.add(problem);
                        break;
                    }
                }
                ++i;
            }
        }

        public String toString() {
            return this.getDetails();
        }

        public String getDetails() {
            StringWriter writer = new StringWriter();
            PrintWriter printWriter = new PrintWriter(writer);
            printWriter.println("==================================================================================");
            this.printTitle(printWriter);
            printWriter.println("==================================================================================");
            this.dumpProblems("Usage:", this.apiUsageProblems, printWriter);
            this.dumpProblems("Compatibility:", this.apiCompatibilityProblems, printWriter);
            this.dumpProblems("Bundle Versions:", this.apiBundleVersionProblems, printWriter);
            printWriter.println("==================================================================================");
            printWriter.flush();
            printWriter.close();
            return String.valueOf(writer.getBuffer());
        }

        private void printTitle(PrintWriter printWriter) {
            printWriter.print(String.valueOf(this.componentID) + " : ");
            printWriter.print("Total: ");
            printWriter.print(this.apiUsageProblems.size() + this.apiBundleVersionProblems.size() + this.apiCompatibilityProblems.size());
            printWriter.print(" (Usage: ");
            printWriter.print(this.apiUsageProblems.size());
            printWriter.print(", Compatibility: ");
            printWriter.print(this.apiCompatibilityProblems.size());
            printWriter.print(", Bundle version: ");
            printWriter.print(this.apiBundleVersionProblems.size());
            printWriter.print(')');
            printWriter.println();
        }

        private void dumpProblems(String title, List<IApiProblem> problemsList, PrintWriter printWriter) {
            if (problemsList.isEmpty()) {
                return;
            }
            printWriter.println(title);
            for (IApiProblem problem : problemsList) {
                printWriter.println(problem.getMessage());
            }
        }
    }
}

