/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.api.tools.internal.tasks;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.eclipse.jdt.core.Signature;
import org.eclipse.osgi.util.NLS;
import org.eclipse.pde.api.tools.internal.tasks.CommonUtilsTask;
import org.eclipse.pde.api.tools.internal.tasks.Messages;
import org.eclipse.pde.api.tools.internal.util.Util;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class APIFreezeReportConversionTask
extends Task {
    boolean debug;
    private String htmlFileLocation;
    private String xmlFileLocation;

    private void dumpEndEntryForComponent(StringBuffer buffer, String componentID) {
        buffer.append(NLS.bind((String)Messages.deltaReportTask_endComponentEntry, (Object)componentID));
    }

    private void dumpEntries(Map<String, List<Entry>> entries, Map<String, List<String>> resolverErrors, StringBuffer buffer) {
        this.dumpHeader(buffer);
        ArrayList<Map.Entry<String, List<Entry>>> allEntries = new ArrayList<Map.Entry<String, List<Entry>>>();
        for (Map.Entry<String, List<Entry>> entry : entries.entrySet()) {
            allEntries.add(entry);
        }
        Collections.sort(allEntries, new Comparator<Object>(){

            @Override
            public int compare(Object o1, Object o2) {
                Map.Entry entry1 = (Map.Entry)o1;
                Map.Entry entry2 = (Map.Entry)o2;
                return ((String)entry1.getKey()).compareTo((String)entry2.getKey());
            }
        });
        for (Map.Entry<String, List<Entry>> mapEntry : allEntries) {
            String key = mapEntry.getKey();
            int index = key.indexOf(40);
            String componentName = index >= 0 ? key.substring(0, index) : key;
            this.dumpEntryForComponent(buffer, key);
            if (resolverErrors.containsKey(componentName)) {
                this.dumpResolverErrorSummary(buffer, componentName, resolverErrors.get(componentName));
            }
            List<Entry> values = mapEntry.getValue();
            Collections.sort(values, new Comparator<Object>(){

                @Override
                public int compare(Object o1, Object o2) {
                    Entry entry1 = (Entry)o1;
                    Entry entry2 = (Entry)o2;
                    String typeName1 = entry1.typeName;
                    String typeName2 = entry2.typeName;
                    if (typeName1 == null) {
                        if (typeName2 == null) {
                            return entry1.key.compareTo(entry2.key);
                        }
                        return -1;
                    }
                    if (typeName2 == null) {
                        return 1;
                    }
                    if (!typeName1.equals(typeName2)) {
                        return typeName1.compareTo(typeName2);
                    }
                    return entry1.key.compareTo(entry2.key);
                }
            });
            if (this.debug) {
                System.out.println("Entries for " + key);
            }
            for (Entry entry : values) {
                if (this.debug) {
                    if (entry.typeName != null) {
                        System.out.print(entry.typeName);
                        System.out.print('#');
                    }
                    System.out.println(entry.key);
                }
                this.dumpEntry(buffer, entry);
            }
            this.dumpEndEntryForComponent(buffer, key);
            if (!resolverErrors.containsKey(componentName)) continue;
            this.dumpResolverErrorTable(buffer, componentName, resolverErrors.get(componentName));
        }
        this.dumpFooter(buffer);
    }

    private void dumpEntry(StringBuffer buffer, Entry entry) {
        buffer.append(NLS.bind((String)Messages.deltaReportTask_entry, (Object)entry.getDisplayKind(), (Object)entry.getDisplayString()));
    }

    private void dumpEntryForComponent(StringBuffer buffer, String componentID) {
        buffer.append(NLS.bind((String)Messages.deltaReportTask_componentEntry, (Object)componentID));
    }

    private void dumpResolverErrorSummary(StringBuffer buffer, String componentID, List<String> resolverErrors) {
        int size = resolverErrors.size();
        if (size == 1) {
            buffer.append(NLS.bind((String)Messages.APIFreezeReportConversionTask_resolverErrorWarningSingle, (Object[])new String[]{componentID, String.valueOf(size)}));
        } else if (size > 1) {
            buffer.append(NLS.bind((String)Messages.APIFreezeReportConversionTask_resolverErrorWarningMultiple, (Object[])new String[]{componentID, String.valueOf(size)}));
        }
    }

    private void dumpResolverErrorTable(StringBuffer buffer, String componentID, List<String> resolverErrors) {
        buffer.append(NLS.bind((String)Messages.APIFreezeReportConversionTask_resolverErrorTableStart, (Object)componentID));
        for (String message : resolverErrors) {
            buffer.append(NLS.bind((String)Messages.APIFreezeReportConversionTask_resolverErrorTableEntry, (Object)message));
        }
        buffer.append(Messages.APIFreezeReportConversionTask_resolverErrorTableEnd);
    }

    private void dumpFooter(StringBuffer buffer) {
        buffer.append(Messages.deltaReportTask_footer);
    }

    private void dumpHeader(StringBuffer buffer) {
        buffer.append(Messages.deltaReportTask_header);
    }

    public void execute() throws BuildException {
        int index;
        File file;
        if (this.xmlFileLocation == null) {
            throw new BuildException(Messages.deltaReportTask_missingXmlFileLocation);
        }
        if (this.debug) {
            System.out.println("xmlFileLocation : " + this.xmlFileLocation);
            System.out.println("htmlFileLocation : " + this.htmlFileLocation);
        }
        if (!(file = new File(this.xmlFileLocation)).exists()) {
            throw new BuildException(NLS.bind((String)Messages.deltaReportTask_missingXmlFile, (Object)this.xmlFileLocation));
        }
        if (file.isDirectory()) {
            throw new BuildException(NLS.bind((String)Messages.deltaReportTask_xmlFileLocationMustBeAFile, (Object)this.xmlFileLocation));
        }
        File outputFile = null;
        if (this.htmlFileLocation == null) {
            index = this.xmlFileLocation.lastIndexOf(46);
            if (index == -1 || !this.xmlFileLocation.substring(index).toLowerCase().equals(".xml")) {
                throw new BuildException(Messages.deltaReportTask_xmlFileLocationShouldHaveAnXMLExtension);
            }
            this.htmlFileLocation = this.extractNameFromXMLName(index);
            if (this.debug) {
                System.out.println("output name :" + this.htmlFileLocation);
            }
            outputFile = new File(this.htmlFileLocation);
        } else {
            index = this.htmlFileLocation.lastIndexOf(46);
            if (index == -1 || !this.htmlFileLocation.substring(index).toLowerCase().equals(".html")) {
                throw new BuildException(Messages.deltaReportTask_htmlFileLocationShouldHaveAnHtmlExtension);
            }
            outputFile = new File(this.htmlFileLocation);
            if (outputFile.exists()) {
                if (outputFile.isDirectory()) {
                    throw new BuildException(NLS.bind((String)Messages.deltaReportTask_hmlFileLocationMustBeAFile, (Object)outputFile.getAbsolutePath()));
                }
            } else {
                File parentFile = outputFile.getParentFile();
                if (!parentFile.exists() && !parentFile.mkdirs()) {
                    throw new BuildException(NLS.bind((String)Messages.errorCreatingParentReportFile, (Object)parentFile.getAbsolutePath()));
                }
            }
        }
        SAXParserFactory factory = SAXParserFactory.newInstance();
        SAXParser parser = null;
        try {
            parser = factory.newSAXParser();
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
        if (parser == null) {
            throw new BuildException(Messages.deltaReportTask_couldNotCreateSAXParser);
        }
        try {
            ConverterDefaultHandler defaultHandler = new ConverterDefaultHandler(this.debug);
            parser.parse(file, (DefaultHandler)defaultHandler);
            StringBuffer buffer = new StringBuffer();
            this.dumpEntries(defaultHandler.getEntries(), defaultHandler.getResolverErrors(), buffer);
            this.writeOutput(buffer);
        }
        catch (SAXException sAXException) {
        }
        catch (IOException iOException) {}
    }

    private String extractNameFromXMLName(int index) {
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.xmlFileLocation.substring(0, index)).append(".html");
        return String.valueOf(buffer);
    }

    public void setDebug(String debugValue) {
        this.debug = Boolean.toString(true).equals(debugValue);
    }

    public void setHtmlFile(String htmlFilePath) {
        this.htmlFileLocation = htmlFilePath;
    }

    public void setXmlFile(String xmlFilePath) {
        this.xmlFileLocation = xmlFilePath;
    }

    private void writeOutput(StringBuffer buffer) throws IOException {
        FileWriter writer = null;
        BufferedWriter bufferedWriter = null;
        try {
            writer = new FileWriter(this.htmlFileLocation);
            bufferedWriter = new BufferedWriter(writer);
            bufferedWriter.write(String.valueOf(buffer));
        }
        finally {
            if (bufferedWriter != null) {
                bufferedWriter.close();
            }
        }
    }

    static final class ConverterDefaultHandler
    extends DefaultHandler {
        private static final String API_BASELINE_DELTAS = "Added and removed bundles";
        private String[] arguments;
        private List<String> argumentsList;
        private String componentID;
        private boolean debug;
        private int flags;
        private String key;
        private String kind;
        private Map<String, List<Entry>> map = new HashMap<String, List<Entry>>();
        private String typename;
        private int elementType;
        private Map<String, List<String>> resolverErrors = new HashMap<String, List<String>>();
        private boolean isResolverSection;

        public ConverterDefaultHandler(boolean debug) {
            this.debug = debug;
        }

        @Override
        public void endElement(String uri, String localName, String name) throws SAXException {
            if ("resolver_errors".equals(name)) {
                this.isResolverSection = false;
            } else if ("delta".equals(name)) {
                Entry entry = new Entry(this.flags, this.elementType, this.key, this.typename, this.arguments, this.kind);
                List<Entry> list = this.map.get(this.componentID);
                if (list != null) {
                    list.add(entry);
                } else {
                    ArrayList<Entry> value = new ArrayList<Entry>();
                    value.add(entry);
                    this.map.put(this.componentID, value);
                }
            } else if ("message_arguments".equals(name) && this.argumentsList != null && this.argumentsList.size() != 0) {
                this.arguments = new String[this.argumentsList.size()];
                this.argumentsList.toArray(this.arguments);
            }
        }

        public Map<String, List<Entry>> getEntries() {
            return this.map;
        }

        public Map<String, List<String>> getResolverErrors() {
            return this.resolverErrors;
        }

        private void printAttribute(Attributes attributes, String name) {
            System.out.println("\t" + name + " = " + String.valueOf(attributes.getValue(name)));
        }

        @Override
        public void startElement(String uri, String localName, String name, Attributes attributes) throws SAXException {
            if (this.isResolverSection) {
                if ("report".equals(name)) {
                    this.componentID = attributes.getValue("componentID");
                } else if ("resolver_error".equals(name)) {
                    List<String> errors = this.resolverErrors.get(this.componentID);
                    if (errors == null) {
                        errors = new ArrayList<String>();
                        this.resolverErrors.put(this.componentID, errors);
                    }
                    String message = attributes.getValue("message");
                    errors.add(message);
                    if (this.debug) {
                        System.out.println("Resolver error : " + this.componentID + " : " + message);
                    }
                }
            } else if ("delta".equals(name)) {
                String value;
                if (this.debug) {
                    System.out.println("name : " + name);
                    this.printAttribute(attributes, "compatible");
                    this.printAttribute(attributes, "componentId");
                    this.printAttribute(attributes, "element_type");
                    this.printAttribute(attributes, "flags");
                    this.printAttribute(attributes, "key");
                    this.printAttribute(attributes, "kind");
                    this.printAttribute(attributes, "newModifiers");
                    this.printAttribute(attributes, "oldModifiers");
                    this.printAttribute(attributes, "restrictions");
                    this.printAttribute(attributes, "type_name");
                }
                this.componentID = (value = attributes.getValue("componentId")) == null ? API_BASELINE_DELTAS : value;
                this.flags = Integer.parseInt(attributes.getValue("flags"));
                this.elementType = Util.getDeltaElementTypeValue((String)attributes.getValue("element_type"));
                this.typename = attributes.getValue("type_name");
                this.key = attributes.getValue("key");
                this.kind = attributes.getValue("kind");
            } else if ("message_arguments".equals(name)) {
                if (this.argumentsList == null) {
                    this.argumentsList = new ArrayList<String>();
                } else {
                    this.argumentsList.clear();
                }
            } else if ("message_argument".equals(name)) {
                this.argumentsList.add(attributes.getValue("value"));
            } else if ("resolver_errors".equals(name)) {
                this.isResolverSection = true;
                if (this.debug) {
                    System.out.println("Reading resolver error section");
                }
            }
        }
    }

    static class Entry {
        String[] arguments;
        int flags;
        int elementType;
        String key;
        String typeName;
        String kind;
        private static final String ADDED = "ADDED";
        private static final String REMOVED = "REMOVED";

        public Entry(int flags, int elementType, String key, String typeName, String[] arguments, String kind) {
            this.flags = flags;
            this.key = key.replace('/', '.');
            if (typeName != null) {
                this.typeName = typeName.replace('/', '.');
            }
            this.arguments = arguments;
            this.kind = kind;
            this.elementType = elementType;
        }

        public String getDisplayString() {
            StringBuffer buffer = new StringBuffer();
            if (this.typeName != null && this.typeName.length() != 0) {
                buffer.append(this.typeName);
                block0 : switch (this.flags) {
                    case 25: 
                    case 27: 
                    case 28: 
                    case 62: 
                    case 65: 
                    case 66: {
                        int indexOf = this.key.indexOf(40);
                        if (indexOf == -1) {
                            return null;
                        }
                        int index = indexOf;
                        String selector = this.key.substring(0, index);
                        String descriptor = this.key.substring(index, this.key.length());
                        buffer.append('#');
                        buffer.append(Signature.toString((String)descriptor, (String)selector, null, (boolean)false, (boolean)true));
                        break;
                    }
                    case 8: 
                    case 63: {
                        int indexOf = this.key.indexOf(40);
                        if (indexOf == -1) {
                            return null;
                        }
                        int index = indexOf;
                        String selector = this.key.substring(0, index);
                        String descriptor = this.key.substring(index, this.key.length());
                        buffer.append('#');
                        buffer.append(Signature.toString((String)descriptor, (String)selector, null, (boolean)false, (boolean)false));
                        break;
                    }
                    case 12: 
                    case 16: 
                    case 61: 
                    case 64: {
                        buffer.append('#');
                        buffer.append(this.key);
                        break;
                    }
                    case 48: 
                    case 56: 
                    case 70: 
                    case 71: {
                        buffer.append('.');
                        buffer.append(this.key);
                        break;
                    }
                    case 72: {
                        switch (this.elementType) {
                            case 1: 
                            case 4: 
                            case 6: 
                            case 8: {
                                buffer.append('.');
                                buffer.append(this.key);
                                break block0;
                            }
                            case 5: {
                                int indexOf = this.key.indexOf(40);
                                if (indexOf == -1) {
                                    return null;
                                }
                                int index = indexOf;
                                String selector = this.key.substring(0, index);
                                String descriptor = this.key.substring(index, this.key.length());
                                buffer.append('#');
                                buffer.append(Signature.toString((String)descriptor, (String)selector, null, (boolean)false, (boolean)false));
                                break block0;
                            }
                            case 9: {
                                int indexOf = this.key.indexOf(40);
                                if (indexOf == -1) {
                                    return null;
                                }
                                int index = indexOf;
                                String selector = this.key.substring(0, index);
                                String descriptor = this.key.substring(index, this.key.length());
                                buffer.append('#');
                                buffer.append(Signature.toString((String)descriptor, (String)selector, null, (boolean)false, (boolean)true));
                                break block0;
                            }
                            case 7: {
                                buffer.append('#');
                                buffer.append(this.key);
                                break block0;
                            }
                        }
                        break;
                    }
                }
            } else {
                switch (this.flags) {
                    case 59: {
                        buffer.append(NLS.bind((String)Messages.deltaReportTask_entry_major_version, (Object[])this.arguments));
                        break;
                    }
                    case 60: {
                        buffer.append(NLS.bind((String)Messages.deltaReportTask_entry_minor_version, (Object[])this.arguments));
                        break;
                    }
                    case 3: {
                        buffer.append(this.key);
                        break;
                    }
                }
            }
            return CommonUtilsTask.convertToHtml(String.valueOf(buffer));
        }

        public String getDisplayKind() {
            if (ADDED.equals(this.kind)) {
                return Messages.AddedElement;
            }
            if (REMOVED.equals(this.kind)) {
                return Messages.RemovedElement;
            }
            return Messages.ChangedElement;
        }
    }
}

