/*
 * Decompiled with CFR 0.152.
 */
package de.itemis.xtext.utils.jface.viewers;

import java.lang.reflect.Field;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.projection.ProjectionDocument;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.jface.text.source.projection.ProjectionViewer;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.editors.text.TextSourceViewerConfiguration;
import org.eclipse.xtext.ui.editor.XtextSourceViewer;

class XtextSourceViewerEx
extends XtextSourceViewer {
    private final StyledText styledText;
    private final IPreferenceStore preferenceStore;

    public XtextSourceViewerEx(StyledText styledText, IPreferenceStore preferenceStore) {
        super(null, null, null, false, styledText.getStyle());
        this.styledText = styledText;
        this.preferenceStore = preferenceStore;
        super.createControl(styledText.getParent(), styledText.getStyle());
    }

    protected void createControl(Composite parent, int styles) {
    }

    protected StyledText createTextWidget(Composite parent, int styles) {
        return this.styledText;
    }

    protected boolean updateSlaveDocument(IDocument slaveDocument, int modelRangeOffset, int modelRangeLength) throws BadLocationException {
        if (slaveDocument instanceof ProjectionDocument) {
            ProjectionDocument projection = (ProjectionDocument)slaveDocument;
            int offset = modelRangeOffset;
            int length = modelRangeLength;
            if (!this.isProjectionMode()) {
                IDocument master = projection.getMasterDocument();
                int line = master.getLineOfOffset(modelRangeOffset);
                length = modelRangeOffset - (offset += master.getLineOffset(line)) + modelRangeLength;
            }
            try {
                this.setPrivateHandleProjectionChangesField(false);
                projection.replaceMasterDocumentRanges(offset, length);
            }
            finally {
                this.setPrivateHandleProjectionChangesField(true);
            }
            return true;
        }
        return false;
    }

    public void configure(SourceViewerConfiguration configuration) {
        try {
            Field declaredField = TextSourceViewerConfiguration.class.getDeclaredField("fPreferenceStore");
            declaredField.setAccessible(true);
            declaredField.set(configuration, this.preferenceStore);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        super.configure(configuration);
    }

    private void setPrivateHandleProjectionChangesField(boolean value) {
        try {
            Field declaredField = ProjectionViewer.class.getDeclaredField("fHandleProjectionChanges");
            declaredField.setAccessible(true);
            declaredField.set((Object)this, value);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

