/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.extendedtypes.invariantcontainerconfiguration;

import java.util.Arrays;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.gmf.runtime.emf.type.core.ElementTypeRegistry;
import org.eclipse.gmf.runtime.emf.type.core.IClientContext;
import org.eclipse.gmf.runtime.emf.type.core.IElementMatcher;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.infra.extendedtypes.Activator;
import org.eclipse.papyrus.infra.extendedtypes.invariantcontainerconfiguration.HierarchyPermission;
import org.eclipse.papyrus.infra.extendedtypes.invariantcontainerconfiguration.InvariantContainerConfiguration;
import org.eclipse.papyrus.infra.extendedtypes.invariantsemantictypeconfiguration.IInvariantContainerDescriptor;
import org.eclipse.papyrus.infra.services.edit.internal.context.TypeContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InvariantContainerConfigurationContainerDescriptor
implements IInvariantContainerDescriptor<InvariantContainerConfiguration> {
    protected EList<HierarchyPermission> permissions;
    private IClientContext sharedContext;
    private IElementMatcher matcher;

    public IElementMatcher getMatcher() {
        if (this.matcher == null) {
            this.matcher = this.createMatcher();
        }
        return this.matcher;
    }

    protected IElementMatcher createMatcher() {
        return new IElementMatcher(){

            public boolean matches(EObject eObject) {
                if (eObject == null) {
                    return false;
                }
                IElementType[] types = ElementTypeRegistry.getInstance().getAllTypesMatching(eObject, InvariantContainerConfigurationContainerDescriptor.this.sharedContext);
                if (types == null || types.length == 0) {
                    return false;
                }
                boolean isValid = false;
                for (HierarchyPermission permission : InvariantContainerConfigurationContainerDescriptor.this.permissions) {
                    boolean isPermitted = permission.isIsPermitted();
                    String childType = permission.getChildType();
                    boolean isStrict = permission.isIsStrict();
                    IElementType type = ElementTypeRegistry.getInstance().getType(childType);
                    if (type == null) continue;
                    if (isStrict) {
                        if (types[0].equals(type)) {
                            if (!isPermitted) continue;
                            isValid = true;
                            continue;
                        }
                        if (isPermitted) continue;
                        isValid = false;
                        continue;
                    }
                    List<IElementType> allTypes = Arrays.asList(types);
                    if (!allTypes.contains(type)) continue;
                    if (isPermitted) {
                        isValid = true;
                        continue;
                    }
                    if (isPermitted) continue;
                    isValid = false;
                }
                return isValid;
            }
        };
    }

    public EReference[] getContainmentFeatures() {
        return null;
    }

    @Override
    public void init(InvariantContainerConfiguration ruleConfiguration) {
        this.permissions = ruleConfiguration.getPermissions();
        try {
            this.sharedContext = TypeContext.getContext();
        }
        catch (ServiceException e) {
            Activator.log.error((Throwable)e);
        }
    }
}

