/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.extendedtypes.handler;

import java.util.Iterator;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.emf.common.util.URI;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.papyrus.infra.extendedtypes.ExtendedElementTypeSetRegistry;
import org.eclipse.papyrus.infra.extendedtypes.preferences.ExtendedTypesPreferences;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.statushandlers.StatusManager;

public class DeployExtendedTypeSetConfigurationHandler
extends AbstractHandler
implements IHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        ISelection currentSelection = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        if (!(currentSelection instanceof IStructuredSelection) || currentSelection.isEmpty()) {
            return null;
        }
        final IStructuredSelection selection = (IStructuredSelection)currentSelection;
        final Shell activeShell = HandlerUtil.getActiveShell((ExecutionEvent)event);
        Job job = new Job("Deploy extended type set configuration"){

            protected IStatus run(IProgressMonitor monitor) {
                monitor.beginTask("Deploying selected configurations", selection.size());
                return DeployExtendedTypeSetConfigurationHandler.this.doExecute(selection, monitor);
            }
        };
        job.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

            public void done(final IJobChangeEvent event) {
                activeShell.getDisplay().asyncExec(new Runnable(){

                    public void run() {
                        if (event.getResult().isOK()) {
                            MessageDialog.openInformation((Shell)activeShell, (String)"Success", (String)event.getResult().getMessage());
                        } else if (event.getResult().getSeverity() < 4) {
                            StatusManager.getManager().handle(event.getResult(), 2);
                        }
                    }
                });
            }
        });
        job.setUser(true);
        job.schedule();
        return null;
    }

    protected IStatus doExecute(IStructuredSelection selection, IProgressMonitor monitor) {
        Iterator selectionIterator = selection.iterator();
        MultiStatus result = new MultiStatus("org.eclipse.papyrus.infra.extendedtypes", 0, "The properties view configuration has been successfully deployed and activated", null);
        while (selectionIterator.hasNext()) {
            Object selectedElement = selectionIterator.next();
            if (!(selectedElement instanceof IAdaptable)) continue;
            IFile selectedFile = (IFile)((IAdaptable)selectedElement).getAdapter(IFile.class);
            if (selectedFile == null) {
                monitor.worked(1);
                result.add((IStatus)new Status(4, "org.eclipse.papyrus.infra.extendedtypes", "The selected element is not a file"));
                continue;
            }
            String fileName = selectedFile.getFullPath().removeFileExtension().lastSegment();
            monitor.subTask("Deploy " + fileName);
            URI emfURI = null;
            if (selectedFile.getFullPath() != null) {
                emfURI = URI.createPlatformResourceURI((String)selectedFile.getFullPath().toString(), (boolean)true);
            } else if (selectedFile.getRawLocation() != null) {
                emfURI = URI.createFileURI((String)selectedFile.getRawLocation().toString());
            }
            if (emfURI == null) {
                monitor.worked(1);
                result.add((IStatus)new Status(4, "org.eclipse.papyrus.infra.extendedtypes", "The selected element is not a valid configuration file"));
                continue;
            }
            ExtendedTypesPreferences.registerWorkspaceDefinition(fileName, selectedFile.getFullPath().toString());
            monitor.subTask("Reset Element Types Registry");
            ExtendedElementTypeSetRegistry.getInstance().loadExtendedElementTypeSet(fileName);
            monitor.worked(1);
            result.add((IStatus)new Status(0, "org.eclipse.papyrus.infra.extendedtypes", "The extended types configuration has been successfully deployed and activated"));
        }
        if (result.getChildren().length == 1) {
            return result.getChildren()[0];
        }
        if (result.isOK()) {
            return result;
        }
        MultiStatus actualResult = new MultiStatus("org.eclipse.papyrus.infra.extendedtypes", result.getCode(), "Some errors occurred during the deployment", result.getException());
        actualResult.merge((IStatus)result);
        return actualResult;
    }
}

