/*
 * Decompiled with CFR 0.152.
 */
package org.yakindu.sct.model.stext.util;

import com.google.common.collect.Lists;
import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.workspace.util.WorkspaceSynchronizer;
import org.eclipse.xtext.resource.IContainer;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.resource.IResourceDescription;
import org.eclipse.xtext.resource.IResourceDescriptions;
import org.eclipse.xtext.resource.impl.ResourceSetBasedResourceDescriptions;
import org.yakindu.base.types.Package;
import org.yakindu.base.types.TypesPackage;
import org.yakindu.sct.model.stext.stext.Import;

public class ImportResolver {
    @Inject
    private IContainer.Manager containerManager;
    @Inject
    private IResourceDescriptions resourceDescriptions;

    public <T extends EObject> List<T> getImportedElementsOfType(Import importDeclaration, Class<T> type) {
        ArrayList varDefs = Lists.newArrayList();
        Package importedPackage = this.getPackageForNamespace(importDeclaration.eResource(), importDeclaration.getImportedNamespace());
        if (importedPackage != null) {
            TreeIterator iter = importedPackage.eAllContents();
            while (iter.hasNext()) {
                EObject next = (EObject)iter.next();
                if (!type.isInstance(next)) continue;
                varDefs.add((EObject)type.cast(next));
            }
        }
        return varDefs;
    }

    public Package getPackageForNamespace(Resource contextResource, String namespace) {
        URI uri;
        IResourceDescription resourceDescription;
        this.initResourceDescriptions(contextResource);
        if (namespace.endsWith(".*")) {
            namespace = namespace.substring(0, namespace.length() - 2);
        }
        if ((resourceDescription = this.resourceDescriptions.getResourceDescription(uri = contextResource.getURI())) == null) {
            return null;
        }
        for (IContainer container : this.containerManager.getVisibleContainers(resourceDescription, this.resourceDescriptions)) {
            Iterable currentDescriptions = container.getResourceDescriptions();
            for (IResourceDescription resDesc : currentDescriptions) {
                Iterable visiblePackages = resDesc.getExportedObjectsByType(TypesPackage.Literals.PACKAGE);
                for (IEObjectDescription pkgDesc : visiblePackages) {
                    if (!pkgDesc.getName().toString().equals(namespace)) continue;
                    return (Package)pkgDesc.getEObjectOrProxy();
                }
            }
        }
        return null;
    }

    private void initResourceDescriptions(Resource contextResource) {
        if (this.resourceDescriptions instanceof ResourceSetBasedResourceDescriptions) {
            ResourceSet rset = this.buildResourceSet(contextResource);
            ((ResourceSetBasedResourceDescriptions)this.resourceDescriptions).setContext((Notifier)rset);
        }
    }

    private ResourceSet buildResourceSet(Resource contextResource) {
        ResourceSetImpl rset = new ResourceSetImpl();
        IProject project = WorkspaceSynchronizer.getFile((Resource)contextResource).getProject();
        try {
            project.accept(new IResourceVisitor((ResourceSet)rset){
                private final /* synthetic */ ResourceSet val$rset;
                {
                    this.val$rset = resourceSet;
                }

                public boolean visit(IResource resource) throws CoreException {
                    if ("types".equals(resource.getFileExtension())) {
                        String filePath = resource.getFullPath().toString();
                        this.val$rset.createResource(URI.createPlatformResourceURI((String)filePath, (boolean)true));
                    }
                    return true;
                }
            });
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        rset.getResources().add((Object)contextResource);
        return rset;
    }
}

