/*
 * Decompiled with CFR 0.152.
 */
package org.yakindu.sct.model.stext.scoping;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.inject.Inject;
import de.itemis.xtext.utils.jface.viewers.ContextElementAdapter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.naming.IQualifiedNameConverter;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.scoping.IScope;
import org.eclipse.xtext.scoping.Scopes;
import org.eclipse.xtext.scoping.impl.AbstractDeclarativeScopeProvider;
import org.eclipse.xtext.scoping.impl.FilteringScope;
import org.eclipse.xtext.scoping.impl.ImportNormalizer;
import org.eclipse.xtext.scoping.impl.SimpleScope;
import org.eclipse.xtext.util.PolymorphicDispatcher;
import org.eclipse.xtext.util.Strings;
import org.yakindu.base.expressions.expressions.ElementReferenceExpression;
import org.yakindu.base.expressions.expressions.Expression;
import org.yakindu.base.expressions.expressions.FeatureCall;
import org.yakindu.base.types.ComplexType;
import org.yakindu.base.types.EnumerationType;
import org.yakindu.base.types.Feature;
import org.yakindu.base.types.ITypeSystem;
import org.yakindu.base.types.TypeSystemUtils;
import org.yakindu.sct.model.sgraph.SGraphPackage;
import org.yakindu.sct.model.sgraph.Scope;
import org.yakindu.sct.model.sgraph.Statechart;
import org.yakindu.sct.model.stext.scoping.ContextPredicateProvider;
import org.yakindu.sct.model.stext.stext.Import;
import org.yakindu.sct.model.stext.stext.ImportScope;
import org.yakindu.sct.model.stext.stext.InterfaceScope;
import org.yakindu.sct.model.stext.stext.InternalScope;

public class STextScopeProvider
extends AbstractDeclarativeScopeProvider {
    @Inject
    ITypeSystem typeSystem;
    @Inject
    TypeSystemUtils typeSystemUtils;
    @Inject
    private ContextPredicateProvider predicateProvider;
    @Inject
    private IQualifiedNameConverter qualifiedNameConverter;

    public IScope getScope(EObject context, EReference reference) {
        try {
            PolymorphicDispatcher.ErrorHandler originalHandler = this.getErrorHandler();
            this.setErrorHandler(new ErrorHandlerDelegate(originalHandler));
            IScope scope = super.getScope(context, reference);
            this.setErrorHandler(originalHandler);
            return scope;
        }
        catch (Throwable t) {
            t.printStackTrace();
            return null;
        }
    }

    public IScope scope_TypedElement_type(EObject context, EReference reference) {
        Statechart statechart = this.getStatechart(context);
        EList scopes = statechart.getScopes();
        IScope scope = this.retrieveImportScope(context, reference, (EList<Scope>)scopes);
        Predicate<IEObjectDescription> predicate = this.calculateFilterPredicate(context, reference);
        return new FilteringScope(scope, predicate);
    }

    public IScope scope_ElementReferenceExpression_reference(EObject context, EReference reference) {
        IScope namdScope = this.getNamedTopLevelScope(context, reference);
        IScope unnamedScope = this.getUnnamedTopLevelScope(context, reference);
        Predicate<IEObjectDescription> predicate = this.calculateFilterPredicate(context, reference);
        unnamedScope = new FilteringScope(unnamedScope, predicate);
        SimpleScope scope = new SimpleScope(Iterables.concat((Iterable)namdScope.getAllElements(), (Iterable)unnamedScope.getAllElements(), (Iterable)Scopes.scopeFor((Iterable)this.typeSystemUtils.getEnumerationTypes(this.typeSystem)).getAllElements()));
        return scope;
    }

    public IScope scope_FeatureCall_feature(FeatureCall context, EReference reference) {
        Predicate<IEObjectDescription> predicate = this.calculateFilterPredicate((EObject)context, reference);
        Expression owner = context.getOwner();
        EObject element = null;
        if (owner instanceof ElementReferenceExpression) {
            element = ((ElementReferenceExpression)owner).getReference();
        } else if (owner instanceof FeatureCall) {
            element = ((FeatureCall)owner).getFeature();
        } else {
            return this.getDelegate().getScope((EObject)context, reference);
        }
        IScope scope = IScope.NULLSCOPE;
        if (element instanceof Scope) {
            scope = Scopes.scopeFor((Iterable)((Scope)element).getDeclarations());
            scope = new FilteringScope(scope, predicate);
        }
        if (element instanceof ComplexType) {
            scope = Scopes.scopeFor((Iterable)((ComplexType)element).getAllFeatures(), (IScope)scope);
            scope = new FilteringScope(scope, predicate);
        }
        if (element instanceof EnumerationType) {
            scope = Scopes.scopeFor((Iterable)((EnumerationType)element).getEnumerator(), (IScope)scope);
            scope = new FilteringScope(scope, predicate);
        }
        if (element instanceof Feature && ((Feature)element).getType() instanceof ComplexType) {
            scope = Scopes.scopeFor((Iterable)((ComplexType)((Feature)element).getType()).getAllFeatures(), (IScope)scope);
            scope = new FilteringScope(scope, predicate);
        }
        return scope;
    }

    private Predicate<IEObjectDescription> calculateFilterPredicate(EObject context, EReference reference) {
        Predicate<IEObjectDescription> predicate = null;
        EObject container = context;
        EReference ref = reference;
        while (container != null) {
            predicate = this.predicateProvider.getPredicate(container.eClass(), ref);
            if (!(predicate instanceof ContextPredicateProvider.EmptyPredicate)) break;
            ref = (EReference)container.eContainingFeature();
            container = container.eContainer();
        }
        return predicate;
    }

    protected IScope getNamedTopLevelScope(EObject context, EReference reference) {
        ArrayList scopeCandidates = Lists.newArrayList();
        Statechart statechart = this.getStatechart(context);
        if (statechart == null) {
            return IScope.NULLSCOPE;
        }
        EList scopes = statechart.getScopes();
        for (Scope scope : scopes) {
            String name;
            if (!(scope instanceof InterfaceScope) || (name = ((InterfaceScope)scope).getName()) == null || name.trim().length() <= 0) continue;
            scopeCandidates.add(scope);
        }
        return Scopes.scopeFor((Iterable)scopeCandidates);
    }

    protected ImportNormalizer createImportedNamespaceResolver(String namespace, boolean ignoreCase) {
        boolean hasWildCard;
        if (Strings.isEmpty((String)namespace)) {
            return null;
        }
        QualifiedName importedNamespace = this.qualifiedNameConverter.toQualifiedName(namespace);
        if (importedNamespace == null || importedNamespace.getSegmentCount() < 1) {
            return null;
        }
        boolean bl = hasWildCard = ignoreCase ? importedNamespace.getLastSegment().equalsIgnoreCase("*") : importedNamespace.getLastSegment().equals("*");
        if (hasWildCard) {
            if (importedNamespace.getSegmentCount() <= 1) {
                return null;
            }
            return new ImportNormalizer(importedNamespace.skipLast(1), true, ignoreCase);
        }
        return new ImportNormalizer(importedNamespace, false, ignoreCase);
    }

    protected IScope getUnnamedTopLevelScope(EObject context, EReference reference) {
        Scope scope2;
        ArrayList scopeCandidates = Lists.newArrayList();
        Statechart statechart = this.getStatechart(context);
        if (statechart == null) {
            return IScope.NULLSCOPE;
        }
        EList scopes = statechart.getScopes();
        for (Scope scope2 : scopes) {
            if (scope2 instanceof InterfaceScope) {
                String name = ((InterfaceScope)scope2).getName();
                if (name != null && name.trim().length() != 0) continue;
                scopeCandidates.addAll(scope2.getDeclarations());
                continue;
            }
            if (!(scope2 instanceof InternalScope)) continue;
            scopeCandidates.addAll(scope2.getDeclarations());
        }
        scope2 = this.retrieveImportScope(context, reference, (EList<Scope>)scopes);
        return Scopes.scopeFor((Iterable)scopeCandidates, (IScope)scope2);
    }

    private IScope retrieveImportScope(EObject context, EReference reference, EList<Scope> scopes) {
        IScope scope = this.getDelegate().getScope(context, reference);
        Iterable filter = Iterables.filter(scopes, ImportScope.class);
        if (Iterables.size((Iterable)filter) > 0) {
            ArrayList normalizers = Lists.newArrayList();
            for (ImportScope importScope : filter) {
                EList<Import> imports = importScope.getImports();
                for (Import import1 : imports) {
                    normalizers.add(this.createImportedNamespaceResolver(import1.getImportedNamespace(), false));
                }
            }
            scope = new org.eclipse.xtext.scoping.impl.ImportScope((List)normalizers, scope, null, reference.getEReferenceType(), false);
        }
        return scope;
    }

    protected Statechart getStatechart(EObject context) {
        ContextElementAdapter provider = (ContextElementAdapter)EcoreUtil.getExistingAdapter((Notifier)context.eResource(), ContextElementAdapter.class);
        if (provider == null) {
            return (Statechart)EcoreUtil2.getContainerOfType((EObject)context, Statechart.class);
        }
        return (Statechart)EcoreUtil.getObjectByType((Collection)provider.getElement().eResource().getContents(), (EClassifier)SGraphPackage.Literals.STATECHART);
    }

    private static class ErrorHandlerDelegate<T>
    implements PolymorphicDispatcher.ErrorHandler<T> {
        private PolymorphicDispatcher.ErrorHandler<T> delegate;
        public static final Log LOG = LogFactory.getLog(STextScopeProvider.class);

        public ErrorHandlerDelegate(PolymorphicDispatcher.ErrorHandler<T> delegate) {
            this.delegate = delegate;
        }

        public T handle(Object[] params, Throwable throwable) {
            if (throwable instanceof NoSuchMethodException) {
                LOG.debug((Object)"Error in scope method, using fallback", throwable);
            } else {
                LOG.warn((Object)"Error in scope method, using fallback", throwable);
            }
            return (T)this.delegate.handle(params, throwable);
        }
    }
}

