/*
 * Decompiled with CFR 0.152.
 */
package org.yakindu.sct.ui.editor.wizards;

import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.URI;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.dialogs.WizardNewFileCreationPage;

public class CreationWizardPage
extends WizardNewFileCreationPage {
    private final String fileExtension;

    public CreationWizardPage(String pageName, IStructuredSelection selection, String fileExtension) {
        super(pageName, selection);
        this.fileExtension = fileExtension;
    }

    protected String getExtension() {
        return this.fileExtension;
    }

    public URI getURI() {
        return URI.createPlatformResourceURI((String)this.getFilePath().toString(), (boolean)false);
    }

    protected IPath getFilePath() {
        String fileName;
        IPath path = this.getContainerFullPath();
        if (path == null) {
            path = new Path("");
        }
        if ((fileName = this.getFileName()) != null) {
            path = path.append(fileName);
        }
        return path;
    }

    public void createControl(Composite parent) {
        super.createControl(parent);
        this.setFileName(CreationWizardPage.getUniqueFileName(this.getContainerFullPath(), this.getFileName(), this.getExtension()));
        this.setPageComplete(this.validatePage());
    }

    protected boolean validatePage() {
        if (!super.validatePage()) {
            return false;
        }
        String extension = this.getExtension();
        if (extension != null && !this.getFilePath().toString().endsWith("." + extension)) {
            this.setErrorMessage(NLS.bind((String)"file extension is not valid!", (Object)extension));
            return false;
        }
        return true;
    }

    public static String getUniqueFileName(IPath containerFullPath, String fileName, String extension) {
        if (containerFullPath == null) {
            containerFullPath = new Path("");
        }
        if (fileName == null || fileName.trim().length() == 0) {
            fileName = "default";
        }
        IPath filePath = containerFullPath.append(fileName);
        if (extension != null && !extension.equals(filePath.getFileExtension())) {
            filePath = filePath.addFileExtension(extension);
        }
        extension = filePath.getFileExtension();
        fileName = filePath.removeFileExtension().lastSegment();
        int i = 1;
        while (ResourcesPlugin.getWorkspace().getRoot().exists(filePath)) {
            filePath = containerFullPath.append(String.valueOf(fileName) + ++i);
            if (extension == null) continue;
            filePath = filePath.addFileExtension(extension);
        }
        return filePath.lastSegment();
    }
}

