/*
 * Decompiled with CFR 0.152.
 */
package org.yakindu.sct.ui.editor.policies;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PrecisionRectangle;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gef.editpolicies.AbstractEditPolicy;
import org.eclipse.gef.requests.ChangeBoundsRequest;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.diagram.ui.commands.ICommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.commands.SetBoundsCommand;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.l10n.DiagramUIMessages;
import org.eclipse.gmf.runtime.emf.core.util.EObjectAdapter;
import org.yakindu.sct.ui.editor.editparts.RegionEditPart;
import org.yakindu.sct.ui.editor.editparts.StateEditPart;
import org.yakindu.sct.ui.editor.policies.SetPreferredSizeRequest;

public class EnlargeContainerEditPolicy
extends AbstractEditPolicy {
    public static final Object ROLE = "ResizeContainer";
    public static final int SPACEING = 25;
    private Map<IFigure, Rectangle> boundsCache = new HashMap<IFigure, Rectangle>();
    private List<IGraphicalEditPart> containerHierachy;

    public Command getCommand(Request request) {
        if (!"resize".equals(request.getType()) && !"move".equals(request.getType())) {
            return null;
        }
        if (request instanceof SetPreferredSizeRequest) {
            this.showSourceFeedback(request);
        }
        ChangeBoundsRequest cbr = (ChangeBoundsRequest)request;
        CompoundCommand result = new CompoundCommand();
        for (IGraphicalEditPart currentContainer : this.containerHierachy) {
            IFigure figure = currentContainer.getFigure();
            SetBoundsCommand boundsCommand = new SetBoundsCommand(this.getHost().getEditingDomain(), DiagramUIMessages.SetLocationCommand_Label_Resize, (IAdaptable)new EObjectAdapter((EObject)currentContainer.getNotationView()), figure.getBounds());
            result.add((Command)new ICommandProxy((ICommand)boundsCommand));
            List children = currentContainer.getParent().getChildren();
            for (IGraphicalEditPart childPart : children) {
                if (cbr.getEditParts().contains(childPart)) continue;
                IFigure childFigure = childPart.getFigure();
                if (childPart == currentContainer) continue;
                SetBoundsCommand childBoundsCommand = new SetBoundsCommand(this.getHost().getEditingDomain(), DiagramUIMessages.SetLocationCommand_Label_Resize, (IAdaptable)new EObjectAdapter((EObject)childPart.getNotationView()), childFigure.getBounds());
                result.add((Command)new ICommandProxy((ICommand)childBoundsCommand));
            }
        }
        return result;
    }

    public IGraphicalEditPart getHost() {
        return (IGraphicalEditPart)super.getHost();
    }

    public void showSourceFeedback(Request request) {
        if (this.containerHierachy == null) {
            this.containerHierachy = this.collectContainerHierachy();
        }
        if (!"resize".equals(request.getType()) && !"move".equals(request.getType())) {
            return;
        }
        this.showContainerFeedback((ChangeBoundsRequest)request);
    }

    public void eraseSourceFeedback(Request request) {
        this.boundsCache.clear();
        this.containerHierachy = null;
        super.eraseSourceFeedback(request);
    }

    protected void showContainerFeedback(ChangeBoundsRequest request) {
        int level = 1;
        while (level <= this.containerHierachy.size()) {
            IGraphicalEditPart containerEditPart = this.containerHierachy.get(level - 1);
            IFigure containerFigure = containerEditPart.getFigure();
            Rectangle feedbackBounds = this.getOriginalBounds(containerFigure);
            containerFigure.getParent().translateToAbsolute((Translatable)feedbackBounds);
            feedbackBounds = this.calculateFeedbackBounds(request, feedbackBounds, level, containerFigure);
            this.showChildrenFeedback(containerEditPart, containerFigure, feedbackBounds, request);
            containerFigure.translateToRelative((Translatable)feedbackBounds);
            this.setBounds(containerFigure, feedbackBounds);
            ++level;
        }
    }

    protected List<IGraphicalEditPart> collectContainerHierachy() {
        ArrayList<IGraphicalEditPart> result = new ArrayList<IGraphicalEditPart>();
        IGraphicalEditPart containerEditPart = this.getHost();
        while (containerEditPart != null) {
            if ((containerEditPart = this.getContainer(containerEditPart)) == null) continue;
            result.add(containerEditPart);
        }
        return result;
    }

    protected void showChildrenFeedback(IGraphicalEditPart containerEditPart, IFigure containerFigure, Rectangle containerFeedbackBounds, ChangeBoundsRequest request) {
        Rectangle originalBounds = this.getOriginalBounds(containerFigure);
        Point moveDelta = new Point(containerFeedbackBounds.width - originalBounds.width, containerFeedbackBounds.height - originalBounds.height);
        List children = containerEditPart.getParent().getChildren();
        for (IGraphicalEditPart childPart : children) {
            if (request.getEditParts().contains(childPart) || childPart == containerEditPart) continue;
            this.showChildFeedback(childPart, moveDelta, containerFeedbackBounds);
        }
    }

    protected void showChildFeedback(IGraphicalEditPart childPart, Point moveDelta, Rectangle containerFeedbackBounds) {
        IFigure childFigure = childPart.getFigure();
        Rectangle originalChildBounds = this.getOriginalBounds(childFigure);
        childFigure.getParent().translateToAbsolute((Translatable)originalChildBounds);
        boolean horizontalAffected = this.isHorizontalAffected(containerFeedbackBounds, moveDelta, originalChildBounds);
        boolean verticalAffected = this.isVerticalAffected(containerFeedbackBounds, moveDelta, originalChildBounds);
        if (!horizontalAffected && !verticalAffected) {
            return;
        }
        if (horizontalAffected) {
            originalChildBounds.x += moveDelta.x;
        }
        if (verticalAffected) {
            originalChildBounds.y += moveDelta.y;
        }
        childFigure.getParent().translateToRelative((Translatable)originalChildBounds);
        this.setBounds(childFigure, originalChildBounds);
    }

    private Rectangle getOriginalBounds(IFigure figure) {
        Rectangle originalContainerBounds = this.boundsCache.get(figure);
        if (originalContainerBounds == null) {
            originalContainerBounds = figure.getBounds().getCopy();
            this.boundsCache.put(figure, originalContainerBounds);
        }
        return this.boundsCache.get(figure).getCopy();
    }

    private IGraphicalEditPart getContainer(IGraphicalEditPart host) {
        IGraphicalEditPart containerEditPart = this.getParentState((EditPart)host);
        if (containerEditPart == null && (containerEditPart = this.getParentRegion((EditPart)host)) == null) {
            return null;
        }
        return containerEditPart;
    }

    private boolean isVerticalAffected(Rectangle newBounds, Point moveDelta, Rectangle bounds) {
        boolean verticalAffected;
        boolean bl = verticalAffected = (bounds.x > newBounds.x || bounds.x + bounds.width > newBounds.x) && bounds.x < newBounds.x + newBounds.width || bounds.x + bounds.width < newBounds.x + newBounds.width;
        if (verticalAffected) {
            verticalAffected = bounds.y + moveDelta.y > newBounds.y + newBounds.height;
        }
        return verticalAffected;
    }

    private boolean isHorizontalAffected(Rectangle newBounds, Point moveDelta, Rectangle bounds) {
        boolean horizontalAffected;
        boolean bl = horizontalAffected = (bounds.y > newBounds.y || bounds.y + bounds.height > newBounds.y) && bounds.y < newBounds.y + newBounds.height || bounds.y + bounds.height < newBounds.y + newBounds.height;
        if (horizontalAffected) {
            horizontalAffected = bounds.x + moveDelta.x > newBounds.x + newBounds.width;
        }
        return horizontalAffected;
    }

    protected void setBounds(IFigure figure, Rectangle bounds) {
        figure.setBounds(bounds);
        figure.getParent().setConstraint(figure, (Object)bounds);
    }

    private Rectangle calculateFeedbackBounds(ChangeBoundsRequest request, Rectangle feedbackBounds, int level, IFigure containerFigure) {
        Rectangle result = feedbackBounds.getCopy();
        List editParts = request.getEditParts();
        for (IGraphicalEditPart editPart : editParts) {
            PrecisionRectangle transformedRect = new PrecisionRectangle(editPart.getFigure().getBounds());
            editPart.getFigure().translateToAbsolute((Translatable)transformedRect);
            transformedRect.translate(request.getMoveDelta());
            transformedRect.resize(request.getSizeDelta());
            transformedRect.expand(25 * level, 25 * level);
            result.union((Rectangle)transformedRect);
            Dimension preferredSize = containerFigure.getPreferredSize().getCopy();
            editPart.getFigure().translateToAbsolute((Translatable)preferredSize);
            Dimension max = Dimension.max((Dimension)result.getSize(), (Dimension)preferredSize);
            result.setSize(max);
            if (result.x >= feedbackBounds.x && result.y >= feedbackBounds.y) continue;
            return feedbackBounds;
        }
        return result;
    }

    protected IGraphicalEditPart getParentRegion(EditPart part) {
        part = part.getParent();
        while (!(part instanceof RegionEditPart)) {
            if ((part = part.getParent()) != null) continue;
            return null;
        }
        return (IGraphicalEditPart)part;
    }

    protected IGraphicalEditPart getParentState(EditPart part) {
        part = part.getParent();
        while (!(part instanceof StateEditPart)) {
            if ((part = part.getParent()) != null) continue;
            return null;
        }
        return (IGraphicalEditPart)part;
    }
}

